# Copyright (c) 2023-2024 Arm Limited.
#
# SPDX-License-Identifier: MIT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to
# deal in the Software without restriction, including without limitation the
# rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
# sell copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

find_package(Git)

if(GIT_FOUND)
  execute_process(
    COMMAND ${GIT_EXECUTABLE} rev-parse HEAD
    WORKING_DIRECTORY ${PROJECT_SOURCE_DIR}
    RESULT_VARIABLE RESULT
    OUTPUT_VARIABLE ACL_VERSION_SHA
    OUTPUT_STRIP_TRAILING_WHITESPACE)
endif()

if(NOT GIT_FOUND OR RESULT)
  set(ACL_VERSION_HASH "Unknown")
endif()

file(WRITE "${PROJECT_SOURCE_DIR}/arm_compute_version.embed.tmp" "\"${ACL_VERSION_SHA}\"")

execute_process(
  COMMAND ${CMAKE_COMMAND} -E compare_files
  ${PROJECT_SOURCE_DIR}/arm_compute_version.embed
  ${PROJECT_SOURCE_DIR}/arm_compute_version.embed.tmp
  RESULT_VARIABLE is_same
)

if(is_same EQUAL 0)
    file(REMOVE ${PROJECT_SOURCE_DIR}/arm_compute_version.embed.tmp)
else()
    file(RENAME ${PROJECT_SOURCE_DIR}/arm_compute_version.embed.tmp ${PROJECT_SOURCE_DIR}/arm_compute_version.embed)
endif()
