/*
 * Copyright (c) 2022-2024 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#if defined(ARM_COMPUTE_ENABLE_SME2)

#include <algorithm>
#include <cstddef>

namespace arm_conv {
namespace depthwise {

void sme2_fp32bf16fp32_planar_5x5_s2_4rows_dot_za_impl(
  const float *inptr,
  size_t ld_in_row,
  size_t ld_in_col,
  size_t ld_in_vl,
  unsigned int pad_top,
  unsigned int valid_input_rows,
  unsigned int pad_left,
  unsigned int valid_input_cols,
  const float *weights,
  const float *bias,
  float **outptrs,
  const size_t *outlds,
  const size_t *outvllds,
  unsigned int output_cols,
  unsigned int start_channel,
  unsigned int valid_channels,
  float act_min,
  float act_max
)
{
  struct Args
  {
    const float *inptr;
    size_t ld_in_vl;
    long unsigned int pad_top, pad_bottom, pad_left;
    const float *weights;
    const float *bias;
    long unsigned int input_cols, output_cols;
    float **outptrs;
    const size_t *ld_out_cols;
    const size_t *ld_out_vls;
    long unsigned int current_channel, n_channels;
    float clamp_min, clamp_max;
  };

  Args args = { inptr, ld_in_vl, pad_top, 11u - std::min(11u, pad_top + valid_input_rows), pad_left, weights, bias, valid_input_cols, output_cols, outptrs, outlds, outvllds, start_channel, valid_channels, act_min, act_max };

  __asm__ __volatile__(
    "ldr x3, [%x[args], %[offsetof_Args_pad_bottom]]\n"
    "mov x22, SP\n"
    "mov x21, #0xb\n"
    ".inst 0xd503477f  // SMSTART ZA\n"
    "ldr x4, [%x[args], %[offsetof_Args_pad_top]]\n"
    "sub x20, x22, #0x8\n"
    "ptrue p2.b\n"
    "ldr x5, [%x[args], %[offsetof_Args_n_channels]]\n"
    "and x20, x20, #-0x400\n"
    ".inst 0x25207812  // ptrue pn10.b\n"
    "ld1rw { z30.s }, p2/Z, [%x[args], %[offsetof_Args_clamp_min]]\n"
    "sub x21, x21, x3\n"
    "mov SP, x20\n"
    "ldr x6, [%x[args], %[offsetof_Args_current_channel]]\n"
    "ld1rw { z31.s }, p2/Z, [%x[args], %[offsetof_Args_clamp_max]]\n"
    "str x22, [SP]\n"
    "addvl SP, SP, #-15\n"
    "whilelt p1.s, XZR, x5\n"
    "whilelt p9.s, XZR, x21\n"
    "whilelt p8.s, XZR, x4\n"
    "eor p8.b, p2/Z, p8.b, p9.b\n"
    "1:"  // Channel loop
    "ldr x20, [%x[args], %[offsetof_Args_bias]]\n"
    "fmov z24.s, #0x0\n"
    "cbz x20, 2f\n"
    "ld1w { z24.s }, p1/Z, [x20, x6, LSL #2]\n"
    "2:"  // Load bias: Done
    "ldr x27, [%x[args], %[offsetof_Args_weights]]\n"
    "addvl x26, SP, #15\n"
    "mov x25, #0xb\n"
    "mov z25.d, z24.d\n"
    "addvl x26, x26, #-3\n"
    "ldr x7, [%x[args], %[offsetof_Args_input_cols]]\n"
    "add x24, x4, x3\n"
    "mov z26.d, z24.d\n"
    "ldr x17, [%x[args], %[offsetof_Args_inptr]]\n"
    "lsl x23, %x[ld_in_row], #0x2\n"
    "mov z27.d, z24.d\n"
    "mov x8, #0x0\n"
    "mov x22, x27\n"
    "incb x27\n"
    "ldr x16, [%x[args], %[offsetof_Args_output_cols]]\n"
    "ld1w { z15.s }, p2/Z, [x22]\n"
    "incb x22, ALL, MUL #5\n"
    "sub x20, x7, #0x1\n"
    "ld1w { z23.s }, p2/Z, [x22]\n"
    "incb x22, ALL, MUL #5\n"
    "orr x21, x20, %x[ld_in_col], LSL #18\n"
    "ld1w { z14.s }, p2/Z, [x22]\n"
    "incb x22, ALL, MUL #5\n"
    "orr x21, x5, x21, LSL #20\n"
    ".inst 0x658aa9fd  // bfcvt z29.h, p2/M, z15.s\n"
    "ld1w { z15.s }, p2/Z, [x22]\n"
    "incb x22, ALL, MUL #5\n"
    "lsl x21, x21, #0x2\n"
    "ld1w { z0.s }, p2/Z, [x22]\n"
    "mov x20, x27\n"
    "incb x27\n"
    ".inst 0x658aa9ce  // bfcvt z14.h, p2/M, z14.s\n"
    "ld1w { z22.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "sub x25, x25, x24\n"
    "madd x23, x23, x4, x17\n"
    ".inst 0x648aaafd  // bfcvtnt z29.h, p2/M, z23.s\n"
    "ld1w { z20.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x658aa81c  // bfcvt z28.h, p2/M, z0.s\n"
    "ld1w { z17.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x648aa9ee  // bfcvtnt z14.h, p2/M, z15.s\n"
    "ld1w { z2.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "ld1w { z11.s }, p2/Z, [x20]\n"
    "mov x20, x27\n"
    "incb x27\n"
    "st1h { z29.h }, p2, [x26]\n"
    ".inst 0x658aaad3  // bfcvt z19.h, p2/M, z22.s\n"
    "ld1w { z22.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "st1h { z14.h }, p2, [x26, #1, MUL VL]\n"
    ".inst 0x658aaa21  // bfcvt z1.h, p2/M, z17.s\n"
    "st1h { z28.h }, p2, [x26, #2, MUL VL]\n"
    "addvl x26, x26, #-3\n"
    ".inst 0x658aa965  // bfcvt z5.h, p2/M, z11.s\n"
    ".inst 0x648aaa93  // bfcvtnt z19.h, p2/M, z20.s\n"
    "ld1w { z13.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "ld1w { z0.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x648aa841  // bfcvtnt z1.h, p2/M, z2.s\n"
    "ld1w { z17.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "ld1w { z29.s }, p2/Z, [x20]\n"
    "mov x20, x27\n"
    "incb x27\n"
    "st1h { z19.h }, p2, [x26]\n"
    ".inst 0x658aaad3  // bfcvt z19.h, p2/M, z22.s\n"
    "ld1w { z18.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "st1h { z1.h }, p2, [x26, #1, MUL VL]\n"
    ".inst 0x658aa814  // bfcvt z20.h, p2/M, z0.s\n"
    "st1h { z5.h }, p2, [x26, #2, MUL VL]\n"
    "addvl x26, x26, #-3\n"
    ".inst 0x658aabaf  // bfcvt z15.h, p2/M, z29.s\n"
    ".inst 0x648aa9b3  // bfcvtnt z19.h, p2/M, z13.s\n"
    "ld1w { z7.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "ld1w { z13.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x648aaa34  // bfcvtnt z20.h, p2/M, z17.s\n"
    "ld1w { z29.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "ld1w { z11.s }, p2/Z, [x20]\n"
    "mov x20, x27\n"
    "st1h { z19.h }, p2, [x26]\n"
    ".inst 0x658aaa5c  // bfcvt z28.h, p2/M, z18.s\n"
    "ld1w { z16.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "st1h { z20.h }, p2, [x26, #1, MUL VL]\n"
    ".inst 0x658aa9b6  // bfcvt z22.h, p2/M, z13.s\n"
    "st1h { z15.h }, p2, [x26, #2, MUL VL]\n"
    "addvl x26, x26, #-3\n"
    ".inst 0x658aa965  // bfcvt z5.h, p2/M, z11.s\n"
    ".inst 0x648aa8fc  // bfcvtnt z28.h, p2/M, z7.s\n"
    "ld1w { z19.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "ld1w { z13.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    ".inst 0x648aabb6  // bfcvtnt z22.h, p2/M, z29.s\n"
    "ld1w { z2.s }, p2/Z, [x20]\n"
    "incb x20, ALL, MUL #5\n"
    "ld1w { z0.s }, p2/Z, [x20]\n"
    "st1h { z28.h }, p2, [x26]\n"
    ".inst 0x658aaa10  // bfcvt z16.h, p2/M, z16.s\n"
    "st1h { z22.h }, p2, [x26, #1, MUL VL]\n"
    ".inst 0x658aa9b2  // bfcvt z18.h, p2/M, z13.s\n"
    "st1h { z5.h }, p2, [x26, #2, MUL VL]\n"
    "addvl x26, x26, #-3\n"
    ".inst 0x658aa81c  // bfcvt z28.h, p2/M, z0.s\n"
    ".inst 0x648aaa70  // bfcvtnt z16.h, p2/M, z19.s\n"
    ".inst 0x648aa852  // bfcvtnt z18.h, p2/M, z2.s\n"
    "st1h { z16.h }, p2, [x26]\n"
    "st1h { z18.h }, p2, [x26, #1, MUL VL]\n"
    "st1h { z28.h }, p2, [x26, #2, MUL VL]\n"
    "3:"  // Issue prefetches
    "subs x25, x25, #0x1\n"
    ".inst 0xf8b54afc  // rprfm pldstrm, x21, [x23]\n"
    "add x23, x23, %x[ld_in_col], LSL #2\n"
    "bgt 3b\n"
    "ldr x23, [%x[args], %[offsetof_Args_outptrs]]\n"
    "lsl x21, %x[ld_in_row], #0x2\n"
    ".inst 0xc0040f00  // mova za.d[x8, #0], { z24.d-z27.d }\n"
    "mov x22, #0x4\n"
    "ldr x20, [%x[args], %[offsetof_Args_ld_out_cols]]\n"
    "msub x17, x4, x21, x17\n"
    ".inst 0xc0040f01  // mova za.d[x8, #1], { z24.d-z27.d }\n"
    "ldr x21, [%x[args], %[offsetof_Args_pad_left]]\n"
    ".inst 0xc0040f02  // mova za.d[x8, #2], { z24.d-z27.d }\n"
    "ldp x15, x14, [x23], #0x10\n"
    ".inst 0xc0040f03  // mova za.d[x8, #3], { z24.d-z27.d }\n"
    "ldp x13, x11, [x20], #0x10\n"
    ".inst 0xc0040f04  // mova za.d[x8, #4], { z24.d-z27.d }\n"
    "ldp x10, x9, [x23], #0x10\n"
    "ldp x28, x27, [x20], #0x10\n"
    "cbz x21, 5f\n"
    "cmp x21, x22\n"
    "csel x20, x21, x22, LT\n"
    "sub x21, x21, x20\n"
    "sub x22, x22, x20\n"
    "cbz x21, 5f\n"
    ".inst 0xc0060c00  // mova { z0.d-z3.d }, za.d[x8, #0]\n"
    "and x22, x21, #0x1\n"
    "add x21, x21, #0x1\n"
    "lsr x21, x21, #0x1\n"
    "sub x16, x16, x21\n"
    ".inst 0xc1bfcbc0  // fclamp { z0.s-z3.s }, z30.s, z31.s\n"
    "4:"  // Left padding
    "subs x21, x21, #0x1\n"
    "st1w { z0.s }, p1, [x15]\n"
    "add x15, x15, x13, LSL #2\n"
    "st1w { z1.s }, p1, [x14]\n"
    "add x14, x14, x11, LSL #2\n"
    "st1w { z2.s }, p1, [x10]\n"
    "add x10, x10, x28, LSL #2\n"
    "st1w { z3.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    "bgt 4b\n"
    "5:"  // Left padding: End
    "adds XZR, x4, x3\n"
    "bne 12f\n"
    "cbz x22, 10f\n"
    "cmp x22, #0x1\n"
    "sub x7, x7, x22\n"
    "beq 9f\n"
    "cmp x22, #0x2\n"
    "beq 8f\n"
    "cmp x22, #0x3\n"
    "beq 7f\n"
    "6:"  // Unpadded: 4 priming loads
    "add x21, x17, %x[ld_in_row], LSL #2\n"
    "ld1w { z2.s }, p1/Z, [x17]\n"
    "addvl x20, SP, #12\n"
    "ld1w { z18.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1w { z5.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "ld1w { z17.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa84d  // bfcvt z13.h, p2/M, z2.s\n"
    "ld1w { z19.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "ld1w { z21.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa8ae  // bfcvt z14.h, p2/M, z5.s\n"
    "ld1w { z16.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "ld1w { z1.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa6f  // bfcvt z15.h, p2/M, z19.s\n"
    ".inst 0x648aaa4d  // bfcvtnt z13.h, p2/M, z18.s\n"
    "ld1w { z20.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa10  // bfcvt z16.h, p2/M, z16.s\n"
    ".inst 0x648aaa2e  // bfcvtnt z14.h, p2/M, z17.s\n"
    ".inst 0xa0402a84  // ld1h { z4.h-z5.h }, pn10.b/Z, [x20]\n"
    "ld1w { z3.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaaaf  // bfcvtnt z15.h, p2/M, z21.s\n"
    ".inst 0x658aaa91  // bfcvt z17.h, p2/M, z20.s\n"
    "ld1w { z19.s }, p1/Z, [x21]\n"
    "ld1h { z12.h }, p2/Z, [x20, #2, MUL VL]\n"
    ".inst 0x648aa830  // bfcvtnt z16.h, p2/M, z1.s\n"
    ".inst 0x658aaa72  // bfcvt z18.h, p2/M, z19.s\n"
    ".inst 0x648aa871  // bfcvtnt z17.h, p2/M, z3.s\n"
    ".inst 0xc13411b0  // bfdot za.s[x8, 0], { z13.h-z16.h }, z4.h\n"
    ".inst 0xc13511d0  // bfdot za.s[x8, 0], { z14.h-z17.h }, z5.h\n"
    ".inst 0xc13c11f0  // bfdot za.s[x8, 0], { z15.h-z18.h }, z12.h\n"
    "7:"  // Unpadded: 3 priming loads
    "add x21, x17, %x[ld_in_row], LSL #2\n"
    "ld1w { z17.s }, p1/Z, [x17]\n"
    "addvl x20, SP, #9\n"
    "ld1w { z4.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1w { z11.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "ld1w { z13.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa25  // bfcvt z5.h, p2/M, z17.s\n"
    "ld1w { z18.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "ld1w { z12.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa966  // bfcvt z6.h, p2/M, z11.s\n"
    "ld1w { z14.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "ld1w { z10.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa47  // bfcvt z7.h, p2/M, z18.s\n"
    ".inst 0x648aa885  // bfcvtnt z5.h, p2/M, z4.s\n"
    "ld1w { z0.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa9c8  // bfcvt z8.h, p2/M, z14.s\n"
    ".inst 0x648aa9a6  // bfcvtnt z6.h, p2/M, z13.s\n"
    ".inst 0xa1402a83  // ld1h { z3.h, z11.h }, pn10.b/Z, [x20]\n"
    "ld1w { z4.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa987  // bfcvtnt z7.h, p2/M, z12.s\n"
    ".inst 0x658aa809  // bfcvt z9.h, p2/M, z0.s\n"
    "ld1w { z0.s }, p1/Z, [x21]\n"
    "ld1h { z2.h }, p2/Z, [x20, #2, MUL VL]\n"
    ".inst 0x648aa948  // bfcvtnt z8.h, p2/M, z10.s\n"
    ".inst 0x658aa80a  // bfcvt z10.h, p2/M, z0.s\n"
    ".inst 0x648aa889  // bfcvtnt z9.h, p2/M, z4.s\n"
    ".inst 0xc13310b0  // bfdot za.s[x8, 0], { z5.h-z8.h }, z3.h\n"
    ".inst 0xc13b10d0  // bfdot za.s[x8, 0], { z6.h-z9.h }, z11.h\n"
    ".inst 0xc13210f0  // bfdot za.s[x8, 0], { z7.h-z10.h }, z2.h\n"
    "8:"  // Unpadded: 2 priming loads
    "add x22, x17, %x[ld_in_row], LSL #2\n"
    "ld1w { z11.s }, p1/Z, [x17]\n"
    "addvl x21, SP, #6\n"
    "ld1w { z23.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    "addvl x20, SP, #12\n"
    "ld1w { z19.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1w { z28.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa96b  // bfcvt z11.h, p2/M, z11.s\n"
    "ld1w { z18.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    "ld1w { z6.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa6c  // bfcvt z12.h, p2/M, z19.s\n"
    "ld1w { z17.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    "ld1w { z29.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa4d  // bfcvt z13.h, p2/M, z18.s\n"
    ".inst 0x648aaaeb  // bfcvtnt z11.h, p2/M, z23.s\n"
    "ld1w { z16.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa2e  // bfcvt z14.h, p2/M, z17.s\n"
    ".inst 0x648aab8c  // bfcvtnt z12.h, p2/M, z28.s\n"
    ".inst 0xa1402aa2  // ld1h { z2.h, z10.h }, pn10.b/Z, [x21]\n"
    "ld1w { z20.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa8cd  // bfcvtnt z13.h, p2/M, z6.s\n"
    ".inst 0x658aaa0f  // bfcvt z15.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p1/Z, [x22]\n"
    "ld1h { z3.h }, p2/Z, [x21, #2, MUL VL]\n"
    ".inst 0x648aabae  // bfcvtnt z14.h, p2/M, z29.s\n"
    ".inst 0x658aaa10  // bfcvt z16.h, p2/M, z16.s\n"
    ".inst 0x648aaa8f  // bfcvtnt z15.h, p2/M, z20.s\n"
    ".inst 0xc1321170  // bfdot za.s[x8, 0], { z11.h-z14.h }, z2.h\n"
    ".inst 0xc13a1190  // bfdot za.s[x8, 0], { z12.h-z15.h }, z10.h\n"
    ".inst 0xa0402a80  // ld1h { z0.h-z1.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc1301171  // bfdot za.s[x8, 1], { z11.h-z14.h }, z0.h\n"
    ".inst 0xc13311b0  // bfdot za.s[x8, 0], { z13.h-z16.h }, z3.h\n"
    "ld1h { z0.h }, p2/Z, [x20, #2, MUL VL]\n"
    ".inst 0xc1311191  // bfdot za.s[x8, 1], { z12.h-z15.h }, z1.h\n"
    ".inst 0xc13011b1  // bfdot za.s[x8, 1], { z13.h-z16.h }, z0.h\n"
    "9:"  // Unpadded: 1 priming loads
    "add x22, x17, %x[ld_in_row], LSL #2\n"
    "ld1w { z16.s }, p1/Z, [x17]\n"
    "addvl x21, SP, #3\n"
    "ld1w { z5.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    "addvl x20, SP, #9\n"
    "ld1w { z23.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1w { z0.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa11  // bfcvt z17.h, p2/M, z16.s\n"
    "ld1w { z28.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    "ld1w { z22.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaaf2  // bfcvt z18.h, p2/M, z23.s\n"
    "ld1w { z16.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    "ld1w { z8.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab93  // bfcvt z19.h, p2/M, z28.s\n"
    ".inst 0x648aa8b1  // bfcvtnt z17.h, p2/M, z5.s\n"
    "ld1w { z21.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa14  // bfcvt z20.h, p2/M, z16.s\n"
    ".inst 0x648aa812  // bfcvtnt z18.h, p2/M, z0.s\n"
    ".inst 0xa1402aa2  // ld1h { z2.h, z10.h }, pn10.b/Z, [x21]\n"
    "ld1w { z13.s }, p1/Z, [x22]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaad3  // bfcvtnt z19.h, p2/M, z22.s\n"
    ".inst 0x658aaab5  // bfcvt z21.h, p2/M, z21.s\n"
    "ld1w { z16.s }, p1/Z, [x22]\n"
    "ld1h { z0.h }, p2/Z, [x21, #2, MUL VL]\n"
    ".inst 0x648aa914  // bfcvtnt z20.h, p2/M, z8.s\n"
    ".inst 0x658aaa16  // bfcvt z22.h, p2/M, z16.s\n"
    ".inst 0x648aa9b5  // bfcvtnt z21.h, p2/M, z13.s\n"
    ".inst 0xc1321230  // bfdot za.s[x8, 0], { z17.h-z20.h }, z2.h\n"
    ".inst 0xc13a1250  // bfdot za.s[x8, 0], { z18.h-z21.h }, z10.h\n"
    ".inst 0xa1402a83  // ld1h { z3.h, z11.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc1331231  // bfdot za.s[x8, 1], { z17.h-z20.h }, z3.h\n"
    ".inst 0xc1301270  // bfdot za.s[x8, 0], { z19.h-z22.h }, z0.h\n"
    "ld1h { z7.h }, p2/Z, [x20, #2, MUL VL]\n"
    ".inst 0xc13b1251  // bfdot za.s[x8, 1], { z18.h-z21.h }, z11.h\n"
    ".inst 0xc1371271  // bfdot za.s[x8, 1], { z19.h-z22.h }, z7.h\n"
    "10:"  // Unpadded: 0 priming loads
    "cmp x7, #0x2\n"
    ".inst 0xa1402be0  // ld1h { z0.h, z8.h }, pn10.b/Z, [SP]\n"
    "ld1h { z9.h }, p2/Z, [SP, #2, MUL VL]\n"
    "blt 20f\n"
    "add x21, x17, %x[ld_in_row], LSL #2\n"
    "ld1w { z10.s }, p1/Z, [x17]\n"
    "sub x7, x7, #0x2\n"
    "ld1w { z14.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "sub x16, x16, #0x1\n"
    "ld1w { z21.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "lsr x20, x7, #0x1\n"
    "ld1w { z19.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa941  // bfcvt z1.h, p2/M, z10.s\n"
    "cmp x20, x16\n"
    "ld1w { z28.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "csel x26, x20, x16, LT\n"
    "ld1w { z16.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaaa2  // bfcvt z2.h, p2/M, z21.s\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1w { z6.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "and x7, x7, #0x1\n"
    "ld1w { z23.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aab83  // bfcvt z3.h, p2/M, z28.s\n"
    ".inst 0x648aa9c1  // bfcvtnt z1.h, p2/M, z14.s\n"
    "ld1w { z5.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "sub x16, x16, x26\n"
    "ld1w { z12.s }, p1/Z, [x21]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa8c4  // bfcvt z4.h, p2/M, z6.s\n"
    ".inst 0x648aaa62  // bfcvtnt z2.h, p2/M, z19.s\n"
    "ld1w { z29.s }, p1/Z, [x21]\n"
    ".inst 0x658aa8a5  // bfcvt z5.h, p2/M, z5.s\n"
    ".inst 0x648aaa03  // bfcvtnt z3.h, p2/M, z16.s\n"
    ".inst 0x648aaae4  // bfcvtnt z4.h, p2/M, z23.s\n"
    ".inst 0x658aaba6  // bfcvt z6.h, p2/M, z29.s\n"
    ".inst 0x648aa985  // bfcvtnt z5.h, p2/M, z12.s\n"
    "cbz x26, 19f\n"
    "11:"  // Unpadded: Main loop
    ".inst 0xc1301030  // bfdot za.s[x8, 0], { z1.h-z4.h }, z0.h\n"
    "addvl x25, SP, #6\n"
    "addvl x24, SP, #12\n"
    "ld1w { z10.s }, p1/Z, [x17]\n"
    "add x23, x17, %x[ld_in_row], LSL #2\n"
    "addvl x22, SP, #3\n"
    "ld1w { z13.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1w { z11.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    "addvl x21, SP, #9\n"
    ".inst 0xc1381050  // bfdot za.s[x8, 0], { z2.h-z5.h }, z8.h\n"
    ".inst 0xa1402b27  // ld1h { z7.h, z15.h }, pn10.b/Z, [x25]\n"
    "add x20, x17, %x[ld_in_row], LSL #2\n"
    "subs x26, x26, #0x1\n"
    "ld1w { z22.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    "ld1w { z21.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1371031  // bfdot za.s[x8, 1], { z1.h-z4.h }, z7.h\n"
    "ld1w { z0.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1391070  // bfdot za.s[x8, 0], { z3.h-z6.h }, z9.h\n"
    "ld1h { z12.h }, p2/Z, [x25, #2, MUL VL]\n"
    "ld1w { z8.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    "ld1w { z20.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13f1051  // bfdot za.s[x8, 1], { z2.h-z5.h }, z15.h\n"
    ".inst 0xa0402b0e  // ld1h { z14.h-z15.h }, pn10.b/Z, [x24]\n"
    "ld1w { z29.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0xc0060c10  // mova { z16.d-z19.d }, za.d[x8, #0]\n"
    "ld1w { z9.s }, p1/Z, [x23]\n"
    "add x23, x23, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13e1032  // bfdot za.s[x8, 2], { z1.h-z4.h }, z14.h\n"
    ".inst 0x658aa941  // bfcvt z1.h, p2/M, z10.s\n"
    "ld1w { z23.s }, p1/Z, [x23]\n"
    ".inst 0xc13c1071  // bfdot za.s[x8, 1], { z3.h-z6.h }, z12.h\n"
    "ld1h { z12.h }, p2/Z, [x24, #2, MUL VL]\n"
    "ld1w { z28.s }, p1/Z, [x17]\n"
    ".inst 0xc1bfcbd0  // fclamp { z16.s-z19.s }, z30.s, z31.s\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1w { z10.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13f1052  // bfdot za.s[x8, 2], { z2.h-z5.h }, z15.h\n"
    ".inst 0x658aa962  // bfcvt z2.h, p2/M, z11.s\n"
    ".inst 0x648aa9a1  // bfcvtnt z1.h, p2/M, z13.s\n"
    ".inst 0xa0402ace  // ld1h { z14.h-z15.h }, pn10.b/Z, [x22]\n"
    "ld1w { z13.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "st1w { z16.s }, p1, [x15]\n"
    "add x15, x15, x13, LSL #2\n"
    "ld1w { z11.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "st1w { z17.s }, p1, [x14]\n"
    "add x14, x14, x11, LSL #2\n"
    ".inst 0xc13c1072  // bfdot za.s[x8, 2], { z3.h-z6.h }, z12.h\n"
    ".inst 0x658aaaa3  // bfcvt z3.h, p2/M, z21.s\n"
    ".inst 0x658aa904  // bfcvt z4.h, p2/M, z8.s\n"
    "add x8, x8, #0x1\n"
    ".inst 0x648aaac2  // bfcvtnt z2.h, p2/M, z22.s\n"
    ".inst 0x658aaba5  // bfcvt z5.h, p2/M, z29.s\n"
    "ld1w { z12.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaae6  // bfcvt z6.h, p2/M, z23.s\n"
    "ld1h { z8.h }, p2/Z, [x22, #2, MUL VL]\n"
    "st1w { z18.s }, p1, [x10]\n"
    "add x10, x10, x28, LSL #2\n"
    "ld1w { z7.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "st1w { z19.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    ".inst 0x648aa803  // bfcvtnt z3.h, p2/M, z0.s\n"
    ".inst 0x648aaa84  // bfcvtnt z4.h, p2/M, z20.s\n"
    "ld1w { z21.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aa925  // bfcvtnt z5.h, p2/M, z9.s\n"
    "ld1w { z16.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc0040f04  // mova za.d[x8, #4], { z24.d-z27.d }\n"
    "ld1w { z20.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "ld1w { z18.s }, p1/Z, [x20]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13e1030  // bfdot za.s[x8, 0], { z1.h-z4.h }, z14.h\n"
    "ld1w { z17.s }, p1/Z, [x20]\n"
    ".inst 0xc13f1050  // bfdot za.s[x8, 0], { z2.h-z5.h }, z15.h\n"
    ".inst 0xa0402aae  // ld1h { z14.h-z15.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc13e1031  // bfdot za.s[x8, 1], { z1.h-z4.h }, z14.h\n"
    ".inst 0x658aab81  // bfcvt z1.h, p2/M, z28.s\n"
    ".inst 0xc1381070  // bfdot za.s[x8, 0], { z3.h-z6.h }, z8.h\n"
    "ld1h { z14.h }, p2/Z, [x21, #2, MUL VL]\n"
    ".inst 0xc13f1051  // bfdot za.s[x8, 1], { z2.h-z5.h }, z15.h\n"
    ".inst 0x658aa9a2  // bfcvt z2.h, p2/M, z13.s\n"
    ".inst 0xa1402be0  // ld1h { z0.h, z8.h }, pn10.b/Z, [SP]\n"
    ".inst 0x648aa941  // bfcvtnt z1.h, p2/M, z10.s\n"
    ".inst 0xc13e1071  // bfdot za.s[x8, 1], { z3.h-z6.h }, z14.h\n"
    ".inst 0x658aa983  // bfcvt z3.h, p2/M, z12.s\n"
    ".inst 0x658aaaa4  // bfcvt z4.h, p2/M, z21.s\n"
    ".inst 0x658aaa85  // bfcvt z5.h, p2/M, z20.s\n"
    "ld1h { z9.h }, p2/Z, [SP, #2, MUL VL]\n"
    ".inst 0x648aa962  // bfcvtnt z2.h, p2/M, z11.s\n"
    ".inst 0x658aaa26  // bfcvt z6.h, p2/M, z17.s\n"
    ".inst 0x648aa8e3  // bfcvtnt z3.h, p2/M, z7.s\n"
    ".inst 0x648aaa04  // bfcvtnt z4.h, p2/M, z16.s\n"
    ".inst 0x648aaa45  // bfcvtnt z5.h, p2/M, z18.s\n"
    "bgt 11b\n"
    "b 19f\n"
    "12:"  // Padded
    "cbz x22, 17f\n"
    "cmp x22, #0x1\n"
    "sub x7, x7, x22\n"
    "beq 16f\n"
    "cmp x22, #0x2\n"
    "beq 15f\n"
    "cmp x22, #0x3\n"
    "beq 14f\n"
    "13:"  // Padded: 4 priming loads
    "mov x12, #0x0\n"
    "add x21, x17, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "addvl x20, SP, #12\n"
    ".inst 0xa1402a82  // ld1h { z2.h, z10.h }, pn10.b/Z, [x20]\n"
    "ld1h { z0.h }, p2/Z, [x20, #2, MUL VL]\n"
    "ld1w { z16.s }, p0/Z, [x17]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0b  // bfcvt z11.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0x648aaa2b  // bfcvtnt z11.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0c  // bfcvt z12.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa2c  // bfcvtnt z12.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0d  // bfcvt z13.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x8\n"
    ".inst 0x648aaa2d  // bfcvtnt z13.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0e  // bfcvt z14.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa2e  // bfcvtnt z14.h, p2/M, z17.s\n"
    ".inst 0x658aaa0f  // bfcvt z15.h, p2/M, z16.s\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1321170  // bfdot za.s[x8, 0], { z11.h-z14.h }, z2.h\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x648aaa2f  // bfcvtnt z15.h, p2/M, z17.s\n"
    ".inst 0x658aaa10  // bfcvt z16.h, p2/M, z16.s\n"
    ".inst 0xc13a1190  // bfdot za.s[x8, 0], { z12.h-z15.h }, z10.h\n"
    ".inst 0xc13011b0  // bfdot za.s[x8, 0], { z13.h-z16.h }, z0.h\n"
    "14:"  // Padded: 3 priming loads
    "mov x12, #0x0\n"
    "add x21, x17, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "addvl x20, SP, #9\n"
    ".inst 0xa1402a82  // ld1h { z2.h, z10.h }, pn10.b/Z, [x20]\n"
    "ld1h { z0.h }, p2/Z, [x20, #2, MUL VL]\n"
    "ld1w { z16.s }, p0/Z, [x17]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0b  // bfcvt z11.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0x648aaa2b  // bfcvtnt z11.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0c  // bfcvt z12.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa2c  // bfcvtnt z12.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0d  // bfcvt z13.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x8\n"
    ".inst 0x648aaa2d  // bfcvtnt z13.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0e  // bfcvt z14.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa2e  // bfcvtnt z14.h, p2/M, z17.s\n"
    ".inst 0x658aaa0f  // bfcvt z15.h, p2/M, z16.s\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1321170  // bfdot za.s[x8, 0], { z11.h-z14.h }, z2.h\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x648aaa2f  // bfcvtnt z15.h, p2/M, z17.s\n"
    ".inst 0x658aaa10  // bfcvt z16.h, p2/M, z16.s\n"
    ".inst 0xc13a1190  // bfdot za.s[x8, 0], { z12.h-z15.h }, z10.h\n"
    ".inst 0xc13011b0  // bfdot za.s[x8, 0], { z13.h-z16.h }, z0.h\n"
    "15:"  // Padded: 2 priming loads
    "mov x12, #0x0\n"
    "add x22, x17, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "addvl x21, SP, #6\n"
    ".inst 0xa0402aa8  // ld1h { z8.h-z9.h }, pn10.b/Z, [x21]\n"
    "addvl x20, SP, #12\n"
    "ld1h { z2.h }, p2/Z, [x21, #2, MUL VL]\n"
    "ld1w { z16.s }, p0/Z, [x17]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0b  // bfcvt z11.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0x648aaa2b  // bfcvtnt z11.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0c  // bfcvt z12.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa2c  // bfcvtnt z12.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0d  // bfcvt z13.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x8\n"
    ".inst 0x648aaa2d  // bfcvtnt z13.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0e  // bfcvt z14.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa2e  // bfcvtnt z14.h, p2/M, z17.s\n"
    ".inst 0x658aaa0f  // bfcvt z15.h, p2/M, z16.s\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1381170  // bfdot za.s[x8, 0], { z11.h-z14.h }, z8.h\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x648aaa2f  // bfcvtnt z15.h, p2/M, z17.s\n"
    ".inst 0x658aaa10  // bfcvt z16.h, p2/M, z16.s\n"
    ".inst 0xc1391190  // bfdot za.s[x8, 0], { z12.h-z15.h }, z9.h\n"
    ".inst 0xa0402a80  // ld1h { z0.h-z1.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc1301171  // bfdot za.s[x8, 1], { z11.h-z14.h }, z0.h\n"
    ".inst 0xc13211b0  // bfdot za.s[x8, 0], { z13.h-z16.h }, z2.h\n"
    "ld1h { z0.h }, p2/Z, [x20, #2, MUL VL]\n"
    ".inst 0xc1311191  // bfdot za.s[x8, 1], { z12.h-z15.h }, z1.h\n"
    ".inst 0xc13011b1  // bfdot za.s[x8, 1], { z13.h-z16.h }, z0.h\n"
    "16:"  // Padded: 1 priming loads
    "mov x12, #0x0\n"
    "add x22, x17, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "addvl x21, SP, #3\n"
    ".inst 0xa0402aa8  // ld1h { z8.h-z9.h }, pn10.b/Z, [x21]\n"
    "addvl x20, SP, #9\n"
    "ld1h { z2.h }, p2/Z, [x21, #2, MUL VL]\n"
    "ld1w { z16.s }, p0/Z, [x17]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0b  // bfcvt z11.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0x648aaa2b  // bfcvtnt z11.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0c  // bfcvt z12.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa2c  // bfcvtnt z12.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0d  // bfcvt z13.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x8\n"
    ".inst 0x648aaa2d  // bfcvtnt z13.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa0e  // bfcvt z14.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa2e  // bfcvtnt z14.h, p2/M, z17.s\n"
    ".inst 0x658aaa0f  // bfcvt z15.h, p2/M, z16.s\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1381170  // bfdot za.s[x8, 0], { z11.h-z14.h }, z8.h\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x648aaa2f  // bfcvtnt z15.h, p2/M, z17.s\n"
    ".inst 0x658aaa10  // bfcvt z16.h, p2/M, z16.s\n"
    ".inst 0xc1391190  // bfdot za.s[x8, 0], { z12.h-z15.h }, z9.h\n"
    ".inst 0xa0402a80  // ld1h { z0.h-z1.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc1301171  // bfdot za.s[x8, 1], { z11.h-z14.h }, z0.h\n"
    ".inst 0xc13211b0  // bfdot za.s[x8, 0], { z13.h-z16.h }, z2.h\n"
    "ld1h { z0.h }, p2/Z, [x20, #2, MUL VL]\n"
    ".inst 0xc1311191  // bfdot za.s[x8, 1], { z12.h-z15.h }, z1.h\n"
    ".inst 0xc13011b1  // bfdot za.s[x8, 1], { z13.h-z16.h }, z0.h\n"
    "17:"  // Padded: 0 priming loads
    "cmp x7, #0x2\n"
    ".inst 0xa1402be0  // ld1h { z0.h, z8.h }, pn10.b/Z, [SP]\n"
    "ld1h { z9.h }, p2/Z, [SP, #2, MUL VL]\n"
    "blt 20f\n"
    "mov x12, #0x0\n"
    "add x21, x17, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "sub x7, x7, #0x2\n"
    "sub x16, x16, #0x1\n"
    "lsr x20, x7, #0x1\n"
    "cmp x20, x16\n"
    "and x7, x7, #0x1\n"
    "ld1w { z16.s }, p0/Z, [x17]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "csel x26, x20, x16, LT\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    "sub x16, x16, x26\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa01  // bfcvt z1.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0x648aaa21  // bfcvtnt z1.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa02  // bfcvt z2.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa22  // bfcvtnt z2.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa03  // bfcvt z3.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x8\n"
    ".inst 0x648aaa23  // bfcvtnt z3.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa04  // bfcvt z4.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x21]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa24  // bfcvtnt z4.h, p2/M, z17.s\n"
    "ld1w { z18.s }, p0/Z, [x21]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x21, x21, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa05  // bfcvt z5.h, p2/M, z16.s\n"
    "ld1w { z17.s }, p0/Z, [x21]\n"
    ".inst 0x648aaa45  // bfcvtnt z5.h, p2/M, z18.s\n"
    ".inst 0x658aaa26  // bfcvt z6.h, p2/M, z17.s\n"
    "cbz x26, 19f\n"
    "18:"  // Padded: Main loop
    "mov x12, #0x0\n"
    "add x25, x17, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1301030  // bfdot za.s[x8, 0], { z1.h-z4.h }, z0.h\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "addvl x24, SP, #6\n"
    "addvl x23, SP, #12\n"
    "addvl x22, SP, #3\n"
    "addvl x21, SP, #9\n"
    "subs x26, x26, #0x1\n"
    "ld1w { z18.s }, p0/Z, [x17]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    ".inst 0xc1381050  // bfdot za.s[x8, 0], { z2.h-z5.h }, z8.h\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    ".inst 0xa0402b0a  // ld1h { z10.h-z11.h }, pn10.b/Z, [x24]\n"
    "add x20, x17, %x[ld_in_row], LSL #2\n"
    "ld1w { z0.s }, p0/Z, [x25]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x25, x25, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13a1031  // bfdot za.s[x8, 1], { z1.h-z4.h }, z10.h\n"
    ".inst 0xc1391070  // bfdot za.s[x8, 0], { z3.h-z6.h }, z9.h\n"
    "ld1h { z9.h }, p2/Z, [x24, #2, MUL VL]\n"
    "ld1w { z19.s }, p0/Z, [x25]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x25, x25, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0xc13b1051  // bfdot za.s[x8, 1], { z2.h-z5.h }, z11.h\n"
    ".inst 0xa0402aea  // ld1h { z10.h-z11.h }, pn10.b/Z, [x23]\n"
    "ld1w { z17.s }, p0/Z, [x25]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x25, x25, %x[ld_in_row], LSL #2\n"
    ".inst 0xc0060c0c  // mova { z12.d-z15.d }, za.d[x8, #0]\n"
    ".inst 0xc13a1032  // bfdot za.s[x8, 2], { z1.h-z4.h }, z10.h\n"
    ".inst 0x658aaa52  // bfcvt z18.h, p2/M, z18.s\n"
    "ld1w { z16.s }, p0/Z, [x25]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x25, x25, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1391071  // bfdot za.s[x8, 1], { z3.h-z6.h }, z9.h\n"
    "ld1h { z9.h }, p2/Z, [x23, #2, MUL VL]\n"
    ".inst 0xc1bfcbcc  // fclamp { z12.s-z15.s }, z30.s, z31.s\n"
    "ld1w { z22.s }, p0/Z, [x25]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x25, x25, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13b1052  // bfdot za.s[x8, 2], { z2.h-z5.h }, z11.h\n"
    ".inst 0x658aaa73  // bfcvt z19.h, p2/M, z19.s\n"
    ".inst 0x648aa812  // bfcvtnt z18.h, p2/M, z0.s\n"
    ".inst 0xa1402ac0  // ld1h { z0.h, z8.h }, pn10.b/Z, [x22]\n"
    "st1w { z12.s }, p1, [x15]\n"
    "add x15, x15, x13, LSL #2\n"
    "ld1w { z11.s }, p0/Z, [x25]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x25, x25, %x[ld_in_row], LSL #2\n"
    "st1w { z13.s }, p1, [x14]\n"
    "mov x12, #0x8\n"
    ".inst 0xc1391072  // bfdot za.s[x8, 2], { z3.h-z6.h }, z9.h\n"
    ".inst 0x658aaa14  // bfcvt z20.h, p2/M, z16.s\n"
    "add x8, x8, #0x1\n"
    ".inst 0x648aaa33  // bfcvtnt z19.h, p2/M, z17.s\n"
    "ld1h { z2.h }, p2/Z, [x22, #2, MUL VL]\n"
    "add x14, x14, x11, LSL #2\n"
    "st1w { z14.s }, p1, [x10]\n"
    "ld1w { z16.s }, p0/Z, [x25]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x25, x25, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa975  // bfcvt z21.h, p2/M, z11.s\n"
    "add x10, x10, x28, LSL #2\n"
    "st1w { z15.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    ".inst 0xc0040f04  // mova za.d[x8, #4], { z24.d-z27.d }\n"
    ".inst 0x648aaad4  // bfcvtnt z20.h, p2/M, z22.s\n"
    "ld1w { z17.s }, p0/Z, [x25]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x25, x25, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa15  // bfcvtnt z21.h, p2/M, z16.s\n"
    "ld1w { z9.s }, p0/Z, [x25]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x25, x25, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa36  // bfcvt z22.h, p2/M, z17.s\n"
    "mov x12, #0x0\n"
    ".inst 0xc1301250  // bfdot za.s[x8, 0], { z18.h-z21.h }, z0.h\n"
    "ld1w { z16.s }, p0/Z, [x25]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    ".inst 0x648aa936  // bfcvtnt z22.h, p2/M, z9.s\n"
    "ld1w { z9.s }, p0/Z, [x17]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    ".inst 0x658aaa17  // bfcvt z23.h, p2/M, z16.s\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    ".inst 0xc1381270  // bfdot za.s[x8, 0], { z19.h-z22.h }, z8.h\n"
    ".inst 0xa0402aac  // ld1h { z12.h-z13.h }, pn10.b/Z, [x21]\n"
    "ld1w { z4.s }, p0/Z, [x20]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13c1251  // bfdot za.s[x8, 1], { z18.h-z21.h }, z12.h\n"
    ".inst 0x658aa921  // bfcvt z1.h, p2/M, z9.s\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1321290  // bfdot za.s[x8, 0], { z20.h-z23.h }, z2.h\n"
    "mov x12, #0x4\n"
    "ld1h { z12.h }, p2/Z, [x21, #2, MUL VL]\n"
    "ld1w { z17.s }, p0/Z, [x20]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13d1271  // bfdot za.s[x8, 1], { z19.h-z22.h }, z13.h\n"
    ".inst 0x658aaa02  // bfcvt z2.h, p2/M, z16.s\n"
    ".inst 0xa1402be0  // ld1h { z0.h, z8.h }, pn10.b/Z, [SP]\n"
    ".inst 0x648aa881  // bfcvtnt z1.h, p2/M, z4.s\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13c1291  // bfdot za.s[x8, 1], { z20.h-z23.h }, z12.h\n"
    "ld1h { z9.h }, p2/Z, [SP, #2, MUL VL]\n"
    ".inst 0x648aaa22  // bfcvtnt z2.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x20]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa03  // bfcvt z3.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x8\n"
    ".inst 0x648aaa23  // bfcvtnt z3.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x20]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa04  // bfcvt z4.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x20]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa24  // bfcvtnt z4.h, p2/M, z17.s\n"
    "ld1w { z18.s }, p0/Z, [x20]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x20, x20, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa05  // bfcvt z5.h, p2/M, z16.s\n"
    "ld1w { z17.s }, p0/Z, [x20]\n"
    ".inst 0x648aaa45  // bfcvtnt z5.h, p2/M, z18.s\n"
    ".inst 0x658aaa26  // bfcvt z6.h, p2/M, z17.s\n"
    "bgt 18b\n"
    "19:"  // Main loop tail
    "mov x12, #0x0\n"
    ".inst 0xc1301030  // bfdot za.s[x8, 0], { z1.h-z4.h }, z0.h\n"
    "add x24, x17, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "addvl x23, SP, #6\n"
    "addvl x22, SP, #12\n"
    "addvl x21, SP, #3\n"
    "addvl x20, SP, #9\n"
    "ld1w { z18.s }, p0/Z, [x17]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    ".inst 0xc1381050  // bfdot za.s[x8, 0], { z2.h-z5.h }, z8.h\n"
    "add x17, x17, %x[ld_in_col], LSL #2\n"
    ".inst 0xa0402aec  // ld1h { z12.h-z13.h }, pn10.b/Z, [x23]\n"
    "ld1w { z14.s }, p0/Z, [x24]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13c1031  // bfdot za.s[x8, 1], { z1.h-z4.h }, z12.h\n"
    ".inst 0xc1391070  // bfdot za.s[x8, 0], { z3.h-z6.h }, z9.h\n"
    "ld1h { z7.h }, p2/Z, [x23, #2, MUL VL]\n"
    "ld1w { z17.s }, p0/Z, [x24]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0xc13d1051  // bfdot za.s[x8, 1], { z2.h-z5.h }, z13.h\n"
    ".inst 0xa0402acc  // ld1h { z12.h-z13.h }, pn10.b/Z, [x22]\n"
    "ld1w { z15.s }, p0/Z, [x24]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0xc0060c08  // mova { z8.d-z11.d }, za.d[x8, #0]\n"
    ".inst 0xc13c1032  // bfdot za.s[x8, 2], { z1.h-z4.h }, z12.h\n"
    ".inst 0x658aaa4c  // bfcvt z12.h, p2/M, z18.s\n"
    "ld1w { z19.s }, p0/Z, [x24]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1371071  // bfdot za.s[x8, 1], { z3.h-z6.h }, z7.h\n"
    "ld1h { z7.h }, p2/Z, [x22, #2, MUL VL]\n"
    ".inst 0xc1bfcbc8  // fclamp { z8.s-z11.s }, z30.s, z31.s\n"
    "ld1w { z18.s }, p0/Z, [x24]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0xc13d1052  // bfdot za.s[x8, 2], { z2.h-z5.h }, z13.h\n"
    ".inst 0x658aaa2d  // bfcvt z13.h, p2/M, z17.s\n"
    ".inst 0x648aa9cc  // bfcvtnt z12.h, p2/M, z14.s\n"
    ".inst 0xa0402aa0  // ld1h { z0.h-z1.h }, pn10.b/Z, [x21]\n"
    "st1w { z8.s }, p1, [x15]\n"
    "add x15, x15, x13, LSL #2\n"
    "ld1w { z8.s }, p0/Z, [x24]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    "st1w { z9.s }, p1, [x14]\n"
    "mov x12, #0x8\n"
    ".inst 0xc1371072  // bfdot za.s[x8, 2], { z3.h-z6.h }, z7.h\n"
    ".inst 0x658aaa6e  // bfcvt z14.h, p2/M, z19.s\n"
    "add x8, x8, #0x1\n"
    ".inst 0x648aa9ed  // bfcvtnt z13.h, p2/M, z15.s\n"
    "ld1h { z2.h }, p2/Z, [x21, #2, MUL VL]\n"
    "add x14, x14, x11, LSL #2\n"
    "st1w { z10.s }, p1, [x10]\n"
    "ld1w { z17.s }, p0/Z, [x24]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aa90f  // bfcvt z15.h, p2/M, z8.s\n"
    "add x10, x10, x28, LSL #2\n"
    "st1w { z11.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    ".inst 0xc0040f04  // mova za.d[x8, #4], { z24.d-z27.d }\n"
    ".inst 0x648aaa4e  // bfcvtnt z14.h, p2/M, z18.s\n"
    "ld1w { z16.s }, p0/Z, [x24]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa2f  // bfcvtnt z15.h, p2/M, z17.s\n"
    ".inst 0x658aaa10  // bfcvt z16.h, p2/M, z16.s\n"
    "ld1w { z17.s }, p0/Z, [x24]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x24, x24, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1301190  // bfdot za.s[x8, 0], { z12.h-z15.h }, z0.h\n"
    "ld1w { z9.s }, p0/Z, [x24]\n"
    ".inst 0x648aaa30  // bfcvtnt z16.h, p2/M, z17.s\n"
    ".inst 0x658aa931  // bfcvt z17.h, p2/M, z9.s\n"
    ".inst 0xc13111b0  // bfdot za.s[x8, 0], { z13.h-z16.h }, z1.h\n"
    ".inst 0xa0402a80  // ld1h { z0.h-z1.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc1301191  // bfdot za.s[x8, 1], { z12.h-z15.h }, z0.h\n"
    ".inst 0xc13211d0  // bfdot za.s[x8, 0], { z14.h-z17.h }, z2.h\n"
    "ld1h { z5.h }, p2/Z, [x20, #2, MUL VL]\n"
    ".inst 0xc13111b1  // bfdot za.s[x8, 1], { z13.h-z16.h }, z1.h\n"
    ".inst 0xa1402be0  // ld1h { z0.h, z8.h }, pn10.b/Z, [SP]\n"
    ".inst 0xc13511d1  // bfdot za.s[x8, 1], { z14.h-z17.h }, z5.h\n"
    "ld1h { z9.h }, p2/Z, [SP, #2, MUL VL]\n"
    "20:"  // Main loop skip tail
    "cbz x7, 21f\n"  // Skip remainder inputs
    "mov x12, #0x0\n"
    "add x22, x17, %x[ld_in_row], LSL #2\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "addvl x21, SP, #6\n"
    "addvl x20, SP, #12\n"
    "sub x16, x16, #0x1\n"
    "ld1w { z16.s }, p0/Z, [x17]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa12  // bfcvt z18.h, p2/M, z16.s\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x4\n"
    ".inst 0x648aaa32  // bfcvtnt z18.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa13  // bfcvt z19.h, p2/M, z16.s\n"
    "ld1w { z29.s }, p0/Z, [x22]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa33  // bfcvtnt z19.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aabb4  // bfcvt z20.h, p2/M, z29.s\n"
    "ld1w { z16.s }, p0/Z, [x22]\n"
    ".inst 0x25f04500  // psel p0.s, p1.s/Z, p8.s[w12, #3]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    "mov x12, #0x8\n"
    ".inst 0x648aaa34  // bfcvtnt z20.h, p2/M, z17.s\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25304500  // psel p0.s, p1.s/Z, p8.s[w12]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x658aaa15  // bfcvt z21.h, p2/M, z16.s\n"
    "ld1w { z13.s }, p0/Z, [x22]\n"
    ".inst 0x25704500  // psel p0.s, p1.s/Z, p8.s[w12, #1]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0x648aaa35  // bfcvtnt z21.h, p2/M, z17.s\n"
    ".inst 0x658aa9b6  // bfcvt z22.h, p2/M, z13.s\n"
    "ld1w { z17.s }, p0/Z, [x22]\n"
    ".inst 0x25b04500  // psel p0.s, p1.s/Z, p8.s[w12, #2]\n"
    "add x22, x22, %x[ld_in_row], LSL #2\n"
    ".inst 0xc1301250  // bfdot za.s[x8, 0], { z18.h-z21.h }, z0.h\n"
    "ld1w { z14.s }, p0/Z, [x22]\n"
    ".inst 0x648aaa36  // bfcvtnt z22.h, p2/M, z17.s\n"
    ".inst 0x658aa9d7  // bfcvt z23.h, p2/M, z14.s\n"
    ".inst 0xc1381270  // bfdot za.s[x8, 0], { z19.h-z22.h }, z8.h\n"
    ".inst 0xa0402aa0  // ld1h { z0.h-z1.h }, pn10.b/Z, [x21]\n"
    ".inst 0xc1301251  // bfdot za.s[x8, 1], { z18.h-z21.h }, z0.h\n"
    ".inst 0xc1391290  // bfdot za.s[x8, 0], { z20.h-z23.h }, z9.h\n"
    "ld1h { z14.h }, p2/Z, [x21, #2, MUL VL]\n"
    ".inst 0xc1311271  // bfdot za.s[x8, 1], { z19.h-z22.h }, z1.h\n"
    ".inst 0xa0402a80  // ld1h { z0.h-z1.h }, pn10.b/Z, [x20]\n"
    ".inst 0xc0060c04  // mova { z4.d-z7.d }, za.d[x8, #0]\n"
    ".inst 0xc1301252  // bfdot za.s[x8, 2], { z18.h-z21.h }, z0.h\n"
    ".inst 0xc13e1291  // bfdot za.s[x8, 1], { z20.h-z23.h }, z14.h\n"
    "ld1h { z0.h }, p2/Z, [x20, #2, MUL VL]\n"
    ".inst 0xc1bfcbc4  // fclamp { z4.s-z7.s }, z30.s, z31.s\n"
    ".inst 0xc1311272  // bfdot za.s[x8, 2], { z19.h-z22.h }, z1.h\n"
    "st1w { z4.s }, p1, [x15]\n"
    "add x15, x15, x13, LSL #2\n"
    "st1w { z5.s }, p1, [x14]\n"
    "add x14, x14, x11, LSL #2\n"
    ".inst 0xc1301292  // bfdot za.s[x8, 2], { z20.h-z23.h }, z0.h\n"
    "add x8, x8, #0x1\n"
    "st1w { z6.s }, p1, [x10]\n"
    "add x10, x10, x28, LSL #2\n"
    "st1w { z7.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    ".inst 0xc0040f04  // mova za.d[x8, #4], { z24.d-z27.d }\n"
    "21:"  // Tail input: End
    "cbz x16, 23f\n"
    "22:"  // Right padding loop
    ".inst 0xc0060c10  // mova { z16.d-z19.d }, za.d[x8, #0]\n"
    "add x8, x8, #0x1\n"
    "subs x16, x16, #0x1\n"
    ".inst 0xc0040f04  // mova za.d[x8, #4], { z24.d-z27.d }\n"
    ".inst 0xc1bfcbd0  // fclamp { z16.s-z19.s }, z30.s, z31.s\n"
    "st1w { z16.s }, p1, [x15]\n"
    "add x15, x15, x13, LSL #2\n"
    "st1w { z17.s }, p1, [x14]\n"
    "add x14, x14, x11, LSL #2\n"
    "st1w { z18.s }, p1, [x10]\n"
    "add x10, x10, x28, LSL #2\n"
    "st1w { z19.s }, p1, [x9]\n"
    "add x9, x9, x27, LSL #2\n"
    "bgt 22b\n"
    "23:"  // End
    "ldr x20, [%x[args], %[offsetof_Args_weights]]\n"
    "incw x6\n"
    "whilelt p1.s, x6, x5\n"
    "incb x20, ALL, MUL #16\n"
    "incb x20, ALL, MUL #9\n"
    "str x20, [%x[args], %[offsetof_Args_weights]]\n"
    "ldr x21, [%x[args], %[offsetof_Args_ld_in_vl]]\n"
    "ldr x20, [%x[args], %[offsetof_Args_inptr]]\n"
    "add x20, x20, x21, LSL #2\n"
    "str x20, [%x[args], %[offsetof_Args_inptr]]\n"
    "ldr x25, [%x[args], %[offsetof_Args_outptrs]]\n"
    "ldr x24, [%x[args], %[offsetof_Args_ld_out_vls]]\n"
    "ldp x23, x22, [x25, #0x0]\n"
    "ldp x21, x20, [x24, #0x0]\n"
    "add x23, x23, x21, LSL #2\n"
    "add x22, x22, x20, LSL #2\n"
    "stp x23, x22, [x25, #0x0]\n"
    "ldp x23, x22, [x25, #0x10]\n"
    "ldp x21, x20, [x24, #0x10]\n"
    "add x23, x23, x21, LSL #2\n"
    "add x22, x22, x20, LSL #2\n"
    "stp x23, x22, [x25, #0x10]\n"
    "b.any 1b\n"
    "addvl SP, SP, #15\n"
    ".inst 0xd503467f  // SMSTOP\n"
    "ldr x20, [SP, #0x0]\n"
    "mov SP, x20\n"
    :
    : [args] "r" (&args), [ld_in_col] "r" (ld_in_col), [ld_in_row] "r" (ld_in_row), [offsetof_Args_bias] "I" (offsetof(Args, bias)), [offsetof_Args_clamp_max] "I" (offsetof(Args, clamp_max)), [offsetof_Args_clamp_min] "I" (offsetof(Args, clamp_min)), [offsetof_Args_current_channel] "I" (offsetof(Args, current_channel)), [offsetof_Args_inptr] "I" (offsetof(Args, inptr)), [offsetof_Args_input_cols] "I" (offsetof(Args, input_cols)), [offsetof_Args_ld_in_vl] "I" (offsetof(Args, ld_in_vl)), [offsetof_Args_ld_out_cols] "I" (offsetof(Args, ld_out_cols)), [offsetof_Args_ld_out_vls] "I" (offsetof(Args, ld_out_vls)), [offsetof_Args_n_channels] "I" (offsetof(Args, n_channels)), [offsetof_Args_outptrs] "I" (offsetof(Args, outptrs)), [offsetof_Args_output_cols] "I" (offsetof(Args, output_cols)), [offsetof_Args_pad_bottom] "I" (offsetof(Args, pad_bottom)), [offsetof_Args_pad_left] "I" (offsetof(Args, pad_left)), [offsetof_Args_pad_top] "I" (offsetof(Args, pad_top)), [offsetof_Args_weights] "I" (offsetof(Args, weights))
    : "cc", "memory", "p0", "p1", "p2", "p3", "p4", "p5", "p6", "p7", "p8", "p9", "p10", "p11", "p12", "p13", "p14", "p15", "x3", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13", "x14", "x15", "x16", "x17", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "z16", "z17", "z18", "z19", "z20", "z21", "z22", "z23", "z24", "z25", "z26", "z27", "z28", "z29", "z30", "z31"
  );
}

}  // namespace depthwise
}  // namespace arm_conv

#endif  // defined(ARM_COMPUTE_ENABLE_SME2)
