/* SPDX-License-Identifier: GPL-2.0-or-later */

#define _IIO_DEVICE_NAME(str, skt, stk)     str##skt##stk
#define IIO_DEVICE_NAME(str, skt, stk)      _IIO_DEVICE_NAME(str, skt, stk)
#define IIO_RESOURCE_NAME(res, str, skt, stk)      res##str##skt##stk

#define STR(s)  #s
#define _IIO_DEVICE_UID(str, skt, stk)      STR(str##skt##stk)
#define IIO_DEVICE_UID(str, skt, stk)       _IIO_DEVICE_UID(str, skt, stk)

Device (IIO_DEVICE_NAME(DEVPREFIX, SOCKET_NAME, STACK))
{
	Name (_HID, "ACPI0017") /* CXL */
	Name (_CID, Package (0x02)
	{
		EisaId ("PNP0A08") /* PCI Express Bus */,
		EisaId ("PNP0A03") /* PCI Bus */
	})
	Name (_UID, IIO_DEVICE_UID(DEVPREFIX, SOCKET_NAME, STACK))
	Method (_STA, 0, NotSerialized)
	{
		/*
		 * _CRS is being generated by SSDT for available stacks only and
		 * when missing the stack isn't available.
		 */
		If (CondRefOf (_CRS))
		{
			Return (0xf)
		}
		Else
		{
			Return (0)
		}
	}
	Method (_PRT, 0, NotSerialized)
	{
		Return (\_SB.PRTID)
	}
	Method (_OSC, 4, NotSerialized)
	{
		Return (\_SB.POSC(Arg0, Arg1, Arg2, Arg3,
			(PCIE_LTR_CONTROL|
			PCIE_CAP_STRUCTURE_CONTROL|
			PCIE_PME_CONTROL|
			PCIE_AER_CONTROL|
			PCIE_NATIVE_HOTPLUG_CONTROL), 1,
			CXL_ERROR_REPORTING_CONTROL))
	}
}
