/* SPDX-License-Identifier: GPL-2.0-only OR MIT */

#ifndef __SOC_MEDIATEK_MT8196_INCLUDE_SOC_CLK_BUF_CTL_H__
#define __SOC_MEDIATEK_MT8196_INCLUDE_SOC_CLK_BUF_CTL_H__

#include <console/console.h>

#define MT6685_PMRC_CON0			0x190
#define MT6685_PMRC_CON1			0x191
#define MT6685_PMRC_CON0_SET			0x198
#define MT6685_PMRC_CON1_SET			0x199
#define MT6685_PMRC_CON0_CLR			0x19a
#define MT6685_PMRC_CON1_CLR			0x19b
#define MT6685_PMRC_CON3			0x19c
#define MT6685_XO_BUF_CTL0_L			0x54c
#define MT6685_XO_BUF_CTL0_H			0x54d
#define MT6685_XO_BUF_CTL1_L			0x54e
#define MT6685_XO_BUF_CTL1_H			0x54f
#define MT6685_XO_BUF_CTL2_L			0x550
#define MT6685_XO_BUF_CTL2_H			0x551
#define MT6685_XO_BUF_CTL3_L			0x552
#define MT6685_XO_BUF_CTL3_H			0x553
#define MT6685_XO_BUF_CTL4_L			0x554
#define MT6685_XO_BUF_CTL4_H			0x555
#define MT6685_XO_BUF_CTL5_L			0x556
#define MT6685_XO_BUF_CTL5_H			0x557
#define MT6685_XO_BUF_CTL6_L			0x558
#define MT6685_XO_BUF_CTL6_H			0x559
#define MT6685_XO_BUF_CTL7_L			0x55a
#define MT6685_XO_BUF_CTL7_H			0x55b
#define MT6685_XO_BUF_CTL8_L			0x55c
#define MT6685_XO_BUF_CTL8_H			0x55d
#define MT6685_XO_BUF_CTL9_L			0x55e
#define MT6685_XO_BUF_CTL9_H			0x55f
#define MT6685_XO_BUF_CTL10_L			0x560
#define MT6685_XO_BUF_CTL10_H			0x561
#define MT6685_XO_BUF_CTL11_L			0x562
#define MT6685_XO_BUF_CTL11_H			0x563
#define MT6685_XO_BUF_CTL12_L			0x564
#define MT6685_XO_BUF_CTL12_H			0x565
#define MT6685_XO_CONN_BT0			0x567
#define MT6685_DCXO_DIG_MANCTRL_CW1		0x796
#define MT6685_DCXO_BBLPM_CW0			0x797
#define MT6685_DCXO_BBLPM_CW1			0x798
#define MT6685_DCXO_LDO_CW0			0x799
#define MT6685_DCXO_EXTBUF1_CW0			0x79a
#define MT6685_DCXO_EXTBUF2_CW0			0x79b
#define MT6685_DCXO_EXTBUF3_CW0			0x79c
#define MT6685_DCXO_EXTBUF4_CW0			0x79d
#define MT6685_DCXO_EXTBUF5_CW0			0x79e
#define MT6685_DCXO_EXTBUF6_CW0			0x79f
#define MT6685_DCXO_EXTBUF7_CW0			0x7a0
#define MT6685_DCXO_EXTBUF8_CW0			0x7a1
#define MT6685_DCXO_EXTBUF9_CW0			0x7a2
#define MT6685_DCXO_EXTBUF10_CW0		0x7a3
#define MT6685_DCXO_EXTBUF11_CW0		0x7a4
#define MT6685_DCXO_EXTBUF12_CW0		0x7a5
#define MT6685_DCXO_EXTBUF13_CW0		0x7a6
#define MT6685_DCXO_RGMON_CW0_L			0x7b2
#define MT6685_DCXO_RGMON_CW0_H			0x7b3
#define MT6685_DCXO_RGMON_CW2_L			0x7b4
#define MT6685_DCXO_RGMON_CW2_H			0x7b5
#define MT6685_DCXO_RGMON_CW1			0x7c3
#define MT6685_DCXO_DIGCLK_ELR			0x7f4
#define MT6685_LDO_VBBCK_CON0			0x1b87
#define MT6685_LDO_VBBCK_OP_EN1			0x1b8e
#define MT6685_LDO_VBBCK_OP_EN1_SET		0x1b8f
#define MT6685_LDO_VBBCK_OP_EN1_CLR		0x1b90
#define MT6685_LDO_VRFCK1_CON0			0x1b97
#define MT6685_LDO_VRFCK1_OP_EN1		0x1b9e
#define MT6685_LDO_VRFCK1_OP_EN1_SET		0x1b9f
#define MT6685_LDO_VRFCK1_OP_EN1_CLR		0x1ba0
#define MT6685_LDO_VRFCK2_CON0			0x1ba7
#define MT6685_LDO_VRFCK2_OP_EN1		0x1bae
#define MT6685_LDO_VRFCK2_OP_EN1_SET		0x1baf
#define MT6685_LDO_VRFCK2_OP_EN1_CLR		0x1bb0

/* Register_TOP_REG */
#define RG_DCXO_SRCLKEN1_MODE_ADDR		MT6685_PMRC_CON3
#define RG_DCXO_SRCLKEN1_MODE_MASK		0x3
#define RG_DCXO_SRCLKEN1_MODE_SHIFT		2
/* Register_SCK_REG */
#define XO_BBCK1_VOTE_L_ADDR			MT6685_XO_BUF_CTL0_L
#define XO_BBCK1_VOTE_L_MASK			0xff
#define XO_BBCK1_VOTE_L_SHIFT			0
#define XO_BBCK1_VOTE_H_ADDR			MT6685_XO_BUF_CTL0_H
#define XO_BBCK1_VOTE_H_MASK			0x3f
#define XO_BBCK1_VOTE_H_SHIFT			0
#define XO_BBCK2_VOTE_L_ADDR			MT6685_XO_BUF_CTL1_L
#define XO_BBCK2_VOTE_L_MASK			0xff
#define XO_BBCK2_VOTE_L_SHIFT			0
#define XO_BBCK2_VOTE_H_ADDR			MT6685_XO_BUF_CTL1_H
#define XO_BBCK2_VOTE_H_MASK			0x3f
#define XO_BBCK2_VOTE_H_SHIFT			0
#define XO_BBCK3_VOTE_L_ADDR			MT6685_XO_BUF_CTL2_L
#define XO_BBCK3_VOTE_L_MASK			0xff
#define XO_BBCK3_VOTE_L_SHIFT			0
#define XO_BBCK3_VOTE_H_ADDR			MT6685_XO_BUF_CTL2_H
#define XO_BBCK3_VOTE_H_MASK			0x3f
#define XO_BBCK3_VOTE_H_SHIFT			0
#define XO_BBCK4_VOTE_L_ADDR			MT6685_XO_BUF_CTL3_L
#define XO_BBCK4_VOTE_L_MASK			0xff
#define XO_BBCK4_VOTE_L_SHIFT			0
#define XO_BBCK4_VOTE_H_ADDR			MT6685_XO_BUF_CTL3_H
#define XO_BBCK4_VOTE_H_MASK			0x3f
#define XO_BBCK4_VOTE_H_SHIFT			0
#define XO_BBCK5_VOTE_L_ADDR			MT6685_XO_BUF_CTL4_L
#define XO_BBCK5_VOTE_L_MASK			0xff
#define XO_BBCK5_VOTE_L_SHIFT			0
#define XO_BBCK5_VOTE_H_ADDR			MT6685_XO_BUF_CTL4_H
#define XO_BBCK5_VOTE_H_MASK			0x3f
#define XO_BBCK5_VOTE_H_SHIFT			0
#define XO_RFCK1A_VOTE_L_ADDR			MT6685_XO_BUF_CTL5_L
#define XO_RFCK1A_VOTE_L_MASK			0xff
#define XO_RFCK1A_VOTE_L_SHIFT			0
#define XO_RFCK1A_VOTE_H_ADDR			MT6685_XO_BUF_CTL5_H
#define XO_RFCK1A_VOTE_H_MASK			0x3f
#define XO_RFCK1A_VOTE_H_SHIFT			0
#define XO_RFCK1B_VOTE_L_ADDR			MT6685_XO_BUF_CTL6_L
#define XO_RFCK1B_VOTE_L_MASK			0xff
#define XO_RFCK1B_VOTE_L_SHIFT			0
#define XO_RFCK1B_VOTE_H_ADDR			MT6685_XO_BUF_CTL6_H
#define XO_RFCK1B_VOTE_H_MASK			0x3f
#define XO_RFCK1B_VOTE_H_SHIFT			0
#define XO_RFCK1C_VOTE_L_ADDR			MT6685_XO_BUF_CTL7_L
#define XO_RFCK1C_VOTE_L_MASK			0xff
#define XO_RFCK1C_VOTE_L_SHIFT			0
#define XO_RFCK1C_VOTE_H_ADDR			MT6685_XO_BUF_CTL7_H
#define XO_RFCK1C_VOTE_H_MASK			0x3f
#define XO_RFCK1C_VOTE_H_SHIFT			0
#define XO_RFCK2A_VOTE_L_ADDR			MT6685_XO_BUF_CTL8_L
#define XO_RFCK2A_VOTE_L_MASK			0xff
#define XO_RFCK2A_VOTE_L_SHIFT			0
#define XO_RFCK2A_VOTE_H_ADDR			MT6685_XO_BUF_CTL8_H
#define XO_RFCK2A_VOTE_H_MASK			0x3f
#define XO_RFCK2A_VOTE_H_SHIFT			0
#define XO_RFCK2B_VOTE_L_ADDR			MT6685_XO_BUF_CTL9_L
#define XO_RFCK2B_VOTE_L_MASK			0xff
#define XO_RFCK2B_VOTE_L_SHIFT			0
#define XO_RFCK2B_VOTE_H_ADDR			MT6685_XO_BUF_CTL9_H
#define XO_RFCK2B_VOTE_H_MASK			0x3f
#define XO_RFCK2B_VOTE_H_SHIFT			0
#define XO_RFCK2C_VOTE_L_ADDR			MT6685_XO_BUF_CTL10_L
#define XO_RFCK2C_VOTE_L_MASK			0xff
#define XO_RFCK2C_VOTE_L_SHIFT			0
#define XO_RFCK2C_VOTE_H_ADDR			MT6685_XO_BUF_CTL10_H
#define XO_RFCK2C_VOTE_H_MASK			0x3f
#define XO_RFCK2C_VOTE_H_SHIFT			0
#define XO_CONCK1_VOTE_L_ADDR			MT6685_XO_BUF_CTL11_L
#define XO_CONCK1_VOTE_L_MASK			0xff
#define XO_CONCK1_VOTE_L_SHIFT			0
#define XO_CONCK1_VOTE_H_ADDR			MT6685_XO_BUF_CTL11_H
#define XO_CONCK1_VOTE_H_MASK			0x3f
#define XO_CONCK1_VOTE_H_SHIFT			0
#define XO_CONCK2_VOTE_L_ADDR			MT6685_XO_BUF_CTL12_L
#define XO_CONCK2_VOTE_L_MASK			0xff
#define XO_CONCK2_VOTE_L_SHIFT			0
#define XO_CONCK2_VOTE_H_ADDR			MT6685_XO_BUF_CTL12_H
#define XO_CONCK2_VOTE_H_MASK			0x3f
#define XO_CONCK2_VOTE_H_SHIFT			0
#define XO_MODE_CONN_BT_MASK_ADDR		MT6685_XO_CONN_BT0
#define XO_MODE_CONN_BT_MASK_MASK		0x1
#define XO_MODE_CONN_BT_MASK_SHIFT		0
#define XO_BUF_CONN_BT_MASK_ADDR		MT6685_XO_CONN_BT0
#define XO_BUF_CONN_BT_MASK_MASK		0x1
#define XO_BUF_CONN_BT_MASK_SHIFT		1
/* Register_DCXO_REG */
#define XO_PMIC_TOP_DIG_SW_ADDR			MT6685_DCXO_DIG_MANCTRL_CW1
#define XO_PMIC_TOP_DIG_SW_MASK			0x1
#define XO_PMIC_TOP_DIG_SW_SHIFT		0
#define XO_ENBB_MAN_ADDR			MT6685_DCXO_DIG_MANCTRL_CW1
#define XO_ENBB_MAN_MASK			0x1
#define XO_ENBB_MAN_SHIFT			1
#define XO_ENBB_EN_M_ADDR			MT6685_DCXO_DIG_MANCTRL_CW1
#define XO_ENBB_EN_M_MASK			0x1
#define XO_ENBB_EN_M_SHIFT			2
#define XO_CLKSEL_MAN_ADDR			MT6685_DCXO_DIG_MANCTRL_CW1
#define XO_CLKSEL_MAN_MASK			0x1
#define XO_CLKSEL_MAN_SHIFT			3
#define XO_CLKSEL_EN_M_ADDR			MT6685_DCXO_DIG_MANCTRL_CW1
#define XO_CLKSEL_EN_M_MASK			0x1
#define XO_CLKSEL_EN_M_SHIFT			4
#define XO_BB_LPM_EN_M_ADDR			MT6685_DCXO_BBLPM_CW0
#define XO_BB_LPM_EN_M_MASK			0x1
#define XO_BB_LPM_EN_M_SHIFT			0
#define XO_BB_LPM_EN_SEL_ADDR			MT6685_DCXO_BBLPM_CW0
#define XO_BB_LPM_EN_SEL_MASK			0x1
#define XO_BB_LPM_EN_SEL_SHIFT			1
#define XO_BBCK1_BBLPM_EN_MASK_ADDR		MT6685_DCXO_BBLPM_CW0
#define XO_BBCK1_BBLPM_EN_MASK_MASK		0x1
#define XO_BBCK1_BBLPM_EN_MASK_SHIFT		2
#define XO_BBCK2_BBLPM_EN_MASK_ADDR		MT6685_DCXO_BBLPM_CW0
#define XO_BBCK2_BBLPM_EN_MASK_MASK		0x1
#define XO_BBCK2_BBLPM_EN_MASK_SHIFT		3
#define XO_BBCK3_BBLPM_EN_MASK_ADDR		MT6685_DCXO_BBLPM_CW0
#define XO_BBCK3_BBLPM_EN_MASK_MASK		0x1
#define XO_BBCK3_BBLPM_EN_MASK_SHIFT		4
#define XO_BBCK4_BBLPM_EN_MASK_ADDR		MT6685_DCXO_BBLPM_CW0
#define XO_BBCK4_BBLPM_EN_MASK_MASK		0x1
#define XO_BBCK4_BBLPM_EN_MASK_SHIFT		5
#define XO_BBCK5_BBLPM_EN_MASK_ADDR		MT6685_DCXO_BBLPM_CW0
#define XO_BBCK5_BBLPM_EN_MASK_MASK		0x1
#define XO_BBCK5_BBLPM_EN_MASK_SHIFT		6
#define XO_BBLPM_EN_MAN_ADDR			MT6685_DCXO_BBLPM_CW1
#define XO_BBLPM_EN_MAN_MASK			0x1
#define XO_BBLPM_EN_MAN_SHIFT			0
#define XO_BBLPM_EN_MAN_M_ADDR			MT6685_DCXO_BBLPM_CW1
#define XO_BBLPM_EN_MAN_M_MASK			0x1
#define XO_BBLPM_EN_MAN_M_SHIFT			1
#define XO_VBBCK_EN_MAN_ADDR			MT6685_DCXO_LDO_CW0
#define XO_VBBCK_EN_MAN_MASK			0x1
#define XO_VBBCK_EN_MAN_SHIFT			0
#define XO_VBBCK_EN_M_ADDR			MT6685_DCXO_LDO_CW0
#define XO_VBBCK_EN_M_MASK			0x1
#define XO_VBBCK_EN_M_SHIFT			1
#define XO_VRFCK1_EN_MAN_ADDR			MT6685_DCXO_LDO_CW0
#define XO_VRFCK1_EN_MAN_MASK			0x1
#define XO_VRFCK1_EN_MAN_SHIFT			2
#define XO_VRFCK1_EN_M_ADDR			MT6685_DCXO_LDO_CW0
#define XO_VRFCK1_EN_M_MASK			0x1
#define XO_VRFCK1_EN_M_SHIFT			3
#define XO_VRFCK2_EN_MAN_ADDR			MT6685_DCXO_LDO_CW0
#define XO_VRFCK2_EN_MAN_MASK			0x1
#define XO_VRFCK2_EN_MAN_SHIFT			4
#define XO_VRFCK2_EN_M_ADDR			MT6685_DCXO_LDO_CW0
#define XO_VRFCK2_EN_M_MASK			0x1
#define XO_VRFCK2_EN_M_SHIFT			5
#define XO_VCONCK_EN_MAN_ADDR			MT6685_DCXO_LDO_CW0
#define XO_VCONCK_EN_MAN_MASK			0x1
#define XO_VCONCK_EN_MAN_SHIFT			6
#define XO_VCONCK_EN_M_ADDR			MT6685_DCXO_LDO_CW0
#define XO_VCONCK_EN_M_MASK			0x1
#define XO_VCONCK_EN_M_SHIFT			7
#define XO_BBCK1_MODE_ADDR			MT6685_DCXO_EXTBUF1_CW0
#define XO_BBCK1_EN_M_ADDR			MT6685_DCXO_EXTBUF1_CW0
#define XO_BBCK1_EN_M_MASK			0x1
#define XO_BBCK1_EN_M_SHIFT			2
#define RG_XO_EXTBUF_BBCK1_RSEL_ADDR		MT6685_DCXO_EXTBUF1_CW0
#define RG_XO_EXTBUF_BBCK1_RSEL_MASK		0x7
#define RG_XO_EXTBUF_BBCK1_RSEL_SHIFT		3
#define RG_XO_EXTBUF_BBCK1_HD_ADDR		MT6685_DCXO_EXTBUF1_CW0
#define RG_XO_EXTBUF_BBCK1_HD_MASK		0x3
#define RG_XO_EXTBUF_BBCK1_HD_SHIFT		6
#define XO_BBCK2_MODE_ADDR			MT6685_DCXO_EXTBUF2_CW0
#define XO_BBCK2_EN_M_ADDR			MT6685_DCXO_EXTBUF2_CW0
#define XO_BBCK2_EN_M_MASK			0x1
#define XO_BBCK2_EN_M_SHIFT			2
#define RG_XO_EXTBUF_BBCK2_RSEL_ADDR		MT6685_DCXO_EXTBUF2_CW0
#define RG_XO_EXTBUF_BBCK2_RSEL_MASK		0x7
#define RG_XO_EXTBUF_BBCK2_RSEL_SHIFT		3
#define RG_XO_EXTBUF_BBCK2_HD_ADDR		MT6685_DCXO_EXTBUF2_CW0
#define RG_XO_EXTBUF_BBCK2_HD_MASK		0x3
#define RG_XO_EXTBUF_BBCK2_HD_SHIFT		6
#define XO_BBCK3_MODE_ADDR			MT6685_DCXO_EXTBUF3_CW0
#define XO_BBCK3_EN_M_ADDR			MT6685_DCXO_EXTBUF3_CW0
#define XO_BBCK3_EN_M_MASK			0x1
#define XO_BBCK3_EN_M_SHIFT			2
#define RG_XO_EXTBUF_BBCK3_RSEL_ADDR		MT6685_DCXO_EXTBUF3_CW0
#define RG_XO_EXTBUF_BBCK3_RSEL_MASK		0x7
#define RG_XO_EXTBUF_BBCK3_RSEL_SHIFT		3
#define RG_XO_EXTBUF_BBCK3_HD_ADDR		MT6685_DCXO_EXTBUF3_CW0
#define RG_XO_EXTBUF_BBCK3_HD_MASK		0x3
#define RG_XO_EXTBUF_BBCK3_HD_SHIFT		6
#define XO_BBCK4_MODE_ADDR			MT6685_DCXO_EXTBUF4_CW0
#define XO_BBCK4_EN_M_ADDR			MT6685_DCXO_EXTBUF4_CW0
#define XO_BBCK4_EN_M_MASK			0x1
#define XO_BBCK4_EN_M_SHIFT			2
#define RG_XO_EXTBUF_BBCK4_RSEL_ADDR		MT6685_DCXO_EXTBUF4_CW0
#define RG_XO_EXTBUF_BBCK4_RSEL_MASK		0x7
#define RG_XO_EXTBUF_BBCK4_RSEL_SHIFT		3
#define RG_XO_EXTBUF_BBCK4_HD_ADDR		MT6685_DCXO_EXTBUF4_CW0
#define RG_XO_EXTBUF_BBCK4_HD_MASK		0x3
#define RG_XO_EXTBUF_BBCK4_HD_SHIFT		6
#define XO_BBCK5_MODE_ADDR			MT6685_DCXO_EXTBUF5_CW0
#define XO_BBCK5_EN_M_ADDR			MT6685_DCXO_EXTBUF5_CW0
#define XO_BBCK5_EN_M_MASK			0x1
#define XO_BBCK5_EN_M_SHIFT			2
#define RG_XO_EXTBUF_BBCK5_RSEL_ADDR		MT6685_DCXO_EXTBUF5_CW0
#define RG_XO_EXTBUF_BBCK5_RSEL_MASK		0x7
#define RG_XO_EXTBUF_BBCK5_RSEL_SHIFT		3
#define RG_XO_EXTBUF_BBCK5_HD_ADDR		MT6685_DCXO_EXTBUF5_CW0
#define RG_XO_EXTBUF_BBCK5_HD_MASK		0x3
#define RG_XO_EXTBUF_BBCK5_HD_SHIFT		6
#define XO_RFCK1A_MODE_ADDR			MT6685_DCXO_EXTBUF6_CW0
#define XO_RFCK1A_EN_M_ADDR			MT6685_DCXO_EXTBUF6_CW0
#define XO_RFCK1A_EN_M_MASK			0x1
#define XO_RFCK1A_EN_M_SHIFT			2
#define RG_XO_EXTBUF_RFCK1A_RSEL_ADDR		MT6685_DCXO_EXTBUF6_CW0
#define RG_XO_EXTBUF_RFCK1A_RSEL_MASK		0x7
#define RG_XO_EXTBUF_RFCK1A_RSEL_SHIFT		3
#define XO_RFCK1B_MODE_ADDR			MT6685_DCXO_EXTBUF7_CW0
#define XO_RFCK1B_EN_M_ADDR			MT6685_DCXO_EXTBUF7_CW0
#define XO_RFCK1B_EN_M_MASK			0x1
#define XO_RFCK1B_EN_M_SHIFT			2
#define RG_XO_EXTBUF_RFCK1B_RSEL_ADDR		MT6685_DCXO_EXTBUF7_CW0
#define RG_XO_EXTBUF_RFCK1B_RSEL_MASK		0x7
#define RG_XO_EXTBUF_RFCK1B_RSEL_SHIFT		3
#define XO_RFCK1C_MODE_ADDR			MT6685_DCXO_EXTBUF8_CW0
#define XO_RFCK1C_EN_M_ADDR			MT6685_DCXO_EXTBUF8_CW0
#define XO_RFCK1C_EN_M_MASK			0x1
#define XO_RFCK1C_EN_M_SHIFT			2
#define RG_XO_EXTBUF_RFCK1C_RSEL_ADDR		MT6685_DCXO_EXTBUF8_CW0
#define RG_XO_EXTBUF_RFCK1C_RSEL_MASK		0x7
#define RG_XO_EXTBUF_RFCK1C_RSEL_SHIFT		3
#define XO_RFCK2A_MODE_ADDR			MT6685_DCXO_EXTBUF9_CW0
#define XO_RFCK2A_EN_M_ADDR			MT6685_DCXO_EXTBUF9_CW0
#define XO_RFCK2A_EN_M_MASK			0x1
#define XO_RFCK2A_EN_M_SHIFT			2
#define RG_XO_EXTBUF_RFCK2A_RSEL_ADDR		MT6685_DCXO_EXTBUF9_CW0
#define RG_XO_EXTBUF_RFCK2A_RSEL_MASK		0x7
#define RG_XO_EXTBUF_RFCK2A_RSEL_SHIFT		3
#define XO_RFCK2B_MODE_ADDR			MT6685_DCXO_EXTBUF10_CW0
#define XO_RFCK2B_EN_M_ADDR			MT6685_DCXO_EXTBUF10_CW0
#define XO_RFCK2B_EN_M_MASK			0x1
#define XO_RFCK2B_EN_M_SHIFT			2
#define RG_XO_EXTBUF_RFCK2B_RSEL_ADDR		MT6685_DCXO_EXTBUF10_CW0
#define RG_XO_EXTBUF_RFCK2B_RSEL_MASK		0x7
#define RG_XO_EXTBUF_RFCK2B_RSEL_SHIFT		3
#define XO_RFCK2C_MODE_ADDR			MT6685_DCXO_EXTBUF11_CW0
#define XO_RFCK2C_EN_M_ADDR			MT6685_DCXO_EXTBUF11_CW0
#define XO_RFCK2C_EN_M_MASK			0x1
#define XO_RFCK2C_EN_M_SHIFT			2
#define RG_XO_EXTBUF_RFCK2C_RSEL_ADDR		MT6685_DCXO_EXTBUF11_CW0
#define RG_XO_EXTBUF_RFCK2C_RSEL_MASK		0x7
#define RG_XO_EXTBUF_RFCK2C_RSEL_SHIFT		3
#define XO_CONCK1_MODE_ADDR			MT6685_DCXO_EXTBUF12_CW0
#define XO_CONCK1_EN_M_ADDR			MT6685_DCXO_EXTBUF12_CW0
#define XO_CONCK1_EN_M_MASK			0x1
#define XO_CONCK1_EN_M_SHIFT			2
#define RG_XO_EXTBUF_CONCK1_RSEL_ADDR		MT6685_DCXO_EXTBUF12_CW0
#define RG_XO_EXTBUF_CONCK1_RSEL_MASK		0x7
#define RG_XO_EXTBUF_CONCK1_RSEL_SHIFT		3
#define XO_CONCK2_MODE_ADDR			MT6685_DCXO_EXTBUF13_CW0
#define XO_CONCK2_EN_M_ADDR			MT6685_DCXO_EXTBUF13_CW0
#define XO_CONCK2_EN_M_MASK			0x1
#define XO_CONCK2_EN_M_SHIFT			2
#define RG_XO_EXTBUF_CONCK2_RSEL_ADDR		MT6685_DCXO_EXTBUF13_CW0
#define RG_XO_EXTBUF_CONCK2_RSEL_MASK		0x7
#define RG_XO_EXTBUF_CONCK2_RSEL_SHIFT		3
#define XO_AUXOUT_SEL_L_ADDR			MT6685_DCXO_RGMON_CW0_L
#define XO_AUXOUT_SEL_L_MASK			0xff
#define XO_AUXOUT_SEL_L_SHIFT			0
#define XO_AUXOUT_SEL_H_ADDR			MT6685_DCXO_RGMON_CW0_H
#define XO_AUXOUT_SEL_H_MASK			0x3
#define XO_AUXOUT_SEL_H_SHIFT			0
#define XO_STATIC_AUXOUT_L_ADDR			MT6685_DCXO_RGMON_CW2_L
#define XO_STATIC_AUXOUT_L_MASK			0xff
#define XO_STATIC_AUXOUT_L_SHIFT		0
#define XO_STATIC_AUXOUT_H_ADDR			MT6685_DCXO_RGMON_CW2_H
#define XO_STATIC_AUXOUT_H_MASK			0xff
#define XO_STATIC_AUXOUT_H_SHIFT		0
#define XO_STATIC_AUXOUT_SEL_ADDR		MT6685_DCXO_RGMON_CW1
#define XO_STATIC_AUXOUT_SEL_MASK		0x7f
#define XO_STATIC_AUXOUT_SEL_SHIFT		0
#define RG_XO_DIG26M_DIV2_ADDR			MT6685_DCXO_DIGCLK_ELR
#define RG_XO_DIG26M_DIV2_MASK			0x1
#define RG_XO_DIG26M_DIV2_SHIFT			0
/* Register_LDO_REG */
#define RG_LDO_VBBCK_EN_ADDR			MT6685_LDO_VBBCK_CON0
#define RG_LDO_VBBCK_EN_MASK			0x1
#define RG_LDO_VBBCK_EN_SHIFT			0
#define RG_LDO_VBBCK_HW14_OP_EN_ADDR		MT6685_LDO_VBBCK_OP_EN1
#define RG_LDO_VBBCK_HW14_OP_EN_MASK		0x1
#define RG_LDO_VBBCK_HW14_OP_EN_SHIFT		6
#define RG_LDO_VRFCK1_EN_ADDR			MT6685_LDO_VRFCK1_CON0
#define RG_LDO_VRFCK1_EN_MASK			0x1
#define RG_LDO_VRFCK1_EN_SHIFT			0
#define RG_LDO_VRFCK1_HW14_OP_EN_ADDR		MT6685_LDO_VRFCK1_OP_EN1
#define RG_LDO_VRFCK1_HW14_OP_EN_MASK		0x1
#define RG_LDO_VRFCK1_HW14_OP_EN_SHIFT		6
#define RG_LDO_VRFCK2_EN_ADDR			MT6685_LDO_VRFCK2_CON0
#define RG_LDO_VRFCK2_EN_MASK			0x1
#define RG_LDO_VRFCK2_EN_SHIFT			0
#define RG_LDO_VRFCK2_HW14_OP_EN_ADDR		MT6685_LDO_VRFCK2_OP_EN1
#define RG_LDO_VRFCK2_HW14_OP_EN_MASK		0x1
#define RG_LDO_VRFCK2_HW14_OP_EN_SHIFT		6

/* PMIF Register */
#define PMIFSPMI_INF_EN				(PMIF_SPMI_BASE + 0x0024)
#define PMIFSPMI_INF_EN_SRCLKEN_RC_HW_MSK	0x1
#define PMIFSPMI_INF_EN_SRCLKEN_RC_HW_SHFT	4

#define PMIFSPMI_OTHER_INF_EN			(PMIF_SPMI_BASE + 0x0028)
#define SPMI_OTHER_INF_DCXO0_EN_MSK		0x1
#define SPMI_OTHER_INF_DCXO0_EN_SHFT		0
#define SPMI_OTHER_INF_DCXO1_EN_MSK		0x1
#define SPMI_OTHER_INF_DCXO1_EN_SHFT		1

#define PMIFSPMI_ARB_EN				(PMIF_SPMI_BASE + 0x0150)
#define PMIFSPMI_ARB_EN_SRCLKEN_RC_HW_MSK	0x1
#define PMIFSPMI_ARB_EN_SRCLKEN_RC_HW_SHFT	4
#define PMIFSPMI_ARB_EN_DCXO_CONN_MSK		0x1
#define PMIFSPMI_ARB_EN_DCXO_CONN_SHFT		17
#define PMIFSPMI_ARB_EN_DCXO_NFC_MSK		0x1
#define PMIFSPMI_ARB_EN_DCXO_NFC_SHFT		18

#define PMIFSPMI_SLEEP_PROTECTION_CRL		(PMIF_SPMI_BASE + 0x03F0)
#define PMIFSPMI_SPM_SLEEP_REQ_SEL_MSK		0x3
#define PMIFSPMI_SPM_SLEEP_REQ_SEL_SHFT		0
#define PMIFSPMI_SCP_SLEEP_REQ_SEL_MSK		0x3
#define PMIFSPMI_SCP_SLEEP_REQ_SEL_SHFT		9

#define PMIFSPMI_MODE_CRL			(PMIF_SPMI_BASE + 0x0408)
#define PMIFSPMI_MD_CTL_PMIF_RDY_MSK		0x1
#define PMIFSPMI_MD_CTL_PMIF_RDY_SHFT		9
#define PMIFSPMI_MD_CTL_SRCLK_EN_MSK		0x1
#define PMIFSPMI_MD_CTL_SRCLK_EN_SHFT		10
#define PMIFSPMI_MD_CTL_SRVOL_EN_MSK		0x1
#define PMIFSPMI_MD_CTL_SRVOL_EN_SHFT		11

enum {
	CLOCK_BUFFER_DISABLE,
	CLOCK_BUFFER_SW_CONTROL,
	CLOCK_BUFFER_HW_CONTROL,
};

enum {
	CLK_BUF_OUTPUT_IMPEDANCE_0,
	CLK_BUF_OUTPUT_IMPEDANCE_1,
	CLK_BUF_OUTPUT_IMPEDANCE_2,
	CLK_BUF_OUTPUT_IMPEDANCE_3,
	CLK_BUF_OUTPUT_IMPEDANCE_4,
	CLK_BUF_OUTPUT_IMPEDANCE_5,
	CLK_BUF_OUTPUT_IMPEDANCE_6,
	CLK_BUF_OUTPUT_IMPEDANCE_7,
};

enum {
	CLK_BUF_DRIVING_STRENGTH_0,/* Max */
	CLK_BUF_DRIVING_STRENGTH_1,
	CLK_BUF_DRIVING_STRENGTH_2,
	CLK_BUF_DRIVING_STRENGTH_3,/* Min */
};

#define BBCK_BUF1_STATUS_PMIC			CLOCK_BUFFER_HW_CONTROL
#define BBCK_BUF2_STATUS_PMIC			CLOCK_BUFFER_HW_CONTROL
#define BBCK_BUF3_STATUS_PMIC			CLOCK_BUFFER_DISABLE
#define BBCK_BUF4_STATUS_PMIC			CLOCK_BUFFER_DISABLE
#define BBCK_BUF5_STATUS_PMIC			CLOCK_BUFFER_DISABLE
#define RFCK_BUF1A_STATUS_PMIC			CLOCK_BUFFER_DISABLE
#define RFCK_BUF1B_STATUS_PMIC			CLOCK_BUFFER_HW_CONTROL
#define RFCK_BUF2A_STATUS_PMIC			CLOCK_BUFFER_DISABLE
#define RFCK_BUF2B_STATUS_PMIC			CLOCK_BUFFER_DISABLE

#define BBCK_BUF1_OUTPUT_IMPEDANCE		CLK_BUF_OUTPUT_IMPEDANCE_7
#define BBCK_BUF2_OUTPUT_IMPEDANCE		CLK_BUF_OUTPUT_IMPEDANCE_7
#define BBCK_BUF3_OUTPUT_IMPEDANCE		CLK_BUF_OUTPUT_IMPEDANCE_7
#define BBCK_BUF4_OUTPUT_IMPEDANCE		CLK_BUF_OUTPUT_IMPEDANCE_7
#define BBCK_BUF5_OUTPUT_IMPEDANCE		CLK_BUF_OUTPUT_IMPEDANCE_7
#define RFCK_BUF1A_OUTPUT_IMPEDANCE		CLK_BUF_OUTPUT_IMPEDANCE_1
#define RFCK_BUF1B_OUTPUT_IMPEDANCE		CLK_BUF_OUTPUT_IMPEDANCE_1
#define RFCK_BUF2A_OUTPUT_IMPEDANCE		CLK_BUF_OUTPUT_IMPEDANCE_1
#define RFCK_BUF2B_OUTPUT_IMPEDANCE		CLK_BUF_OUTPUT_IMPEDANCE_1

#define BBCK_BUF1_DRIVING_STRENGTH		CLK_BUF_DRIVING_STRENGTH_2
#define BBCK_BUF2_DRIVING_STRENGTH		CLK_BUF_DRIVING_STRENGTH_2
#define BBCK_BUF3_DRIVING_STRENGTH		CLK_BUF_DRIVING_STRENGTH_2
#define BBCK_BUF4_DRIVING_STRENGTH		CLK_BUF_DRIVING_STRENGTH_2
#define BBCK_BUF5_DRIVING_STRENGTH		CLK_BUF_DRIVING_STRENGTH_2

enum pmic_interface_clkbuf {
	PMIF_VLD_RDY_CLKBUF = 0,
	PMIF_SLP_REQ_CLKBUF,
	PMIF_MAX,
};

/* XO id: Update this enum for porting */
enum xo_id {
	XO_BBCK1 = 0,
	XO_BBCK2,
	XO_BBCK3,
	XO_BBCK4,
	XO_BBCK5,
	XO_RFCK1A,
	XO_RFCK1B,
	XO_RFCK1C,
	XO_RFCK2A,
	XO_RFCK2B,
	XO_RFCK2C,
	XO_CONCK1,
	XO_CONCK2,
	XO_NUMBER,
};

struct ox_cfg {
	u32 reg;
	u8 mode;
	u8 impedance;
	u8 driving;
	struct {
		u8 low_byte;
		u8 high_byte;
	} voter_mask;
};

int clk_buf_init(void);
u16 clk_buf_get_pmrc_en0(void);

#endif
