/* SPDX-License-Identifier: GPL-2.0-only OR MIT */

/*
 * These values are used by MediaTek internally.
 * We can find these registers in "MT6316_PMIC_Design_Notice_for_MT8196G_V0.2".
 * The setting values are provided by MediaTek designers.
 */

#include <console/console.h>
#include <soc/mt6316.h>

static const struct mt6316_setting init_setting_s6[] = {
	/* Disable magic key protection */
	{0x3B1, 0xE9, 0xFF, 0},
	{0x3B2, 0xE6, 0xFF, 0},
	{0x3A8, 0xE9, 0xFF, 0},
	{0x3A9, 0xE6, 0xFF, 0},
	{0xA15, 0x29, 0xFF, 0},
	{0xA16, 0x47, 0xFF, 0},
	{0x141C, 0x43, 0xFF, 0},
	{0x141D, 0x55, 0xFF, 0},
	{0x3AA, 0xDC, 0xFF, 0},
	{0x3AB, 0xF1, 0xFF, 0},
	/* Init setting */
	{0x13, 0x7, 0xFF, 0},
	{0x16, 0x12, 0xFF, 0},
	{0x17, 0x0, 0xFF, 0},
	{0x8A, 0x6, 0xF, 0},
	{0xA1, 0xC, 0xC, 0},
	{0xA2, 0x10, 0x10, 0},
	{0x10C, 0xC, 0xC, 0},
	{0x12C, 0x1, 0x1, 0},
	{0x140, 0x30, 0x30, 0},
	{0x142, 0x30, 0xFF, 0},
	{0x991, 0x11, 0xFF, 0},
	{0x196, 0x1, 0x1, 0},
	{0x197, 0x10, 0x10, 0},
	{0x19A, 0x1, 0x1, 0},
	{0x19B, 0x10, 0x10, 0},
	{0x217, 0x22, 0x22, 0},
	{0x219, 0x1F, 0x1F, 0},
	{0x223, 0x20, 0x20, 0},
	{0x413, 0x7, 0xFF, 0},
	{0x416, 0x12, 0xFF, 0},
	{0x417, 0x0, 0x7, 0},
	{0x988, 0x0, 0x20, 0},
	{0x98C, 0xB0, 0xFF, 0},
	{0x994, 0x0, 0xFF, 0},
	{0xA13, 0x10, 0x10, 0},
	{0xA1F, 0x80, 0x80, 0},
	{0x1452, 0x0, 0xFF, 0},
	{0x1457, 0x22, 0xFF, 0},
	{0x1458, 0x22, 0xFF, 0},
	{0x148A, 0x0, 0x3, 0},
	{0x148F, 0x2, 0x3, 0},
	{0x1492, 0x40, 0x70, 0},
	{0x150A, 0x0, 0x3, 0},
	{0x150F, 0x2, 0x3, 0},
	{0x1512, 0x40, 0x70, 0},
	{0x158A, 0x0, 0x3, 0},
	{0x158F, 0x2, 0x3, 0},
	{0x1592, 0x40, 0x70, 0},
	{0x160A, 0x0, 0x3, 0},
	{0x160F, 0x2, 0x3, 0},
	{0x1612, 0x40, 0x70, 0},
	{0x1729, 0x18, 0x18, 0},
	{0x17A9, 0x18, 0x18, 0},
	{0x1829, 0x18, 0x18, 0},
	{0x18A9, 0x18, 0x18, 0},
	{0x98, 0x2, 0x7, 0},
	{0xA1F, 0xC, 0xC, 0},
	{0xA21, 0x21, 0xFF, 0},
	{0xA23, 0xF0, 0xF0, 0},
	{0xA28, 0x21, 0xFF, 0},
	{0xA29, 0x21, 0xFF, 0},
	{0xA2A, 0x1B, 0xFF, 0},
	{0xA2B, 0x21, 0xFF, 0},
	{0x1440, 0x0, 0xA, 0},
	{0x1487, 0x55, 0xFF, 0},
	{0x148A, 0xD, 0xF, 0},
	{0x148C, 0x3, 0x3, 0},
	{0x148D, 0x28, 0x7F, 0},
	{0x148E, 0x7, 0x7F, 0},
	{0x1490, 0x2, 0x3, 0},
	{0x1491, 0x19, 0x7F, 0},
	{0x1507, 0x55, 0xFF, 0},
	{0x150A, 0xD, 0xF, 0},
	{0x150C, 0x3, 0x3, 0},
	{0x150D, 0x28, 0x7F, 0},
	{0x150E, 0x7, 0x7F, 0},
	{0x1510, 0x2, 0x3, 0},
	{0x1511, 0x19, 0x7F, 0},
	{0x1587, 0xD2, 0xFF, 0},
	{0x158A, 0xD, 0xF, 0},
	{0x158D, 0xD, 0x7F, 0},
	{0x158E, 0x7, 0x7F, 0},
	{0x1590, 0x2, 0x3, 0},
	{0x1591, 0x19, 0x7F, 0},
	{0x1607, 0x55, 0xFF, 0},
	{0x160A, 0xD, 0xF, 0},
	{0x160C, 0x3, 0x3, 0},
	{0x160D, 0x28, 0x7F, 0},
	{0x160E, 0x7, 0x7F, 0},
	{0x1610, 0x2, 0x3, 0},
	{0x1611, 0x19, 0x7F, 0},
	{0x1688, 0x0, 0x1F, 0},
	{0x1689, 0x10, 0x7F, 0},
	{0x168A, 0x0, 0xFF, 0},
	{0x168B, 0x1, 0xFF, 0},
	{0x168C, 0x5, 0x3F, 0},
	{0x168D, 0x9, 0xFF, 0},
	{0x168E, 0xA0, 0xFF, 0},
	{0x1708, 0xD1, 0xFF, 0},
	{0x1709, 0xFC, 0xFF, 0},
	{0x170A, 0x92, 0xFF, 0},
	{0x170B, 0x0, 0x3, 0},
	{0x170C, 0x4C, 0x7F, 0},
	{0x170D, 0x0, 0x7F, 0},
	{0x170E, 0x30, 0x3F, 0},
	{0x170F, 0x9F, 0xFF, 0},
	{0x1710, 0x29, 0x3F, 0},
	{0x1711, 0x0, 0x3F, 0},
	{0x1712, 0x0, 0xFF, 0},
	{0x1713, 0x9C, 0x9C, 0},
	{0x1714, 0x1, 0x7F, 0},
	{0x1715, 0xFF, 0xFF, 0},
	{0x1716, 0x8E, 0xFF, 0},
	{0x1717, 0x3B, 0xFF, 0},
	{0x1718, 0x6A, 0xFF, 0},
	{0x1719, 0x80, 0xFF, 0},
	{0x171A, 0x8, 0x7F, 0},
	{0x171B, 0x1, 0x3F, 0},
	{0x171C, 0x3, 0xF, 0},
	{0x171D, 0x58, 0x7F, 0},
	{0x171E, 0xD, 0x1F, 0},
	{0x1738, 0x4, 0x1F, 0},
	{0x173B, 0x7, 0x1F, 0},
	{0x1788, 0xD1, 0xFF, 0},
	{0x1789, 0xFC, 0xFF, 0},
	{0x178A, 0x92, 0xFF, 0},
	{0x178B, 0x0, 0x3, 0},
	{0x178C, 0x4C, 0x7F, 0},
	{0x178D, 0x0, 0x7F, 0},
	{0x178E, 0x30, 0x3F, 0},
	{0x178F, 0x9F, 0xFF, 0},
	{0x1790, 0x29, 0x3F, 0},
	{0x1791, 0x0, 0x3F, 0},
	{0x1792, 0x0, 0xFF, 0},
	{0x1793, 0xDC, 0xDC, 0},
	{0x1794, 0x0, 0x3F, 0},
	{0x1795, 0xFF, 0xFF, 0},
	{0x1796, 0x8E, 0xFF, 0},
	{0x1797, 0x3B, 0xFF, 0},
	{0x1798, 0x6A, 0xFF, 0},
	{0x1799, 0x80, 0xFF, 0},
	{0x179A, 0x8, 0x7F, 0},
	{0x179B, 0x1, 0x3F, 0},
	{0x179C, 0x3, 0xF, 0},
	{0x179D, 0x58, 0x7F, 0},
	{0x179E, 0xD, 0x1F, 0},
	{0x17BB, 0x7, 0x1F, 0},
	{0x1808, 0xB1, 0xFF, 0},
	{0x1809, 0xCC, 0xFF, 0},
	{0x180A, 0x92, 0xFF, 0},
	{0x180B, 0x0, 0x3, 0},
	{0x180C, 0x54, 0x7F, 0},
	{0x180D, 0x0, 0x7F, 0},
	{0x180E, 0x20, 0x3F, 0},
	{0x180F, 0x9F, 0xFF, 0},
	{0x1810, 0x29, 0x3F, 0},
	{0x1811, 0x0, 0x3F, 0},
	{0x1812, 0x0, 0xFF, 0},
	{0x1813, 0xDC, 0xDC, 0},
	{0x1814, 0x0, 0x3F, 0},
	{0x1815, 0xEF, 0xFF, 0},
	{0x1816, 0x8E, 0xFF, 0},
	{0x1817, 0x13, 0xFF, 0},
	{0x1818, 0x62, 0xFF, 0},
	{0x1819, 0x81, 0xFF, 0},
	{0x181A, 0x1, 0x7F, 0},
	{0x181B, 0x0, 0x3F, 0},
	{0x181C, 0x3, 0xF, 0},
	{0x181D, 0x48, 0x7F, 0},
	{0x181E, 0x17, 0x1F, 0},
	{0x1827, 0x3, 0xFF, 0},
	{0x1838, 0x8, 0x1F, 0},
	{0x183A, 0xB, 0x1F, 0},
	{0x1888, 0xD1, 0xFF, 0},
	{0x1889, 0xFC, 0xFF, 0},
	{0x188A, 0x92, 0xFF, 0},
	{0x188B, 0x0, 0x3, 0},
	{0x188C, 0x4C, 0x7F, 0},
	{0x188D, 0x0, 0x7F, 0},
	{0x188E, 0x30, 0x3F, 0},
	{0x188F, 0x9F, 0xFF, 0},
	{0x1890, 0x29, 0x3F, 0},
	{0x1891, 0x0, 0x3F, 0},
	{0x1892, 0x0, 0xFF, 0},
	{0x1893, 0xDC, 0xDC, 0},
	{0x1894, 0x0, 0x3F, 0},
	{0x1895, 0xFF, 0xFF, 0},
	{0x1896, 0x8E, 0xFF, 0},
	{0x1897, 0x3B, 0xFF, 0},
	{0x1898, 0x6A, 0xFF, 0},
	{0x1899, 0x80, 0xFF, 0},
	{0x189A, 0x8, 0x7F, 0},
	{0x189B, 0x1, 0x3F, 0},
	{0x189C, 0x3, 0xF, 0},
	{0x189D, 0x58, 0x7F, 0},
	{0x189E, 0xD, 0x1F, 0},
	{0x18BB, 0x7, 0x1F, 0},
	/* Add UVLO 2.0 setting */
	{0x999, 0x4, 0x7, 5},
	{0x99e, 0x1, 0x7, 3},
	/* Enable SPMI shutdown command */
	{0x136, 0x1, 0x1, 4},
	/* Enable magic key protection */
	{0x3B1, 0, 0xFF, 0},
	{0x3B2, 0, 0xFF, 0},
	{0x3A8, 0, 0xFF, 0},
	{0x3A9, 0, 0xFF, 0},
	{0xA15, 0, 0xFF, 0},
	{0xA16, 0, 0xFF, 0},
	{0x141C, 0, 0xFF, 0},
	{0x141D, 0, 0xFF, 0},
	{0x3AA, 0, 0xFF, 0},
	{0x3AB, 0, 0xFF, 0},
};

static const struct mt6316_setting init_setting_s7[] = {
	/* Disable magic key protection */
	{0x3B1, 0xE9, 0xFF, 0},
	{0x3B2, 0xE6, 0xFF, 0},
	{0x3A8, 0xE9, 0xFF, 0},
	{0x3A9, 0xE6, 0xFF, 0},
	{0xA15, 0x29, 0xFF, 0},
	{0xA16, 0x47, 0xFF, 0},
	{0x141C, 0x43, 0xFF, 0},
	{0x141D, 0x55, 0xFF, 0},
	{0x3AA, 0xDC, 0xFF, 0},
	{0x3AB, 0xF1, 0xFF, 0},
	/* Init setting */
	{0x13, 0x7, 0xFF, 0},
	{0x16, 0x12, 0xFF, 0},
	{0x17, 0x0, 0xFF, 0},
	{0x8A, 0x6, 0xF, 0},
	{0xA1, 0xC, 0xC, 0},
	{0xA2, 0x10, 0x10, 0},
	{0x10C, 0xC, 0xC, 0},
	{0x12C, 0x1, 0x1, 0},
	{0x140, 0x30, 0x30, 0},
	{0x142, 0x30, 0xFF, 0},
	{0x991, 0x11, 0xFF, 0},
	{0x196, 0x1, 0x1, 0},
	{0x197, 0x10, 0x10, 0},
	{0x19A, 0x1, 0x1, 0},
	{0x19B, 0x10, 0x10, 0},
	{0x217, 0x22, 0x22, 0},
	{0x219, 0x1F, 0x1F, 0},
	{0x223, 0x20, 0x20, 0},
	{0x413, 0x7, 0xFF, 0},
	{0x416, 0x12, 0xFF, 0},
	{0x417, 0x0, 0x7, 0},
	{0x988, 0x0, 0x20, 0},
	{0x98C, 0xB0, 0xFF, 0},
	{0x994, 0x0, 0xFF, 0},
	{0xA13, 0x10, 0x10, 0},
	{0xA1F, 0x80, 0x80, 0},
	{0x1452, 0x0, 0xFF, 0},
	{0x1457, 0x22, 0xFF, 0},
	{0x1458, 0x22, 0xFF, 0},
	{0x148A, 0x0, 0x3, 0},
	{0x148F, 0x2, 0x3, 0},
	{0x1492, 0x40, 0x70, 0},
	{0x150A, 0x0, 0x3, 0},
	{0x150F, 0x2, 0x3, 0},
	{0x1512, 0x40, 0x70, 0},
	{0x158A, 0x0, 0x3, 0},
	{0x158F, 0x2, 0x3, 0},
	{0x1592, 0x40, 0x70, 0},
	{0x160A, 0x0, 0x3, 0},
	{0x160F, 0x2, 0x3, 0},
	{0x1612, 0x40, 0x70, 0},
	{0x1729, 0x18, 0x18, 0},
	{0x17A9, 0x18, 0x18, 0},
	{0x1829, 0x18, 0x18, 0},
	{0x18A9, 0x18, 0x18, 0},
	{0x98, 0x2, 0x7, 0},
	{0xA1F, 0xC, 0xC, 0},
	{0xA21, 0x21, 0xFF, 0},
	{0xA23, 0xF0, 0xF0, 0},
	{0xA28, 0x20, 0xFF, 0},
	{0xA29, 0x20, 0xFF, 0},
	{0xA2A, 0x20, 0xFF, 0},
	{0xA2B, 0x20, 0xFF, 0},
	{0x1440, 0x0, 0xE, 0},
	{0x1487, 0x96, 0xFF, 0},
	{0x148A, 0xD, 0xF, 0},
	{0x148C, 0x3, 0x3, 0},
	{0x148D, 0x19, 0x7F, 0},
	{0x148E, 0x7, 0x7F, 0},
	{0x1490, 0x2, 0x3, 0},
	{0x1491, 0x19, 0x7F, 0},
	{0x1507, 0x96, 0xFF, 0},
	{0x150A, 0xD, 0xF, 0},
	{0x150C, 0x3, 0x3, 0},
	{0x150D, 0x19, 0x7F, 0},
	{0x150E, 0x7, 0x7F, 0},
	{0x1510, 0x2, 0x3, 0},
	{0x1511, 0x19, 0x7F, 0},
	{0x1587, 0x96, 0xFF, 0},
	{0x158A, 0xD, 0xF, 0},
	{0x158C, 0x3, 0x3, 0},
	{0x158D, 0x19, 0x7F, 0},
	{0x158E, 0x7, 0x7F, 0},
	{0x1590, 0x2, 0x3, 0},
	{0x1591, 0x19, 0x7F, 0},
	{0x1607, 0x96, 0xFF, 0},
	{0x160A, 0xD, 0xF, 0},
	{0x160C, 0x3, 0x3, 0},
	{0x160D, 0x19, 0x7F, 0},
	{0x160E, 0x7, 0x7F, 0},
	{0x1610, 0x2, 0x3, 0},
	{0x1611, 0x19, 0x7F, 0},
	{0x1688, 0x0, 0x1F, 0},
	{0x1689, 0x10, 0x7F, 0},
	{0x168A, 0x0, 0xFF, 0},
	{0x168B, 0x1, 0xFF, 0},
	{0x168C, 0x7, 0x3F, 0},
	{0x168D, 0x9, 0xFF, 0},
	{0x168E, 0xA0, 0xFF, 0},
	{0x1708, 0xD1, 0xFF, 0},
	{0x1709, 0xFC, 0xFF, 0},
	{0x170A, 0x92, 0xFF, 0},
	{0x170B, 0x0, 0x3, 0},
	{0x170C, 0x4C, 0x7F, 0},
	{0x170D, 0x0, 0x7F, 0},
	{0x170E, 0x30, 0x3F, 0},
	{0x170F, 0x9F, 0xFF, 0},
	{0x1710, 0x29, 0x3F, 0},
	{0x1711, 0x0, 0x3F, 0},
	{0x1712, 0x0, 0xFF, 0},
	{0x1713, 0x9C, 0x9C, 0},
	{0x1714, 0x1, 0x7F, 0},
	{0x1715, 0xFF, 0xFF, 0},
	{0x1716, 0x8E, 0xFF, 0},
	{0x1717, 0x3B, 0xFF, 0},
	{0x1718, 0x6A, 0xFF, 0},
	{0x1719, 0x80, 0xFF, 0},
	{0x171A, 0x8, 0x7F, 0},
	{0x171B, 0x1, 0x3F, 0},
	{0x171C, 0x3, 0xF, 0},
	{0x171D, 0x38, 0x7F, 0},
	{0x171E, 0xD, 0x1F, 0},
	{0x173B, 0x7, 0x1F, 0},
	{0x1788, 0xD1, 0xFF, 0},
	{0x1789, 0xFC, 0xFF, 0},
	{0x178A, 0x92, 0xFF, 0},
	{0x178B, 0x0, 0x3, 0},
	{0x178C, 0x4C, 0x7F, 0},
	{0x178D, 0x0, 0x7F, 0},
	{0x178E, 0x30, 0x3F, 0},
	{0x178F, 0x9F, 0xFF, 0},
	{0x1790, 0x29, 0x3F, 0},
	{0x1791, 0x0, 0x3F, 0},
	{0x1792, 0x0, 0xFF, 0},
	{0x1793, 0xDC, 0xDC, 0},
	{0x1794, 0x0, 0x3F, 0},
	{0x1795, 0xFF, 0xFF, 0},
	{0x1796, 0x8E, 0xFF, 0},
	{0x1797, 0x3B, 0xFF, 0},
	{0x1798, 0x6A, 0xFF, 0},
	{0x1799, 0x80, 0xFF, 0},
	{0x179A, 0x8, 0x7F, 0},
	{0x179B, 0x1, 0x3F, 0},
	{0x179C, 0x3, 0xF, 0},
	{0x179D, 0x38, 0x7F, 0},
	{0x179E, 0xD, 0x1F, 0},
	{0x17BB, 0x7, 0x1F, 0},
	{0x1808, 0xD1, 0xFF, 0},
	{0x1809, 0xFC, 0xFF, 0},
	{0x180A, 0x92, 0xFF, 0},
	{0x180B, 0x0, 0x3, 0},
	{0x180C, 0x4C, 0x7F, 0},
	{0x180D, 0x0, 0x7F, 0},
	{0x180E, 0x30, 0x3F, 0},
	{0x180F, 0x9F, 0xFF, 0},
	{0x1810, 0x29, 0x3F, 0},
	{0x1811, 0x0, 0x3F, 0},
	{0x1812, 0x0, 0xFF, 0},
	{0x1813, 0xDC, 0xDC, 0},
	{0x1814, 0x0, 0x3F, 0},
	{0x1815, 0xFF, 0xFF, 0},
	{0x1816, 0x8E, 0xFF, 0},
	{0x1817, 0x3B, 0xFF, 0},
	{0x1818, 0x6A, 0xFF, 0},
	{0x1819, 0x80, 0xFF, 0},
	{0x181A, 0x8, 0x7F, 0},
	{0x181B, 0x1, 0x3F, 0},
	{0x181C, 0x3, 0xF, 0},
	{0x181D, 0x38, 0x7F, 0},
	{0x181E, 0xD, 0x1F, 0},
	{0x183B, 0x7, 0x1F, 0},
	{0x1888, 0xD1, 0xFF, 0},
	{0x1889, 0xFC, 0xFF, 0},
	{0x188A, 0x92, 0xFF, 0},
	{0x188B, 0x0, 0x3, 0},
	{0x188C, 0x4C, 0x7F, 0},
	{0x188D, 0x0, 0x7F, 0},
	{0x188E, 0x30, 0x3F, 0},
	{0x188F, 0x9F, 0xFF, 0},
	{0x1890, 0x29, 0x3F, 0},
	{0x1891, 0x0, 0x3F, 0},
	{0x1892, 0x0, 0xFF, 0},
	{0x1893, 0xDC, 0xDC, 0},
	{0x1894, 0x0, 0x3F, 0},
	{0x1895, 0xFF, 0xFF, 0},
	{0x1896, 0x8E, 0xFF, 0},
	{0x1897, 0x3B, 0xFF, 0},
	{0x1898, 0x6A, 0xFF, 0},
	{0x1899, 0x80, 0xFF, 0},
	{0x189A, 0x8, 0x7F, 0},
	{0x189B, 0x1, 0x3F, 0},
	{0x189C, 0x3, 0xF, 0},
	{0x189D, 0x58, 0x7F, 0},
	{0x189E, 0xD, 0x1F, 0},
	{0x18BB, 0x7, 0x1F, 0},
	/* Add UVLO 2.0 setting */
	{0x999, 0x4, 0x7, 5},
	{0x99e, 0x1, 0x7, 3},
	/* Enable SPMI shutdown command */
	{0x136, 0x1, 0x1, 4},
	/* Enable magic key protection */
	{0x3B1, 0, 0xFF, 0},
	{0x3B2, 0, 0xFF, 0},
	{0x3A8, 0, 0xFF, 0},
	{0x3A9, 0, 0xFF, 0},
	{0xA15, 0, 0xFF, 0},
	{0xA16, 0, 0xFF, 0},
	{0x141C, 0, 0xFF, 0},
	{0x141D, 0, 0xFF, 0},
	{0x3AA, 0, 0xFF, 0},
	{0x3AB, 0, 0xFF, 0},
};

static const struct mt6316_setting init_setting_s8[] = {
	/* Disable magic key protection */
	{0x3B1, 0xE9, 0xFF, 0},
	{0x3B2, 0xE6, 0xFF, 0},
	{0x3A8, 0xE9, 0xFF, 0},
	{0x3A9, 0xE6, 0xFF, 0},
	{0xA15, 0x29, 0xFF, 0},
	{0xA16, 0x47, 0xFF, 0},
	{0x141C, 0x43, 0xFF, 0},
	{0x141D, 0x55, 0xFF, 0},
	{0x3AA, 0xDC, 0xFF, 0},
	{0x3AB, 0xF1, 0xFF, 0},
	/* Init setting */
	{0x13, 0x7, 0xFF, 0},
	{0x16, 0x12, 0xFF, 0},
	{0x17, 0x0, 0xFF, 0},
	{0x8A, 0x6, 0xF, 0},
	{0xA1, 0xC, 0xC, 0},
	{0xA2, 0x10, 0x10, 0},
	{0x10C, 0xC, 0xC, 0},
	{0x12C, 0x1, 0x1, 0},
	{0x140, 0x30, 0x30, 0},
	{0x142, 0x30, 0xFF, 0},
	{0x991, 0x11, 0xFF, 0},
	{0x196, 0x1, 0x1, 0},
	{0x197, 0x10, 0x10, 0},
	{0x19A, 0x1, 0x1, 0},
	{0x19B, 0x10, 0x10, 0},
	{0x217, 0x22, 0x22, 0},
	{0x219, 0x1F, 0x1F, 0},
	{0x223, 0x20, 0x20, 0},
	{0x413, 0x7, 0xFF, 0},
	{0x416, 0x12, 0xFF, 0},
	{0x417, 0x0, 0x7, 0},
	{0x988, 0x0, 0x20, 0},
	{0x98C, 0xB0, 0xFF, 0},
	{0x994, 0x0, 0xFF, 0},
	{0xA13, 0x10, 0x10, 0},
	{0xA1F, 0x80, 0x80, 0},
	{0x1452, 0x0, 0xFF, 0},
	{0x1457, 0x22, 0xFF, 0},
	{0x1458, 0x22, 0xFF, 0},
	{0x148A, 0x0, 0x3, 0},
	{0x148F, 0x2, 0x3, 0},
	{0x1492, 0x40, 0x70, 0},
	{0x150A, 0x0, 0x3, 0},
	{0x150F, 0x2, 0x3, 0},
	{0x1512, 0x40, 0x70, 0},
	{0x158A, 0x0, 0x3, 0},
	{0x158F, 0x2, 0x3, 0},
	{0x1592, 0x40, 0x70, 0},
	{0x160A, 0x0, 0x3, 0},
	{0x160F, 0x2, 0x3, 0},
	{0x1612, 0x40, 0x70, 0},
	{0x1729, 0x18, 0x18, 0},
	{0x17A9, 0x18, 0x18, 0},
	{0x1829, 0x18, 0x18, 0},
	{0x18A9, 0x18, 0x18, 0},
	{0xA18, 0x1, 0x1, 0},
	{0xA19, 0x2, 0xFF, 0},
	{0xA1A, 0x0, 0xFF, 0},
	{0xA1B, 0x0, 0xFF, 0},
	{0xA1C, 0x2, 0xFF, 0},
	{0xA1D, 0x2, 0xFF, 0},
	{0xA1F, 0xC, 0xC, 0},
	{0xA21, 0x1E, 0xFF, 0},
	{0xA23, 0xF0, 0xF0, 0},
	{0xA28, 0x1, 0xFF, 0},
	{0xA29, 0x1, 0xFF, 0},
	{0xA2A, 0x1E, 0xFF, 0},
	{0xA2B, 0x1E, 0xFF, 0},
	{0x1440, 0x0, 0xA, 0},
	{0x1487, 0x96, 0xFF, 0},
	{0x148A, 0xF, 0xF, 0},
	{0x148C, 0x3, 0x3, 0},
	{0x148D, 0xD, 0x7F, 0},
	{0x148E, 0x7, 0x7F, 0},
	{0x1490, 0x2, 0x3, 0},
	{0x1491, 0x19, 0x7F, 0},
	{0x1507, 0x96, 0xFF, 0},
	{0x150A, 0xF, 0xF, 0},
	{0x150D, 0xD, 0x7F, 0},
	{0x150E, 0x7, 0x7F, 0},
	{0x1510, 0x2, 0x3, 0},
	{0x1511, 0x19, 0x7F, 0},
	{0x1587, 0x55, 0xFF, 0},
	{0x158A, 0xF, 0xF, 0},
	{0x158C, 0x7, 0x7, 0},
	{0x158D, 0x28, 0x7F, 0},
	{0x158E, 0x7, 0x7F, 0},
	{0x1590, 0x2, 0x3, 0},
	{0x1591, 0x19, 0x7F, 0},
	{0x1607, 0x55, 0xFF, 0},
	{0x160A, 0xF, 0xF, 0},
	{0x160C, 0x7, 0x7, 0},
	{0x160D, 0x28, 0x7F, 0},
	{0x160E, 0x7, 0x7F, 0},
	{0x1610, 0x2, 0x3, 0},
	{0x1611, 0x19, 0x7F, 0},
	{0x1688, 0x0, 0x1F, 0},
	{0x1689, 0x50, 0x7F, 0},
	{0x168A, 0xA2, 0xFF, 0},
	{0x168B, 0x1, 0xFF, 0},
	{0x168C, 0x5, 0x3F, 0},
	{0x168D, 0xF, 0xFF, 0},
	{0x168E, 0x23, 0xFF, 0},
	{0x1708, 0xD1, 0xFF, 0},
	{0x1709, 0xAC, 0xFF, 0},
	{0x170A, 0x92, 0xFF, 0},
	{0x170B, 0x0, 0x3, 0},
	{0x170C, 0x48, 0x7F, 0},
	{0x170D, 0x8, 0x7F, 0},
	{0x170E, 0x30, 0x3F, 0},
	{0x170F, 0x4F, 0xFF, 0},
	{0x1710, 0x24, 0x3F, 0},
	{0x1711, 0x0, 0x3F, 0},
	{0x1712, 0x0, 0xFF, 0},
	{0x1713, 0x9C, 0x9C, 0},
	{0x1714, 0x41, 0x7F, 0},
	{0x1715, 0xEF, 0xFF, 0},
	{0x1716, 0x9C, 0xFF, 0},
	{0x1717, 0x1B, 0xFF, 0},
	{0x1718, 0xDE, 0xFF, 0},
	{0x1719, 0x86, 0xFF, 0},
	{0x171A, 0x8, 0x7F, 0},
	{0x171B, 0xB, 0x3F, 0},
	{0x171C, 0x3, 0xF, 0},
	{0x171D, 0x59, 0x7F, 0},
	{0x171E, 0x19, 0x1F, 0},
	{0x1734, 0x7, 0x3F, 0},
	{0x173A, 0x1A, 0x1F, 0},
	{0x1788, 0xD9, 0xFF, 0},
	{0x1789, 0xBF, 0xFF, 0},
	{0x178A, 0x92, 0xFF, 0},
	{0x178B, 0x0, 0x3, 0},
	{0x178C, 0x54, 0x7F, 0},
	{0x178D, 0x28, 0x7F, 0},
	{0x178E, 0x30, 0x3F, 0},
	{0x178F, 0x9F, 0xFF, 0},
	{0x1790, 0x9, 0x3F, 0},
	{0x1791, 0x0, 0x3F, 0},
	{0x1792, 0x0, 0xFF, 0},
	{0x1793, 0xDC, 0xDC, 0},
	{0x1794, 0x24, 0x3F, 0},
	{0x1795, 0xFF, 0xFF, 0},
	{0x1796, 0x8E, 0xFF, 0},
	{0x1797, 0x1B, 0xFF, 0},
	{0x1798, 0xAA, 0xFF, 0},
	{0x1799, 0x83, 0xFF, 0},
	{0x179A, 0x8, 0x7F, 0},
	{0x179B, 0x1, 0x3F, 0},
	{0x179C, 0x3, 0xF, 0},
	{0x179D, 0x0, 0x7F, 0},
	{0x179E, 0x9, 0x1F, 0},
	{0x17BA, 0x1A, 0x1F, 0},
	{0x1808, 0xD1, 0xFF, 0},
	{0x1809, 0xAC, 0xFF, 0},
	{0x180A, 0x92, 0xFF, 0},
	{0x180B, 0x0, 0x3, 0},
	{0x180C, 0x48, 0x7F, 0},
	{0x180D, 0x8, 0x7F, 0},
	{0x180E, 0x30, 0x3F, 0},
	{0x180F, 0x4F, 0xFF, 0},
	{0x1810, 0x24, 0x3F, 0},
	{0x1811, 0x0, 0x3F, 0},
	{0x1812, 0x0, 0xFF, 0},
	{0x1813, 0xDC, 0xDC, 0},
	{0x1814, 0x20, 0x3F, 0},
	{0x1815, 0xEF, 0xFF, 0},
	{0x1816, 0x9C, 0xFF, 0},
	{0x1817, 0x1B, 0xFF, 0},
	{0x1818, 0xDE, 0xFF, 0},
	{0x1819, 0x86, 0xFF, 0},
	{0x181A, 0x8, 0x7F, 0},
	{0x181B, 0xB, 0x3F, 0},
	{0x181C, 0x3, 0xF, 0},
	{0x181D, 0x59, 0x7F, 0},
	{0x181E, 0x19, 0x1F, 0},
	{0x1834, 0x7, 0x3F, 0},
	{0x183A, 0x1A, 0x1F, 0},
	{0x1888, 0xD9, 0xFF, 0},
	{0x1889, 0xBF, 0xFF, 0},
	{0x188A, 0x92, 0xFF, 0},
	{0x188B, 0x0, 0x3, 0},
	{0x188C, 0x54, 0x7F, 0},
	{0x188D, 0x28, 0x7F, 0},
	{0x188E, 0x30, 0x3F, 0},
	{0x188F, 0x9F, 0xFF, 0},
	{0x1890, 0x9, 0x3F, 0},
	{0x1891, 0x0, 0x3F, 0},
	{0x1892, 0x0, 0xFF, 0},
	{0x1893, 0xDC, 0xDC, 0},
	{0x1894, 0x24, 0x3F, 0},
	{0x1895, 0xFF, 0xFF, 0},
	{0x1896, 0x8E, 0xFF, 0},
	{0x1897, 0x1B, 0xFF, 0},
	{0x1898, 0xAA, 0xFF, 0},
	{0x1899, 0x83, 0xFF, 0},
	{0x189A, 0x8, 0x7F, 0},
	{0x189B, 0x1, 0x3F, 0},
	{0x189C, 0x3, 0xF, 0},
	{0x189D, 0x0, 0x7F, 0},
	{0x189E, 0x9, 0x1F, 0},
	{0x18BA, 0x1A, 0x1F, 0},
	/* Add UVLO 2.0 setting */
	{0x999, 0x4, 0x7, 5},
	{0x99e, 0x1, 0x7, 3},
	/* Enable SPMI shutdown command */
	{0x136, 0x1, 0x1, 4},
	/* Enable magic key protection */
	{0x3B1, 0, 0xFF, 0},
	{0x3B2, 0, 0xFF, 0},
	{0x3A8, 0, 0xFF, 0},
	{0x3A9, 0, 0xFF, 0},
	{0xA15, 0, 0xFF, 0},
	{0xA16, 0, 0xFF, 0},
	{0x141C, 0, 0xFF, 0},
	{0x141D, 0, 0xFF, 0},
	{0x3AA, 0, 0xFF, 0},
	{0x3AB, 0, 0xFF, 0},
};

/* KP(VCPUB + DREQ) */
static const struct mt6316_setting init_setting_s15[] = {
	/* Disable magic key protection */
	{0x3B1, 0xE9, 0xFF, 0},
	{0x3B2, 0xE6, 0xFF, 0},
	{0x3A8, 0xE9, 0xFF, 0},
	{0x3A9, 0xE6, 0xFF, 0},
	{0xA15, 0x29, 0xFF, 0},
	{0xA16, 0x47, 0xFF, 0},
	{0x141C, 0x43, 0xFF, 0},
	{0x141D, 0x55, 0xFF, 0},
	{0x3AA, 0xDC, 0xFF, 0},
	{0x3AB, 0xF1, 0xFF, 0},
	/* Init setting */
	{0x13, 0x7, 0xFF, 0},
	{0x16, 0x12, 0xFF, 0},
	{0x17, 0x0, 0xFF, 0},
	{0x8A, 0x6, 0xF, 0},
	{0xA1, 0xC, 0xC, 0},
	{0xA2, 0x10, 0x10, 0},
	{0x10C, 0xC, 0xC, 0},
	{0x12C, 0x1, 0x1, 0},
	{0x140, 0x30, 0x30, 0},
	{0x142, 0x30, 0xFF, 0},
	{0x991, 0x11, 0xFF, 0},
	{0x196, 0x1, 0x1, 0},
	{0x197, 0x10, 0x10, 0},
	{0x19A, 0x1, 0x1, 0},
	{0x19B, 0x10, 0x10, 0},
	{0x217, 0x22, 0x22, 0},
	{0x219, 0x1F, 0x1F, 0},
	{0x223, 0x20, 0x20, 0},
	{0x413, 0x7, 0xFF, 0},
	{0x416, 0x12, 0xFF, 0},
	{0x417, 0x0, 0x7, 0},
	{0x988, 0x0, 0x20, 0},
	{0x98C, 0xB0, 0xFF, 0},
	{0x994, 0x0, 0xFF, 0},
	{0xA13, 0x10, 0x10, 0},
	{0xA1F, 0x80, 0x80, 0},
	{0x1452, 0x0, 0xFF, 0},
	{0x1457, 0x22, 0xFF, 0},
	{0x1458, 0x22, 0xFF, 0},
	{0x148A, 0x0, 0x3, 0},
	{0x148F, 0x2, 0x3, 0},
	{0x1492, 0x40, 0x70, 0},
	{0x150A, 0x0, 0x3, 0},
	{0x150F, 0x2, 0x3, 0},
	{0x1512, 0x40, 0x70, 0},
	{0x158A, 0x0, 0x3, 0},
	{0x158F, 0x2, 0x3, 0},
	{0x1592, 0x40, 0x70, 0},
	{0x160A, 0x0, 0x3, 0},
	{0x160F, 0x2, 0x3, 0},
	{0x1612, 0x40, 0x70, 0},
	{0x1729, 0x18, 0x18, 0},
	{0x17A9, 0x18, 0x18, 0},
	{0x1829, 0x18, 0x18, 0},
	{0x18A9, 0x18, 0x18, 0},
	{0x98, 0x2, 0x7, 0},
	{0xA1F, 0xC, 0xC, 0},
	{0xA21, 0x21, 0xFF, 0},
	{0xA23, 0xF0, 0xF0, 0},
	{0xA28, 0x1A, 0xFF, 0},
	{0xA29, 0x1A, 0xFF, 0},
	{0xA2A, 0x18, 0xFF, 0},
	{0xA2B, 0x1A, 0xFF, 0},
	{0x1440, 0x0, 0xA, 0},
	{0x1487, 0x55, 0xFF, 0},
	{0x148A, 0xD, 0xF, 0},
	{0x148C, 0x3, 0x3, 0},
	{0x148D, 0x28, 0x7F, 0},
	{0x148E, 0x7, 0x7F, 0},
	{0x1490, 0x2, 0x3, 0},
	{0x1491, 0x19, 0x7F, 0},
	{0x1507, 0x55, 0xFF, 0},
	{0x150A, 0xD, 0xF, 0},
	{0x150C, 0x3, 0x3, 0},
	{0x150D, 0x28, 0x7F, 0},
	{0x150E, 0x7, 0x7F, 0},
	{0x1510, 0x2, 0x3, 0},
	{0x1511, 0x19, 0x7F, 0},
	{0x1587, 0x96, 0xFF, 0},
	{0x158A, 0xD, 0xF, 0},
	{0x158D, 0xD, 0x7F, 0},
	{0x158E, 0x7, 0x7F, 0},
	{0x1590, 0x2, 0x3, 0},
	{0x1591, 0x19, 0x7F, 0},
	{0x1607, 0x55, 0xFF, 0},
	{0x160A, 0xD, 0xF, 0},
	{0x160C, 0x3, 0x3, 0},
	{0x160D, 0x28, 0x7F, 0},
	{0x160E, 0x7, 0x7F, 0},
	{0x1610, 0x2, 0x3, 0},
	{0x1611, 0x19, 0x7F, 0},
	{0x1688, 0x0, 0x1F, 0},
	{0x1689, 0x10, 0x7F, 0},
	{0x168A, 0x0, 0xFF, 0},
	{0x168B, 0x1, 0xFF, 0},
	{0x168C, 0x5, 0x3F, 0},
	{0x168D, 0xB, 0xFF, 0},
	{0x168E, 0xA0, 0xFF, 0},
	{0x1708, 0xD1, 0xFF, 0},
	{0x1709, 0xFC, 0xFF, 0},
	{0x170A, 0x92, 0xFF, 0},
	{0x170B, 0x0, 0x3, 0},
	{0x170C, 0x4C, 0x7F, 0},
	{0x170D, 0x0, 0x7F, 0},
	{0x170E, 0x30, 0x3F, 0},
	{0x170F, 0x9F, 0xFF, 0},
	{0x1710, 0x29, 0x3F, 0},
	{0x1711, 0x0, 0x3F, 0},
	{0x1712, 0x0, 0xFF, 0},
	{0x1713, 0x9C, 0x9C, 0},
	{0x1714, 0x1, 0x7F, 0},
	{0x1715, 0xFF, 0xFF, 0},
	{0x1716, 0x8E, 0xFF, 0},
	{0x1717, 0x3B, 0xFF, 0},
	{0x1718, 0x6A, 0xFF, 0},
	{0x1719, 0x80, 0xFF, 0},
	{0x171A, 0x8, 0x7F, 0},
	{0x171B, 0x1, 0x3F, 0},
	{0x171C, 0x3, 0xF, 0},
	{0x171D, 0x58, 0x7F, 0},
	{0x171E, 0xD, 0x1F, 0},
	{0x173B, 0x7, 0x1F, 0},
	{0x1788, 0xD1, 0xFF, 0},
	{0x1789, 0xFC, 0xFF, 0},
	{0x178A, 0x92, 0xFF, 0},
	{0x178B, 0x0, 0x3, 0},
	{0x178C, 0x4C, 0x7F, 0},
	{0x178D, 0x0, 0x7F, 0},
	{0x178E, 0x30, 0x3F, 0},
	{0x178F, 0x9F, 0xFF, 0},
	{0x1790, 0x29, 0x3F, 0},
	{0x1791, 0x0, 0x3F, 0},
	{0x1792, 0x0, 0xFF, 0},
	{0x1793, 0xDC, 0xDC, 0},
	{0x1794, 0x0, 0x3F, 0},
	{0x1795, 0xFF, 0xFF, 0},
	{0x1796, 0x8E, 0xFF, 0},
	{0x1797, 0x3B, 0xFF, 0},
	{0x1798, 0x6A, 0xFF, 0},
	{0x1799, 0x80, 0xFF, 0},
	{0x179A, 0x8, 0x7F, 0},
	{0x179B, 0x1, 0x3F, 0},
	{0x179C, 0x3, 0xF, 0},
	{0x179D, 0x58, 0x7F, 0},
	{0x179E, 0xD, 0x1F, 0},
	{0x17BB, 0x7, 0x1F, 0},
	{0x1808, 0xF1, 0xFF, 0},
	{0x1809, 0xEC, 0xFF, 0},
	{0x180A, 0x92, 0xFF, 0},
	{0x180B, 0x0, 0x3, 0},
	{0x180C, 0x54, 0x7F, 0},
	{0x180D, 0x0, 0x7F, 0},
	{0x180E, 0x10, 0x3F, 0},
	{0x180F, 0x9F, 0xFF, 0},
	{0x1810, 0x29, 0x3F, 0},
	{0x1811, 0x0, 0x3F, 0},
	{0x1812, 0x0, 0xFF, 0},
	{0x1813, 0xDC, 0xDC, 0},
	{0x1814, 0x0, 0x3F, 0},
	{0x1815, 0xEF, 0xFF, 0},
	{0x1816, 0x8C, 0xFF, 0},
	{0x1817, 0x13, 0xFF, 0},
	{0x1818, 0xE2, 0xFF, 0},
	{0x1819, 0x81, 0xFF, 0},
	{0x181A, 0x1, 0x7F, 0},
	{0x181B, 0x0, 0x3F, 0},
	{0x181C, 0x3, 0xF, 0},
	{0x181D, 0x39, 0x7F, 0},
	{0x181E, 0x15, 0x1F, 0},
	{0x1888, 0xD1, 0xFF, 0},
	{0x1889, 0xFC, 0xFF, 0},
	{0x188A, 0x92, 0xFF, 0},
	{0x188B, 0x0, 0x3, 0},
	{0x188C, 0x4C, 0x7F, 0},
	{0x188D, 0x0, 0x7F, 0},
	{0x188E, 0x30, 0x3F, 0},
	{0x188F, 0x9F, 0xFF, 0},
	{0x1890, 0x29, 0x3F, 0},
	{0x1891, 0x0, 0x3F, 0},
	{0x1892, 0x0, 0xFF, 0},
	{0x1893, 0xDC, 0xDC, 0},
	{0x1894, 0x0, 0x3F, 0},
	{0x1895, 0xFF, 0xFF, 0},
	{0x1896, 0x8E, 0xFF, 0},
	{0x1897, 0x3B, 0xFF, 0},
	{0x1898, 0x6A, 0xFF, 0},
	{0x1899, 0x80, 0xFF, 0},
	{0x189A, 0x8, 0x7F, 0},
	{0x189B, 0x1, 0x3F, 0},
	{0x189C, 0x3, 0xF, 0},
	{0x189D, 0x58, 0x7F, 0},
	{0x189E, 0xD, 0x1F, 0},
	{0x18BB, 0x7, 0x1F, 0},
	/* Add UVLO 2.0 setting */
	{0x999, 0x4, 0x7, 5},
	{0x99e, 0x1, 0x7, 3},
	/* Enable SPMI shutdown command */
	{0x136, 0x1, 0x1, 4},
	/* Enable magic key protection */
	{0x3B1, 0, 0xFF, 0},
	{0x3B2, 0, 0xFF, 0},
	{0x3A8, 0, 0xFF, 0},
	{0x3A9, 0, 0xFF, 0},
	{0xA15, 0, 0xFF, 0},
	{0xA16, 0, 0xFF, 0},
	{0x141C, 0, 0xFF, 0},
	{0x141D, 0, 0xFF, 0},
	{0x3AA, 0, 0xFF, 0},
	{0x3AB, 0, 0xFF, 0},
};

static inline void write_field(enum spmi_slave slvid, const struct mt6316_setting *setting)
{
	mt6316_write_field(slvid, setting->addr, setting->val, setting->mask, setting->shift);
}

void mt6316_init_setting(void)
{
	for (int i = 0; i < ARRAY_SIZE(init_setting_s6); i++)
		write_field(SPMI_SLAVE_6, &init_setting_s6[i]);

	for (int i = 0; i < ARRAY_SIZE(init_setting_s7); i++)
		write_field(SPMI_SLAVE_7, &init_setting_s7[i]);

	for (int i = 0; i < ARRAY_SIZE(init_setting_s8); i++)
		write_field(SPMI_SLAVE_8, &init_setting_s8[i]);

	for (int i = 0; i < ARRAY_SIZE(init_setting_s15); i++)
		write_field(SPMI_SLAVE_15, &init_setting_s15[i]);
}
