/* SPDX-License-Identifier: GPL-2.0-only */

#include <memlayout.h>
#include <soc/addressmap.h>

#include <arch/header.ld>

#define L2LIM_START(addr) REGION_START(l2lim, addr)
#define L2LIM_END(addr) REGION_END(l2lim, addr)

SECTIONS
{
	L2LIM_START(FU540_L2LIM)
	BOOTBLOCK(FU540_L2LIM, 64K)
	CAR_STACK(FU540_L2LIM + 64K, 12K)
	PRERAM_CBMEM_CONSOLE(FU540_L2LIM + 76K, 8K)
	CBFS_MCACHE(FU540_L2LIM + 84K, 8K)
	FMAP_CACHE(FU540_L2LIM + 92K, 2K)
	ROMSTAGE(FU540_L2LIM + 128K, 128K)
	PRERAM_CBFS_CACHE(FU540_L2LIM + 256K, 128K)
	L2LIM_END(FU540_L2LIM + 2M)

	DRAM_START(FU540_DRAM)
	OPENSBI(FU540_DRAM, 256K)
	RAMSTAGE(FU540_DRAM + 256K, 2M)
	MEM_STACK(FU540_DRAM + 256K + 2M, 20K)
	POSTRAM_CBFS_CACHE(FU540_DRAM + 3M, 29M)
}
