% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/21-dbAppendTableArrow.R
\name{dbAppendTableArrow}
\alias{dbAppendTableArrow}
\title{Insert rows into a table from an Arrow stream}
\usage{
dbAppendTableArrow(conn, name, value, ...)
}
\arguments{
\item{conn}{A \link[=DBIConnection-class]{DBI::DBIConnection} object,
as returned by \code{\link[=dbConnect]{dbConnect()}}.}

\item{name}{The table name, passed on to \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[=Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[=SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{value}{An object coercible with \code{\link[nanoarrow:as_nanoarrow_array_stream]{nanoarrow::as_nanoarrow_array_stream()}}.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbAppendTableArrow()} returns a
scalar
numeric.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The \code{dbAppendTableArrow()} method assumes that the table has been created
beforehand, e.g. with \code{\link[=dbCreateTableArrow]{dbCreateTableArrow()}}.
The default implementation calls \code{\link[=dbAppendTable]{dbAppendTable()}} for each chunk
of the stream.
Use \code{\link[=dbAppendTable]{dbAppendTable()}} to append data from a data.frame.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbAppendTableArrow")}
}
\section{Failure modes}{


If the table does not exist,
or the new data in \code{values} is not a data frame or has different column names,
an error is raised; the remote table remains unchanged.

An error is raised when calling this method for a closed
or invalid connection.
An error is also raised
if \code{name} cannot be processed with \code{\link[DBI:dbQuoteIdentifier]{DBI::dbQuoteIdentifier()}} or
if this results in a non-scalar.

}

\section{Specification}{


SQL keywords can be used freely in table names, column names, and data.
Quotes, commas, spaces, and other special characters such as newlines and tabs,
can also be used in the data,
and, if the database supports non-syntactic identifiers,
also for table names
and column names.

The following data types must be supported at least,
and be read identically with \code{\link[DBI:dbReadTable]{DBI::dbReadTable()}}:
\itemize{
\item integer
\item numeric
(the behavior for \code{Inf} and \code{NaN} is not specified)
\item logical
\item \code{NA} as NULL
\item 64-bit values (using \code{"bigint"} as field type); the result can be
\itemize{
\item converted to a numeric, which may lose precision,
\item converted a character vector, which gives the full decimal
representation
\item written to another table and read again unchanged
}
\item character (in both UTF-8
and native encodings),
supporting empty strings
(before and after non-empty strings)
\item factor (possibly returned as character)
\item objects of type \link[blob:blob]{blob::blob}
(if supported by the database)
\item date
(if supported by the database;
returned as \code{Date})
also for dates prior to 1970 or 1900 or after 2038
\item time
(if supported by the database;
returned as objects that inherit from \code{difftime})
\item timestamp
(if supported by the database;
returned as \code{POSIXct}
respecting the time zone but not necessarily preserving the
input time zone),
also for timestamps prior to 1970 or 1900 or after 2038
respecting the time zone but not necessarily preserving the
input time zone)
}

Mixing column types in the same table is supported.


The \code{name} argument is processed as follows,
to support databases that allow non-syntactic names for their objects:
\itemize{
\item If an unquoted table name as string: \code{dbAppendTableArrow()} will do the quoting,
perhaps by calling \code{dbQuoteIdentifier(conn, x = name)}
\item If the result of a call to \code{\link[DBI:dbQuoteIdentifier]{DBI::dbQuoteIdentifier()}}: no more quoting is done
to support databases that allow non-syntactic names for their objects:
}


The \code{value} argument must be a data frame
with a subset of the columns of the existing table.
The order of the columns does not matter.

}

\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE) && requireNamespace("nanoarrow", quietly = TRUE)) withAutoprint(\{ # examplesIf}
con <- dbConnect(RSQLite::SQLite(), ":memory:")
dbCreateTableArrow(con, "iris", iris[0, ])
dbAppendTableArrow(con, "iris", iris[1:5, ])
dbReadTable(con, "iris")
dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
\seealso{
Other DBIConnection generics: 
\code{\link{DBIConnection-class}},
\code{\link{dbAppendTable}()},
\code{\link{dbCreateTable}()},
\code{\link{dbCreateTableArrow}()},
\code{\link{dbDataType}()},
\code{\link{dbDisconnect}()},
\code{\link{dbExecute}()},
\code{\link{dbExistsTable}()},
\code{\link{dbGetException}()},
\code{\link{dbGetInfo}()},
\code{\link{dbGetQuery}()},
\code{\link{dbGetQueryArrow}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbIsValid}()},
\code{\link{dbListFields}()},
\code{\link{dbListObjects}()},
\code{\link{dbListResults}()},
\code{\link{dbListTables}()},
\code{\link{dbQuoteIdentifier}()},
\code{\link{dbReadTable}()},
\code{\link{dbReadTableArrow}()},
\code{\link{dbRemoveTable}()},
\code{\link{dbSendQuery}()},
\code{\link{dbSendQueryArrow}()},
\code{\link{dbSendStatement}()},
\code{\link{dbUnquoteIdentifier}()},
\code{\link{dbWriteTable}()},
\code{\link{dbWriteTableArrow}()}
}
\concept{DBIConnection generics}
