/*=============================================================================
		ps-font.c
			by Nobuyuki SHIRAKI
			Last change : Tue  5 February 2002   0:38:05
=============================================================================*/

/*-----------------------------------------------------------------------------
			Set PS Fonts Width
-----------------------------------------------------------------------------*/

#include	"e2ps.h"


char *gsFonts = "Times-Roman
Times-Italic
Times-Bold
Times-BoldItalic
Helvetica
Helvetica-Oblique
Helvetica-Bold
Helvetica-BoldOblique
Courier
Courier-Oblique
Courier-Bold
Courier-BoldOblique
Symbol
AvantGarde-Book
AvantGarde_BookOblique
AvantGarde_Demi
AvantGarde_DemiOblique
Bookman-Light
Bookman-LightItalic
Bookman-Demi
Bookman-DemiItalic
Helvetica-Narrow
Helvetica-Narrow-Oblique
Helvetica-Narrow-Bold
Helvetica-Narrow-BoldObliqeu
NewCenturySchlbl-Roman
NewCenturySchlbl-Italic
NewCenturySchlbl-Bold
NewCenturySchlbl-BoldItalic
Palatino-Roman
Palatino-Italic
Palatino-Bold
Palatino-BoldItalic
Zapfchancery-MediumItalic
ZapfDingbats
Ryumin-Light.Hiragana
Ryumin-Light.Katakana
Gothic-Meduim.Hiragana
Gothic-Medium.Katakana
";


/* Set PostScript Font Width */
char *ps_font(char *font, float f[256]) {
  int	i;

  if ( font == NULL || *(font) == '\0' ) {
    return gsFonts;
  }
  else {
    for ( i = 0 ; i < 256 ; i++ ) f[i] = 0.0;
    if ( !strcmp(font, "Times-Roman") ) {
      f[32] = 0.25;
      f[33] = 0.332764;
      f[34] = 0.407959;
      f[35] = 0.5;
      f[36] = 0.5;
      f[37] = 0.832764;
      f[38] = 0.777832;
      f[39] = 0.332764;
      f[40] = 0.332764;
      f[41] = 0.332764;
      f[42] = 0.5;
      f[43] = 0.563965;
      f[44] = 0.25;
      f[45] = 0.332764;
      f[46] = 0.25;
      f[47] = 0.277832;
      f[48] = 0.5;
      f[49] = 0.5;
      f[50] = 0.5;
      f[51] = 0.5;
      f[52] = 0.5;
      f[53] = 0.5;
      f[54] = 0.5;
      f[55] = 0.5;
      f[56] = 0.5;
      f[57] = 0.5;
      f[58] = 0.277832;
      f[59] = 0.277832;
      f[60] = 0.563965;
      f[61] = 0.563965;
      f[62] = 0.563965;
      f[63] = 0.443848;
      f[64] = 0.920898;
      f[65] = 0.721924;
      f[66] = 0.666992;
      f[67] = 0.666992;
      f[68] = 0.721924;
      f[69] = 0.61084;
      f[70] = 0.555908;
      f[71] = 0.721924;
      f[72] = 0.721924;
      f[73] = 0.332764;
      f[74] = 0.388916;
      f[75] = 0.721924;
      f[76] = 0.61084;
      f[77] = 0.888916;
      f[78] = 0.721924;
      f[79] = 0.721924;
      f[80] = 0.555908;
      f[81] = 0.721924;
      f[82] = 0.666992;
      f[83] = 0.555908;
      f[84] = 0.61084;
      f[85] = 0.721924;
      f[86] = 0.721924;
      f[87] = 0.943848;
      f[88] = 0.721924;
      f[89] = 0.721924;
      f[90] = 0.61084;
      f[91] = 0.332764;
      f[92] = 0.277832;
      f[93] = 0.332764;
      f[94] = 0.468994;
      f[95] = 0.5;
      f[96] = 0.332764;
      f[97] = 0.443848;
      f[98] = 0.5;
      f[99] = 0.443848;
      f[100] = 0.5;
      f[101] = 0.443848;
      f[102] = 0.332764;
      f[103] = 0.5;
      f[104] = 0.5;
      f[105] = 0.277832;
      f[106] = 0.277832;
      f[107] = 0.5;
      f[108] = 0.277832;
      f[109] = 0.777832;
      f[110] = 0.5;
      f[111] = 0.5;
      f[112] = 0.5;
      f[113] = 0.5;
      f[114] = 0.332764;
      f[115] = 0.388916;
      f[116] = 0.277832;
      f[117] = 0.5;
      f[118] = 0.5;
      f[119] = 0.721924;
      f[120] = 0.5;
      f[121] = 0.5;
      f[122] = 0.443848;
      f[123] = 0.47998;
      f[124] = 0.199951;
      f[125] = 0.47998;
      f[126] = 0.540771;
      f[161] = 0.332764;
      f[162] = 0.5;
      f[163] = 0.5;
      f[164] = 0.166992;
      f[165] = 0.5;
      f[166] = 0.5;
      f[167] = 0.5;
      f[168] = 0.5;
      f[169] = 0.179932;
      f[170] = 0.443848;
      f[171] = 0.5;
      f[172] = 0.332764;
      f[173] = 0.332764;
      f[174] = 0.555908;
      f[175] = 0.555908;
      f[177] = 0.5;
      f[178] = 0.5;
      f[179] = 0.5;
      f[180] = 0.25;
      f[182] = 0.452881;
      f[183] = 0.349854;
      f[184] = 0.332764;
      f[185] = 0.443848;
      f[186] = 0.443848;
      f[187] = 0.5;
      f[188] = 1.0;
      f[189] = 1.0;
      f[191] = 0.443848;
      f[193] = 0.332764;
      f[194] = 0.332764;
      f[195] = 0.332764;
      f[196] = 0.332764;
      f[197] = 0.332764;
      f[198] = 0.332764;
      f[199] = 0.332764;
      f[200] = 0.332764;
      f[202] = 0.332764;
      f[203] = 0.332764;
      f[205] = 0.332764;
      f[206] = 0.332764;
      f[207] = 0.332764;
      f[208] = 1.0;
      f[225] = 0.888916;
      f[227] = 0.275879;
      f[232] = 0.61084;
      f[233] = 0.721924;
      f[234] = 0.888916;
      f[235] = 0.309814;
      f[241] = 0.666992;
      f[245] = 0.277832;
      f[248] = 0.277832;
      f[249] = 0.5;
      f[250] = 0.721924;
      f[251] = 0.5;
    }
    else if ( !strcmp(font, "Times-Italic") ) {
      f[32] = 0.25;
      f[33] = 0.332764;
      f[34] = 0.419922;
      f[35] = 0.5;
      f[36] = 0.5;
      f[37] = 0.832764;
      f[38] = 0.777832;
      f[39] = 0.332764;
      f[40] = 0.332764;
      f[41] = 0.332764;
      f[42] = 0.5;
      f[43] = 0.674805;
      f[44] = 0.25;
      f[45] = 0.332764;
      f[46] = 0.25;
      f[47] = 0.277832;
      f[48] = 0.5;
      f[49] = 0.5;
      f[50] = 0.5;
      f[51] = 0.5;
      f[52] = 0.5;
      f[53] = 0.5;
      f[54] = 0.5;
      f[55] = 0.5;
      f[56] = 0.5;
      f[57] = 0.5;
      f[58] = 0.332764;
      f[59] = 0.332764;
      f[60] = 0.674805;
      f[61] = 0.674805;
      f[62] = 0.674805;
      f[63] = 0.5;
      f[64] = 0.919922;
      f[65] = 0.61084;
      f[66] = 0.61084;
      f[67] = 0.666992;
      f[68] = 0.721924;
      f[69] = 0.61084;
      f[70] = 0.61084;
      f[71] = 0.721924;
      f[72] = 0.721924;
      f[73] = 0.332764;
      f[74] = 0.443848;
      f[75] = 0.666992;
      f[76] = 0.555908;
      f[77] = 0.832764;
      f[78] = 0.666992;
      f[79] = 0.721924;
      f[80] = 0.61084;
      f[81] = 0.721924;
      f[82] = 0.61084;
      f[83] = 0.5;
      f[84] = 0.555908;
      f[85] = 0.721924;
      f[86] = 0.61084;
      f[87] = 0.832764;
      f[88] = 0.61084;
      f[89] = 0.555908;
      f[90] = 0.555908;
      f[91] = 0.388916;
      f[92] = 0.277832;
      f[93] = 0.388916;
      f[94] = 0.421875;
      f[95] = 0.5;
      f[96] = 0.332764;
      f[97] = 0.5;
      f[98] = 0.5;
      f[99] = 0.443848;
      f[100] = 0.5;
      f[101] = 0.443848;
      f[102] = 0.277832;
      f[103] = 0.5;
      f[104] = 0.5;
      f[105] = 0.277832;
      f[106] = 0.277832;
      f[107] = 0.443848;
      f[108] = 0.277832;
      f[109] = 0.721924;
      f[110] = 0.5;
      f[111] = 0.5;
      f[112] = 0.5;
      f[113] = 0.5;
      f[114] = 0.388916;
      f[115] = 0.388916;
      f[116] = 0.277832;
      f[117] = 0.5;
      f[118] = 0.443848;
      f[119] = 0.666992;
      f[120] = 0.443848;
      f[121] = 0.443848;
      f[122] = 0.388916;
      f[123] = 0.399902;
      f[124] = 0.274902;
      f[125] = 0.399902;
      f[126] = 0.540771;
      f[161] = 0.388916;
      f[162] = 0.5;
      f[163] = 0.5;
      f[164] = 0.166992;
      f[165] = 0.5;
      f[166] = 0.5;
      f[167] = 0.5;
      f[168] = 0.5;
      f[169] = 0.213867;
      f[170] = 0.555908;
      f[171] = 0.5;
      f[172] = 0.332764;
      f[173] = 0.332764;
      f[174] = 0.5;
      f[175] = 0.5;
      f[177] = 0.5;
      f[178] = 0.5;
      f[179] = 0.5;
      f[180] = 0.25;
      f[182] = 0.522949;
      f[183] = 0.349854;
      f[184] = 0.332764;
      f[185] = 0.555908;
      f[186] = 0.555908;
      f[187] = 0.5;
      f[188] = 0.888916;
      f[189] = 1.0;
      f[191] = 0.5;
      f[193] = 0.332764;
      f[194] = 0.332764;
      f[195] = 0.332764;
      f[196] = 0.332764;
      f[197] = 0.332764;
      f[198] = 0.332764;
      f[199] = 0.332764;
      f[200] = 0.332764;
      f[202] = 0.332764;
      f[203] = 0.332764;
      f[205] = 0.332764;
      f[206] = 0.332764;
      f[207] = 0.332764;
      f[208] = 0.888916;
      f[225] = 0.888916;
      f[227] = 0.275879;
      f[232] = 0.555908;
      f[233] = 0.721924;
      f[234] = 0.943848;
      f[235] = 0.309814;
      f[241] = 0.666992;
      f[245] = 0.277832;
      f[248] = 0.277832;
      f[249] = 0.5;
      f[250] = 0.666992;
      f[251] = 0.5;
    }
    else if ( !strcmp(font, "Times-Bold") ) {
      f[32] = 0.25;
      f[33] = 0.332764;
      f[34] = 0.554932;
      f[35] = 0.5;
      f[36] = 0.5;
      f[37] = 1.0;
      f[38] = 0.832764;
      f[39] = 0.332764;
      f[40] = 0.332764;
      f[41] = 0.332764;
      f[42] = 0.5;
      f[43] = 0.569824;
      f[44] = 0.25;
      f[45] = 0.332764;
      f[46] = 0.25;
      f[47] = 0.277832;
      f[48] = 0.5;
      f[49] = 0.5;
      f[50] = 0.5;
      f[51] = 0.5;
      f[52] = 0.5;
      f[53] = 0.5;
      f[54] = 0.5;
      f[55] = 0.5;
      f[56] = 0.5;
      f[57] = 0.5;
      f[58] = 0.332764;
      f[59] = 0.332764;
      f[60] = 0.569824;
      f[61] = 0.569824;
      f[62] = 0.569824;
      f[63] = 0.5;
      f[64] = 0.929932;
      f[65] = 0.721924;
      f[66] = 0.666992;
      f[67] = 0.721924;
      f[68] = 0.721924;
      f[69] = 0.666992;
      f[70] = 0.61084;
      f[71] = 0.777832;
      f[72] = 0.777832;
      f[73] = 0.388916;
      f[74] = 0.5;
      f[75] = 0.777832;
      f[76] = 0.666992;
      f[77] = 0.943848;
      f[78] = 0.721924;
      f[79] = 0.777832;
      f[80] = 0.61084;
      f[81] = 0.777832;
      f[82] = 0.721924;
      f[83] = 0.555908;
      f[84] = 0.666992;
      f[85] = 0.721924;
      f[86] = 0.721924;
      f[87] = 1.0;
      f[88] = 0.721924;
      f[89] = 0.721924;
      f[90] = 0.666992;
      f[91] = 0.332764;
      f[92] = 0.277832;
      f[93] = 0.332764;
      f[94] = 0.580811;
      f[95] = 0.5;
      f[96] = 0.332764;
      f[97] = 0.5;
      f[98] = 0.555908;
      f[99] = 0.443848;
      f[100] = 0.555908;
      f[101] = 0.443848;
      f[102] = 0.332764;
      f[103] = 0.5;
      f[104] = 0.555908;
      f[105] = 0.277832;
      f[106] = 0.332764;
      f[107] = 0.555908;
      f[108] = 0.277832;
      f[109] = 0.832764;
      f[110] = 0.555908;
      f[111] = 0.5;
      f[112] = 0.555908;
      f[113] = 0.555908;
      f[114] = 0.443848;
      f[115] = 0.388916;
      f[116] = 0.332764;
      f[117] = 0.555908;
      f[118] = 0.5;
      f[119] = 0.721924;
      f[120] = 0.5;
      f[121] = 0.5;
      f[122] = 0.443848;
      f[123] = 0.393799;
      f[124] = 0.219971;
      f[125] = 0.393799;
      f[126] = 0.519775;
      f[161] = 0.332764;
      f[162] = 0.5;
      f[163] = 0.5;
      f[164] = 0.166992;
      f[165] = 0.5;
      f[166] = 0.5;
      f[167] = 0.5;
      f[168] = 0.5;
      f[169] = 0.277832;
      f[170] = 0.5;
      f[171] = 0.5;
      f[172] = 0.332764;
      f[173] = 0.332764;
      f[174] = 0.555908;
      f[175] = 0.555908;
      f[177] = 0.5;
      f[178] = 0.5;
      f[179] = 0.5;
      f[180] = 0.25;
      f[182] = 0.539795;
      f[183] = 0.349854;
      f[184] = 0.332764;
      f[185] = 0.5;
      f[186] = 0.5;
      f[187] = 0.5;
      f[188] = 1.0;
      f[189] = 1.0;
      f[191] = 0.5;
      f[193] = 0.332764;
      f[194] = 0.332764;
      f[195] = 0.332764;
      f[196] = 0.332764;
      f[197] = 0.332764;
      f[198] = 0.332764;
      f[199] = 0.332764;
      f[200] = 0.332764;
      f[202] = 0.332764;
      f[203] = 0.332764;
      f[205] = 0.332764;
      f[206] = 0.332764;
      f[207] = 0.332764;
      f[208] = 1.0;
      f[225] = 1.0;
      f[227] = 0.299805;
      f[232] = 0.666992;
      f[233] = 0.777832;
      f[234] = 1.0;
      f[235] = 0.329834;
      f[241] = 0.721924;
      f[245] = 0.277832;
      f[248] = 0.277832;
      f[249] = 0.5;
      f[250] = 0.721924;
      f[251] = 0.555908;
    }
    else if ( !strcmp(font, "Times-BoldItalic") ) {
      f[32] = 0.25;
      f[33] = 0.388916;
      f[34] = 0.554932;
      f[35] = 0.5;
      f[36] = 0.5;
      f[37] = 0.832764;
      f[38] = 0.777832;
      f[39] = 0.332764;
      f[40] = 0.332764;
      f[41] = 0.332764;
      f[42] = 0.5;
      f[43] = 0.569824;
      f[44] = 0.25;
      f[45] = 0.332764;
      f[46] = 0.25;
      f[47] = 0.277832;
      f[48] = 0.5;
      f[49] = 0.5;
      f[50] = 0.5;
      f[51] = 0.5;
      f[52] = 0.5;
      f[53] = 0.5;
      f[54] = 0.5;
      f[55] = 0.5;
      f[56] = 0.5;
      f[57] = 0.5;
      f[58] = 0.332764;
      f[59] = 0.332764;
      f[60] = 0.569824;
      f[61] = 0.569824;
      f[62] = 0.569824;
      f[63] = 0.5;
      f[64] = 0.831787;
      f[65] = 0.666992;
      f[66] = 0.666992;
      f[67] = 0.666992;
      f[68] = 0.721924;
      f[69] = 0.666992;
      f[70] = 0.666992;
      f[71] = 0.721924;
      f[72] = 0.777832;
      f[73] = 0.388916;
      f[74] = 0.5;
      f[75] = 0.666992;
      f[76] = 0.61084;
      f[77] = 0.888916;
      f[78] = 0.721924;
      f[79] = 0.721924;
      f[80] = 0.61084;
      f[81] = 0.721924;
      f[82] = 0.666992;
      f[83] = 0.555908;
      f[84] = 0.61084;
      f[85] = 0.721924;
      f[86] = 0.666992;
      f[87] = 0.888916;
      f[88] = 0.666992;
      f[89] = 0.61084;
      f[90] = 0.61084;
      f[91] = 0.332764;
      f[92] = 0.277832;
      f[93] = 0.332764;
      f[94] = 0.569824;
      f[95] = 0.5;
      f[96] = 0.332764;
      f[97] = 0.5;
      f[98] = 0.5;
      f[99] = 0.443848;
      f[100] = 0.5;
      f[101] = 0.443848;
      f[102] = 0.332764;
      f[103] = 0.5;
      f[104] = 0.555908;
      f[105] = 0.277832;
      f[106] = 0.277832;
      f[107] = 0.5;
      f[108] = 0.277832;
      f[109] = 0.777832;
      f[110] = 0.555908;
      f[111] = 0.5;
      f[112] = 0.5;
      f[113] = 0.5;
      f[114] = 0.388916;
      f[115] = 0.388916;
      f[116] = 0.277832;
      f[117] = 0.555908;
      f[118] = 0.443848;
      f[119] = 0.666992;
      f[120] = 0.5;
      f[121] = 0.443848;
      f[122] = 0.388916;
      f[123] = 0.3479;
      f[124] = 0.219971;
      f[125] = 0.3479;
      f[126] = 0.569824;
      f[161] = 0.388916;
      f[162] = 0.5;
      f[163] = 0.5;
      f[164] = 0.166992;
      f[165] = 0.5;
      f[166] = 0.5;
      f[167] = 0.5;
      f[168] = 0.5;
      f[169] = 0.277832;
      f[170] = 0.5;
      f[171] = 0.5;
      f[172] = 0.332764;
      f[173] = 0.332764;
      f[174] = 0.555908;
      f[175] = 0.555908;
      f[177] = 0.5;
      f[178] = 0.5;
      f[179] = 0.5;
      f[180] = 0.25;
      f[182] = 0.5;
      f[183] = 0.349854;
      f[184] = 0.332764;
      f[185] = 0.5;
      f[186] = 0.5;
      f[187] = 0.5;
      f[188] = 1.0;
      f[189] = 1.0;
      f[191] = 0.5;
      f[193] = 0.332764;
      f[194] = 0.332764;
      f[195] = 0.332764;
      f[196] = 0.332764;
      f[197] = 0.332764;
      f[198] = 0.332764;
      f[199] = 0.332764;
      f[200] = 0.332764;
      f[202] = 0.332764;
      f[203] = 0.332764;
      f[205] = 0.332764;
      f[206] = 0.332764;
      f[207] = 0.332764;
      f[208] = 1.0;
      f[225] = 0.943848;
      f[227] = 0.265869;
      f[232] = 0.61084;
      f[233] = 0.721924;
      f[234] = 0.943848;
      f[235] = 0.299805;
      f[241] = 0.721924;
      f[245] = 0.277832;
      f[248] = 0.277832;
      f[249] = 0.5;
      f[250] = 0.721924;
      f[251] = 0.5;
    }
    else if ( !strcmp(font, "Helvetica") ) {
      f[32] = 0.277832;
      f[33] = 0.277832;
      f[34] = 0.35498;
      f[35] = 0.555908;
      f[36] = 0.555908;
      f[37] = 0.888916;
      f[38] = 0.666992;
      f[39] = 0.221924;
      f[40] = 0.332764;
      f[41] = 0.332764;
      f[42] = 0.388916;
      f[43] = 0.583984;
      f[44] = 0.277832;
      f[45] = 0.332764;
      f[46] = 0.277832;
      f[47] = 0.277832;
      f[48] = 0.555908;
      f[49] = 0.555908;
      f[50] = 0.555908;
      f[51] = 0.555908;
      f[52] = 0.555908;
      f[53] = 0.555908;
      f[54] = 0.555908;
      f[55] = 0.555908;
      f[56] = 0.555908;
      f[57] = 0.555908;
      f[58] = 0.277832;
      f[59] = 0.277832;
      f[60] = 0.583984;
      f[61] = 0.583984;
      f[62] = 0.583984;
      f[63] = 0.555908;
      f[64] = 1.01489;
      f[65] = 0.666992;
      f[66] = 0.666992;
      f[67] = 0.721924;
      f[68] = 0.721924;
      f[69] = 0.666992;
      f[70] = 0.61084;
      f[71] = 0.777832;
      f[72] = 0.721924;
      f[73] = 0.277832;
      f[74] = 0.5;
      f[75] = 0.666992;
      f[76] = 0.555908;
      f[77] = 0.832764;
      f[78] = 0.721924;
      f[79] = 0.777832;
      f[80] = 0.666992;
      f[81] = 0.777832;
      f[82] = 0.721924;
      f[83] = 0.666992;
      f[84] = 0.61084;
      f[85] = 0.721924;
      f[86] = 0.666992;
      f[87] = 0.943848;
      f[88] = 0.666992;
      f[89] = 0.666992;
      f[90] = 0.61084;
      f[91] = 0.277832;
      f[92] = 0.277832;
      f[93] = 0.277832;
      f[94] = 0.468994;
      f[95] = 0.555908;
      f[96] = 0.221924;
      f[97] = 0.555908;
      f[98] = 0.555908;
      f[99] = 0.5;
      f[100] = 0.555908;
      f[101] = 0.555908;
      f[102] = 0.277832;
      f[103] = 0.555908;
      f[104] = 0.555908;
      f[105] = 0.221924;
      f[106] = 0.221924;
      f[107] = 0.5;
      f[108] = 0.221924;
      f[109] = 0.832764;
      f[110] = 0.555908;
      f[111] = 0.555908;
      f[112] = 0.555908;
      f[113] = 0.555908;
      f[114] = 0.332764;
      f[115] = 0.5;
      f[116] = 0.277832;
      f[117] = 0.555908;
      f[118] = 0.5;
      f[119] = 0.721924;
      f[120] = 0.5;
      f[121] = 0.5;
      f[122] = 0.5;
      f[123] = 0.333984;
      f[124] = 0.259766;
      f[125] = 0.333984;
      f[126] = 0.583984;
      f[161] = 0.332764;
      f[162] = 0.555908;
      f[163] = 0.555908;
      f[164] = 0.166992;
      f[165] = 0.555908;
      f[166] = 0.555908;
      f[167] = 0.555908;
      f[168] = 0.555908;
      f[169] = 0.190918;
      f[170] = 0.332764;
      f[171] = 0.555908;
      f[172] = 0.332764;
      f[173] = 0.332764;
      f[174] = 0.5;
      f[175] = 0.5;
      f[177] = 0.555908;
      f[178] = 0.555908;
      f[179] = 0.555908;
      f[180] = 0.277832;
      f[182] = 0.536865;
      f[183] = 0.349854;
      f[184] = 0.221924;
      f[185] = 0.332764;
      f[186] = 0.332764;
      f[187] = 0.555908;
      f[188] = 1.0;
      f[189] = 1.0;
      f[191] = 0.61084;
      f[193] = 0.332764;
      f[194] = 0.332764;
      f[195] = 0.332764;
      f[196] = 0.332764;
      f[197] = 0.332764;
      f[198] = 0.332764;
      f[199] = 0.332764;
      f[200] = 0.332764;
      f[202] = 0.332764;
      f[203] = 0.332764;
      f[205] = 0.332764;
      f[206] = 0.332764;
      f[207] = 0.332764;
      f[208] = 1.0;
      f[225] = 1.0;
      f[227] = 0.369873;
      f[232] = 0.555908;
      f[233] = 0.777832;
      f[234] = 1.0;
      f[235] = 0.36499;
      f[241] = 0.888916;
      f[245] = 0.277832;
      f[248] = 0.221924;
      f[249] = 0.61084;
      f[250] = 0.943848;
      f[251] = 0.61084;
    }
    else if ( !strcmp(font, "Helvetica-Oblique") ) {
      f[32] = 0.277832;
      f[33] = 0.277832;
      f[34] = 0.35498;
      f[35] = 0.555908;
      f[36] = 0.555908;
      f[37] = 0.888916;
      f[38] = 0.666992;
      f[39] = 0.221924;
      f[40] = 0.332764;
      f[41] = 0.332764;
      f[42] = 0.388916;
      f[43] = 0.583984;
      f[44] = 0.277832;
      f[45] = 0.332764;
      f[46] = 0.277832;
      f[47] = 0.277832;
      f[48] = 0.555908;
      f[49] = 0.555908;
      f[50] = 0.555908;
      f[51] = 0.555908;
      f[52] = 0.555908;
      f[53] = 0.555908;
      f[54] = 0.555908;
      f[55] = 0.555908;
      f[56] = 0.555908;
      f[57] = 0.555908;
      f[58] = 0.277832;
      f[59] = 0.277832;
      f[60] = 0.583984;
      f[61] = 0.583984;
      f[62] = 0.583984;
      f[63] = 0.555908;
      f[64] = 1.01489;
      f[65] = 0.666992;
      f[66] = 0.666992;
      f[67] = 0.721924;
      f[68] = 0.721924;
      f[69] = 0.666992;
      f[70] = 0.61084;
      f[71] = 0.777832;
      f[72] = 0.721924;
      f[73] = 0.277832;
      f[74] = 0.5;
      f[75] = 0.666992;
      f[76] = 0.555908;
      f[77] = 0.832764;
      f[78] = 0.721924;
      f[79] = 0.777832;
      f[80] = 0.666992;
      f[81] = 0.777832;
      f[82] = 0.721924;
      f[83] = 0.666992;
      f[84] = 0.61084;
      f[85] = 0.721924;
      f[86] = 0.666992;
      f[87] = 0.943848;
      f[88] = 0.666992;
      f[89] = 0.666992;
      f[90] = 0.61084;
      f[91] = 0.277832;
      f[92] = 0.277832;
      f[93] = 0.277832;
      f[94] = 0.468994;
      f[95] = 0.555908;
      f[96] = 0.221924;
      f[97] = 0.555908;
      f[98] = 0.555908;
      f[99] = 0.5;
      f[100] = 0.555908;
      f[101] = 0.555908;
      f[102] = 0.277832;
      f[103] = 0.555908;
      f[104] = 0.555908;
      f[105] = 0.221924;
      f[106] = 0.221924;
      f[107] = 0.5;
      f[108] = 0.221924;
      f[109] = 0.832764;
      f[110] = 0.555908;
      f[111] = 0.555908;
      f[112] = 0.555908;
      f[113] = 0.555908;
      f[114] = 0.332764;
      f[115] = 0.5;
      f[116] = 0.277832;
      f[117] = 0.555908;
      f[118] = 0.5;
      f[119] = 0.721924;
      f[120] = 0.5;
      f[121] = 0.5;
      f[122] = 0.5;
      f[123] = 0.333984;
      f[124] = 0.259766;
      f[125] = 0.333984;
      f[126] = 0.583984;
      f[161] = 0.332764;
      f[162] = 0.555908;
      f[163] = 0.555908;
      f[164] = 0.166992;
      f[165] = 0.555908;
      f[166] = 0.555908;
      f[167] = 0.555908;
      f[168] = 0.555908;
      f[169] = 0.190918;
      f[170] = 0.332764;
      f[171] = 0.555908;
      f[172] = 0.332764;
      f[173] = 0.332764;
      f[174] = 0.5;
      f[175] = 0.5;
      f[177] = 0.555908;
      f[178] = 0.555908;
      f[179] = 0.555908;
      f[180] = 0.277832;
      f[182] = 0.536865;
      f[183] = 0.349854;
      f[184] = 0.221924;
      f[185] = 0.332764;
      f[186] = 0.332764;
      f[187] = 0.555908;
      f[188] = 1.0;
      f[189] = 1.0;
      f[191] = 0.61084;
      f[193] = 0.332764;
      f[194] = 0.332764;
      f[195] = 0.332764;
      f[196] = 0.332764;
      f[197] = 0.332764;
      f[198] = 0.332764;
      f[199] = 0.332764;
      f[200] = 0.332764;
      f[202] = 0.332764;
      f[203] = 0.332764;
      f[205] = 0.332764;
      f[206] = 0.332764;
      f[207] = 0.332764;
      f[208] = 1.0;
      f[225] = 1.0;
      f[227] = 0.369873;
      f[232] = 0.555908;
      f[233] = 0.777832;
      f[234] = 1.0;
      f[235] = 0.36499;
      f[241] = 0.888916;
      f[245] = 0.277832;
      f[248] = 0.221924;
      f[249] = 0.61084;
      f[250] = 0.943848;
      f[251] = 0.61084;
    }
    else if ( !strcmp(font, "Helvetica-Bold") ) {
      f[32] = 0.277832;
      f[33] = 0.332764;
      f[34] = 0.473877;
      f[35] = 0.555908;
      f[36] = 0.555908;
      f[37] = 0.888916;
      f[38] = 0.721924;
      f[39] = 0.277832;
      f[40] = 0.332764;
      f[41] = 0.332764;
      f[42] = 0.388916;
      f[43] = 0.583984;
      f[44] = 0.277832;
      f[45] = 0.332764;
      f[46] = 0.277832;
      f[47] = 0.277832;
      f[48] = 0.555908;
      f[49] = 0.555908;
      f[50] = 0.555908;
      f[51] = 0.555908;
      f[52] = 0.555908;
      f[53] = 0.555908;
      f[54] = 0.555908;
      f[55] = 0.555908;
      f[56] = 0.555908;
      f[57] = 0.555908;
      f[58] = 0.332764;
      f[59] = 0.332764;
      f[60] = 0.583984;
      f[61] = 0.583984;
      f[62] = 0.583984;
      f[63] = 0.61084;
      f[64] = 0.974854;
      f[65] = 0.721924;
      f[66] = 0.721924;
      f[67] = 0.721924;
      f[68] = 0.721924;
      f[69] = 0.666992;
      f[70] = 0.61084;
      f[71] = 0.777832;
      f[72] = 0.721924;
      f[73] = 0.277832;
      f[74] = 0.555908;
      f[75] = 0.721924;
      f[76] = 0.61084;
      f[77] = 0.832764;
      f[78] = 0.721924;
      f[79] = 0.777832;
      f[80] = 0.666992;
      f[81] = 0.777832;
      f[82] = 0.721924;
      f[83] = 0.666992;
      f[84] = 0.61084;
      f[85] = 0.721924;
      f[86] = 0.666992;
      f[87] = 0.943848;
      f[88] = 0.666992;
      f[89] = 0.666992;
      f[90] = 0.61084;
      f[91] = 0.332764;
      f[92] = 0.277832;
      f[93] = 0.332764;
      f[94] = 0.583984;
      f[95] = 0.555908;
      f[96] = 0.277832;
      f[97] = 0.555908;
      f[98] = 0.61084;
      f[99] = 0.555908;
      f[100] = 0.61084;
      f[101] = 0.555908;
      f[102] = 0.332764;
      f[103] = 0.61084;
      f[104] = 0.61084;
      f[105] = 0.277832;
      f[106] = 0.277832;
      f[107] = 0.555908;
      f[108] = 0.277832;
      f[109] = 0.888916;
      f[110] = 0.61084;
      f[111] = 0.61084;
      f[112] = 0.61084;
      f[113] = 0.61084;
      f[114] = 0.388916;
      f[115] = 0.555908;
      f[116] = 0.332764;
      f[117] = 0.61084;
      f[118] = 0.555908;
      f[119] = 0.777832;
      f[120] = 0.555908;
      f[121] = 0.555908;
      f[122] = 0.5;
      f[123] = 0.388916;
      f[124] = 0.279785;
      f[125] = 0.388916;
      f[126] = 0.583984;
      f[161] = 0.332764;
      f[162] = 0.555908;
      f[163] = 0.555908;
      f[164] = 0.166992;
      f[165] = 0.555908;
      f[166] = 0.555908;
      f[167] = 0.555908;
      f[168] = 0.555908;
      f[169] = 0.237793;
      f[170] = 0.5;
      f[171] = 0.555908;
      f[172] = 0.332764;
      f[173] = 0.332764;
      f[174] = 0.61084;
      f[175] = 0.61084;
      f[177] = 0.555908;
      f[178] = 0.555908;
      f[179] = 0.555908;
      f[180] = 0.277832;
      f[182] = 0.555908;
      f[183] = 0.349854;
      f[184] = 0.277832;
      f[185] = 0.5;
      f[186] = 0.5;
      f[187] = 0.555908;
      f[188] = 1.0;
      f[189] = 1.0;
      f[191] = 0.61084;
      f[193] = 0.332764;
      f[194] = 0.332764;
      f[195] = 0.332764;
      f[196] = 0.332764;
      f[197] = 0.332764;
      f[198] = 0.332764;
      f[199] = 0.332764;
      f[200] = 0.332764;
      f[202] = 0.332764;
      f[203] = 0.332764;
      f[205] = 0.332764;
      f[206] = 0.332764;
      f[207] = 0.332764;
      f[208] = 1.0;
      f[225] = 1.0;
      f[227] = 0.369873;
      f[232] = 0.61084;
      f[233] = 0.777832;
      f[234] = 1.0;
      f[235] = 0.36499;
      f[241] = 0.888916;
      f[245] = 0.277832;
      f[248] = 0.277832;
      f[249] = 0.61084;
      f[250] = 0.943848;
      f[251] = 0.61084;
    }
    else if ( !strcmp(font, "Helvetica-BoldOblique") ) {
      f[32] = 0.277832;
      f[33] = 0.332764;
      f[34] = 0.473877;
      f[35] = 0.555908;
      f[36] = 0.555908;
      f[37] = 0.888916;
      f[38] = 0.721924;
      f[39] = 0.277832;
      f[40] = 0.332764;
      f[41] = 0.332764;
      f[42] = 0.388916;
      f[43] = 0.583984;
      f[44] = 0.277832;
      f[45] = 0.332764;
      f[46] = 0.277832;
      f[47] = 0.277832;
      f[48] = 0.555908;
      f[49] = 0.555908;
      f[50] = 0.555908;
      f[51] = 0.555908;
      f[52] = 0.555908;
      f[53] = 0.555908;
      f[54] = 0.555908;
      f[55] = 0.555908;
      f[56] = 0.555908;
      f[57] = 0.555908;
      f[58] = 0.332764;
      f[59] = 0.332764;
      f[60] = 0.583984;
      f[61] = 0.583984;
      f[62] = 0.583984;
      f[63] = 0.61084;
      f[64] = 0.974854;
      f[65] = 0.721924;
      f[66] = 0.721924;
      f[67] = 0.721924;
      f[68] = 0.721924;
      f[69] = 0.666992;
      f[70] = 0.61084;
      f[71] = 0.777832;
      f[72] = 0.721924;
      f[73] = 0.277832;
      f[74] = 0.555908;
      f[75] = 0.721924;
      f[76] = 0.61084;
      f[77] = 0.832764;
      f[78] = 0.721924;
      f[79] = 0.777832;
      f[80] = 0.666992;
      f[81] = 0.777832;
      f[82] = 0.721924;
      f[83] = 0.666992;
      f[84] = 0.61084;
      f[85] = 0.721924;
      f[86] = 0.666992;
      f[87] = 0.943848;
      f[88] = 0.666992;
      f[89] = 0.666992;
      f[90] = 0.61084;
      f[91] = 0.332764;
      f[92] = 0.277832;
      f[93] = 0.332764;
      f[94] = 0.583984;
      f[95] = 0.555908;
      f[96] = 0.277832;
      f[97] = 0.555908;
      f[98] = 0.61084;
      f[99] = 0.555908;
      f[100] = 0.61084;
      f[101] = 0.555908;
      f[102] = 0.332764;
      f[103] = 0.61084;
      f[104] = 0.61084;
      f[105] = 0.277832;
      f[106] = 0.277832;
      f[107] = 0.555908;
      f[108] = 0.277832;
      f[109] = 0.888916;
      f[110] = 0.61084;
      f[111] = 0.61084;
      f[112] = 0.61084;
      f[113] = 0.61084;
      f[114] = 0.388916;
      f[115] = 0.555908;
      f[116] = 0.332764;
      f[117] = 0.61084;
      f[118] = 0.555908;
      f[119] = 0.777832;
      f[120] = 0.555908;
      f[121] = 0.555908;
      f[122] = 0.5;
      f[123] = 0.388916;
      f[124] = 0.279785;
      f[125] = 0.388916;
      f[126] = 0.583984;
      f[161] = 0.332764;
      f[162] = 0.555908;
      f[163] = 0.555908;
      f[164] = 0.166992;
      f[165] = 0.555908;
      f[166] = 0.555908;
      f[167] = 0.555908;
      f[168] = 0.555908;
      f[169] = 0.237793;
      f[170] = 0.5;
      f[171] = 0.555908;
      f[172] = 0.332764;
      f[173] = 0.332764;
      f[174] = 0.61084;
      f[175] = 0.61084;
      f[177] = 0.555908;
      f[178] = 0.555908;
      f[179] = 0.555908;
      f[180] = 0.277832;
      f[182] = 0.555908;
      f[183] = 0.349854;
      f[184] = 0.277832;
      f[185] = 0.5;
      f[186] = 0.5;
      f[187] = 0.555908;
      f[188] = 1.0;
      f[189] = 1.0;
      f[191] = 0.61084;
      f[193] = 0.332764;
      f[194] = 0.332764;
      f[195] = 0.332764;
      f[196] = 0.332764;
      f[197] = 0.332764;
      f[198] = 0.332764;
      f[199] = 0.332764;
      f[200] = 0.332764;
      f[202] = 0.332764;
      f[203] = 0.332764;
      f[205] = 0.332764;
      f[206] = 0.332764;
      f[207] = 0.332764;
      f[208] = 1.0;
      f[225] = 1.0;
      f[227] = 0.369873;
      f[232] = 0.61084;
      f[233] = 0.777832;
      f[234] = 1.0;
      f[235] = 0.36499;
      f[241] = 0.888916;
      f[245] = 0.277832;
      f[248] = 0.277832;
      f[249] = 0.61084;
      f[250] = 0.943848;
      f[251] = 0.61084;
    }
    else if ( !strcmp(font, "Courier") ) {
      for ( i = 0 ; i < 256 ; i++ ) {
	f[i] = 0.599854;
      }
    }
    else if ( !strcmp(font, "Courier-Oblique") ) {
      for ( i = 0 ; i < 256 ; i++ ) {
	f[i] = 0.599854;
      }
    }
    else if ( !strcmp(font, "Courier-Bold") ) {
      for ( i = 0 ; i < 256 ; i++ ) {
	f[i] = 0.599854;
      }
    }
    else if ( !strcmp(font, "Courier-BoldOblique") ) {
      for ( i = 0 ; i < 256 ; i++ ) {
	f[i] = 0.599854;
      }
    }
    else if ( !strcmp(font, "Symbol") ) {
      f[32] = 0.25;
      f[33] = 0.332764;
      f[34] = 0.712891;
      f[35] = 0.5;
      f[36] = 0.548828;
      f[37] = 0.832764;
      f[38] = 0.777832;
      f[39] = 0.438965;
      f[40] = 0.332764;
      f[41] = 0.332764;
      f[42] = 0.5;
      f[43] = 0.548828;
      f[44] = 0.25;
      f[45] = 0.548828;
      f[46] = 0.25;
      f[47] = 0.277832;
      f[48] = 0.5;
      f[49] = 0.5;
      f[50] = 0.5;
      f[51] = 0.5;
      f[52] = 0.5;
      f[53] = 0.5;
      f[54] = 0.5;
      f[55] = 0.5;
      f[56] = 0.5;
      f[57] = 0.5;
      f[58] = 0.277832;
      f[59] = 0.277832;
      f[60] = 0.548828;
      f[61] = 0.548828;
      f[62] = 0.548828;
      f[63] = 0.443848;
      f[64] = 0.548828;
      f[65] = 0.721924;
      f[66] = 0.666992;
      f[67] = 0.721924;
      f[68] = 0.611816;
      f[69] = 0.61084;
      f[70] = 0.762939;
      f[71] = 0.602783;
      f[72] = 0.721924;
      f[73] = 0.332764;
      f[74] = 0.630859;
      f[75] = 0.721924;
      f[76] = 0.685791;
      f[77] = 0.888916;
      f[78] = 0.721924;
      f[79] = 0.721924;
      f[80] = 0.767822;
      f[81] = 0.740967;
      f[82] = 0.555908;
      f[83] = 0.591797;
      f[84] = 0.61084;
      f[85] = 0.689941;
      f[86] = 0.438965;
      f[87] = 0.767822;
      f[88] = 0.644775;
      f[89] = 0.794922;
      f[90] = 0.61084;
      f[91] = 0.332764;
      f[92] = 0.862793;
      f[93] = 0.332764;
      f[94] = 0.657959;
      f[95] = 0.5;
      f[96] = 0.5;
      f[97] = 0.630859;
      f[98] = 0.548828;
      f[99] = 0.548828;
      f[100] = 0.493896;
      f[101] = 0.438965;
      f[102] = 0.520996;
      f[103] = 0.410889;
      f[104] = 0.602783;
      f[105] = 0.328857;
      f[106] = 0.602783;
      f[107] = 0.548828;
      f[108] = 0.548828;
      f[109] = 0.575928;
      f[110] = 0.520996;
      f[111] = 0.548828;
      f[112] = 0.548828;
      f[113] = 0.520996;
      f[114] = 0.548828;
      f[115] = 0.602783;
      f[116] = 0.438965;
      f[117] = 0.575928;
      f[118] = 0.712891;
      f[119] = 0.685791;
      f[120] = 0.49292;
      f[121] = 0.685791;
      f[122] = 0.493896;
      f[123] = 0.47998;
      f[124] = 0.199951;
      f[125] = 0.47998;
      f[126] = 0.548828;
      f[161] = 0.619873;
      f[162] = 0.246826;
      f[163] = 0.548828;
      f[164] = 0.166992;
      f[165] = 0.712891;
      f[166] = 0.5;
      f[167] = 0.75293;
      f[168] = 0.75293;
      f[169] = 0.75293;
      f[170] = 0.75293;
      f[171] = 1.04199;
      f[172] = 0.986816;
      f[173] = 0.602783;
      f[174] = 0.986816;
      f[175] = 0.602783;
      f[176] = 0.399902;
      f[177] = 0.548828;
      f[178] = 0.410889;
      f[179] = 0.548828;
      f[180] = 0.548828;
      f[181] = 0.712891;
      f[182] = 0.493896;
      f[183] = 0.459961;
      f[184] = 0.548828;
      f[185] = 0.548828;
      f[186] = 0.548828;
      f[187] = 0.548828;
      f[188] = 1.0;
      f[189] = 0.602783;
      f[190] = 1.0;
      f[191] = 0.657959;
      f[192] = 0.822998;
      f[193] = 0.685791;
      f[194] = 0.794922;
      f[195] = 0.986816;
      f[196] = 0.767822;
      f[197] = 0.767822;
      f[198] = 0.822998;
      f[199] = 0.767822;
      f[200] = 0.767822;
      f[201] = 0.712891;
      f[202] = 0.712891;
      f[203] = 0.712891;
      f[204] = 0.712891;
      f[205] = 0.712891;
      f[206] = 0.712891;
      f[207] = 0.712891;
      f[208] = 0.767822;
      f[209] = 0.712891;
      f[210] = 0.789795;
      f[211] = 0.789795;
      f[212] = 0.889893;
      f[213] = 0.822998;
      f[214] = 0.548828;
      f[215] = 0.25;
      f[216] = 0.712891;
      f[217] = 0.602783;
      f[218] = 0.602783;
      f[219] = 1.04199;
      f[220] = 0.986816;
      f[221] = 0.602783;
      f[222] = 0.986816;
      f[223] = 0.602783;
      f[224] = 0.493896;
      f[225] = 0.328857;
      f[226] = 0.789795;
      f[227] = 0.789795;
      f[228] = 0.785889;
      f[229] = 0.712891;
      f[230] = 0.383789;
      f[231] = 0.383789;
      f[232] = 0.383789;
      f[233] = 0.383789;
      f[234] = 0.383789;
      f[235] = 0.383789;
      f[236] = 0.493896;
      f[237] = 0.493896;
      f[238] = 0.493896;
      f[239] = 0.493896;
      f[241] = 0.328857;
      f[242] = 0.273926;
      f[243] = 0.685791;
      f[244] = 0.685791;
      f[245] = 0.685791;
      f[246] = 0.383789;
      f[247] = 0.383789;
      f[248] = 0.383789;
      f[249] = 0.383789;
      f[250] = 0.383789;
      f[251] = 0.383789;
      f[252] = 0.493896;
      f[253] = 0.493896;
      f[254] = 0.493896;
    }
    else if (
	     !strcmp(font, "AvantGarde-Book") ||
	     !strcmp(font, "AvantGarde-BookOblique") ) {
      f[32] = 0.276855;
      f[33] = 0.294922;
      f[34] = 0.308838;
      f[35] = 0.719971;
      f[36] = 0.553955;
      f[37] = 0.774902;
      f[38] = 0.756836;
      f[39] = 0.35083;
      f[40] = 0.368896;
      f[41] = 0.368896;
      f[42] = 0.424805;
      f[43] = 0.605957;
      f[44] = 0.276855;
      f[45] = 0.331787;
      f[46] = 0.276855;
      f[47] = 0.436768;
      f[48] = 0.553955;
      f[49] = 0.553955;
      f[50] = 0.553955;
      f[51] = 0.553955;
      f[52] = 0.553955;
      f[53] = 0.553955;
      f[54] = 0.553955;
      f[55] = 0.553955;
      f[56] = 0.553955;
      f[57] = 0.553955;
      f[58] = 0.276855;
      f[59] = 0.276855;
      f[60] = 0.605957;
      f[61] = 0.605957;
      f[62] = 0.605957;
      f[63] = 0.59082;
      f[64] = 0.866943;
      f[65] = 0.73999;
      f[66] = 0.573975;
      f[67] = 0.812988;
      f[68] = 0.743896;
      f[69] = 0.535889;
      f[70] = 0.484863;
      f[71] = 0.871826;
      f[72] = 0.682861;
      f[73] = 0.22583;
      f[74] = 0.481934;
      f[75] = 0.59082;
      f[76] = 0.461914;
      f[77] = 0.918945;
      f[78] = 0.73999;
      f[79] = 0.868896;
      f[80] = 0.591797;
      f[81] = 0.87085;
      f[82] = 0.606934;
      f[83] = 0.497803;
      f[84] = 0.425781;
      f[85] = 0.654785;
      f[86] = 0.701904;
      f[87] = 0.959961;
      f[88] = 0.608887;
      f[89] = 0.591797;
      f[90] = 0.47998;
      f[91] = 0.35083;
      f[92] = 0.60498;
      f[93] = 0.35083;
      f[94] = 0.671875;
      f[95] = 0.5;
      f[96] = 0.35083;
      f[97] = 0.682861;
      f[98] = 0.681885;
      f[99] = 0.646973;
      f[100] = 0.684814;
      f[101] = 0.649902;
      f[102] = 0.313965;
      f[103] = 0.672852;
      f[104] = 0.609863;
      f[105] = 0.199951;
      f[106] = 0.202881;
      f[107] = 0.501953;
      f[108] = 0.199951;
      f[109] = 0.937988;
      f[110] = 0.609863;
      f[111] = 0.654785;
      f[112] = 0.681885;
      f[113] = 0.681885;
      f[114] = 0.300781;
      f[115] = 0.387939;
      f[116] = 0.338867;
      f[117] = 0.60791;
      f[118] = 0.553955;
      f[119] = 0.830811;
      f[120] = 0.47998;
      f[121] = 0.535889;
      f[122] = 0.424805;
      f[123] = 0.35083;
      f[124] = 0.671875;
      f[125] = 0.35083;
      f[126] = 0.605957;
      f[161] = 0.294922;
      f[162] = 0.553955;
      f[163] = 0.553955;
      f[164] = 0.165771;
      f[165] = 0.553955;
      f[166] = 0.553955;
      f[169] = 0.197998;
      f[170] = 0.501953;
      f[171] = 0.424805;
      f[172] = 0.250977;
      f[173] = 0.250977;
      f[174] = 0.486816;
      f[175] = 0.484863;
      f[177] = 0.5;
      f[179] = 0.552979;
      f[180] = 0.276855;
      f[183] = 0.605957;
      f[185] = 0.501953;
      f[186] = 0.483887;
      f[187] = 0.424805;
      f[188] = 1.0;
      f[191] = 0.59082;
      f[193] = 0.37793;
      f[194] = 0.375;
      f[195] = 0.501953;
      f[196] = 0.438965;
      f[200] = 0.368896;
      f[203] = 0.323975;
      f[205] = 0.551758;
      f[208] = 1.0;
      f[225] = 0.991943;
      f[234] = 1.19385;
      f[241] = 1.15698;
      f[245] = 0.199951;
      f[250] = 1.13696;
      f[251] = 0.553955;
    }
    else if (
	     !strcmp(font, "AvantGarde-Demi") ||
	     !strcmp(font, "AvantGarde-DemiOblique") ) {
      f[32] = 0.279785;
      f[33] = 0.279785;
      f[34] = 0.359863;
      f[35] = 0.599854;
      f[36] = 0.559814;
      f[37] = 0.859863;
      f[38] = 0.679932;
      f[39] = 0.279785;
      f[40] = 0.379883;
      f[41] = 0.379883;
      f[42] = 0.439941;
      f[43] = 0.599854;
      f[44] = 0.279785;
      f[45] = 0.419922;
      f[46] = 0.279785;
      f[47] = 0.459961;
      f[48] = 0.559814;
      f[49] = 0.559814;
      f[50] = 0.559814;
      f[51] = 0.559814;
      f[52] = 0.559814;
      f[53] = 0.559814;
      f[54] = 0.559814;
      f[55] = 0.559814;
      f[56] = 0.559814;
      f[57] = 0.559814;
      f[58] = 0.279785;
      f[59] = 0.279785;
      f[60] = 0.599854;
      f[61] = 0.599854;
      f[62] = 0.599854;
      f[63] = 0.559814;
      f[64] = 0.73999;
      f[65] = 0.73999;
      f[66] = 0.579834;
      f[67] = 0.779785;
      f[68] = 0.699951;
      f[69] = 0.519775;
      f[70] = 0.47998;
      f[71] = 0.839844;
      f[72] = 0.679932;
      f[73] = 0.279785;
      f[74] = 0.47998;
      f[75] = 0.619873;
      f[76] = 0.439941;
      f[77] = 0.899902;
      f[78] = 0.73999;
      f[79] = 0.839844;
      f[80] = 0.559814;
      f[81] = 0.839844;
      f[82] = 0.579834;
      f[83] = 0.519775;
      f[84] = 0.419922;
      f[85] = 0.639893;
      f[86] = 0.699951;
      f[87] = 0.899902;
      f[88] = 0.679932;
      f[89] = 0.619873;
      f[90] = 0.5;
      f[91] = 0.319824;
      f[92] = 0.639893;
      f[93] = 0.319824;
      f[94] = 0.599854;
      f[95] = 0.5;
      f[96] = 0.279785;
      f[97] = 0.659912;
      f[98] = 0.659912;
      f[99] = 0.639893;
      f[100] = 0.659912;
      f[101] = 0.639893;
      f[102] = 0.279785;
      f[103] = 0.659912;
      f[104] = 0.599854;
      f[105] = 0.23999;
      f[106] = 0.259766;
      f[107] = 0.579834;
      f[108] = 0.23999;
      f[109] = 0.939941;
      f[110] = 0.599854;
      f[111] = 0.639893;
      f[112] = 0.659912;
      f[113] = 0.659912;
      f[114] = 0.319824;
      f[115] = 0.439941;
      f[116] = 0.299805;
      f[117] = 0.599854;
      f[118] = 0.559814;
      f[119] = 0.799805;
      f[120] = 0.559814;
      f[121] = 0.579834;
      f[122] = 0.459961;
      f[123] = 0.339844;
      f[124] = 0.599854;
      f[125] = 0.339844;
      f[126] = 0.599854;
      f[161] = 0.279785;
      f[162] = 0.559814;
      f[163] = 0.559814;
      f[164] = 0.159912;
      f[165] = 0.559814;
      f[166] = 0.559814;
      f[169] = 0.219971;
      f[170] = 0.47998;
      f[171] = 0.459961;
      f[172] = 0.23999;
      f[173] = 0.23999;
      f[174] = 0.519775;
      f[175] = 0.519775;
      f[177] = 0.5;
      f[179] = 0.559814;
      f[180] = 0.279785;
      f[183] = 0.599854;
      f[185] = 0.47998;
      f[186] = 0.47998;
      f[187] = 0.459961;
      f[188] = 1.0;
      f[191] = 0.559814;
      f[193] = 0.419922;
      f[194] = 0.419922;
      f[195] = 0.539795;
      f[196] = 0.47998;
      f[200] = 0.5;
      f[203] = 0.339844;
      f[205] = 0.699951;
      f[208] = 1.0;
      f[225] = 0.899902;
      f[234] = 1.05981;
      f[241] = 1.07983;
      f[245] = 0.23999;
      f[250] = 1.07983;
      f[251] = 0.599854;
    }
    else if ( !strcmp(font, "Bookman-Light") ) {
      f[32] = 0.319824;
      f[33] = 0.299805;
      f[34] = 0.379883;
      f[35] = 0.619873;
      f[36] = 0.619873;
      f[37] = 0.899902;
      f[38] = 0.799805;
      f[39] = 0.219971;
      f[40] = 0.299805;
      f[41] = 0.299805;
      f[42] = 0.439941;
      f[43] = 0.599854;
      f[44] = 0.319824;
      f[45] = 0.399902;
      f[46] = 0.319824;
      f[47] = 0.599854;
      f[48] = 0.619873;
      f[49] = 0.619873;
      f[50] = 0.619873;
      f[51] = 0.619873;
      f[52] = 0.619873;
      f[53] = 0.619873;
      f[54] = 0.619873;
      f[55] = 0.619873;
      f[56] = 0.619873;
      f[57] = 0.619873;
      f[58] = 0.319824;
      f[59] = 0.319824;
      f[60] = 0.599854;
      f[61] = 0.599854;
      f[62] = 0.599854;
      f[63] = 0.539795;
      f[64] = 0.819824;
      f[65] = 0.679932;
      f[66] = 0.73999;
      f[67] = 0.73999;
      f[68] = 0.799805;
      f[69] = 0.719971;
      f[70] = 0.639893;
      f[71] = 0.799805;
      f[72] = 0.799805;
      f[73] = 0.339844;
      f[74] = 0.599854;
      f[75] = 0.719971;
      f[76] = 0.599854;
      f[77] = 0.919922;
      f[78] = 0.73999;
      f[79] = 0.799805;
      f[80] = 0.619873;
      f[81] = 0.819824;
      f[82] = 0.719971;
      f[83] = 0.659912;
      f[84] = 0.619873;
      f[85] = 0.779785;
      f[86] = 0.699951;
      f[87] = 0.959961;
      f[88] = 0.719971;
      f[89] = 0.639893;
      f[90] = 0.639893;
      f[91] = 0.299805;
      f[92] = 0.599854;
      f[93] = 0.299805;
      f[94] = 0.599854;
      f[95] = 0.5;
      f[96] = 0.219971;
      f[97] = 0.579834;
      f[98] = 0.619873;
      f[99] = 0.519775;
      f[100] = 0.619873;
      f[101] = 0.519775;
      f[102] = 0.319824;
      f[103] = 0.539795;
      f[104] = 0.659912;
      f[105] = 0.299805;
      f[106] = 0.299805;
      f[107] = 0.619873;
      f[108] = 0.299805;
      f[109] = 0.939941;
      f[110] = 0.659912;
      f[111] = 0.559814;
      f[112] = 0.619873;
      f[113] = 0.579834;
      f[114] = 0.439941;
      f[115] = 0.519775;
      f[116] = 0.379883;
      f[117] = 0.679932;
      f[118] = 0.519775;
      f[119] = 0.779785;
      f[120] = 0.559814;
      f[121] = 0.539795;
      f[122] = 0.47998;
      f[123] = 0.279785;
      f[124] = 0.599854;
      f[125] = 0.279785;
      f[126] = 0.599854;
      f[161] = 0.299805;
      f[162] = 0.619873;
      f[163] = 0.619873;
      f[164] = 0.139893;
      f[165] = 0.619873;
      f[166] = 0.619873;
      f[169] = 0.219971;
      f[170] = 0.399902;
      f[171] = 0.359863;
      f[172] = 0.23999;
      f[173] = 0.23999;
      f[174] = 0.619873;
      f[175] = 0.619873;
      f[177] = 0.5;
      f[179] = 0.539795;
      f[180] = 0.319824;
      f[183] = 0.459961;
      f[185] = 0.399902;
      f[186] = 0.399902;
      f[187] = 0.359863;
      f[188] = 1.0;
      f[191] = 0.539795;
      f[193] = 0.339844;
      f[194] = 0.339844;
      f[195] = 0.419922;
      f[196] = 0.439941;
      f[200] = 0.419922;
      f[203] = 0.319824;
      f[205] = 0.379883;
      f[208] = 1.0;
      f[225] = 1.25977;
      f[234] = 1.23999;
      f[241] = 0.859863;
      f[245] = 0.299805;
      f[250] = 0.899902;
      f[251] = 0.659912;
    }
    else if ( !strcmp(font, "Bookman-LightItalic") ) {
      f[32] = 0.299805;
      f[33] = 0.319824;
      f[34] = 0.359863;
      f[35] = 0.619873;
      f[36] = 0.619873;
      f[37] = 0.799805;
      f[38] = 0.819824;
      f[39] = 0.279785;
      f[40] = 0.279785;
      f[41] = 0.279785;
      f[42] = 0.439941;
      f[43] = 0.599854;
      f[44] = 0.299805;
      f[45] = 0.319824;
      f[46] = 0.299805;
      f[47] = 0.599854;
      f[48] = 0.619873;
      f[49] = 0.619873;
      f[50] = 0.619873;
      f[51] = 0.619873;
      f[52] = 0.619873;
      f[53] = 0.619873;
      f[54] = 0.619873;
      f[55] = 0.619873;
      f[56] = 0.619873;
      f[57] = 0.619873;
      f[58] = 0.299805;
      f[59] = 0.299805;
      f[60] = 0.599854;
      f[61] = 0.599854;
      f[62] = 0.599854;
      f[63] = 0.539795;
      f[64] = 0.779785;
      f[65] = 0.699951;
      f[66] = 0.719971;
      f[67] = 0.719971;
      f[68] = 0.73999;
      f[69] = 0.679932;
      f[70] = 0.619873;
      f[71] = 0.759766;
      f[72] = 0.799805;
      f[73] = 0.319824;
      f[74] = 0.559814;
      f[75] = 0.719971;
      f[76] = 0.579834;
      f[77] = 0.859863;
      f[78] = 0.719971;
      f[79] = 0.759766;
      f[80] = 0.599854;
      f[81] = 0.779785;
      f[82] = 0.699951;
      f[83] = 0.639893;
      f[84] = 0.599854;
      f[85] = 0.719971;
      f[86] = 0.679932;
      f[87] = 0.959961;
      f[88] = 0.699951;
      f[89] = 0.659912;
      f[90] = 0.579834;
      f[91] = 0.259766;
      f[92] = 0.599854;
      f[93] = 0.259766;
      f[94] = 0.599854;
      f[95] = 0.5;
      f[96] = 0.279785;
      f[97] = 0.619873;
      f[98] = 0.599854;
      f[99] = 0.47998;
      f[100] = 0.639893;
      f[101] = 0.539795;
      f[102] = 0.339844;
      f[103] = 0.559814;
      f[104] = 0.619873;
      f[105] = 0.279785;
      f[106] = 0.279785;
      f[107] = 0.599854;
      f[108] = 0.279785;
      f[109] = 0.879883;
      f[110] = 0.619873;
      f[111] = 0.539795;
      f[112] = 0.599854;
      f[113] = 0.559814;
      f[114] = 0.399902;
      f[115] = 0.539795;
      f[116] = 0.339844;
      f[117] = 0.619873;
      f[118] = 0.539795;
      f[119] = 0.879883;
      f[120] = 0.539795;
      f[121] = 0.599854;
      f[122] = 0.519775;
      f[123] = 0.359863;
      f[124] = 0.599854;
      f[125] = 0.379883;
      f[126] = 0.599854;
      f[161] = 0.319824;
      f[162] = 0.619873;
      f[163] = 0.619873;
      f[164] = 0.0197754;
      f[165] = 0.619873;
      f[166] = 0.619873;
      f[169] = 0.199951;
      f[170] = 0.439941;
      f[171] = 0.299805;
      f[172] = 0.179932;
      f[173] = 0.179932;
      f[174] = 0.639893;
      f[175] = 0.659912;
      f[177] = 0.5;
      f[179] = 0.619873;
      f[180] = 0.299805;
      f[183] = 0.459961;
      f[185] = 0.47998;
      f[186] = 0.439941;
      f[187] = 0.299805;
      f[188] = 1.0;
      f[191] = 0.539795;
      f[193] = 0.339844;
      f[194] = 0.319824;
      f[195] = 0.439941;
      f[196] = 0.439941;
      f[200] = 0.419922;
      f[203] = 0.319824;
      f[205] = 0.339844;
      f[208] = 1.0;
      f[225] = 1.21997;
      f[234] = 1.17993;
      f[241] = 0.879883;
      f[245] = 0.279785;
      f[250] = 0.899902;
      f[251] = 0.619873;
    }
    else if ( !strcmp(font, "Bookman-Demi") ) {
      f[32] = 0.339844;
      f[33] = 0.359863;
      f[34] = 0.419922;
      f[35] = 0.659912;
      f[36] = 0.659912;
      f[37] = 0.939941;
      f[38] = 0.799805;
      f[39] = 0.319824;
      f[40] = 0.319824;
      f[41] = 0.319824;
      f[42] = 0.459961;
      f[43] = 0.599854;
      f[44] = 0.339844;
      f[45] = 0.359863;
      f[46] = 0.339844;
      f[47] = 0.599854;
      f[48] = 0.659912;
      f[49] = 0.659912;
      f[50] = 0.659912;
      f[51] = 0.659912;
      f[52] = 0.659912;
      f[53] = 0.659912;
      f[54] = 0.659912;
      f[55] = 0.659912;
      f[56] = 0.659912;
      f[57] = 0.659912;
      f[58] = 0.339844;
      f[59] = 0.339844;
      f[60] = 0.599854;
      f[61] = 0.599854;
      f[62] = 0.599854;
      f[63] = 0.659912;
      f[64] = 0.819824;
      f[65] = 0.719971;
      f[66] = 0.719971;
      f[67] = 0.73999;
      f[68] = 0.779785;
      f[69] = 0.719971;
      f[70] = 0.679932;
      f[71] = 0.779785;
      f[72] = 0.819824;
      f[73] = 0.399902;
      f[74] = 0.639893;
      f[75] = 0.799805;
      f[76] = 0.639893;
      f[77] = 0.939941;
      f[78] = 0.73999;
      f[79] = 0.799805;
      f[80] = 0.659912;
      f[81] = 0.799805;
      f[82] = 0.779785;
      f[83] = 0.659912;
      f[84] = 0.699951;
      f[85] = 0.73999;
      f[86] = 0.719971;
      f[87] = 0.939941;
      f[88] = 0.779785;
      f[89] = 0.699951;
      f[90] = 0.639893;
      f[91] = 0.299805;
      f[92] = 0.599854;
      f[93] = 0.299805;
      f[94] = 0.599854;
      f[95] = 0.5;
      f[96] = 0.319824;
      f[97] = 0.579834;
      f[98] = 0.599854;
      f[99] = 0.579834;
      f[100] = 0.639893;
      f[101] = 0.579834;
      f[102] = 0.379883;
      f[103] = 0.579834;
      f[104] = 0.679932;
      f[105] = 0.359863;
      f[106] = 0.339844;
      f[107] = 0.659912;
      f[108] = 0.339844;
      f[109] = 1.0;
      f[110] = 0.679932;
      f[111] = 0.619873;
      f[112] = 0.639893;
      f[113] = 0.619873;
      f[114] = 0.459961;
      f[115] = 0.519775;
      f[116] = 0.459961;
      f[117] = 0.659912;
      f[118] = 0.599854;
      f[119] = 0.799805;
      f[120] = 0.599854;
      f[121] = 0.619873;
      f[122] = 0.559814;
      f[123] = 0.319824;
      f[124] = 0.599854;
      f[125] = 0.319824;
      f[126] = 0.599854;
      f[161] = 0.359863;
      f[162] = 0.659912;
      f[163] = 0.659912;
      f[164] = 0.119873;
      f[165] = 0.659912;
      f[166] = 0.659912;
      f[169] = 0.23999;
      f[170] = 0.539795;
      f[171] = 0.399902;
      f[172] = 0.219971;
      f[173] = 0.219971;
      f[174] = 0.73999;
      f[175] = 0.73999;
      f[177] = 0.5;
      f[179] = 0.379883;
      f[180] = 0.339844;
      f[183] = 0.459961;
      f[185] = 0.539795;
      f[186] = 0.539795;
      f[187] = 0.399902;
      f[188] = 1.0;
      f[191] = 0.659912;
      f[193] = 0.399902;
      f[194] = 0.399902;
      f[195] = 0.5;
      f[196] = 0.47998;
      f[200] = 0.5;
      f[203] = 0.359863;
      f[205] = 0.439941;
      f[208] = 1.0;
      f[225] = 1.13989;
      f[234] = 1.21997;
      f[241] = 0.879883;
      f[245] = 0.359863;
      f[250] = 0.939941;
      f[251] = 0.659912;
    }
    else if ( !strcmp(font, "Bookman-DemiItalic") ) {
      f[32] = 0.339844;
      f[33] = 0.319824;
      f[34] = 0.379883;
      f[35] = 0.679932;
      f[36] = 0.679932;
      f[37] = 0.879883;
      f[38] = 0.97998;
      f[39] = 0.319824;
      f[40] = 0.259766;
      f[41] = 0.259766;
      f[42] = 0.459961;
      f[43] = 0.599854;
      f[44] = 0.339844;
      f[45] = 0.279785;
      f[46] = 0.339844;
      f[47] = 0.359863;
      f[48] = 0.679932;
      f[49] = 0.679932;
      f[50] = 0.679932;
      f[51] = 0.679932;
      f[52] = 0.679932;
      f[53] = 0.679932;
      f[54] = 0.679932;
      f[55] = 0.679932;
      f[56] = 0.679932;
      f[57] = 0.679932;
      f[58] = 0.339844;
      f[59] = 0.339844;
      f[60] = 0.619873;
      f[61] = 0.599854;
      f[62] = 0.619873;
      f[63] = 0.619873;
      f[64] = 0.779785;
      f[65] = 0.719971;
      f[66] = 0.719971;
      f[67] = 0.699951;
      f[68] = 0.759766;
      f[69] = 0.719971;
      f[70] = 0.659912;
      f[71] = 0.759766;
      f[72] = 0.799805;
      f[73] = 0.379883;
      f[74] = 0.619873;
      f[75] = 0.779785;
      f[76] = 0.639893;
      f[77] = 0.859863;
      f[78] = 0.73999;
      f[79] = 0.759766;
      f[80] = 0.639893;
      f[81] = 0.759766;
      f[82] = 0.73999;
      f[83] = 0.699951;
      f[84] = 0.699951;
      f[85] = 0.73999;
      f[86] = 0.659912;
      f[87] = 1.0;
      f[88] = 0.73999;
      f[89] = 0.659912;
      f[90] = 0.679932;
      f[91] = 0.259766;
      f[92] = 0.579834;
      f[93] = 0.259766;
      f[94] = 0.619873;
      f[95] = 0.5;
      f[96] = 0.319824;
      f[97] = 0.679932;
      f[98] = 0.599854;
      f[99] = 0.559814;
      f[100] = 0.679932;
      f[101] = 0.559814;
      f[102] = 0.419922;
      f[103] = 0.619873;
      f[104] = 0.699951;
      f[105] = 0.379883;
      f[106] = 0.319824;
      f[107] = 0.699951;
      f[108] = 0.379883;
      f[109] = 0.959961;
      f[110] = 0.679932;
      f[111] = 0.599854;
      f[112] = 0.659912;
      f[113] = 0.619873;
      f[114] = 0.5;
      f[115] = 0.539795;
      f[116] = 0.439941;
      f[117] = 0.679932;
      f[118] = 0.539795;
      f[119] = 0.859863;
      f[120] = 0.619873;
      f[121] = 0.599854;
      f[122] = 0.559814;
      f[123] = 0.299805;
      f[124] = 0.619873;
      f[125] = 0.299805;
      f[126] = 0.619873;
      f[161] = 0.319824;
      f[162] = 0.679932;
      f[163] = 0.679932;
      f[164] = 0.119873;
      f[165] = 0.679932;
      f[166] = 0.679932;
      f[169] = 0.179932;
      f[170] = 0.519775;
      f[171] = 0.379883;
      f[172] = 0.219971;
      f[173] = 0.219971;
      f[174] = 0.819824;
      f[175] = 0.819824;
      f[177] = 0.5;
      f[179] = 0.419922;
      f[180] = 0.339844;
      f[183] = 0.359863;
      f[185] = 0.519775;
      f[186] = 0.519775;
      f[187] = 0.379883;
      f[188] = 1.0;
      f[191] = 0.619873;
      f[193] = 0.379883;
      f[194] = 0.339844;
      f[195] = 0.47998;
      f[196] = 0.47998;
      f[200] = 0.519775;
      f[203] = 0.359863;
      f[205] = 0.559814;
      f[208] = 1.0;
      f[225] = 1.13989;
      f[234] = 1.17993;
      f[241] = 0.879883;
      f[245] = 0.379883;
      f[250] = 0.919922;
      f[251] = 0.659912;
    }
    else if ( !strcmp(font, "Helvetica-Narrow") ) {
      f[32] = 0.227783;
      f[33] = 0.227783;
      f[34] = 0.290771;
      f[35] = 0.455811;
      f[36] = 0.455811;
      f[37] = 0.72876;
      f[38] = 0.546875;
      f[39] = 0.181885;
      f[40] = 0.272949;
      f[41] = 0.272949;
      f[42] = 0.318848;
      f[43] = 0.47876;
      f[44] = 0.227783;
      f[45] = 0.272949;
      f[46] = 0.227783;
      f[47] = 0.227783;
      f[48] = 0.455811;
      f[49] = 0.455811;
      f[50] = 0.455811;
      f[51] = 0.455811;
      f[52] = 0.455811;
      f[53] = 0.455811;
      f[54] = 0.455811;
      f[55] = 0.455811;
      f[56] = 0.455811;
      f[57] = 0.455811;
      f[58] = 0.227783;
      f[59] = 0.227783;
      f[60] = 0.47876;
      f[61] = 0.47876;
      f[62] = 0.47876;
      f[63] = 0.455811;
      f[64] = 0.831787;
      f[65] = 0.546875;
      f[66] = 0.546875;
      f[67] = 0.591797;
      f[68] = 0.591797;
      f[69] = 0.546875;
      f[70] = 0.500977;
      f[71] = 0.637939;
      f[72] = 0.591797;
      f[73] = 0.227783;
      f[74] = 0.409912;
      f[75] = 0.546875;
      f[76] = 0.455811;
      f[77] = 0.682861;
      f[78] = 0.591797;
      f[79] = 0.637939;
      f[80] = 0.546875;
      f[81] = 0.637939;
      f[82] = 0.591797;
      f[83] = 0.546875;
      f[84] = 0.500977;
      f[85] = 0.591797;
      f[86] = 0.546875;
      f[87] = 0.773926;
      f[88] = 0.546875;
      f[89] = 0.546875;
      f[90] = 0.500977;
      f[91] = 0.227783;
      f[92] = 0.227783;
      f[93] = 0.227783;
      f[94] = 0.384766;
      f[95] = 0.455811;
      f[96] = 0.181885;
      f[97] = 0.455811;
      f[98] = 0.455811;
      f[99] = 0.409912;
      f[100] = 0.455811;
      f[101] = 0.455811;
      f[102] = 0.227783;
      f[103] = 0.455811;
      f[104] = 0.455811;
      f[105] = 0.181885;
      f[106] = 0.181885;
      f[107] = 0.409912;
      f[108] = 0.181885;
      f[109] = 0.682861;
      f[110] = 0.455811;
      f[111] = 0.455811;
      f[112] = 0.455811;
      f[113] = 0.455811;
      f[114] = 0.272949;
      f[115] = 0.409912;
      f[116] = 0.227783;
      f[117] = 0.455811;
      f[118] = 0.409912;
      f[119] = 0.591797;
      f[120] = 0.409912;
      f[121] = 0.409912;
      f[122] = 0.409912;
      f[123] = 0.273926;
      f[124] = 0.212891;
      f[125] = 0.273926;
      f[126] = 0.47876;
      f[161] = 0.272949;
      f[162] = 0.455811;
      f[163] = 0.455811;
      f[164] = 0.136963;
      f[165] = 0.455811;
      f[166] = 0.455811;
      f[169] = 0.156982;
      f[170] = 0.272949;
      f[171] = 0.455811;
      f[172] = 0.272949;
      f[173] = 0.272949;
      f[174] = 0.409912;
      f[175] = 0.409912;
      f[177] = 0.455811;
      f[179] = 0.455811;
      f[180] = 0.227783;
      f[183] = 0.286865;
      f[185] = 0.272949;
      f[186] = 0.272949;
      f[187] = 0.455811;
      f[188] = 0.819824;
      f[191] = 0.500977;
      f[193] = 0.272949;
      f[194] = 0.272949;
      f[195] = 0.272949;
      f[196] = 0.272949;
      f[200] = 0.272949;
      f[203] = 0.272949;
      f[205] = 0.272949;
      f[208] = 0.819824;
      f[225] = 0.819824;
      f[234] = 0.819824;
      f[241] = 0.72876;
      f[245] = 0.227783;
      f[250] = 0.773926;
      f[251] = 0.500977;
    }
    else if ( !strcmp(font, "Helvetica-Narrow-Oblique") ) {
      f[32] = 0.570801;
      f[33] = 0.570801;
      f[34] = 0.570801;
      f[35] = 0.570801;
      f[36] = 0.570801;
      f[37] = 0.570801;
      f[38] = 0.570801;
      f[39] = 0.570801;
      f[40] = 0.570801;
      f[41] = 0.570801;
      f[42] = 0.570801;
      f[43] = 0.570801;
      f[44] = 0.570801;
      f[45] = 0.570801;
      f[46] = 0.570801;
      f[47] = 0.570801;
      f[48] = 0.570801;
      f[49] = 0.570801;
      f[50] = 0.570801;
      f[51] = 0.570801;
      f[52] = 0.570801;
      f[53] = 0.570801;
      f[54] = 0.570801;
      f[55] = 0.570801;
      f[56] = 0.570801;
      f[57] = 0.570801;
      f[58] = 0.570801;
      f[59] = 0.570801;
      f[60] = 0.570801;
      f[61] = 0.570801;
      f[62] = 0.570801;
      f[63] = 0.570801;
      f[64] = 0.570801;
      f[65] = 0.570801;
      f[66] = 0.570801;
      f[67] = 0.570801;
      f[68] = 0.570801;
      f[69] = 0.570801;
      f[70] = 0.570801;
      f[71] = 0.570801;
      f[72] = 0.570801;
      f[73] = 0.570801;
      f[74] = 0.570801;
      f[75] = 0.570801;
      f[76] = 0.570801;
      f[77] = 0.570801;
      f[78] = 0.570801;
      f[79] = 0.570801;
      f[80] = 0.570801;
      f[81] = 0.570801;
      f[82] = 0.570801;
      f[83] = 0.570801;
      f[84] = 0.570801;
      f[85] = 0.570801;
      f[86] = 0.570801;
      f[87] = 0.570801;
      f[88] = 0.570801;
      f[89] = 0.570801;
      f[90] = 0.570801;
      f[91] = 0.570801;
      f[92] = 0.570801;
      f[93] = 0.570801;
      f[94] = 0.570801;
      f[95] = 0.570801;
      f[96] = 0.570801;
      f[97] = 0.570801;
      f[98] = 0.570801;
      f[99] = 0.570801;
      f[100] = 0.570801;
      f[101] = 0.570801;
      f[102] = 0.570801;
      f[103] = 0.570801;
      f[104] = 0.570801;
      f[105] = 0.570801;
      f[106] = 0.570801;
      f[107] = 0.570801;
      f[108] = 0.570801;
      f[109] = 0.570801;
      f[110] = 0.570801;
      f[111] = 0.570801;
      f[112] = 0.570801;
      f[113] = 0.570801;
      f[114] = 0.570801;
      f[115] = 0.570801;
      f[116] = 0.570801;
      f[117] = 0.570801;
      f[118] = 0.570801;
      f[119] = 0.570801;
      f[120] = 0.570801;
      f[121] = 0.570801;
      f[122] = 0.570801;
      f[123] = 0.570801;
      f[124] = 0.570801;
      f[125] = 0.570801;
      f[126] = 0.570801;
      f[161] = 0.570801;
      f[162] = 0.570801;
      f[163] = 0.570801;
      f[164] = 0.570801;
      f[165] = 0.570801;
      f[166] = 0.570801;
      f[169] = 0.570801;
      f[170] = 0.570801;
      f[172] = 0.570801;
      f[173] = 0.570801;
      f[179] = 0.570801;
      f[180] = 0.570801;
      f[183] = 0.570801;
      f[185] = 0.570801;
      f[186] = 0.570801;
      f[191] = 0.570801;
      f[193] = 0.570801;
      f[194] = 0.570801;
      f[195] = 0.570801;
      f[196] = 0.570801;
      f[200] = 0.570801;
      f[203] = 0.570801;
      f[205] = 0.570801;
      f[245] = 0.570801;
    }
    else if ( !strcmp(font, "Helvetica-Narrow-Bold") ) {
      f[32] = 0.227783;
      f[33] = 0.227783;
      f[34] = 0.290771;
      f[35] = 0.455811;
      f[36] = 0.455811;
      f[37] = 0.72876;
      f[38] = 0.546875;
      f[39] = 0.181885;
      f[40] = 0.272949;
      f[41] = 0.272949;
      f[42] = 0.318848;
      f[43] = 0.47876;
      f[44] = 0.227783;
      f[45] = 0.272949;
      f[46] = 0.227783;
      f[47] = 0.227783;
      f[48] = 0.455811;
      f[49] = 0.455811;
      f[50] = 0.455811;
      f[51] = 0.455811;
      f[52] = 0.455811;
      f[53] = 0.455811;
      f[54] = 0.455811;
      f[55] = 0.455811;
      f[56] = 0.455811;
      f[57] = 0.455811;
      f[58] = 0.227783;
      f[59] = 0.227783;
      f[60] = 0.47876;
      f[61] = 0.47876;
      f[62] = 0.47876;
      f[63] = 0.455811;
      f[64] = 0.831787;
      f[65] = 0.546875;
      f[66] = 0.546875;
      f[67] = 0.591797;
      f[68] = 0.591797;
      f[69] = 0.546875;
      f[70] = 0.500977;
      f[71] = 0.637939;
      f[72] = 0.591797;
      f[73] = 0.227783;
      f[74] = 0.409912;
      f[75] = 0.546875;
      f[76] = 0.455811;
      f[77] = 0.682861;
      f[78] = 0.591797;
      f[79] = 0.637939;
      f[80] = 0.546875;
      f[81] = 0.637939;
      f[82] = 0.591797;
      f[83] = 0.546875;
      f[84] = 0.500977;
      f[85] = 0.591797;
      f[86] = 0.546875;
      f[87] = 0.773926;
      f[88] = 0.546875;
      f[89] = 0.546875;
      f[90] = 0.500977;
      f[91] = 0.227783;
      f[92] = 0.227783;
      f[93] = 0.227783;
      f[94] = 0.384766;
      f[95] = 0.455811;
      f[96] = 0.181885;
      f[97] = 0.455811;
      f[98] = 0.455811;
      f[99] = 0.409912;
      f[100] = 0.455811;
      f[101] = 0.455811;
      f[102] = 0.227783;
      f[103] = 0.455811;
      f[104] = 0.455811;
      f[105] = 0.181885;
      f[106] = 0.181885;
      f[107] = 0.409912;
      f[108] = 0.181885;
      f[109] = 0.682861;
      f[110] = 0.455811;
      f[111] = 0.455811;
      f[112] = 0.455811;
      f[113] = 0.455811;
      f[114] = 0.272949;
      f[115] = 0.409912;
      f[116] = 0.227783;
      f[117] = 0.455811;
      f[118] = 0.409912;
      f[119] = 0.591797;
      f[120] = 0.409912;
      f[121] = 0.409912;
      f[122] = 0.409912;
      f[123] = 0.273926;
      f[124] = 0.212891;
      f[125] = 0.273926;
      f[126] = 0.47876;
      f[161] = 0.272949;
      f[162] = 0.455811;
      f[163] = 0.455811;
      f[164] = 0.136963;
      f[165] = 0.455811;
      f[166] = 0.455811;
      f[169] = 0.156982;
      f[170] = 0.272949;
      f[171] = 0.455811;
      f[172] = 0.272949;
      f[173] = 0.272949;
      f[174] = 0.409912;
      f[175] = 0.409912;
      f[177] = 0.455811;
      f[179] = 0.455811;
      f[180] = 0.227783;
      f[183] = 0.286865;
      f[185] = 0.272949;
      f[186] = 0.272949;
      f[187] = 0.455811;
      f[188] = 0.819824;
      f[191] = 0.500977;
      f[193] = 0.272949;
      f[194] = 0.272949;
      f[195] = 0.272949;
      f[196] = 0.272949;
      f[200] = 0.272949;
      f[203] = 0.272949;
      f[205] = 0.272949;
      f[208] = 0.819824;
      f[225] = 0.819824;
      f[234] = 0.819824;
      f[241] = 0.72876;
      f[245] = 0.227783;
      f[250] = 0.773926;
      f[251] = 0.500977;
    }
    else if ( !strcmp(font, "Helvetica-Narrow-BoldOblique") ) {
      f[32] = 0.570801;
      f[33] = 0.570801;
      f[34] = 0.570801;
      f[35] = 0.570801;
      f[36] = 0.570801;
      f[37] = 0.570801;
      f[38] = 0.570801;
      f[39] = 0.570801;
      f[40] = 0.570801;
      f[41] = 0.570801;
      f[42] = 0.570801;
      f[43] = 0.570801;
      f[44] = 0.570801;
      f[45] = 0.570801;
      f[46] = 0.570801;
      f[47] = 0.570801;
      f[48] = 0.570801;
      f[49] = 0.570801;
      f[50] = 0.570801;
      f[51] = 0.570801;
      f[52] = 0.570801;
      f[53] = 0.570801;
      f[54] = 0.570801;
      f[55] = 0.570801;
      f[56] = 0.570801;
      f[57] = 0.570801;
      f[58] = 0.570801;
      f[59] = 0.570801;
      f[60] = 0.570801;
      f[61] = 0.570801;
      f[62] = 0.570801;
      f[63] = 0.570801;
      f[64] = 0.570801;
      f[65] = 0.570801;
      f[66] = 0.570801;
      f[67] = 0.570801;
      f[68] = 0.570801;
      f[69] = 0.570801;
      f[70] = 0.570801;
      f[71] = 0.570801;
      f[72] = 0.570801;
      f[73] = 0.570801;
      f[74] = 0.570801;
      f[75] = 0.570801;
      f[76] = 0.570801;
      f[77] = 0.570801;
      f[78] = 0.570801;
      f[79] = 0.570801;
      f[80] = 0.570801;
      f[81] = 0.570801;
      f[82] = 0.570801;
      f[83] = 0.570801;
      f[84] = 0.570801;
      f[85] = 0.570801;
      f[86] = 0.570801;
      f[87] = 0.570801;
      f[88] = 0.570801;
      f[89] = 0.570801;
      f[90] = 0.570801;
      f[91] = 0.570801;
      f[92] = 0.570801;
      f[93] = 0.570801;
      f[94] = 0.570801;
      f[95] = 0.570801;
      f[96] = 0.570801;
      f[97] = 0.570801;
      f[98] = 0.570801;
      f[99] = 0.570801;
      f[100] = 0.570801;
      f[101] = 0.570801;
      f[102] = 0.570801;
      f[103] = 0.570801;
      f[104] = 0.570801;
      f[105] = 0.570801;
      f[106] = 0.570801;
      f[107] = 0.570801;
      f[108] = 0.570801;
      f[109] = 0.570801;
      f[110] = 0.570801;
      f[111] = 0.570801;
      f[112] = 0.570801;
      f[113] = 0.570801;
      f[114] = 0.570801;
      f[115] = 0.570801;
      f[116] = 0.570801;
      f[117] = 0.570801;
      f[118] = 0.570801;
      f[119] = 0.570801;
      f[120] = 0.570801;
      f[121] = 0.570801;
      f[122] = 0.570801;
      f[123] = 0.570801;
      f[124] = 0.570801;
      f[125] = 0.570801;
      f[126] = 0.570801;
      f[161] = 0.570801;
      f[162] = 0.570801;
      f[163] = 0.570801;
      f[164] = 0.570801;
      f[165] = 0.570801;
      f[166] = 0.570801;
      f[169] = 0.570801;
      f[170] = 0.570801;
      f[172] = 0.570801;
      f[173] = 0.570801;
      f[179] = 0.570801;
      f[180] = 0.570801;
      f[183] = 0.570801;
      f[185] = 0.570801;
      f[186] = 0.570801;
      f[191] = 0.570801;
      f[193] = 0.570801;
      f[194] = 0.570801;
      f[195] = 0.570801;
      f[196] = 0.570801;
      f[200] = 0.570801;
      f[203] = 0.570801;
      f[205] = 0.570801;
      f[245] = 0.570801;
    }
    else if ( !strcmp(font, "NewCenturySchlbk-Roman") ) {
      f[32] = 0.277832;
      f[33] = 0.295898;
      f[34] = 0.388916;
      f[35] = 0.555908;
      f[36] = 0.555908;
      f[37] = 0.832764;
      f[38] = 0.814941;
      f[39] = 0.203857;
      f[40] = 0.332764;
      f[41] = 0.332764;
      f[42] = 0.5;
      f[43] = 0.605957;
      f[44] = 0.277832;
      f[45] = 0.332764;
      f[46] = 0.277832;
      f[47] = 0.277832;
      f[48] = 0.555908;
      f[49] = 0.555908;
      f[50] = 0.555908;
      f[51] = 0.555908;
      f[52] = 0.555908;
      f[53] = 0.555908;
      f[54] = 0.555908;
      f[55] = 0.555908;
      f[56] = 0.555908;
      f[57] = 0.555908;
      f[58] = 0.277832;
      f[59] = 0.277832;
      f[60] = 0.605957;
      f[61] = 0.605957;
      f[62] = 0.605957;
      f[63] = 0.443848;
      f[64] = 0.736816;
      f[65] = 0.721924;
      f[66] = 0.721924;
      f[67] = 0.721924;
      f[68] = 0.777832;
      f[69] = 0.721924;
      f[70] = 0.666992;
      f[71] = 0.777832;
      f[72] = 0.832764;
      f[73] = 0.406982;
      f[74] = 0.555908;
      f[75] = 0.777832;
      f[76] = 0.666992;
      f[77] = 0.943848;
      f[78] = 0.814941;
      f[79] = 0.777832;
      f[80] = 0.666992;
      f[81] = 0.777832;
      f[82] = 0.721924;
      f[83] = 0.629883;
      f[84] = 0.666992;
      f[85] = 0.814941;
      f[86] = 0.721924;
      f[87] = 0.980957;
      f[88] = 0.703857;
      f[89] = 0.703857;
      f[90] = 0.61084;
      f[91] = 0.332764;
      f[92] = 0.605957;
      f[93] = 0.332764;
      f[94] = 0.605957;
      f[95] = 0.5;
      f[96] = 0.203857;
      f[97] = 0.555908;
      f[98] = 0.555908;
      f[99] = 0.443848;
      f[100] = 0.573975;
      f[101] = 0.5;
      f[102] = 0.332764;
      f[103] = 0.536865;
      f[104] = 0.61084;
      f[105] = 0.314941;
      f[106] = 0.295898;
      f[107] = 0.592773;
      f[108] = 0.314941;
      f[109] = 0.888916;
      f[110] = 0.61084;
      f[111] = 0.5;
      f[112] = 0.573975;
      f[113] = 0.555908;
      f[114] = 0.443848;
      f[115] = 0.462891;
      f[116] = 0.388916;
      f[117] = 0.61084;
      f[118] = 0.536865;
      f[119] = 0.777832;
      f[120] = 0.536865;
      f[121] = 0.536865;
      f[122] = 0.480957;
      f[123] = 0.332764;
      f[124] = 0.605957;
      f[125] = 0.332764;
      f[126] = 0.605957;
      f[161] = 0.295898;
      f[162] = 0.555908;
      f[163] = 0.555908;
      f[164] = 0.166992;
      f[165] = 0.703857;
      f[166] = 0.555908;
      f[167] = 0.5;
      f[168] = 0.605957;
      f[169] = 0.203857;
      f[170] = 0.388916;
      f[171] = 0.425781;
      f[172] = 0.258789;
      f[173] = 0.258789;
      f[174] = 0.61084;
      f[175] = 0.61084;
      f[177] = 0.555908;
      f[178] = 0.5;
      f[179] = 0.5;
      f[180] = 0.277832;
      f[182] = 0.605957;
      f[183] = 0.605957;
      f[184] = 0.203857;
      f[185] = 0.388916;
      f[186] = 0.388916;
      f[187] = 0.425781;
      f[188] = 1.0;
      f[189] = 1.0;
      f[191] = 0.443848;
      f[193] = 0.332764;
      f[194] = 0.332764;
      f[195] = 0.332764;
      f[196] = 0.332764;
      f[197] = 0.332764;
      f[198] = 0.332764;
      f[199] = 0.332764;
      f[200] = 0.332764;
      f[202] = 0.332764;
      f[203] = 0.332764;
      f[205] = 0.332764;
      f[206] = 0.332764;
      f[207] = 0.332764;
      f[208] = 1.0;
      f[225] = 1.0;
      f[227] = 0.333984;
      f[232] = 0.666992;
      f[233] = 0.777832;
      f[234] = 1.0;
      f[235] = 0.299805;
      f[241] = 0.795898;
      f[245] = 0.314941;
      f[248] = 0.314941;
      f[249] = 0.5;
      f[250] = 0.832764;
      f[251] = 0.573975;
    }
    else if ( !strcmp(font, "NewCenturySchlbk-Italic") ) {
      f[32] = 0.277832;
      f[33] = 0.332764;
      f[34] = 0.399902;
      f[35] = 0.605957;
      f[36] = 0.555908;
      f[37] = 0.832764;
      f[38] = 0.851807;
      f[39] = 0.203857;
      f[40] = 0.332764;
      f[41] = 0.332764;
      f[42] = 0.5;
      f[43] = 0.605957;
      f[44] = 0.277832;
      f[45] = 0.332764;
      f[46] = 0.277832;
      f[47] = 0.605957;
      f[48] = 0.555908;
      f[49] = 0.555908;
      f[50] = 0.555908;
      f[51] = 0.555908;
      f[52] = 0.555908;
      f[53] = 0.555908;
      f[54] = 0.555908;
      f[55] = 0.555908;
      f[56] = 0.555908;
      f[57] = 0.555908;
      f[58] = 0.277832;
      f[59] = 0.277832;
      f[60] = 0.605957;
      f[61] = 0.605957;
      f[62] = 0.605957;
      f[63] = 0.443848;
      f[64] = 0.746826;
      f[65] = 0.703857;
      f[66] = 0.721924;
      f[67] = 0.721924;
      f[68] = 0.777832;
      f[69] = 0.721924;
      f[70] = 0.666992;
      f[71] = 0.777832;
      f[72] = 0.832764;
      f[73] = 0.406982;
      f[74] = 0.61084;
      f[75] = 0.740967;
      f[76] = 0.666992;
      f[77] = 0.943848;
      f[78] = 0.814941;
      f[79] = 0.777832;
      f[80] = 0.666992;
      f[81] = 0.777832;
      f[82] = 0.740967;
      f[83] = 0.666992;
      f[84] = 0.684814;
      f[85] = 0.814941;
      f[86] = 0.703857;
      f[87] = 0.925781;
      f[88] = 0.703857;
      f[89] = 0.684814;
      f[90] = 0.666992;
      f[91] = 0.332764;
      f[92] = 0.605957;
      f[93] = 0.332764;
      f[94] = 0.605957;
      f[95] = 0.5;
      f[96] = 0.203857;
      f[97] = 0.573975;
      f[98] = 0.555908;
      f[99] = 0.443848;
      f[100] = 0.61084;
      f[101] = 0.443848;
      f[102] = 0.332764;
      f[103] = 0.536865;
      f[104] = 0.61084;
      f[105] = 0.332764;
      f[106] = 0.314941;
      f[107] = 0.555908;
      f[108] = 0.332764;
      f[109] = 0.888916;
      f[110] = 0.61084;
      f[111] = 0.5;
      f[112] = 0.573975;
      f[113] = 0.555908;
      f[114] = 0.443848;
      f[115] = 0.443848;
      f[116] = 0.351807;
      f[117] = 0.61084;
      f[118] = 0.518799;
      f[119] = 0.777832;
      f[120] = 0.5;
      f[121] = 0.5;
      f[122] = 0.462891;
      f[123] = 0.332764;
      f[124] = 0.605957;
      f[125] = 0.332764;
      f[126] = 0.605957;
      f[161] = 0.332764;
      f[162] = 0.555908;
      f[163] = 0.555908;
      f[164] = 0.166992;
      f[165] = 0.555908;
      f[166] = 0.555908;
      f[167] = 0.5;
      f[168] = 0.605957;
      f[169] = 0.277832;
      f[170] = 0.388916;
      f[171] = 0.425781;
      f[172] = 0.332764;
      f[173] = 0.332764;
      f[174] = 0.61084;
      f[175] = 0.61084;
      f[177] = 0.5;
      f[178] = 0.5;
      f[179] = 0.5;
      f[180] = 0.277832;
      f[182] = 0.649902;
      f[183] = 0.605957;
      f[184] = 0.203857;
      f[185] = 0.388916;
      f[186] = 0.388916;
      f[187] = 0.425781;
      f[188] = 1.0;
      f[189] = 1.0;
      f[191] = 0.443848;
      f[193] = 0.332764;
      f[194] = 0.332764;
      f[195] = 0.332764;
      f[196] = 0.332764;
      f[197] = 0.332764;
      f[198] = 0.332764;
      f[199] = 0.332764;
      f[200] = 0.332764;
      f[202] = 0.332764;
      f[203] = 0.332764;
      f[205] = 0.332764;
      f[206] = 0.332764;
      f[207] = 0.332764;
      f[208] = 1.0;
      f[225] = 0.869873;
      f[227] = 0.421875;
      f[232] = 0.666992;
      f[233] = 0.777832;
      f[234] = 0.980957;
      f[235] = 0.371826;
      f[241] = 0.721924;
      f[245] = 0.332764;
      f[248] = 0.332764;
      f[249] = 0.5;
      f[250] = 0.777832;
      f[251] = 0.555908;
    }
    else if ( !strcmp(font, "NewCenturySchlbk-Bold") ) {
      f[32] = 0.286865;
      f[33] = 0.295898;
      f[34] = 0.332764;
      f[35] = 0.573975;
      f[36] = 0.573975;
      f[37] = 0.832764;
      f[38] = 0.851807;
      f[39] = 0.240967;
      f[40] = 0.388916;
      f[41] = 0.388916;
      f[42] = 0.5;
      f[43] = 0.605957;
      f[44] = 0.277832;
      f[45] = 0.332764;
      f[46] = 0.277832;
      f[47] = 0.277832;
      f[48] = 0.573975;
      f[49] = 0.573975;
      f[50] = 0.573975;
      f[51] = 0.573975;
      f[52] = 0.573975;
      f[53] = 0.573975;
      f[54] = 0.573975;
      f[55] = 0.573975;
      f[56] = 0.573975;
      f[57] = 0.573975;
      f[58] = 0.277832;
      f[59] = 0.277832;
      f[60] = 0.605957;
      f[61] = 0.605957;
      f[62] = 0.605957;
      f[63] = 0.5;
      f[64] = 0.746826;
      f[65] = 0.758789;
      f[66] = 0.777832;
      f[67] = 0.777832;
      f[68] = 0.832764;
      f[69] = 0.758789;
      f[70] = 0.721924;
      f[71] = 0.832764;
      f[72] = 0.869873;
      f[73] = 0.443848;
      f[74] = 0.647949;
      f[75] = 0.814941;
      f[76] = 0.721924;
      f[77] = 0.980957;
      f[78] = 0.832764;
      f[79] = 0.832764;
      f[80] = 0.758789;
      f[81] = 0.832764;
      f[82] = 0.814941;
      f[83] = 0.666992;
      f[84] = 0.721924;
      f[85] = 0.832764;
      f[86] = 0.758789;
      f[87] = 0.980957;
      f[88] = 0.721924;
      f[89] = 0.721924;
      f[90] = 0.666992;
      f[91] = 0.388916;
      f[92] = 0.605957;
      f[93] = 0.388916;
      f[94] = 0.605957;
      f[95] = 0.5;
      f[96] = 0.240967;
      f[97] = 0.61084;
      f[98] = 0.647949;
      f[99] = 0.555908;
      f[100] = 0.666992;
      f[101] = 0.573975;
      f[102] = 0.388916;
      f[103] = 0.61084;
      f[104] = 0.684814;
      f[105] = 0.369873;
      f[106] = 0.351807;
      f[107] = 0.666992;
      f[108] = 0.351807;
      f[109] = 0.962891;
      f[110] = 0.684814;
      f[111] = 0.61084;
      f[112] = 0.666992;
      f[113] = 0.647949;
      f[114] = 0.518799;
      f[115] = 0.5;
      f[116] = 0.425781;
      f[117] = 0.684814;
      f[118] = 0.61084;
      f[119] = 0.888916;
      f[120] = 0.61084;
      f[121] = 0.61084;
      f[122] = 0.536865;
      f[123] = 0.388916;
      f[124] = 0.605957;
      f[125] = 0.388916;
      f[126] = 0.605957;
      f[161] = 0.295898;
      f[162] = 0.573975;
      f[163] = 0.573975;
      f[164] = 0.166992;
      f[165] = 0.721924;
      f[166] = 0.573975;
      f[167] = 0.5;
      f[168] = 0.605957;
      f[169] = 0.240967;
      f[170] = 0.480957;
      f[171] = 0.5;
      f[172] = 0.332764;
      f[173] = 0.332764;
      f[174] = 0.684814;
      f[175] = 0.684814;
      f[177] = 0.5;
      f[179] = 0.5;
      f[180] = 0.277832;
      f[182] = 0.746826;
      f[183] = 0.605957;
      f[185] = 0.480957;
      f[186] = 0.480957;
      f[187] = 0.5;
      f[188] = 1.0;
      f[191] = 0.5;
      f[193] = 0.332764;
      f[194] = 0.332764;
      f[195] = 0.332764;
      f[196] = 0.332764;
      f[197] = 0.332764;
      f[200] = 0.332764;
      f[203] = 0.332764;
      f[205] = 0.332764;
      f[208] = 1.0;
      f[225] = 0.980957;
      f[227] = 0.366943;
      f[233] = 0.832764;
      f[234] = 1.0;
      f[235] = 0.366943;
      f[241] = 0.869873;
      f[245] = 0.369873;
      f[249] = 0.61084;
      f[250] = 0.906982;
      f[251] = 0.61084;
    }
    else if ( !strcmp(font, "NewCenturySchlbk-BoldItalic") ) {
      f[32] = 0.286865;
      f[33] = 0.332764;
      f[34] = 0.399902;
      f[35] = 0.605957;
      f[36] = 0.573975;
      f[37] = 0.888916;
      f[38] = 0.888916;
      f[39] = 0.258789;
      f[40] = 0.406982;
      f[41] = 0.406982;
      f[42] = 0.5;
      f[43] = 0.605957;
      f[44] = 0.286865;
      f[45] = 0.332764;
      f[46] = 0.286865;
      f[47] = 0.277832;
      f[48] = 0.573975;
      f[49] = 0.573975;
      f[50] = 0.573975;
      f[51] = 0.573975;
      f[52] = 0.573975;
      f[53] = 0.573975;
      f[54] = 0.573975;
      f[55] = 0.573975;
      f[56] = 0.573975;
      f[57] = 0.573975;
      f[58] = 0.286865;
      f[59] = 0.286865;
      f[60] = 0.605957;
      f[61] = 0.605957;
      f[62] = 0.605957;
      f[63] = 0.480957;
      f[64] = 0.746826;
      f[65] = 0.740967;
      f[66] = 0.758789;
      f[67] = 0.758789;
      f[68] = 0.832764;
      f[69] = 0.740967;
      f[70] = 0.703857;
      f[71] = 0.814941;
      f[72] = 0.869873;
      f[73] = 0.443848;
      f[74] = 0.666992;
      f[75] = 0.777832;
      f[76] = 0.703857;
      f[77] = 0.943848;
      f[78] = 0.851807;
      f[79] = 0.832764;
      f[80] = 0.740967;
      f[81] = 0.832764;
      f[82] = 0.795898;
      f[83] = 0.684814;
      f[84] = 0.721924;
      f[85] = 0.832764;
      f[86] = 0.740967;
      f[87] = 0.943848;
      f[88] = 0.740967;
      f[89] = 0.703857;
      f[90] = 0.703857;
      f[91] = 0.406982;
      f[92] = 0.605957;
      f[93] = 0.406982;
      f[94] = 0.605957;
      f[95] = 0.5;
      f[96] = 0.258789;
      f[97] = 0.666992;
      f[98] = 0.61084;
      f[99] = 0.536865;
      f[100] = 0.666992;
      f[101] = 0.518799;
      f[102] = 0.388916;
      f[103] = 0.61084;
      f[104] = 0.684814;
      f[105] = 0.388916;
      f[106] = 0.369873;
      f[107] = 0.647949;
      f[108] = 0.388916;
      f[109] = 0.943848;
      f[110] = 0.684814;
      f[111] = 0.573975;
      f[112] = 0.647949;
      f[113] = 0.629883;
      f[114] = 0.518799;
      f[115] = 0.480957;
      f[116] = 0.406982;
      f[117] = 0.684814;
      f[118] = 0.555908;
      f[119] = 0.832764;
      f[120] = 0.573975;
      f[121] = 0.518799;
      f[122] = 0.518799;
      f[123] = 0.406982;
      f[124] = 0.605957;
      f[125] = 0.406982;
      f[126] = 0.605957;
      f[161] = 0.332764;
      f[162] = 0.573975;
      f[163] = 0.573975;
      f[164] = 0.166992;
      f[165] = 0.573975;
      f[166] = 0.573975;
      f[167] = 0.5;
      f[168] = 0.573975;
      f[169] = 0.286865;
      f[170] = 0.480957;
      f[171] = 0.480957;
      f[172] = 0.277832;
      f[173] = 0.277832;
      f[174] = 0.684814;
      f[175] = 0.684814;
      f[177] = 0.5;
      f[179] = 0.5;
      f[180] = 0.286865;
      f[182] = 0.649902;
      f[183] = 0.605957;
      f[185] = 0.480957;
      f[186] = 0.480957;
      f[187] = 0.480957;
      f[188] = 1.0;
      f[191] = 0.480957;
      f[193] = 0.332764;
      f[194] = 0.332764;
      f[195] = 0.332764;
      f[196] = 0.332764;
      f[197] = 0.332764;
      f[200] = 0.332764;
      f[203] = 0.332764;
      f[205] = 0.332764;
      f[208] = 1.0;
      f[225] = 0.888916;
      f[227] = 0.411865;
      f[233] = 0.832764;
      f[234] = 0.962891;
      f[235] = 0.355957;
      f[241] = 0.814941;
      f[245] = 0.388916;
      f[249] = 0.573975;
      f[250] = 0.851807;
      f[251] = 0.573975;
    }
    else if ( !strcmp(font, "Palatino-Roman") ) {
      f[32] = 0.25;
      f[33] = 0.277832;
      f[34] = 0.37085;
      f[35] = 0.5;
      f[36] = 0.5;
      f[37] = 0.839844;
      f[38] = 0.777832;
      f[39] = 0.277832;
      f[40] = 0.332764;
      f[41] = 0.332764;
      f[42] = 0.388916;
      f[43] = 0.605957;
      f[44] = 0.25;
      f[45] = 0.332764;
      f[46] = 0.25;
      f[47] = 0.605957;
      f[48] = 0.5;
      f[49] = 0.5;
      f[50] = 0.5;
      f[51] = 0.5;
      f[52] = 0.5;
      f[53] = 0.5;
      f[54] = 0.5;
      f[55] = 0.5;
      f[56] = 0.5;
      f[57] = 0.5;
      f[58] = 0.25;
      f[59] = 0.25;
      f[60] = 0.605957;
      f[61] = 0.605957;
      f[62] = 0.605957;
      f[63] = 0.443848;
      f[64] = 0.746826;
      f[65] = 0.777832;
      f[66] = 0.61084;
      f[67] = 0.708984;
      f[68] = 0.773926;
      f[69] = 0.61084;
      f[70] = 0.555908;
      f[71] = 0.762939;
      f[72] = 0.831787;
      f[73] = 0.336914;
      f[74] = 0.332764;
      f[75] = 0.72583;
      f[76] = 0.61084;
      f[77] = 0.945801;
      f[78] = 0.830811;
      f[79] = 0.785889;
      f[80] = 0.60376;
      f[81] = 0.785889;
      f[82] = 0.667969;
      f[83] = 0.524902;
      f[84] = 0.612793;
      f[85] = 0.777832;
      f[86] = 0.721924;
      f[87] = 1.0;
      f[88] = 0.666992;
      f[89] = 0.666992;
      f[90] = 0.666992;
      f[91] = 0.332764;
      f[92] = 0.605957;
      f[93] = 0.332764;
      f[94] = 0.605957;
      f[95] = 0.5;
      f[96] = 0.277832;
      f[97] = 0.5;
      f[98] = 0.552979;
      f[99] = 0.443848;
      f[100] = 0.61084;
      f[101] = 0.47876;
      f[102] = 0.332764;
      f[103] = 0.555908;
      f[104] = 0.581787;
      f[105] = 0.290771;
      f[106] = 0.233887;
      f[107] = 0.555908;
      f[108] = 0.290771;
      f[109] = 0.882812;
      f[110] = 0.581787;
      f[111] = 0.545898;
      f[112] = 0.60083;
      f[113] = 0.559814;
      f[114] = 0.394775;
      f[115] = 0.423828;
      f[116] = 0.325928;
      f[117] = 0.602783;
      f[118] = 0.564941;
      f[119] = 0.833984;
      f[120] = 0.515869;
      f[121] = 0.555908;
      f[122] = 0.5;
      f[123] = 0.332764;
      f[124] = 0.605957;
      f[125] = 0.332764;
      f[126] = 0.605957;
      f[161] = 0.277832;
      f[162] = 0.5;
      f[163] = 0.5;
      f[164] = 0.166992;
      f[165] = 0.5;
      f[166] = 0.5;
      f[169] = 0.207764;
      f[170] = 0.5;
      f[171] = 0.5;
      f[172] = 0.330811;
      f[173] = 0.330811;
      f[174] = 0.60498;
      f[175] = 0.60791;
      f[177] = 0.5;
      f[179] = 0.5;
      f[180] = 0.25;
      f[183] = 0.605957;
      f[185] = 0.5;
      f[186] = 0.5;
      f[187] = 0.5;
      f[188] = 1.0;
      f[191] = 0.443848;
      f[193] = 0.332764;
      f[194] = 0.332764;
      f[195] = 0.332764;
      f[196] = 0.332764;
      f[200] = 0.332764;
      f[203] = 0.332764;
      f[205] = 0.379883;
      f[208] = 1.0;
      f[225] = 0.943848;
      f[234] = 0.997803;
      f[241] = 0.757812;
      f[245] = 0.286865;
      f[250] = 0.826904;
      f[251] = 0.555908;
    }
    else if ( !strcmp(font, "Palatino-Italic") ) {
      f[32] = 0.25;
      f[33] = 0.332764;
      f[34] = 0.5;
      f[35] = 0.5;
      f[36] = 0.5;
      f[37] = 0.888916;
      f[38] = 0.777832;
      f[39] = 0.277832;
      f[40] = 0.332764;
      f[41] = 0.332764;
      f[42] = 0.388916;
      f[43] = 0.605957;
      f[44] = 0.25;
      f[45] = 0.332764;
      f[46] = 0.25;
      f[47] = 0.295898;
      f[48] = 0.5;
      f[49] = 0.5;
      f[50] = 0.5;
      f[51] = 0.5;
      f[52] = 0.5;
      f[53] = 0.5;
      f[54] = 0.5;
      f[55] = 0.5;
      f[56] = 0.5;
      f[57] = 0.5;
      f[58] = 0.25;
      f[59] = 0.25;
      f[60] = 0.605957;
      f[61] = 0.605957;
      f[62] = 0.605957;
      f[63] = 0.5;
      f[64] = 0.746826;
      f[65] = 0.721924;
      f[66] = 0.61084;
      f[67] = 0.666992;
      f[68] = 0.777832;
      f[69] = 0.61084;
      f[70] = 0.555908;
      f[71] = 0.721924;
      f[72] = 0.777832;
      f[73] = 0.332764;
      f[74] = 0.332764;
      f[75] = 0.666992;
      f[76] = 0.555908;
      f[77] = 0.943848;
      f[78] = 0.777832;
      f[79] = 0.777832;
      f[80] = 0.61084;
      f[81] = 0.777832;
      f[82] = 0.666992;
      f[83] = 0.555908;
      f[84] = 0.61084;
      f[85] = 0.777832;
      f[86] = 0.721924;
      f[87] = 0.943848;
      f[88] = 0.721924;
      f[89] = 0.666992;
      f[90] = 0.666992;
      f[91] = 0.332764;
      f[92] = 0.605957;
      f[93] = 0.332764;
      f[94] = 0.605957;
      f[95] = 0.5;
      f[96] = 0.277832;
      f[97] = 0.443848;
      f[98] = 0.462891;
      f[99] = 0.406982;
      f[100] = 0.5;
      f[101] = 0.388916;
      f[102] = 0.277832;
      f[103] = 0.5;
      f[104] = 0.5;
      f[105] = 0.277832;
      f[106] = 0.277832;
      f[107] = 0.443848;
      f[108] = 0.277832;
      f[109] = 0.777832;
      f[110] = 0.555908;
      f[111] = 0.443848;
      f[112] = 0.5;
      f[113] = 0.462891;
      f[114] = 0.388916;
      f[115] = 0.388916;
      f[116] = 0.332764;
      f[117] = 0.555908;
      f[118] = 0.5;
      f[119] = 0.721924;
      f[120] = 0.5;
      f[121] = 0.5;
      f[122] = 0.443848;
      f[123] = 0.332764;
      f[124] = 0.605957;
      f[125] = 0.332764;
      f[126] = 0.605957;
      f[161] = 0.332764;
      f[162] = 0.5;
      f[163] = 0.5;
      f[164] = 0.166992;
      f[165] = 0.5;
      f[166] = 0.5;
      f[169] = 0.332764;
      f[170] = 0.5;
      f[171] = 0.5;
      f[172] = 0.332764;
      f[173] = 0.332764;
      f[174] = 0.527832;
      f[175] = 0.544922;
      f[177] = 0.5;
      f[179] = 0.5;
      f[180] = 0.25;
      f[183] = 0.5;
      f[185] = 0.5;
      f[186] = 0.5;
      f[187] = 0.5;
      f[188] = 1.0;
      f[191] = 0.5;
      f[193] = 0.332764;
      f[194] = 0.332764;
      f[195] = 0.332764;
      f[196] = 0.332764;
      f[200] = 0.332764;
      f[203] = 0.332764;
      f[205] = 0.332764;
      f[208] = 1.0;
      f[225] = 0.940918;
      f[234] = 1.02783;
      f[241] = 0.637939;
      f[245] = 0.277832;
      f[250] = 0.668945;
      f[251] = 0.5;
    }
    else if ( !strcmp(font, "Palatino-Bold") ) {
      f[32] = 0.25;
      f[33] = 0.277832;
      f[34] = 0.401855;
      f[35] = 0.5;
      f[36] = 0.5;
      f[37] = 0.888916;
      f[38] = 0.832764;
      f[39] = 0.277832;
      f[40] = 0.332764;
      f[41] = 0.332764;
      f[42] = 0.443848;
      f[43] = 0.605957;
      f[44] = 0.25;
      f[45] = 0.332764;
      f[46] = 0.25;
      f[47] = 0.295898;
      f[48] = 0.5;
      f[49] = 0.5;
      f[50] = 0.5;
      f[51] = 0.5;
      f[52] = 0.5;
      f[53] = 0.5;
      f[54] = 0.5;
      f[55] = 0.5;
      f[56] = 0.5;
      f[57] = 0.5;
      f[58] = 0.25;
      f[59] = 0.25;
      f[60] = 0.605957;
      f[61] = 0.605957;
      f[62] = 0.605957;
      f[63] = 0.443848;
      f[64] = 0.746826;
      f[65] = 0.777832;
      f[66] = 0.666992;
      f[67] = 0.721924;
      f[68] = 0.832764;
      f[69] = 0.61084;
      f[70] = 0.555908;
      f[71] = 0.832764;
      f[72] = 0.832764;
      f[73] = 0.388916;
      f[74] = 0.388916;
      f[75] = 0.777832;
      f[76] = 0.61084;
      f[77] = 1.0;
      f[78] = 0.832764;
      f[79] = 0.832764;
      f[80] = 0.61084;
      f[81] = 0.832764;
      f[82] = 0.721924;
      f[83] = 0.61084;
      f[84] = 0.666992;
      f[85] = 0.777832;
      f[86] = 0.777832;
      f[87] = 1.0;
      f[88] = 0.666992;
      f[89] = 0.666992;
      f[90] = 0.666992;
      f[91] = 0.332764;
      f[92] = 0.605957;
      f[93] = 0.332764;
      f[94] = 0.605957;
      f[95] = 0.5;
      f[96] = 0.277832;
      f[97] = 0.5;
      f[98] = 0.61084;
      f[99] = 0.443848;
      f[100] = 0.61084;
      f[101] = 0.5;
      f[102] = 0.388916;
      f[103] = 0.555908;
      f[104] = 0.61084;
      f[105] = 0.332764;
      f[106] = 0.332764;
      f[107] = 0.61084;
      f[108] = 0.332764;
      f[109] = 0.888916;
      f[110] = 0.61084;
      f[111] = 0.555908;
      f[112] = 0.61084;
      f[113] = 0.61084;
      f[114] = 0.388916;
      f[115] = 0.443848;
      f[116] = 0.332764;
      f[117] = 0.61084;
      f[118] = 0.555908;
      f[119] = 0.832764;
      f[120] = 0.5;
      f[121] = 0.555908;
      f[122] = 0.5;
      f[123] = 0.309814;
      f[124] = 0.605957;
      f[125] = 0.309814;
      f[126] = 0.605957;
      f[161] = 0.277832;
      f[162] = 0.5;
      f[163] = 0.5;
      f[164] = 0.166992;
      f[165] = 0.5;
      f[166] = 0.5;
      f[169] = 0.226807;
      f[170] = 0.5;
      f[171] = 0.5;
      f[172] = 0.388916;
      f[173] = 0.388916;
      f[174] = 0.61084;
      f[175] = 0.61084;
      f[177] = 0.5;
      f[179] = 0.5;
      f[180] = 0.25;
      f[183] = 0.605957;
      f[185] = 0.5;
      f[186] = 0.5;
      f[187] = 0.5;
      f[188] = 1.0;
      f[191] = 0.443848;
      f[193] = 0.332764;
      f[194] = 0.332764;
      f[195] = 0.332764;
      f[196] = 0.332764;
      f[200] = 0.332764;
      f[203] = 0.332764;
      f[205] = 0.332764;
      f[208] = 1.0;
      f[225] = 1.0;
      f[234] = 1.0;
      f[241] = 0.777832;
      f[245] = 0.332764;
      f[250] = 0.832764;
      f[251] = 0.61084;
    }
    else if ( !strcmp(font, "Palatino-BoldItalic") ) {
      f[32] = 0.25;
      f[33] = 0.332764;
      f[34] = 0.5;
      f[35] = 0.5;
      f[36] = 0.5;
      f[37] = 0.888916;
      f[38] = 0.832764;
      f[39] = 0.277832;
      f[40] = 0.332764;
      f[41] = 0.332764;
      f[42] = 0.443848;
      f[43] = 0.605957;
      f[44] = 0.25;
      f[45] = 0.388916;
      f[46] = 0.25;
      f[47] = 0.314941;
      f[48] = 0.5;
      f[49] = 0.5;
      f[50] = 0.5;
      f[51] = 0.5;
      f[52] = 0.5;
      f[53] = 0.5;
      f[54] = 0.5;
      f[55] = 0.5;
      f[56] = 0.5;
      f[57] = 0.5;
      f[58] = 0.25;
      f[59] = 0.25;
      f[60] = 0.605957;
      f[61] = 0.605957;
      f[62] = 0.605957;
      f[63] = 0.443848;
      f[64] = 0.832764;
      f[65] = 0.721924;
      f[66] = 0.666992;
      f[67] = 0.684814;
      f[68] = 0.777832;
      f[69] = 0.61084;
      f[70] = 0.555908;
      f[71] = 0.777832;
      f[72] = 0.777832;
      f[73] = 0.388916;
      f[74] = 0.388916;
      f[75] = 0.721924;
      f[76] = 0.61084;
      f[77] = 0.943848;
      f[78] = 0.777832;
      f[79] = 0.832764;
      f[80] = 0.666992;
      f[81] = 0.832764;
      f[82] = 0.721924;
      f[83] = 0.555908;
      f[84] = 0.61084;
      f[85] = 0.777832;
      f[86] = 0.666992;
      f[87] = 1.0;
      f[88] = 0.721924;
      f[89] = 0.61084;
      f[90] = 0.666992;
      f[91] = 0.332764;
      f[92] = 0.605957;
      f[93] = 0.332764;
      f[94] = 0.605957;
      f[95] = 0.5;
      f[96] = 0.277832;
      f[97] = 0.555908;
      f[98] = 0.536865;
      f[99] = 0.443848;
      f[100] = 0.555908;
      f[101] = 0.443848;
      f[102] = 0.332764;
      f[103] = 0.5;
      f[104] = 0.555908;
      f[105] = 0.332764;
      f[106] = 0.332764;
      f[107] = 0.555908;
      f[108] = 0.332764;
      f[109] = 0.832764;
      f[110] = 0.555908;
      f[111] = 0.555908;
      f[112] = 0.555908;
      f[113] = 0.536865;
      f[114] = 0.388916;
      f[115] = 0.443848;
      f[116] = 0.388916;
      f[117] = 0.555908;
      f[118] = 0.555908;
      f[119] = 0.832764;
      f[120] = 0.5;
      f[121] = 0.555908;
      f[122] = 0.5;
      f[123] = 0.332764;
      f[124] = 0.605957;
      f[125] = 0.332764;
      f[126] = 0.605957;
      f[161] = 0.332764;
      f[162] = 0.5;
      f[163] = 0.5;
      f[164] = 0.166992;
      f[165] = 0.5;
      f[166] = 0.5;
      f[169] = 0.25;
      f[170] = 0.5;
      f[171] = 0.5;
      f[172] = 0.332764;
      f[173] = 0.332764;
      f[174] = 0.61084;
      f[175] = 0.61084;
      f[177] = 0.5;
      f[179] = 0.555908;
      f[180] = 0.25;
      f[183] = 0.605957;
      f[185] = 0.5;
      f[186] = 0.5;
      f[187] = 0.5;
      f[188] = 1.0;
      f[191] = 0.443848;
      f[193] = 0.332764;
      f[194] = 0.332764;
      f[195] = 0.332764;
      f[196] = 0.332764;
      f[200] = 0.332764;
      f[203] = 0.332764;
      f[205] = 0.332764;
      f[208] = 1.0;
      f[225] = 0.943848;
      f[234] = 0.943848;
      f[241] = 0.737793;
      f[245] = 0.332764;
      f[250] = 0.777832;
      f[251] = 0.555908;
    }
    else if ( !strcmp(font, "ZapfChancery-MediumItalic") ) {
      f[32] = 0.219971;
      f[33] = 0.279785;
      f[34] = 0.219971;
      f[35] = 0.439941;
      f[36] = 0.439941;
      f[37] = 0.679932;
      f[38] = 0.779785;
      f[39] = 0.23999;
      f[40] = 0.259766;
      f[41] = 0.219971;
      f[42] = 0.419922;
      f[43] = 0.519775;
      f[44] = 0.219971;
      f[45] = 0.279785;
      f[46] = 0.219971;
      f[47] = 0.339844;
      f[48] = 0.439941;
      f[49] = 0.439941;
      f[50] = 0.439941;
      f[51] = 0.439941;
      f[52] = 0.439941;
      f[53] = 0.439941;
      f[54] = 0.439941;
      f[55] = 0.439941;
      f[56] = 0.439941;
      f[57] = 0.439941;
      f[58] = 0.259766;
      f[59] = 0.23999;
      f[60] = 0.519775;
      f[61] = 0.519775;
      f[62] = 0.519775;
      f[63] = 0.379883;
      f[64] = 0.699951;
      f[65] = 0.619873;
      f[66] = 0.599854;
      f[67] = 0.519775;
      f[68] = 0.699951;
      f[69] = 0.619873;
      f[70] = 0.579834;
      f[71] = 0.619873;
      f[72] = 0.679932;
      f[73] = 0.379883;
      f[74] = 0.399902;
      f[75] = 0.659912;
      f[76] = 0.579834;
      f[77] = 0.839844;
      f[78] = 0.699951;
      f[79] = 0.599854;
      f[80] = 0.539795;
      f[81] = 0.599854;
      f[82] = 0.599854;
      f[83] = 0.459961;
      f[84] = 0.5;
      f[85] = 0.73999;
      f[86] = 0.639893;
      f[87] = 0.879883;
      f[88] = 0.559814;
      f[89] = 0.559814;
      f[90] = 0.619873;
      f[91] = 0.23999;
      f[92] = 0.47998;
      f[93] = 0.319824;
      f[94] = 0.519775;
      f[95] = 0.5;
      f[96] = 0.23999;
      f[97] = 0.419922;
      f[98] = 0.419922;
      f[99] = 0.339844;
      f[100] = 0.439941;
      f[101] = 0.339844;
      f[102] = 0.319824;
      f[103] = 0.399902;
      f[104] = 0.439941;
      f[105] = 0.23999;
      f[106] = 0.219971;
      f[107] = 0.439941;
      f[108] = 0.23999;
      f[109] = 0.619873;
      f[110] = 0.459961;
      f[111] = 0.399902;
      f[112] = 0.439941;
      f[113] = 0.399902;
      f[114] = 0.299805;
      f[115] = 0.319824;
      f[116] = 0.319824;
      f[117] = 0.459961;
      f[118] = 0.439941;
      f[119] = 0.679932;
      f[120] = 0.419922;
      f[121] = 0.399902;
      f[122] = 0.439941;
      f[123] = 0.23999;
      f[124] = 0.519775;
      f[125] = 0.23999;
      f[126] = 0.519775;
      f[161] = 0.279785;
      f[162] = 0.439941;
      f[163] = 0.439941;
      f[164] = 0.0598145;
      f[165] = 0.439941;
      f[166] = 0.439941;
      f[169] = 0.159912;
      f[170] = 0.339844;
      f[171] = 0.339844;
      f[172] = 0.23999;
      f[173] = 0.259766;
      f[174] = 0.519775;
      f[175] = 0.519775;
      f[177] = 0.5;
      f[179] = 0.47998;
      f[180] = 0.219971;
      f[183] = 0.599854;
      f[185] = 0.279785;
      f[186] = 0.359863;
      f[187] = 0.379883;
      f[188] = 1.0;
      f[191] = 0.399902;
      f[193] = 0.219971;
      f[194] = 0.299805;
      f[195] = 0.339844;
      f[196] = 0.439941;
      f[200] = 0.359863;
      f[203] = 0.299805;
      f[205] = 0.399902;
      f[208] = 1.0;
      f[225] = 0.73999;
      f[234] = 0.819824;
      f[241] = 0.539795;
      f[245] = 0.23999;
      f[250] = 0.559814;
      f[251] = 0.419922;
    }
    else if ( !strcmp(font, "ZapfDingbats") ) {
      f[32] = 0.278;
      f[33] = 0.973877;
      f[34] = 0.960938;
      f[35] = 0.973877;
      f[36] = 0.97998;
      f[37] = 0.718994;
      f[38] = 0.788818;
      f[39] = 0.789795;
      f[40] = 0.790771;
      f[41] = 0.689941;
      f[42] = 0.959961;
      f[43] = 0.938965;
      f[44] = 0.548828;
      f[45] = 0.85498;
      f[46] = 0.910889;
      f[47] = 0.932861;
      f[48] = 0.910889;
      f[49] = 0.944824;
      f[50] = 0.973877;
      f[51] = 0.754883;
      f[52] = 0.845947;
      f[53] = 0.761963;
      f[54] = 0.760986;
      f[55] = 0.570801;
      f[56] = 0.676758;
      f[57] = 0.762939;
      f[58] = 0.759766;
      f[59] = 0.758789;
      f[60] = 0.753906;
      f[61] = 0.493896;
      f[62] = 0.551758;
      f[63] = 0.536865;
      f[64] = 0.576904;
      f[65] = 0.691895;
      f[66] = 0.785889;
      f[67] = 0.787842;
      f[68] = 0.787842;
      f[69] = 0.789795;
      f[70] = 0.792969;
      f[71] = 0.793945;
      f[72] = 0.815918;
      f[73] = 0.822998;
      f[74] = 0.788818;
      f[75] = 0.84082;
      f[76] = 0.822998;
      f[77] = 0.832764;
      f[78] = 0.815918;
      f[79] = 0.830811;
      f[80] = 0.922852;
      f[81] = 0.743896;
      f[82] = 0.7229;
      f[83] = 0.748779;
      f[84] = 0.789795;
      f[85] = 0.791992;
      f[86] = 0.694824;
      f[87] = 0.775879;
      f[88] = 0.767822;
      f[89] = 0.791992;
      f[90] = 0.758789;
      f[91] = 0.706787;
      f[92] = 0.707764;
      f[93] = 0.681885;
      f[94] = 0.700928;
      f[95] = 0.825928;
      f[96] = 0.814941;
      f[97] = 0.788818;
      f[98] = 0.788818;
      f[99] = 0.706787;
      f[100] = 0.686768;
      f[101] = 0.695801;
      f[102] = 0.688989;
      f[103] = 0.785889;
      f[104] = 0.786865;
      f[105] = 0.712891;
      f[106] = 0.790771;
      f[107] = 0.784912;
      f[108] = 0.790771;
      f[109] = 0.872803;
      f[110] = 0.760986;
      f[111] = 0.761963;
      f[112] = 0.761963;
      f[113] = 0.758789;
      f[114] = 0.758789;
      f[115] = 0.891846;
      f[116] = 0.891846;
      f[117] = 0.787842;
      f[118] = 0.783936;
      f[119] = 0.437988;
      f[120] = 0.137939;
      f[121] = 0.276855;
      f[122] = 0.414795;
      f[123] = 0.391846;
      f[124] = 0.391846;
      f[125] = 0.667969;
      f[126] = 0.667969;
      f[161] = 0.731934;
      f[162] = 0.543945;
      f[163] = 0.543945;
      f[164] = 0.909912;
      f[165] = 0.666992;
      f[166] = 0.759766;
      f[167] = 0.759766;
      f[168] = 0.775879;
      f[169] = 0.594971;
      f[170] = 0.693848;
      f[171] = 0.625977;
      f[172] = 0.787842;
      f[173] = 0.787842;
      f[174] = 0.787842;
      f[175] = 0.787842;
      f[176] = 0.787842;
      f[177] = 0.787842;
      f[178] = 0.787842;
      f[179] = 0.787842;
      f[180] = 0.787842;
      f[181] = 0.787842;
      f[182] = 0.787842;
      f[183] = 0.787842;
      f[184] = 0.787842;
      f[185] = 0.787842;
      f[186] = 0.787842;
      f[187] = 0.787842;
      f[188] = 0.787842;
      f[189] = 0.787842;
      f[190] = 0.787842;
      f[191] = 0.787842;
      f[192] = 0.787842;
      f[193] = 0.787842;
      f[194] = 0.787842;
      f[195] = 0.787842;
      f[196] = 0.787842;
      f[197] = 0.787842;
      f[198] = 0.787842;
      f[199] = 0.787842;
      f[200] = 0.787842;
      f[201] = 0.787842;
      f[202] = 0.787842;
      f[203] = 0.787842;
      f[204] = 0.787842;
      f[205] = 0.787842;
      f[206] = 0.787842;
      f[207] = 0.787842;
      f[208] = 0.787842;
      f[209] = 0.787842;
      f[210] = 0.787842;
      f[211] = 0.787842;
      f[212] = 0.893799;
      f[213] = 0.837891;
      f[214] = 1.01587;
      f[215] = 0.457764;
      f[216] = 0.747803;
      f[217] = 0.923828;
      f[218] = 0.747803;
      f[219] = 0.917969;
      f[220] = 0.926758;
      f[221] = 0.927979;
      f[222] = 0.927979;
      f[223] = 0.833984;
      f[224] = 0.872803;
      f[225] = 0.827881;
      f[226] = 0.923828;
      f[227] = 0.923828;
      f[228] = 0.916992;
      f[229] = 0.929932;
      f[230] = 0.930908;
      f[231] = 0.462891;
      f[232] = 0.882812;
      f[233] = 0.835938;
      f[234] = 0.835938;
      f[235] = 0.866943;
      f[236] = 0.866943;
      f[237] = 0.695801;
      f[238] = 0.695801;
      f[239] = 0.873779;
      f[241] = 0.873779;
      f[242] = 0.759766;
      f[243] = 0.945801;
      f[244] = 0.770996;
      f[245] = 0.86499;
      f[246] = 0.770996;
      f[247] = 0.887939;
      f[248] = 0.966797;
      f[249] = 0.887939;
      f[250] = 0.830811;
      f[251] = 0.872803;
      f[252] = 0.926758;
      f[253] = 0.969971;
      f[254] = 0.917969;
    }
    else if ( !strcmp(font, "Gothic-Medium.Hiragana") ) {
      for ( i = 0 ; i < 256 ; i++ ) {
	f[i] = 0.5;
      }
    }
    else if ( !strcmp(font, "Gothic-Medium.Katakana") ) {
      for ( i = 0 ; i < 256 ; i++ ) {
	f[i] = 0.5;
      }
    }
    else if ( !strcmp(font, "Ryumin-Light.Hiragana") ) {
      for ( i = 0 ; i < 256 ; i++ ) {
	f[i] = 0.5;
      }
    }
    else if ( !strcmp(font, "Ryumin-Light.Katakana") ) {
      for ( i = 0 ; i < 256 ; i++ ) {
	f[i] = 0.5;
      }
    }
    else {
      for ( i = 0 ; i < 256 ; i++ ) {
	f[i] = 1.0;
      }
    }
    return NULL;
  }
}


/*=============================================================================
			end
=============================================================================*/
