//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package publisher

import (
	"context"
	"net/http"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/messaging"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
)

// Client contains the methods for the Client group.
// Don't use this type directly, use a constructor function instead.
type Client struct {
	internal *azcore.Client
	endpoint string
}

// PublishCloudEvents - Publishes a batch of events to an Azure Event Grid topic.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-01-01
//   - events - An array of events to be published to Event Grid.
//   - options - PublishCloudEventsOptions contains the optional parameters for the Client.PublishCloudEvents
//     method.
func (client *Client) internalPublishCloudEvents(ctx context.Context, events []messaging.CloudEvent, options *PublishCloudEventsOptions) (PublishCloudEventsResponse, error) {
	var err error
	req, err := client.publishCloudEventsCreateRequest(ctx, events, options)
	if err != nil {
		return PublishCloudEventsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PublishCloudEventsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PublishCloudEventsResponse{}, err
	}
	return PublishCloudEventsResponse{}, nil
}

// publishCloudEventsCreateRequest creates the PublishCloudEvents request.
func (client *Client) publishCloudEventsCreateRequest(ctx context.Context, events []messaging.CloudEvent, options *PublishCloudEventsOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPost, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if options != nil && options.AegChannelName != nil {
		req.Raw().Header["aeg-channel-name"] = []string{*options.AegChannelName}
	}
	if err := runtime.MarshalAsJSON(req, events); err != nil {
		return nil, err
	}

	req.Raw().Header.Set("Content-type", "application/cloudevents-batch+json; charset=utf-8")
	return req, nil
}

// PublishCustomEventEvents - Publishes a batch of events to an Azure Event Grid topic.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-01-01
//   - events - An array of events to be published to Event Grid.
//   - options - PublishCustomEventEventsOptions contains the optional parameters for the Client.PublishCustomEventEvents
//     method.
func (client *Client) PublishCustomEventEvents(ctx context.Context, events []any, options *PublishCustomEventEventsOptions) (PublishCustomEventEventsResponse, error) {
	var err error
	req, err := client.publishCustomEventEventsCreateRequest(ctx, events, options)
	if err != nil {
		return PublishCustomEventEventsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PublishCustomEventEventsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PublishCustomEventEventsResponse{}, err
	}
	return PublishCustomEventEventsResponse{}, nil
}

// publishCustomEventEventsCreateRequest creates the PublishCustomEventEvents request.
func (client *Client) publishCustomEventEventsCreateRequest(ctx context.Context, events []any, options *PublishCustomEventEventsOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPost, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if err := runtime.MarshalAsJSON(req, events); err != nil {
		return nil, err
	}
	return req, nil
}

// PublishEvents - Publishes a batch of events to an Azure Event Grid topic.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-01-01
//   - events - An array of events to be published to Event Grid.
//   - options - PublishEventsOptions contains the optional parameters for the Client.PublishEvents method.
func (client *Client) PublishEvents(ctx context.Context, events []Event, options *PublishEventsOptions) (PublishEventsResponse, error) {
	var err error
	req, err := client.publishEventsCreateRequest(ctx, events, options)
	if err != nil {
		return PublishEventsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PublishEventsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PublishEventsResponse{}, err
	}
	return PublishEventsResponse{}, nil
}

// publishEventsCreateRequest creates the PublishEvents request.
func (client *Client) publishEventsCreateRequest(ctx context.Context, events []Event, options *PublishEventsOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPost, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if err := runtime.MarshalAsJSON(req, events); err != nil {
		return nil, err
	}
	return req, nil
}
