//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appservice/armappservice/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_List.json
func ExampleEnvironmentsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.EnvironmentCollection = armappservice.EnvironmentCollection{
		// 	Value: []*armappservice.EnvironmentResource{
		// 		{
		// 			Name: to.Ptr("test-ase"),
		// 			Type: to.Ptr("Microsoft.Web/hostingEnvironments"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase"),
		// 			Kind: to.Ptr("ASEV3"),
		// 			Location: to.Ptr("South Central US"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armappservice.Environment{
		// 				DedicatedHostCount: to.Ptr[int32](0),
		// 				DNSSuffix: to.Ptr("test-ase.p.azurewebsites.net"),
		// 				FrontEndScaleFactor: to.Ptr[int32](15),
		// 				HasLinuxWorkers: to.Ptr(true),
		// 				InternalLoadBalancingMode: to.Ptr(armappservice.LoadBalancingModeNone),
		// 				IpsslAddressCount: to.Ptr[int32](0),
		// 				MaximumNumberOfMachines: to.Ptr[int32](250),
		// 				MultiSize: to.Ptr("Standard_D2d_v4"),
		// 				NetworkingConfiguration: &armappservice.AseV3NetworkingConfiguration{
		// 					ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/configurations/networking"),
		// 					Properties: &armappservice.AseV3NetworkingConfigurationProperties{
		// 						AllowNewPrivateEndpointConnections: to.Ptr(false),
		// 						ExternalInboundIPAddresses: []*string{
		// 							to.Ptr("52.153.248.36")},
		// 							FtpEnabled: to.Ptr(false),
		// 							InternalInboundIPAddresses: []*string{
		// 							},
		// 							LinuxOutboundIPAddresses: []*string{
		// 								to.Ptr("20.88.241.56"),
		// 								to.Ptr("20.88.241.9")},
		// 								RemoteDebugEnabled: to.Ptr(false),
		// 								WindowsOutboundIPAddresses: []*string{
		// 									to.Ptr("20.88.241.56"),
		// 									to.Ptr("20.88.241.9")},
		// 								},
		// 							},
		// 							ProvisioningState: to.Ptr(armappservice.ProvisioningStateSucceeded),
		// 							Status: to.Ptr(armappservice.HostingEnvironmentStatusReady),
		// 							Suspended: to.Ptr(false),
		// 							VirtualNetwork: &armappservice.VirtualNetworkProfile{
		// 								Name: to.Ptr("delegated"),
		// 								Type: to.Ptr("Microsoft.Network/virtualNetworks/subnets"),
		// 								ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-subnet/subnets/delegated"),
		// 								Subnet: to.Ptr(""),
		// 							},
		// 							ZoneRedundant: to.Ptr(false),
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ListByResourceGroup.json
func ExampleEnvironmentsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewListByResourceGroupPager("test-rg", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.EnvironmentCollection = armappservice.EnvironmentCollection{
		// 	Value: []*armappservice.EnvironmentResource{
		// 		{
		// 			Name: to.Ptr("test-ase"),
		// 			Type: to.Ptr("Microsoft.Web/hostingEnvironments"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase"),
		// 			Kind: to.Ptr("ASEV3"),
		// 			Location: to.Ptr("South Central US"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armappservice.Environment{
		// 				DedicatedHostCount: to.Ptr[int32](0),
		// 				DNSSuffix: to.Ptr("test-ase.p.azurewebsites.net"),
		// 				FrontEndScaleFactor: to.Ptr[int32](15),
		// 				HasLinuxWorkers: to.Ptr(true),
		// 				InternalLoadBalancingMode: to.Ptr(armappservice.LoadBalancingModeNone),
		// 				IpsslAddressCount: to.Ptr[int32](0),
		// 				MaximumNumberOfMachines: to.Ptr[int32](250),
		// 				MultiSize: to.Ptr("Standard_D2d_v4"),
		// 				NetworkingConfiguration: &armappservice.AseV3NetworkingConfiguration{
		// 					ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/configurations/networking"),
		// 					Properties: &armappservice.AseV3NetworkingConfigurationProperties{
		// 						AllowNewPrivateEndpointConnections: to.Ptr(false),
		// 						ExternalInboundIPAddresses: []*string{
		// 							to.Ptr("52.153.248.36")},
		// 							FtpEnabled: to.Ptr(false),
		// 							InternalInboundIPAddresses: []*string{
		// 							},
		// 							LinuxOutboundIPAddresses: []*string{
		// 								to.Ptr("20.88.241.56"),
		// 								to.Ptr("20.88.241.9")},
		// 								RemoteDebugEnabled: to.Ptr(false),
		// 								WindowsOutboundIPAddresses: []*string{
		// 									to.Ptr("20.88.241.56"),
		// 									to.Ptr("20.88.241.9")},
		// 								},
		// 							},
		// 							ProvisioningState: to.Ptr(armappservice.ProvisioningStateSucceeded),
		// 							Status: to.Ptr(armappservice.HostingEnvironmentStatusReady),
		// 							Suspended: to.Ptr(false),
		// 							VirtualNetwork: &armappservice.VirtualNetworkProfile{
		// 								Name: to.Ptr("delegated"),
		// 								Type: to.Ptr("Microsoft.Network/virtualNetworks/subnets"),
		// 								ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-subnet/subnets/delegated"),
		// 								Subnet: to.Ptr(""),
		// 							},
		// 							ZoneRedundant: to.Ptr(false),
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_Get.json
func ExampleEnvironmentsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEnvironmentsClient().Get(ctx, "test-rg", "test-ase", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EnvironmentResource = armappservice.EnvironmentResource{
	// 	Name: to.Ptr("test-ase"),
	// 	Type: to.Ptr("Microsoft.Web/hostingEnvironments"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase"),
	// 	Kind: to.Ptr("ASEV3"),
	// 	Location: to.Ptr("South Central US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armappservice.Environment{
	// 		DedicatedHostCount: to.Ptr[int32](0),
	// 		DNSSuffix: to.Ptr("test-ase.p.azurewebsites.net"),
	// 		FrontEndScaleFactor: to.Ptr[int32](15),
	// 		HasLinuxWorkers: to.Ptr(true),
	// 		InternalLoadBalancingMode: to.Ptr(armappservice.LoadBalancingModeNone),
	// 		IpsslAddressCount: to.Ptr[int32](0),
	// 		MaximumNumberOfMachines: to.Ptr[int32](250),
	// 		MultiSize: to.Ptr("Standard_D2d_v4"),
	// 		NetworkingConfiguration: &armappservice.AseV3NetworkingConfiguration{
	// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/configurations/networking"),
	// 			Properties: &armappservice.AseV3NetworkingConfigurationProperties{
	// 				AllowNewPrivateEndpointConnections: to.Ptr(false),
	// 				ExternalInboundIPAddresses: []*string{
	// 					to.Ptr("52.153.248.36")},
	// 					FtpEnabled: to.Ptr(false),
	// 					InternalInboundIPAddresses: []*string{
	// 					},
	// 					LinuxOutboundIPAddresses: []*string{
	// 						to.Ptr("20.88.241.56"),
	// 						to.Ptr("20.88.241.9")},
	// 						RemoteDebugEnabled: to.Ptr(false),
	// 						WindowsOutboundIPAddresses: []*string{
	// 							to.Ptr("20.88.241.56"),
	// 							to.Ptr("20.88.241.9")},
	// 						},
	// 					},
	// 					ProvisioningState: to.Ptr(armappservice.ProvisioningStateSucceeded),
	// 					Status: to.Ptr(armappservice.HostingEnvironmentStatusReady),
	// 					Suspended: to.Ptr(false),
	// 					VirtualNetwork: &armappservice.VirtualNetworkProfile{
	// 						Name: to.Ptr("delegated"),
	// 						Type: to.Ptr("Microsoft.Network/virtualNetworks/subnets"),
	// 						ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-subnet/subnets/delegated"),
	// 						Subnet: to.Ptr(""),
	// 					},
	// 					ZoneRedundant: to.Ptr(false),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_CreateOrUpdate.json
func ExampleEnvironmentsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEnvironmentsClient().BeginCreateOrUpdate(ctx, "test-rg", "test-ase", armappservice.EnvironmentResource{
		Kind:     to.Ptr("Asev3"),
		Location: to.Ptr("South Central US"),
		Properties: &armappservice.Environment{
			VirtualNetwork: &armappservice.VirtualNetworkProfile{
				ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/delegated"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EnvironmentResource = armappservice.EnvironmentResource{
	// 	Name: to.Ptr("test-ase"),
	// 	Type: to.Ptr("Microsoft.Web/hostingEnvironments"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase"),
	// 	Kind: to.Ptr("ASEV3"),
	// 	Location: to.Ptr("South Central US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armappservice.Environment{
	// 		DedicatedHostCount: to.Ptr[int32](0),
	// 		DNSSuffix: to.Ptr("test-ase.p.azurewebsites.net"),
	// 		FrontEndScaleFactor: to.Ptr[int32](15),
	// 		HasLinuxWorkers: to.Ptr(true),
	// 		InternalLoadBalancingMode: to.Ptr(armappservice.LoadBalancingModeNone),
	// 		IpsslAddressCount: to.Ptr[int32](0),
	// 		MaximumNumberOfMachines: to.Ptr[int32](250),
	// 		MultiSize: to.Ptr("Standard_D2d_v4"),
	// 		NetworkingConfiguration: &armappservice.AseV3NetworkingConfiguration{
	// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/configurations/networking"),
	// 			Properties: &armappservice.AseV3NetworkingConfigurationProperties{
	// 				AllowNewPrivateEndpointConnections: to.Ptr(false),
	// 				ExternalInboundIPAddresses: []*string{
	// 					to.Ptr("52.153.248.36")},
	// 					FtpEnabled: to.Ptr(false),
	// 					InternalInboundIPAddresses: []*string{
	// 					},
	// 					LinuxOutboundIPAddresses: []*string{
	// 						to.Ptr("20.88.241.56"),
	// 						to.Ptr("20.88.241.9")},
	// 						RemoteDebugEnabled: to.Ptr(false),
	// 						WindowsOutboundIPAddresses: []*string{
	// 							to.Ptr("20.88.241.56"),
	// 							to.Ptr("20.88.241.9")},
	// 						},
	// 					},
	// 					ProvisioningState: to.Ptr(armappservice.ProvisioningStateSucceeded),
	// 					Status: to.Ptr(armappservice.HostingEnvironmentStatusReady),
	// 					Suspended: to.Ptr(false),
	// 					VirtualNetwork: &armappservice.VirtualNetworkProfile{
	// 						Name: to.Ptr("delegated"),
	// 						Type: to.Ptr("Microsoft.Network/virtualNetworks/subnets"),
	// 						ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-subnet/subnets/delegated"),
	// 						Subnet: to.Ptr(""),
	// 					},
	// 					ZoneRedundant: to.Ptr(false),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_Delete.json
func ExampleEnvironmentsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEnvironmentsClient().BeginDelete(ctx, "test-rg", "test-ase", &armappservice.EnvironmentsClientBeginDeleteOptions{ForceDelete: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_Update.json
func ExampleEnvironmentsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEnvironmentsClient().Update(ctx, "test-rg", "test-ase", armappservice.EnvironmentPatchResource{
		Properties: &armappservice.Environment{
			FrontEndScaleFactor: to.Ptr[int32](20),
			VirtualNetwork: &armappservice.VirtualNetworkProfile{
				ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-subnet/subnets/delegated"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.EnvironmentResource = armappservice.EnvironmentResource{
	// 	Name: to.Ptr("test-ase"),
	// 	Type: to.Ptr("Microsoft.Web/hostingEnvironments"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase"),
	// 	Kind: to.Ptr("ASEV3"),
	// 	Location: to.Ptr("South Central US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armappservice.Environment{
	// 		DedicatedHostCount: to.Ptr[int32](0),
	// 		DNSSuffix: to.Ptr("test-ase.p.azurewebsites.net"),
	// 		FrontEndScaleFactor: to.Ptr[int32](15),
	// 		HasLinuxWorkers: to.Ptr(true),
	// 		InternalLoadBalancingMode: to.Ptr(armappservice.LoadBalancingModeNone),
	// 		IpsslAddressCount: to.Ptr[int32](0),
	// 		MaximumNumberOfMachines: to.Ptr[int32](250),
	// 		MultiSize: to.Ptr("Standard_D2d_v4"),
	// 		NetworkingConfiguration: &armappservice.AseV3NetworkingConfiguration{
	// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/configurations/networking"),
	// 			Properties: &armappservice.AseV3NetworkingConfigurationProperties{
	// 				AllowNewPrivateEndpointConnections: to.Ptr(false),
	// 				ExternalInboundIPAddresses: []*string{
	// 					to.Ptr("52.153.248.36")},
	// 					FtpEnabled: to.Ptr(false),
	// 					InternalInboundIPAddresses: []*string{
	// 					},
	// 					LinuxOutboundIPAddresses: []*string{
	// 						to.Ptr("20.88.241.56"),
	// 						to.Ptr("20.88.241.9")},
	// 						RemoteDebugEnabled: to.Ptr(false),
	// 						WindowsOutboundIPAddresses: []*string{
	// 							to.Ptr("20.88.241.56"),
	// 							to.Ptr("20.88.241.9")},
	// 						},
	// 					},
	// 					ProvisioningState: to.Ptr(armappservice.ProvisioningStateSucceeded),
	// 					Status: to.Ptr(armappservice.HostingEnvironmentStatusReady),
	// 					Suspended: to.Ptr(false),
	// 					VirtualNetwork: &armappservice.VirtualNetworkProfile{
	// 						Name: to.Ptr("delegated"),
	// 						Type: to.Ptr("Microsoft.Network/virtualNetworks/subnets"),
	// 						ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-subnet/subnets/delegated"),
	// 						Subnet: to.Ptr(""),
	// 					},
	// 					ZoneRedundant: to.Ptr(false),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ListCapacities.json
func ExampleEnvironmentsClient_NewListCapacitiesPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewListCapacitiesPager("test-rg", "test-ase", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.StampCapacityCollection = armappservice.StampCapacityCollection{
		// 	Value: []*armappservice.StampCapacity{
		// 		{
		// 			AvailableCapacity: to.Ptr[int64](0),
		// 			ComputeMode: to.Ptr(armappservice.ComputeModeOptionsDedicated),
		// 			ExcludeFromCapacityAllocation: to.Ptr(false),
		// 			IsApplicableForAllComputeModes: to.Ptr(false),
		// 			IsLinux: to.Ptr(false),
		// 			TotalCapacity: to.Ptr[int64](1),
		// 			WorkerSizeID: to.Ptr[int32](0),
		// 		},
		// 		{
		// 			AvailableCapacity: to.Ptr[int64](0),
		// 			ComputeMode: to.Ptr(armappservice.ComputeModeOptionsDedicated),
		// 			ExcludeFromCapacityAllocation: to.Ptr(false),
		// 			IsApplicableForAllComputeModes: to.Ptr(false),
		// 			IsLinux: to.Ptr(false),
		// 			TotalCapacity: to.Ptr[int64](1),
		// 			WorkerSizeID: to.Ptr[int32](1),
		// 		},
		// 		{
		// 			AvailableCapacity: to.Ptr[int64](0),
		// 			ComputeMode: to.Ptr(armappservice.ComputeModeOptionsDedicated),
		// 			ExcludeFromCapacityAllocation: to.Ptr(false),
		// 			IsApplicableForAllComputeModes: to.Ptr(false),
		// 			IsLinux: to.Ptr(false),
		// 			TotalCapacity: to.Ptr[int64](1),
		// 			WorkerSizeID: to.Ptr[int32](2),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_GetVipInfo.json
func ExampleEnvironmentsClient_GetVipInfo() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEnvironmentsClient().GetVipInfo(ctx, "test-rg", "test-ase", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AddressResponse = armappservice.AddressResponse{
	// 	Name: to.Ptr("test-ase"),
	// 	Type: to.Ptr("Microsoft.Web/hostingEnvironments/capacities"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/Microsoft.Web/hostingEnvironments/test-ase/capacities/virtualip"),
	// 	Properties: &armappservice.AddressResponseProperties{
	// 		OutboundIPAddresses: []*string{
	// 			to.Ptr("20.112.141.120")},
	// 			ServiceIPAddress: to.Ptr("20.112.141.120"),
	// 			VipMappings: []*armappservice.VirtualIPMapping{
	// 				{
	// 					InUse: to.Ptr(false),
	// 					InternalHTTPPort: to.Ptr[int32](20003),
	// 					InternalHTTPSPort: to.Ptr[int32](20001),
	// 					VirtualIP: to.Ptr("20.112.141.135"),
	// 				},
	// 				{
	// 					InUse: to.Ptr(false),
	// 					InternalHTTPPort: to.Ptr[int32](20004),
	// 					InternalHTTPSPort: to.Ptr[int32](20002),
	// 					VirtualIP: to.Ptr("20.112.141.150"),
	// 			}},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ChangeVnet.json
func ExampleEnvironmentsClient_BeginChangeVnet() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEnvironmentsClient().BeginChangeVnet(ctx, "test-rg", "test-ase", armappservice.VirtualNetworkProfile{
		ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	for res.More() {
		page, err := res.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WebAppCollection = armappservice.WebAppCollection{
		// 	Value: []*armappservice.Site{
		// 	},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetAseCustomDnsSuffixConfiguration.json
func ExampleEnvironmentsClient_GetAseCustomDNSSuffixConfiguration() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEnvironmentsClient().GetAseCustomDNSSuffixConfiguration(ctx, "test-rg", "test-ase", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CustomDNSSuffixConfiguration = armappservice.CustomDNSSuffixConfiguration{
	// 	Name: to.Ptr("customDnsSuffix"),
	// 	Type: to.Ptr("Microsoft.Web/hostingEnvironments/configurations/customdnssuffix"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/configurations/customdnssuffix"),
	// 	Properties: &armappservice.CustomDNSSuffixConfigurationProperties{
	// 		CertificateURL: to.Ptr("https://test-kv.vault.azure.net/secrets/contosocert"),
	// 		DNSSuffix: to.Ptr("contoso.com"),
	// 		KeyVaultReferenceIdentity: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/test-rg/providers/microsoft.managedidentity/userassignedidentities/test-user-mi"),
	// 		ProvisioningState: to.Ptr(armappservice.CustomDNSSuffixProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/UpdateAseCustomDnsSuffixConfiguration.json
func ExampleEnvironmentsClient_UpdateAseCustomDNSSuffixConfiguration() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEnvironmentsClient().UpdateAseCustomDNSSuffixConfiguration(ctx, "test-rg", "test-ase", armappservice.CustomDNSSuffixConfiguration{
		Properties: &armappservice.CustomDNSSuffixConfigurationProperties{
			CertificateURL:            to.Ptr("https://test-kv.vault.azure.net/secrets/contosocert"),
			DNSSuffix:                 to.Ptr("contoso.com"),
			KeyVaultReferenceIdentity: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/test-rg/providers/microsoft.managedidentity/userassignedidentities/test-user-mi"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CustomDNSSuffixConfiguration = armappservice.CustomDNSSuffixConfiguration{
	// 	Name: to.Ptr("customDnsSuffix"),
	// 	Type: to.Ptr("Microsoft.Web/hostingEnvironments/configurations/customdnssuffix"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/configurations/customdnssuffix"),
	// 	Properties: &armappservice.CustomDNSSuffixConfigurationProperties{
	// 		CertificateURL: to.Ptr("https://test-kv.vault.azure.net/secrets/contosocert"),
	// 		DNSSuffix: to.Ptr("contoso.com"),
	// 		KeyVaultReferenceIdentity: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/test-rg/providers/microsoft.managedidentity/userassignedidentities/test-user-mi"),
	// 		ProvisioningState: to.Ptr(armappservice.CustomDNSSuffixProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/DeleteAseCustomDnsSuffixConfiguration.json
func ExampleEnvironmentsClient_DeleteAseCustomDNSSuffixConfiguration() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEnvironmentsClient().DeleteAseCustomDNSSuffixConfiguration(ctx, "test-rg", "test-ase", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Interface = map[string]any{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_GetAseV3NetworkingConfiguration.json
func ExampleEnvironmentsClient_GetAseV3NetworkingConfiguration() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEnvironmentsClient().GetAseV3NetworkingConfiguration(ctx, "test-rg", "test-ase", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AseV3NetworkingConfiguration = armappservice.AseV3NetworkingConfiguration{
	// 	Name: to.Ptr("networking"),
	// 	Type: to.Ptr("Microsoft.Web/hostingEnvironments/configurations/networking"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/configurations/networking"),
	// 	Properties: &armappservice.AseV3NetworkingConfigurationProperties{
	// 		AllowNewPrivateEndpointConnections: to.Ptr(false),
	// 		ExternalInboundIPAddresses: []*string{
	// 			to.Ptr("52.153.248.36")},
	// 			FtpEnabled: to.Ptr(false),
	// 			InternalInboundIPAddresses: []*string{
	// 			},
	// 			LinuxOutboundIPAddresses: []*string{
	// 				to.Ptr("20.88.241.56"),
	// 				to.Ptr("20.88.241.9")},
	// 				RemoteDebugEnabled: to.Ptr(false),
	// 				WindowsOutboundIPAddresses: []*string{
	// 					to.Ptr("20.88.241.56"),
	// 					to.Ptr("20.88.241.9")},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_UpdateAseNetworkingConfiguration.json
func ExampleEnvironmentsClient_UpdateAseNetworkingConfiguration() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEnvironmentsClient().UpdateAseNetworkingConfiguration(ctx, "test-rg", "test-ase", armappservice.AseV3NetworkingConfiguration{
		Properties: &armappservice.AseV3NetworkingConfigurationProperties{
			FtpEnabled:         to.Ptr(true),
			RemoteDebugEnabled: to.Ptr(true),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AseV3NetworkingConfiguration = armappservice.AseV3NetworkingConfiguration{
	// 	Name: to.Ptr("networking"),
	// 	Type: to.Ptr("Microsoft.Web/hostingEnvironments/configurations/networking"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/configurations/networking"),
	// 	Properties: &armappservice.AseV3NetworkingConfigurationProperties{
	// 		AllowNewPrivateEndpointConnections: to.Ptr(false),
	// 		ExternalInboundIPAddresses: []*string{
	// 			to.Ptr("52.153.248.36")},
	// 			FtpEnabled: to.Ptr(true),
	// 			InternalInboundIPAddresses: []*string{
	// 			},
	// 			LinuxOutboundIPAddresses: []*string{
	// 				to.Ptr("20.88.241.56"),
	// 				to.Ptr("20.88.241.9")},
	// 				RemoteDebugEnabled: to.Ptr(true),
	// 				WindowsOutboundIPAddresses: []*string{
	// 					to.Ptr("20.88.241.56"),
	// 					to.Ptr("20.88.241.9")},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ListDiagnostics.json
func ExampleEnvironmentsClient_ListDiagnostics() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEnvironmentsClient().ListDiagnostics(ctx, "test-rg", "test-ase", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.HostingEnvironmentDiagnosticsArray = []*armappservice.HostingEnvironmentDiagnostics{}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_GetDiagnosticsItem.json
func ExampleEnvironmentsClient_GetDiagnosticsItem() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEnvironmentsClient().GetDiagnosticsItem(ctx, "test-rg", "test-ase", "test-diagnostic", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.HostingEnvironmentDiagnostics = armappservice.HostingEnvironmentDiagnostics{
	// 	Name: to.Ptr("test-diagnostic"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetInboundNetworkDependenciesEndpoints.json
func ExampleEnvironmentsClient_NewGetInboundNetworkDependenciesEndpointsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewGetInboundNetworkDependenciesEndpointsPager("Sample-WestUSResourceGroup", "SampleAse", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.InboundEnvironmentEndpointCollection = armappservice.InboundEnvironmentEndpointCollection{
		// 	Value: []*armappservice.InboundEnvironmentEndpoint{
		// 		{
		// 			Description: to.Ptr("App Service management"),
		// 			Endpoints: []*string{
		// 				to.Ptr("70.37.57.58/32"),
		// 				to.Ptr("157.55.208.185/32"),
		// 				to.Ptr("23.102.188.65/32"),
		// 				to.Ptr("191.236.154.88/32"),
		// 				to.Ptr("52.174.22.21/32"),
		// 				to.Ptr("13.94.149.179/32"),
		// 				to.Ptr("13.94.143.126/32"),
		// 				to.Ptr("13.94.141.115/32"),
		// 				to.Ptr("52.178.195.197/32"),
		// 				to.Ptr("52.178.190.65/32"),
		// 				to.Ptr("52.178.184.149/32"),
		// 				to.Ptr("52.178.177.147/32"),
		// 				to.Ptr("13.75.127.117/32"),
		// 				to.Ptr("40.83.125.161/32"),
		// 				to.Ptr("40.83.121.56/32"),
		// 				to.Ptr("40.83.120.64/32"),
		// 				to.Ptr("52.187.56.50/32"),
		// 				to.Ptr("52.187.63.37/32"),
		// 				to.Ptr("52.187.59.251/32"),
		// 				to.Ptr("52.187.63.19/32"),
		// 				to.Ptr("52.165.158.140/32"),
		// 				to.Ptr("52.165.152.214/32"),
		// 				to.Ptr("52.165.154.193/32"),
		// 				to.Ptr("52.165.153.122/32"),
		// 				to.Ptr("104.44.129.255/32"),
		// 				to.Ptr("104.44.134.255/32"),
		// 				to.Ptr("104.44.129.243/32"),
		// 				to.Ptr("104.44.129.141/32"),
		// 				to.Ptr("65.52.193.203/32"),
		// 				to.Ptr("70.37.89.222/32"),
		// 				to.Ptr("13.64.115.203/32"),
		// 				to.Ptr("52.225.177.153/32"),
		// 				to.Ptr("65.52.172.237/32")},
		// 				Ports: []*string{
		// 					to.Ptr("454"),
		// 					to.Ptr("455")},
		// 				},
		// 				{
		// 					Description: to.Ptr("App Service Environment VIP"),
		// 					Endpoints: []*string{
		// 						to.Ptr("52.247.209.18/32")},
		// 						Ports: []*string{
		// 							to.Ptr("454"),
		// 							to.Ptr("455"),
		// 							to.Ptr("16001")},
		// 						},
		// 						{
		// 							Description: to.Ptr("App Service Environment subnet"),
		// 							Endpoints: []*string{
		// 								to.Ptr("192.168.250.0/24")},
		// 								Ports: []*string{
		// 									to.Ptr("All")},
		// 							}},
		// 						}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ListMultiRolePools.json
func ExampleEnvironmentsClient_NewListMultiRolePoolsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewListMultiRolePoolsPager("test-rg", "test-ase", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WorkerPoolCollection = armappservice.WorkerPoolCollection{
		// 	Value: []*armappservice.WorkerPoolResource{
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr("Microsoft.Web/hostingEnvironments/multiRolePools"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/multiRolePools/default"),
		// 			Properties: &armappservice.WorkerPool{
		// 				InstanceNames: []*string{
		// 					to.Ptr("10.7.1.8"),
		// 					to.Ptr("10.7.1.9")},
		// 					WorkerCount: to.Ptr[int32](2),
		// 					WorkerSize: to.Ptr("Standard_D1_V2"),
		// 				},
		// 				SKU: &armappservice.SKUDescription{
		// 					Name: to.Ptr("Q1"),
		// 					Capacity: to.Ptr[int32](2),
		// 					Family: to.Ptr("Q"),
		// 					Size: to.Ptr("Q1"),
		// 					Tier: to.Ptr("Quantum"),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_GetMultiRolePool.json
func ExampleEnvironmentsClient_GetMultiRolePool() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEnvironmentsClient().GetMultiRolePool(ctx, "test-rg", "test-ase", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WorkerPoolResource = armappservice.WorkerPoolResource{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Web/hostingEnvironments/multiRolePools"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/multiRolePools/default"),
	// 	Properties: &armappservice.WorkerPool{
	// 		InstanceNames: []*string{
	// 			to.Ptr("10.7.1.8"),
	// 			to.Ptr("10.7.1.9")},
	// 			WorkerCount: to.Ptr[int32](2),
	// 			WorkerSize: to.Ptr("Standard_D1_V2"),
	// 		},
	// 		SKU: &armappservice.SKUDescription{
	// 			Name: to.Ptr("Q1"),
	// 			Capacity: to.Ptr[int32](2),
	// 			Family: to.Ptr("Q"),
	// 			Size: to.Ptr("Q1"),
	// 			Tier: to.Ptr("Quantum"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_CreateOrUpdateMultiRolePool.json
func ExampleEnvironmentsClient_BeginCreateOrUpdateMultiRolePool() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEnvironmentsClient().BeginCreateOrUpdateMultiRolePool(ctx, "test-rg", "test-ase", armappservice.WorkerPoolResource{
		Properties: &armappservice.WorkerPool{
			WorkerCount: to.Ptr[int32](3),
			WorkerSize:  to.Ptr("Medium"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WorkerPoolResource = armappservice.WorkerPoolResource{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ListMultiRolePoolInstanceMetricDefinitions.json
func ExampleEnvironmentsClient_NewListMultiRolePoolInstanceMetricDefinitionsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewListMultiRolePoolInstanceMetricDefinitionsPager("test-rg", "test-ase", "10.7.1.8", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ResourceMetricDefinitionCollection = armappservice.ResourceMetricDefinitionCollection{
		// 	Value: []*armappservice.ResourceMetricDefinition{
		// 		{
		// 			Name: to.Ptr("CpuPercentage"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/metricdefinitions/cpupercentage"),
		// 		},
		// 		{
		// 			Name: to.Ptr("MemoryPercentage"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/metricdefinitions/MemoryPercentage"),
		// 		},
		// 		{
		// 			Name: to.Ptr("DiskQueueLength"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/metricdefinitions/DiskQueueLength"),
		// 		},
		// 		{
		// 			Name: to.Ptr("HttpQueueLength"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/metricdefinitions/HttpQueueLength"),
		// 		},
		// 		{
		// 			Name: to.Ptr("BytesReceived"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/metricdefinitions/BytesReceived"),
		// 		},
		// 		{
		// 			Name: to.Ptr("BytesSent"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/metricdefinitions/BytesSent"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ListMultiRoleMetricDefinitions.json
func ExampleEnvironmentsClient_NewListMultiRoleMetricDefinitionsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewListMultiRoleMetricDefinitionsPager("test-rg", "test-ase", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ResourceMetricDefinitionCollection = armappservice.ResourceMetricDefinitionCollection{
		// 	Value: []*armappservice.ResourceMetricDefinition{
		// 		{
		// 			Name: to.Ptr("CpuPercentage"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/metricdefinitions/cpupercentage"),
		// 		},
		// 		{
		// 			Name: to.Ptr("MemoryPercentage"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/metricdefinitions/MemoryPercentage"),
		// 		},
		// 		{
		// 			Name: to.Ptr("DiskQueueLength"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/metricdefinitions/DiskQueueLength"),
		// 		},
		// 		{
		// 			Name: to.Ptr("HttpQueueLength"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/metricdefinitions/HttpQueueLength"),
		// 		},
		// 		{
		// 			Name: to.Ptr("BytesReceived"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/metricdefinitions/BytesReceived"),
		// 		},
		// 		{
		// 			Name: to.Ptr("BytesSent"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/metricdefinitions/BytesSent"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ListMultiRolePoolSkus.json
func ExampleEnvironmentsClient_NewListMultiRolePoolSKUsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewListMultiRolePoolSKUsPager("test-rg", "test-ase", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SKUInfoCollection = armappservice.SKUInfoCollection{
		// 	Value: []*armappservice.SKUInfo{
		// 		{
		// 			Capacity: &armappservice.SKUCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](247),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr("automatic"),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Web/hostingEnvironments/multiRolePools"),
		// 			SKU: &armappservice.SKUDescription{
		// 				Name: to.Ptr("S2"),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armappservice.SKUCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](247),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr("automatic"),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Web/hostingEnvironments/multiRolePools"),
		// 			SKU: &armappservice.SKUDescription{
		// 				Name: to.Ptr("S3"),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armappservice.SKUCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](247),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr("automatic"),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Web/hostingEnvironments/multiRolePools"),
		// 			SKU: &armappservice.SKUDescription{
		// 				Name: to.Ptr("S4"),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armappservice.SKUCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](247),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr("automatic"),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Web/hostingEnvironments/multiRolePools"),
		// 			SKU: &armappservice.SKUDescription{
		// 				Name: to.Ptr("O2"),
		// 				Tier: to.Ptr("Optimized"),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armappservice.SKUCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](247),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr("automatic"),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Web/hostingEnvironments/multiRolePools"),
		// 			SKU: &armappservice.SKUDescription{
		// 				Name: to.Ptr("O3"),
		// 				Tier: to.Ptr("Optimized"),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armappservice.SKUCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](247),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr("automatic"),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Web/hostingEnvironments/multiRolePools"),
		// 			SKU: &armappservice.SKUDescription{
		// 				Name: to.Ptr("O4"),
		// 				Tier: to.Ptr("Optimized"),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armappservice.SKUCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](247),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr("automatic"),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Web/hostingEnvironments/multiRolePools"),
		// 			SKU: &armappservice.SKUDescription{
		// 				Name: to.Ptr("Q1"),
		// 				Tier: to.Ptr("Quantum"),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armappservice.SKUCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](247),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr("automatic"),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Web/hostingEnvironments/multiRolePools"),
		// 			SKU: &armappservice.SKUDescription{
		// 				Name: to.Ptr("Q2"),
		// 				Tier: to.Ptr("Quantum"),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armappservice.SKUCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](247),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr("automatic"),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Web/hostingEnvironments/multiRolePools"),
		// 			SKU: &armappservice.SKUDescription{
		// 				Name: to.Ptr("Q3"),
		// 				Tier: to.Ptr("Quantum"),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armappservice.SKUCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](247),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr("automatic"),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Web/hostingEnvironments/multiRolePools"),
		// 			SKU: &armappservice.SKUDescription{
		// 				Name: to.Ptr("Q4"),
		// 				Tier: to.Ptr("Quantum"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_TestUpgradeAvailableNotification.json
func ExampleEnvironmentsClient_TestUpgradeAvailableNotification() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewEnvironmentsClient().TestUpgradeAvailableNotification(ctx, "rg", "SampleHostingEnvironment", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_Upgrade.json
func ExampleEnvironmentsClient_BeginUpgrade() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEnvironmentsClient().BeginUpgrade(ctx, "rg", "SampleHostingEnvironment", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ListMultiRoleUsages.json
func ExampleEnvironmentsClient_NewListMultiRoleUsagesPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewListMultiRoleUsagesPager("test-rg", "test-ase", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageCollection = armappservice.UsageCollection{
		// 	Value: []*armappservice.Usage{
		// 	},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ListOperations.json
func ExampleEnvironmentsClient_ListOperations() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEnvironmentsClient().ListOperations(ctx, "test-rg", "test-ase", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationArray = []*armappservice.Operation{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/GetOutboundNetworkDependenciesEndpoints.json
func ExampleEnvironmentsClient_NewGetOutboundNetworkDependenciesEndpointsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewGetOutboundNetworkDependenciesEndpointsPager("Sample-WestUSResourceGroup", "SampleAse", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OutboundEnvironmentEndpointCollection = armappservice.OutboundEnvironmentEndpointCollection{
		// 	Value: []*armappservice.OutboundEnvironmentEndpoint{
		// 		{
		// 			Category: to.Ptr("Azure Storage"),
		// 			Endpoints: []*armappservice.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("blob.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("52.183.104.36"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](42.0469),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("52.183.104.36"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](41.7038),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("queue.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("52.183.104.25"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](37.326),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("52.183.104.25"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](37.513600000000004),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("table.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("52.183.104.26"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](32.789),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("52.183.104.26"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](1.8702),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("file.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("52.183.104.28"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](36.7378),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("52.183.104.28"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](36.7108),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("blob.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.64"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](4.0261000000000005),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.64"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.8264),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("queue.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.73"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](40.8523),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.73"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](40.7501),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("table.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.74"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](1.2071),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.74"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](38.2975),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("file.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.76"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](59.383700000000005),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.76"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](60.0775),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("blob.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.64"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.5512),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.64"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](2.6777),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("queue.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.73"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.5204),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.73"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](2.8193),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("table.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.74"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.2720000000000002),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.74"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.0147),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("file.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.76"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.2387),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.76"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.2804),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("blob.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.66.176.16"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](43.025200000000005),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.66.176.16"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](43.1683),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("queue.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.66.176.25"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](41.8598),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.66.176.25"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](41.9805),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("table.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.66.176.26"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](30.542900000000003),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.66.176.26"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](0.9832000000000001),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("file.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.66.176.28"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](35.9562),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.66.176.28"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](36.0643),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("blob.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.64"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.2829),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.64"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](2.3393),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("queue.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.73"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.4103000000000003),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.73"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](4.1032),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("table.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.74"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.1141),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.74"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.0247),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("file.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.76"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](2.834),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.76"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](2.8198000000000003),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("blob.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.64"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](1.3855000000000002),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.64"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](1.0594000000000001),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("queue.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.73"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](2.4717000000000002),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.73"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](2.4827),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("table.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.74"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.395),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.74"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.1701),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("file.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.76"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](1.4308),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.76"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](22.5866),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("blob.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.64"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](2.5372),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.64"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](2.4626),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("queue.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.73"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.7873),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.73"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](4.1911000000000005),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("table.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.74"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](2.9162000000000003),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.74"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](2.7896),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("file.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.76"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](26.723100000000002),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("13.77.184.76"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](26.735200000000003),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("Azure SQL Database"),
		// 			Endpoints: []*armappservice.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("database.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.66.226.202"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](1.5964),
		// 							Port: to.Ptr[int32](1433),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("Azure Management"),
		// 			Endpoints: []*armappservice.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("management.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("23.102.135.246"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](46.5764),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("admin.core.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("23.102.135.247"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](47.408),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("management.azure.com"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("52.151.25.45"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.9529),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("Azure Active Directory"),
		// 			Endpoints: []*armappservice.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("graph.windows.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("20.190.133.83"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.2264),
		// 							Port: to.Ptr[int32](443),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("20.190.133.81"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.2264),
		// 							Port: to.Ptr[int32](443),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("20.190.133.67"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.2264),
		// 							Port: to.Ptr[int32](443),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("40.126.5.34"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.2264),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("Regional Service"),
		// 			Endpoints: []*armappservice.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("gr-prod-mwh.cloudapp.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("13.66.225.188"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](3.3826),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("az-prod.metrics.nsatc.net"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("40.77.24.27"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](38.5647),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("SSL Certificate Verification"),
		// 			Endpoints: []*armappservice.EndpointDependency{
		// 				{
		// 					DomainName: to.Ptr("ocsp.msocsp.com"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("104.18.25.243"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](6.0651),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("104.18.25.243"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](12.888),
		// 							Port: to.Ptr[int32](443),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("104.18.24.243"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](6.0651),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("104.18.24.243"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](12.888),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("mscrl.microsoft.com"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("152.199.4.33"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](6.742900000000001),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("152.199.4.33"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](7.436100000000001),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("crl.microsoft.com"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("23.215.102.10"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](25.136200000000002),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("23.215.102.10"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](25.0085),
		// 							Port: to.Ptr[int32](443),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("23.215.102.42"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](25.136200000000002),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("23.215.102.42"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](25.0085),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("www.microsoft.com"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("23.49.13.56"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](7.9229),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("23.49.13.56"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](8.4871),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("crl3.digicert.com"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("72.21.91.29"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](5.4074),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("72.21.91.29"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](5.577),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("ocsp.digicert.com"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("72.21.91.29"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](6.8989),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("72.21.91.29"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](5.667400000000001),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("cacerts.digicert.com"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("104.18.11.39"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](10.772400000000001),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("104.18.11.39"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](10.7705),
		// 							Port: to.Ptr[int32](443),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("104.18.10.39"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](10.772400000000001),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("104.18.10.39"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](10.7705),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					DomainName: to.Ptr("www.thawte.com"),
		// 					EndpointDetails: []*armappservice.EndpointDetail{
		// 						{
		// 							IPAddress: to.Ptr("54.69.98.161"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](47.532900000000005),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("54.69.98.161"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](48.5362),
		// 							Port: to.Ptr[int32](443),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("35.167.62.148"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](47.532900000000005),
		// 							Port: to.Ptr[int32](80),
		// 						},
		// 						{
		// 							IPAddress: to.Ptr("35.167.62.148"),
		// 							IsAccessible: to.Ptr(true),
		// 							Latency: to.Ptr[float64](48.5362),
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 			}},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_GetPrivateEndpointConnectionList.json
func ExampleEnvironmentsClient_NewGetPrivateEndpointConnectionListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewGetPrivateEndpointConnectionListPager("test-rg", "test-ase", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PrivateEndpointConnectionCollection = armappservice.PrivateEndpointConnectionCollection{
		// 	Value: []*armappservice.RemotePrivateEndpointConnectionARMResource{
		// 		{
		// 			Name: to.Ptr("fa38656c-034e-43d8-adce-fe06ce039c98"),
		// 			Type: to.Ptr("Microsoft.Web/hostingEnvironments/privateEndpointConnections"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/privateEndpointConnections/fa38656c-034e-43d8-adce-fe06ce039c98"),
		// 			Properties: &armappservice.RemotePrivateEndpointConnectionARMResourceProperties{
		// 				IPAddresses: []*string{
		// 				},
		// 				PrivateEndpoint: &armappservice.ArmIDWrapper{
		// 					ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Network/test-privateEndpoint"),
		// 				},
		// 				PrivateLinkServiceConnectionState: &armappservice.PrivateLinkConnectionState{
		// 					Description: to.Ptr("Please approve my connection, thanks!"),
		// 					ActionsRequired: to.Ptr("None"),
		// 					Status: to.Ptr("Disconnecting"),
		// 				},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_GetPrivateEndpointConnection.json
func ExampleEnvironmentsClient_GetPrivateEndpointConnection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEnvironmentsClient().GetPrivateEndpointConnection(ctx, "test-rg", "test-ase", "fa38656c-034e-43d8-adce-fe06ce039c98", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RemotePrivateEndpointConnectionARMResource = armappservice.RemotePrivateEndpointConnectionARMResource{
	// 	Name: to.Ptr("fa38656c-034e-43d8-adce-fe06ce039c98"),
	// 	Type: to.Ptr("Microsoft.Web/hostingEnvironments/privateEndpointConnections"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/privateEndpointConnections/fa38656c-034e-43d8-adce-fe06ce039c98"),
	// 	Properties: &armappservice.RemotePrivateEndpointConnectionARMResourceProperties{
	// 		IPAddresses: []*string{
	// 		},
	// 		PrivateEndpoint: &armappservice.ArmIDWrapper{
	// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Network/test-privateEndpoint"),
	// 		},
	// 		PrivateLinkServiceConnectionState: &armappservice.PrivateLinkConnectionState{
	// 			Description: to.Ptr("Please approve my connection, thanks!"),
	// 			ActionsRequired: to.Ptr("None"),
	// 			Status: to.Ptr("Disconnecting"),
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ApproveOrRejectPrivateEndpointConnection.json
func ExampleEnvironmentsClient_BeginApproveOrRejectPrivateEndpointConnection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEnvironmentsClient().BeginApproveOrRejectPrivateEndpointConnection(ctx, "test-rg", "test-ase", "fa38656c-034e-43d8-adce-fe06ce039c98", armappservice.PrivateLinkConnectionApprovalRequestResource{
		Properties: &armappservice.PrivateLinkConnectionApprovalRequest{
			PrivateLinkServiceConnectionState: &armappservice.PrivateLinkConnectionState{
				Description: to.Ptr("Approved by johndoe@company.com"),
				Status:      to.Ptr("Approved"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RemotePrivateEndpointConnectionARMResource = armappservice.RemotePrivateEndpointConnectionARMResource{
	// 	Name: to.Ptr("fa38656c-034e-43d8-adce-fe06ce039c98"),
	// 	Type: to.Ptr("Microsoft.Web/hostingEnvironments/privateEndpointConnections"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/privateEndpointConnections/fa38656c-034e-43d8-adce-fe06ce039c98"),
	// 	Properties: &armappservice.RemotePrivateEndpointConnectionARMResourceProperties{
	// 		IPAddresses: []*string{
	// 		},
	// 		PrivateEndpoint: &armappservice.ArmIDWrapper{
	// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Network/test-privateEndpoint"),
	// 		},
	// 		PrivateLinkServiceConnectionState: &armappservice.PrivateLinkConnectionState{
	// 			Description: to.Ptr("Approved by johndoe@company.com"),
	// 			ActionsRequired: to.Ptr("None"),
	// 			Status: to.Ptr("Approved"),
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_DeletePrivateEndpointConnection.json
func ExampleEnvironmentsClient_BeginDeletePrivateEndpointConnection() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEnvironmentsClient().BeginDeletePrivateEndpointConnection(ctx, "test-rg", "test-ase", "fa38656c-034e-43d8-adce-fe06ce039c98", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Interface = map[string]any{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_GetPrivateLinkResources.json
func ExampleEnvironmentsClient_GetPrivateLinkResources() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEnvironmentsClient().GetPrivateLinkResources(ctx, "test-rg", "test-ase", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PrivateLinkResourcesWrapper = armappservice.PrivateLinkResourcesWrapper{
	// 	Value: []*armappservice.PrivateLinkResource{
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_Reboot.json
func ExampleEnvironmentsClient_Reboot() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewEnvironmentsClient().Reboot(ctx, "test-rg", "test-ase", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_Resume.json
func ExampleEnvironmentsClient_BeginResume() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEnvironmentsClient().BeginResume(ctx, "test-rg", "test-ase", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	for res.More() {
		page, err := res.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WebAppCollection = armappservice.WebAppCollection{
		// 	Value: []*armappservice.Site{
		// 	},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ListAppServicePlans.json
func ExampleEnvironmentsClient_NewListAppServicePlansPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewListAppServicePlansPager("test-rg", "test-ase", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PlanCollection = armappservice.PlanCollection{
		// 	Value: []*armappservice.Plan{
		// 		{
		// 			Name: to.Ptr("test-asp"),
		// 			Type: to.Ptr("Microsoft.Web/serverfarms"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/serverfarms/test-asp"),
		// 			Kind: to.Ptr("app"),
		// 			Location: to.Ptr("Central US EUAP"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armappservice.PlanProperties{
		// 				ElasticScaleEnabled: to.Ptr(false),
		// 				GeoRegion: to.Ptr("Central US EUAP"),
		// 				HostingEnvironmentProfile: &armappservice.HostingEnvironmentProfile{
		// 					Name: to.Ptr("test-ase"),
		// 					Type: to.Ptr("Microsoft.Web/hostingEnvironments"),
		// 					ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase"),
		// 				},
		// 				HyperV: to.Ptr(false),
		// 				IsSpot: to.Ptr(false),
		// 				IsXenon: to.Ptr(false),
		// 				MaximumElasticWorkerCount: to.Ptr[int32](0),
		// 				MaximumNumberOfWorkers: to.Ptr[int32](100),
		// 				NumberOfSites: to.Ptr[int32](0),
		// 				PerSiteScaling: to.Ptr(false),
		// 				ProvisioningState: to.Ptr(armappservice.ProvisioningStateSucceeded),
		// 				Reserved: to.Ptr(false),
		// 				ResourceGroup: to.Ptr("test-rg"),
		// 				Status: to.Ptr(armappservice.StatusOptionsReady),
		// 				Subscription: to.Ptr("34adfa4f-cedf-4dc0-ba29-b6d1a69ab345"),
		// 				TargetWorkerCount: to.Ptr[int32](1),
		// 				TargetWorkerSizeID: to.Ptr[int32](0),
		// 				ZoneRedundant: to.Ptr(false),
		// 			},
		// 			SKU: &armappservice.SKUDescription{
		// 				Name: to.Ptr("I1"),
		// 				Capacity: to.Ptr[int32](0),
		// 				Family: to.Ptr("I"),
		// 				Size: to.Ptr("I1"),
		// 				Tier: to.Ptr("Isolated"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ListWebApps.json
func ExampleEnvironmentsClient_NewListWebAppsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewListWebAppsPager("test-rg", "test-ase", &armappservice.EnvironmentsClientListWebAppsOptions{PropertiesToInclude: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WebAppCollection = armappservice.WebAppCollection{
		// 	Value: []*armappservice.Site{
		// 		{
		// 			Name: to.Ptr("test-site"),
		// 			Type: to.Ptr("Microsoft.Web/sites"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/sites/test-site"),
		// 			Location: to.Ptr("Central US EUAP"),
		// 			Properties: &armappservice.SiteProperties{
		// 				AvailabilityState: to.Ptr(armappservice.SiteAvailabilityStateNormal),
		// 				ClientAffinityEnabled: to.Ptr(true),
		// 				ClientCertEnabled: to.Ptr(false),
		// 				ClientCertMode: to.Ptr(armappservice.ClientCertModeRequired),
		// 				ContainerSize: to.Ptr[int32](0),
		// 				CustomDomainVerificationID: to.Ptr("2982A67AD520FBCD070650FC77814FB03B62927C6EFCA2F5FF3BF5DC60088845"),
		// 				DailyMemoryTimeQuota: to.Ptr[int32](0),
		// 				DefaultHostName: to.Ptr("test-site.test-ase.p.azurewebsites.net"),
		// 				Enabled: to.Ptr(true),
		// 				EnabledHostNames: []*string{
		// 					to.Ptr("test-site.test-ase.p.azurewebsites.net"),
		// 					to.Ptr("test-site.scm.test-ase.p.azurewebsites.net")},
		// 					HostNameSSLStates: []*armappservice.HostNameSSLState{
		// 						{
		// 							Name: to.Ptr("test-site.test-ase.p.azurewebsites.net"),
		// 							HostType: to.Ptr(armappservice.HostTypeStandard),
		// 							SSLState: to.Ptr(armappservice.SSLStateDisabled),
		// 						},
		// 						{
		// 							Name: to.Ptr("test-site.scm.test-ase.p.azurewebsites.net"),
		// 							HostType: to.Ptr(armappservice.HostTypeRepository),
		// 							SSLState: to.Ptr(armappservice.SSLStateDisabled),
		// 					}},
		// 					HostNames: []*string{
		// 						to.Ptr("test-site.test-ase.p.azurewebsites.net")},
		// 						HostNamesDisabled: to.Ptr(false),
		// 						HostingEnvironmentProfile: &armappservice.HostingEnvironmentProfile{
		// 							Name: to.Ptr("test-ase"),
		// 							Type: to.Ptr("Microsoft.Web/hostingEnvironments"),
		// 							ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase"),
		// 						},
		// 						HTTPSOnly: to.Ptr(false),
		// 						HyperV: to.Ptr(false),
		// 						IsXenon: to.Ptr(false),
		// 						KeyVaultReferenceIdentity: to.Ptr("SystemAssigned"),
		// 						LastModifiedTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-04-08T12:41:04.123Z"); return t}()),
		// 						OutboundIPAddresses: to.Ptr("20.112.141.120"),
		// 						PossibleOutboundIPAddresses: to.Ptr("20.112.141.120"),
		// 						RedundancyMode: to.Ptr(armappservice.RedundancyModeNone),
		// 						RepositorySiteName: to.Ptr("test-site"),
		// 						Reserved: to.Ptr(false),
		// 						ResourceGroup: to.Ptr("test-rg"),
		// 						ScmSiteAlsoStopped: to.Ptr(false),
		// 						ServerFarmID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/serverfarms/test-serverfarm"),
		// 						SiteConfig: &armappservice.SiteConfig{
		// 							FunctionAppScaleLimit: to.Ptr[int32](0),
		// 							LinuxFxVersion: to.Ptr(""),
		// 							MinimumElasticInstanceCount: to.Ptr[int32](0),
		// 							NumberOfWorkers: to.Ptr[int32](1),
		// 						},
		// 						State: to.Ptr("Running"),
		// 						StorageAccountRequired: to.Ptr(false),
		// 						UsageState: to.Ptr(armappservice.UsageStateNormal),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_Suspend.json
func ExampleEnvironmentsClient_BeginSuspend() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEnvironmentsClient().BeginSuspend(ctx, "test-rg", "test-ase", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	for res.More() {
		page, err := res.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WebAppCollection = armappservice.WebAppCollection{
		// 	Value: []*armappservice.Site{
		// 	},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ListUsages.json
func ExampleEnvironmentsClient_NewListUsagesPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewListUsagesPager("test-rg", "test-ase", &armappservice.EnvironmentsClientListUsagesOptions{Filter: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CsmUsageQuotaCollection = armappservice.CsmUsageQuotaCollection{
		// 	Value: []*armappservice.CsmUsageQuota{
		// 		{
		// 			Name: &armappservice.LocalizableString{
		// 				LocalizedValue: to.Ptr("File System Storage"),
		// 				Value: to.Ptr("FileSystemStorage"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](37888),
		// 			Limit: to.Ptr[int64](1099511627776),
		// 			NextResetTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "9999-12-31T23:59:59.999Z"); return t}()),
		// 			Unit: to.Ptr("Bytes"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ListWorkerPools.json
func ExampleEnvironmentsClient_NewListWorkerPoolsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewListWorkerPoolsPager("test-rg", "test-ase", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.WorkerPoolCollection = armappservice.WorkerPoolCollection{
		// 	Value: []*armappservice.WorkerPoolResource{
		// 		{
		// 			Name: to.Ptr("workerPool1"),
		// 			Type: to.Ptr("Microsoft.Web/hostingEnvironments/workerPools"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/workerPools/workerPool1"),
		// 			Kind: to.Ptr("ASEV1"),
		// 			Properties: &armappservice.WorkerPool{
		// 				InstanceNames: []*string{
		// 				},
		// 				WorkerCount: to.Ptr[int32](2),
		// 				WorkerSize: to.Ptr("Small"),
		// 				WorkerSizeID: to.Ptr[int32](0),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("workerPool2"),
		// 			Type: to.Ptr("Microsoft.Web/hostingEnvironments/workerPools"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/workerPools/workerPool2"),
		// 			Kind: to.Ptr("ASEV1"),
		// 			Properties: &armappservice.WorkerPool{
		// 				InstanceNames: []*string{
		// 				},
		// 				WorkerCount: to.Ptr[int32](0),
		// 				WorkerSize: to.Ptr("Small"),
		// 				WorkerSizeID: to.Ptr[int32](1),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("workerPool3"),
		// 			Type: to.Ptr("Microsoft.Web/hostingEnvironments/workerPools"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/workerPools/workerPool3"),
		// 			Kind: to.Ptr("ASEV1"),
		// 			Properties: &armappservice.WorkerPool{
		// 				InstanceNames: []*string{
		// 				},
		// 				WorkerCount: to.Ptr[int32](0),
		// 				WorkerSize: to.Ptr("Small"),
		// 				WorkerSizeID: to.Ptr[int32](2),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_GetWorkerPool.json
func ExampleEnvironmentsClient_GetWorkerPool() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewEnvironmentsClient().GetWorkerPool(ctx, "test-rg", "test-ase", "workerPool1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WorkerPoolResource = armappservice.WorkerPoolResource{
	// 	Name: to.Ptr("workerPool1"),
	// 	Type: to.Ptr("Microsoft.Web/hostingEnvironments/workerPools"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/workerPools/workerPool1"),
	// 	Kind: to.Ptr("ASEV1"),
	// 	Properties: &armappservice.WorkerPool{
	// 		InstanceNames: []*string{
	// 		},
	// 		WorkerCount: to.Ptr[int32](2),
	// 		WorkerSize: to.Ptr("Small"),
	// 		WorkerSizeID: to.Ptr[int32](0),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_CreateOrUpdateWorkerPool.json
func ExampleEnvironmentsClient_BeginCreateOrUpdateWorkerPool() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewEnvironmentsClient().BeginCreateOrUpdateWorkerPool(ctx, "test-rg", "test-ase", "0", armappservice.WorkerPoolResource{
		Properties: &armappservice.WorkerPool{
			WorkerCount: to.Ptr[int32](3),
			WorkerSize:  to.Ptr("Small"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WorkerPoolResource = armappservice.WorkerPoolResource{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ListWorkerPoolInstanceMetricDefinitions.json
func ExampleEnvironmentsClient_NewListWorkerPoolInstanceMetricDefinitionsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewListWorkerPoolInstanceMetricDefinitionsPager("test-rg", "test-ase", "0", "10.8.0.7", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ResourceMetricDefinitionCollection = armappservice.ResourceMetricDefinitionCollection{
		// 	Value: []*armappservice.ResourceMetricDefinition{
		// 		{
		// 			Name: to.Ptr("CpuPercentage"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/workerPools/0/metricDefinitions/CpuPercentage"),
		// 		},
		// 		{
		// 			Name: to.Ptr("MemoryPercentage"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/workerPools/0/metricDefinitions/MemoryPercentage"),
		// 		},
		// 		{
		// 			Name: to.Ptr("DiskQueueLength"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/workerPools/0/metricDefinitions/DiskQueueLength"),
		// 		},
		// 		{
		// 			Name: to.Ptr("HttpQueueLength"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/workerPools/0/metricDefinitions/HttpQueueLength"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ListWebWorkerMetricDefinitions.json
func ExampleEnvironmentsClient_NewListWebWorkerMetricDefinitionsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewListWebWorkerMetricDefinitionsPager("test-rg", "test-ase", "0", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ResourceMetricDefinitionCollection = armappservice.ResourceMetricDefinitionCollection{
		// 	Value: []*armappservice.ResourceMetricDefinition{
		// 		{
		// 			Name: to.Ptr("CpuPercentage"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/workerPools/0/metricDefinitions/CpuPercentage"),
		// 		},
		// 		{
		// 			Name: to.Ptr("MemoryPercentage"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/workerPools/0/metricDefinitions/MemoryPercentage"),
		// 		},
		// 		{
		// 			Name: to.Ptr("DiskQueueLength"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/workerPools/0/metricDefinitions/DiskQueueLength"),
		// 		},
		// 		{
		// 			Name: to.Ptr("HttpQueueLength"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/test-rg/providers/Microsoft.Web/hostingEnvironments/test-ase/workerPools/0/metricDefinitions/HttpQueueLength"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ListWorkerPoolSkus.json
func ExampleEnvironmentsClient_NewListWorkerPoolSKUsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewListWorkerPoolSKUsPager("test-rg", "test-ase", "workerPool1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SKUInfoCollection = armappservice.SKUInfoCollection{
		// 	Value: []*armappservice.SKUInfo{
		// 		{
		// 			Capacity: &armappservice.SKUCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](53),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr("automatic"),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Web/hostingEnvironments/workerPools"),
		// 			SKU: &armappservice.SKUDescription{
		// 				Name: to.Ptr("S1"),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armappservice.SKUCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](53),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr("automatic"),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Web/hostingEnvironments/workerPools"),
		// 			SKU: &armappservice.SKUDescription{
		// 				Name: to.Ptr("S2"),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armappservice.SKUCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](53),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr("automatic"),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Web/hostingEnvironments/workerPools"),
		// 			SKU: &armappservice.SKUDescription{
		// 				Name: to.Ptr("S3"),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armappservice.SKUCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](53),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr("automatic"),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Web/hostingEnvironments/workerPools"),
		// 			SKU: &armappservice.SKUDescription{
		// 				Name: to.Ptr("S4"),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 		},
		// 		{
		// 			Capacity: &armappservice.SKUCapacity{
		// 				Default: to.Ptr[int32](2),
		// 				Maximum: to.Ptr[int32](53),
		// 				Minimum: to.Ptr[int32](2),
		// 				ScaleType: to.Ptr("automatic"),
		// 			},
		// 			ResourceType: to.Ptr("Microsoft.Web/hostingEnvironments/workerPools"),
		// 			SKU: &armappservice.SKUDescription{
		// 				Name: to.Ptr("O1"),
		// 				Tier: to.Ptr("Optimized"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/738ab25fe76324897f273645906d4a0415068a6c/specification/web/resource-manager/Microsoft.Web/stable/2023-01-01/examples/AppServiceEnvironments_ListWebWorkerUsages.json
func ExampleEnvironmentsClient_NewListWebWorkerUsagesPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armappservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewEnvironmentsClient().NewListWebWorkerUsagesPager("test-rg", "test-ase", "0", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsageCollection = armappservice.UsageCollection{
		// 	Value: []*armappservice.Usage{
		// 	},
		// }
	}
}
