//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurity

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// AdvancedThreatProtectionClient contains the methods for the AdvancedThreatProtection group.
// Don't use this type directly, use NewAdvancedThreatProtectionClient() instead.
type AdvancedThreatProtectionClient struct {
	internal *arm.Client
}

// NewAdvancedThreatProtectionClient creates a new instance of AdvancedThreatProtectionClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewAdvancedThreatProtectionClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*AdvancedThreatProtectionClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &AdvancedThreatProtectionClient{
		internal: cl,
	}
	return client, nil
}

// Create - Creates or updates the Advanced Threat Protection settings on a specified resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-01-01
//   - resourceID - The identifier of the resource.
//   - advancedThreatProtectionSetting - Advanced Threat Protection Settings
//   - options - AdvancedThreatProtectionClientCreateOptions contains the optional parameters for the AdvancedThreatProtectionClient.Create
//     method.
func (client *AdvancedThreatProtectionClient) Create(ctx context.Context, resourceID string, advancedThreatProtectionSetting AdvancedThreatProtectionSetting, options *AdvancedThreatProtectionClientCreateOptions) (AdvancedThreatProtectionClientCreateResponse, error) {
	var err error
	const operationName = "AdvancedThreatProtectionClient.Create"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceID, advancedThreatProtectionSetting, options)
	if err != nil {
		return AdvancedThreatProtectionClientCreateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AdvancedThreatProtectionClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AdvancedThreatProtectionClientCreateResponse{}, err
	}
	resp, err := client.createHandleResponse(httpResp)
	return resp, err
}

// createCreateRequest creates the Create request.
func (client *AdvancedThreatProtectionClient) createCreateRequest(ctx context.Context, resourceID string, advancedThreatProtectionSetting AdvancedThreatProtectionSetting, options *AdvancedThreatProtectionClientCreateOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/advancedThreatProtectionSettings/{settingName}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	urlPath = strings.ReplaceAll(urlPath, "{settingName}", url.PathEscape("current"))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, advancedThreatProtectionSetting); err != nil {
		return nil, err
	}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *AdvancedThreatProtectionClient) createHandleResponse(resp *http.Response) (AdvancedThreatProtectionClientCreateResponse, error) {
	result := AdvancedThreatProtectionClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AdvancedThreatProtectionSetting); err != nil {
		return AdvancedThreatProtectionClientCreateResponse{}, err
	}
	return result, nil
}

// Get - Gets the Advanced Threat Protection settings for the specified resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-01-01
//   - resourceID - The identifier of the resource.
//   - options - AdvancedThreatProtectionClientGetOptions contains the optional parameters for the AdvancedThreatProtectionClient.Get
//     method.
func (client *AdvancedThreatProtectionClient) Get(ctx context.Context, resourceID string, options *AdvancedThreatProtectionClientGetOptions) (AdvancedThreatProtectionClientGetResponse, error) {
	var err error
	const operationName = "AdvancedThreatProtectionClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceID, options)
	if err != nil {
		return AdvancedThreatProtectionClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AdvancedThreatProtectionClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AdvancedThreatProtectionClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *AdvancedThreatProtectionClient) getCreateRequest(ctx context.Context, resourceID string, options *AdvancedThreatProtectionClientGetOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/advancedThreatProtectionSettings/{settingName}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	urlPath = strings.ReplaceAll(urlPath, "{settingName}", url.PathEscape("current"))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *AdvancedThreatProtectionClient) getHandleResponse(resp *http.Response) (AdvancedThreatProtectionClientGetResponse, error) {
	result := AdvancedThreatProtectionClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AdvancedThreatProtectionSetting); err != nil {
		return AdvancedThreatProtectionClientGetResponse{}, err
	}
	return result, nil
}
