// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/baremetalsolution/v2/baremetalsolution.proto

package baremetalsolutionpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents the metadata from a long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the action executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user requested the cancellation
	// of the operation. Operations that have been successfully cancelled
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used with the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_rawDescGZIP(), []int{0}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Response message from resetting a server.
type ResetInstanceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ResetInstanceResponse) Reset() {
	*x = ResetInstanceResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResetInstanceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResetInstanceResponse) ProtoMessage() {}

func (x *ResetInstanceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResetInstanceResponse.ProtoReflect.Descriptor instead.
func (*ResetInstanceResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_rawDescGZIP(), []int{1}
}

var File_google_cloud_baremetalsolution_v2_baremetalsolution_proto protoreflect.FileDescriptor

var file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2f, 0x76, 0x32, 0x2f, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65,
	0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c,
	0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x6c, 0x75, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x6e, 0x66, 0x73, 0x5f, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61,
	0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x6f, 0x73, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74,
	0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2f, 0x76, 0x32, 0x2f, 0x73, 0x73, 0x68, 0x5f, 0x6b, 0x65, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x73, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd5, 0x02,
	0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17,
	0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x17, 0x0a, 0x15, 0x52, 0x65, 0x73, 0x65, 0x74, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32, 0xba,
	0x4b, 0x0a, 0x11, 0x42, 0x61, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x6c, 0x53, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0xc2, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0xaf, 0x01, 0x0a, 0x0b, 0x47, 0x65,
	0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74,
	0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65,
	0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x3c, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xea, 0x01, 0x0a, 0x0e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7f, 0xca, 0x41, 0x1d, 0x0a, 0x08, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x14, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x32, 0x36, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcf, 0x01, 0x0a, 0x0e, 0x52, 0x65, 0x6e,
	0x61, 0x6d, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d,
	0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e,
	0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x22, 0x56, 0xda, 0x41, 0x14, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6e, 0x65, 0x77, 0x5f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x39, 0x3a, 0x01, 0x2a, 0x22, 0x34, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xdb, 0x01, 0x0a, 0x0d, 0x52,
	0x65, 0x73, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65,
	0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x52, 0x65, 0x73, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x72, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x52, 0x65, 0x73, 0x65, 0x74,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38,
	0x3a, 0x01, 0x2a, 0x22, 0x33, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x65, 0x74, 0x12, 0xdb, 0x01, 0x0a, 0x0d, 0x53, 0x74, 0x61,
	0x72, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65,
	0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x53,
	0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x72, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x53, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x3a, 0x01,
	0x2a, 0x22, 0x33, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0xd7, 0x01, 0x0a, 0x0c, 0x53, 0x74, 0x6f, 0x70, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c,
	0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x6f, 0x70,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x70,
	0xca, 0x41, 0x29, 0x0a, 0x14, 0x53, 0x74, 0x6f, 0x70, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x3a, 0x01, 0x2a, 0x22, 0x32, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x6f, 0x70,
	0x12, 0xa8, 0x02, 0x0a, 0x1e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x73,
	0x6f, 0x6c, 0x65, 0x12, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x43,
	0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9c, 0x01, 0xca,
	0x41, 0x3b, 0x0a, 0x26, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x73, 0x6f,
	0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x3a, 0x01, 0x2a, 0x22, 0x4c, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65,
	0x72, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x12, 0xac, 0x02, 0x0a, 0x1f,
	0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x12,
	0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x73,
	0x6f, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9e, 0x01, 0xca, 0x41, 0x3c, 0x0a,
	0x27, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x3a, 0x01, 0x2a, 0x22, 0x4d, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x72,
	0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x65, 0x12, 0xd6, 0x01, 0x0a, 0x09, 0x44,
	0x65, 0x74, 0x61, 0x63, 0x68, 0x4c, 0x75, 0x6e, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61,
	0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x74,
	0x61, 0x63, 0x68, 0x4c, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x75, 0xca, 0x41,
	0x1d, 0x0a, 0x08, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2c, 0x6c, 0x75, 0x6e, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x40, 0x3a, 0x01, 0x2a, 0x22, 0x3b, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x74, 0x61, 0x63, 0x68,
	0x4c, 0x75, 0x6e, 0x12, 0xba, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x53, 0x48, 0x4b,
	0x65, 0x79, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x53, 0x48, 0x4b,
	0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65,
	0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x53, 0x48, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x3c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x73, 0x68, 0x4b, 0x65, 0x79, 0x73,
	0x12, 0xcb, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x53, 0x48, 0x4b, 0x65,
	0x79, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x53, 0x48, 0x4b,
	0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74,
	0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x53,
	0x48, 0x4b, 0x65, 0x79, 0x22, 0x58, 0xda, 0x41, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x73, 0x73, 0x68, 0x5f, 0x6b, 0x65, 0x79, 0x2c, 0x73, 0x73, 0x68, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x3a, 0x07, 0x73, 0x73, 0x68, 0x5f, 0x6b, 0x65,
	0x79, 0x22, 0x2b, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x73, 0x68, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x9a,
	0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x53, 0x48, 0x4b, 0x65, 0x79, 0x12,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x53, 0x48, 0x4b, 0x65, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x3a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x2a, 0x2b,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x73, 0x68, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xba, 0x01, 0x0a, 0x0b,
	0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d,
	0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3c, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x12, 0xa7, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74,
	0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d,
	0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e,
	0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x22, 0x3a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xdc, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x75, 0xca, 0x41, 0x1b, 0x0a,
	0x06, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x12, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x06, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x32, 0x32, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xc5, 0x01, 0x0a, 0x0c, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x56, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65,
	0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x22, 0x52, 0xda, 0x41, 0x12, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6e,
	0x65, 0x77, 0x5f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x37, 0x3a, 0x01, 0x2a, 0x22, 0x32, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd5, 0x01, 0x0a, 0x0b, 0x45, 0x76,
	0x69, 0x63, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74,
	0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x76,
	0x69, 0x63, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x70, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x3a, 0x01, 0x2a, 0x22, 0x31,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x76, 0x69, 0x63,
	0x74, 0x12, 0xd6, 0x01, 0x0a, 0x0c, 0x52, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x56, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0xca, 0x41, 0x1b, 0x0a, 0x06,
	0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0f, 0x76, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x2c, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x69, 0x62, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x39, 0x3a, 0x01, 0x2a, 0x22, 0x34, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x76, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x12, 0xbe, 0x01, 0x0a, 0x0c, 0x4c,
	0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d,
	0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0xdf, 0x01, 0x0a, 0x10,
	0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x73, 0x61, 0x67, 0x65,
	0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x55, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65,
	0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x73, 0x61, 0x67,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x52, 0xda, 0x41, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x3a, 0x6c, 0x69, 0x73,
	0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x73, 0x61, 0x67, 0x65, 0x12, 0xab, 0x01,
	0x0a, 0x0a, 0x47, 0x65, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65,
	0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x47, 0x65, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0x3b,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe3, 0x01, 0x0a, 0x0d,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72,
	0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7a, 0xca, 0x41, 0x1c, 0x0a, 0x07, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x13, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3f, 0x3a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x32, 0x34, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xf4, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65,
	0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65,
	0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x22, 0x69, 0xda,
	0x41, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f,
	0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x0f,
	0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x22,
	0x37, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x12, 0x95, 0x02, 0x0a, 0x15, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x9b, 0x01, 0xca, 0x41, 0x23, 0x0a, 0x0e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0f, 0x76, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x5d, 0x3a, 0x01, 0x2a, 0x22, 0x58, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x12, 0xb6, 0x01, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74,
	0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x46, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39,
	0x2a, 0x37, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcb, 0x01, 0x0a, 0x11, 0x47, 0x65,
	0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65,
	0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x22,
	0x46, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xde, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74,
	0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x12,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x48,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12,
	0x37, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x12, 0xa5, 0x01, 0x0a, 0x06, 0x47, 0x65, 0x74,
	0x4c, 0x75, 0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x75, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x75, 0x6e, 0x22, 0x41, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xb8, 0x01, 0x0a, 0x08, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x75, 0x6e, 0x73, 0x12, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72,
	0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x75, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c, 0x75, 0x6e, 0x73, 0x12, 0xd6, 0x01, 0x0a, 0x08,
	0x45, 0x76, 0x69, 0x63, 0x74, 0x4c, 0x75, 0x6e, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61,
	0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x76, 0x69,
	0x63, 0x74, 0x4c, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x77, 0xca, 0x41, 0x2a,
	0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x01, 0x2a, 0x22, 0x38, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x75, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65,
	0x76, 0x69, 0x63, 0x74, 0x12, 0xaf, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x4e, 0x66, 0x73, 0x53,
	0x68, 0x61, 0x72, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x4e, 0x66, 0x73, 0x53,
	0x68, 0x61, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d,
	0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e,
	0x4e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x22, 0x3c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x66, 0x73, 0x53, 0x68, 0x61,
	0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc2, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x4e,
	0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61,
	0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x4e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x66, 0x73, 0x53, 0x68, 0x61,
	0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x6e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x73, 0x12, 0xee, 0x01, 0x0a, 0x0e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x82, 0x01, 0xca, 0x41, 0x1d, 0x0a, 0x08, 0x4e,
	0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x15, 0x6e, 0x66, 0x73,
	0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x09, 0x6e, 0x66, 0x73, 0x5f, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x32, 0x37, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x66, 0x73, 0x5f, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xde, 0x01, 0x0a,
	0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x66, 0x73, 0x53, 0x68, 0x61,
	0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x73, 0xca, 0x41, 0x1d, 0x0a, 0x08, 0x4e,
	0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x10, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x6e, 0x66, 0x73, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3a, 0x3a, 0x09, 0x6e, 0x66, 0x73, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x22, 0x2d,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x73, 0x12, 0xcf, 0x01,
	0x0a, 0x0e, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x4e, 0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65,
	0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x4e, 0x66, 0x73, 0x53, 0x68,
	0x61, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65,
	0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e,
	0x66, 0x73, 0x53, 0x68, 0x61, 0x72, 0x65, 0x22, 0x56, 0xda, 0x41, 0x14, 0x6e, 0x61, 0x6d, 0x65,
	0x2c, 0x6e, 0x65, 0x77, 0x5f, 0x6e, 0x66, 0x73, 0x73, 0x68, 0x61, 0x72, 0x65, 0x5f, 0x69, 0x64,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x01, 0x2a, 0x22, 0x34, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x66, 0x73, 0x53,
	0x68, 0x61, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0xd4, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x66, 0x73, 0x53, 0x68, 0x61,
	0x72, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x66, 0x73,
	0x53, 0x68, 0x61, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x69, 0xca, 0x41, 0x2a,
	0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x2a, 0x2d, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x66, 0x73, 0x53, 0x68, 0x61,
	0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe6, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x51, 0x75, 0x6f, 0x74, 0x61,
	0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x73, 0x12,
	0x8b, 0x02, 0x0a, 0x18, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65,
	0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x66, 0xda, 0x41, 0x1a, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a, 0x01, 0x2a, 0x22, 0x3e, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x3a, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x12, 0xd7, 0x01,
	0x0a, 0x15, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c,
	0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x50,
	0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61,
	0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x46, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x88, 0x02, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50,
	0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61,
	0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x71, 0xda, 0x41, 0x1a, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x13, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x37, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x12, 0xa2, 0x02, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x8a, 0x01, 0xda, 0x41, 0x1f,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x62, 0x3a, 0x13, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x4b, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xca, 0x01, 0x0a, 0x0d, 0x52, 0x65, 0x6e, 0x61,
	0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74,
	0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65,
	0x6e, 0x61, 0x6d, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0x54,
	0xda, 0x41, 0x13, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6e, 0x65, 0x77, 0x5f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x3a, 0x01, 0x2a, 0x22,
	0x33, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0xbe, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x53, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x53,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x72,
	0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x53, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6f, 0x73, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x73, 0x1a, 0x54, 0xca, 0x41, 0x20, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65,
	0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x85, 0x02, 0x0a, 0x25,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x32, 0x42, 0x16, 0x42, 0x61, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x6c,
	0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x53, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x62, 0x61, 0x72,
	0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62,
	0x3b, 0x62, 0x61, 0x72, 0x65, 0x6d, 0x65, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x70, 0x62, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x42, 0x61, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x6c, 0x53, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x61, 0x72, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x6c, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x24, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x42, 0x61,
	0x72, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x6c, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x3a,
	0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_rawDescOnce sync.Once
	file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_rawDescData = file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_rawDesc
)

func file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_rawDescGZIP() []byte {
	file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_rawDescOnce.Do(func() {
		file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_rawDescData)
	})
	return file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_rawDescData
}

var file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_goTypes = []interface{}{
	(*OperationMetadata)(nil),                      // 0: google.cloud.baremetalsolution.v2.OperationMetadata
	(*ResetInstanceResponse)(nil),                  // 1: google.cloud.baremetalsolution.v2.ResetInstanceResponse
	(*timestamppb.Timestamp)(nil),                  // 2: google.protobuf.Timestamp
	(*ListInstancesRequest)(nil),                   // 3: google.cloud.baremetalsolution.v2.ListInstancesRequest
	(*GetInstanceRequest)(nil),                     // 4: google.cloud.baremetalsolution.v2.GetInstanceRequest
	(*UpdateInstanceRequest)(nil),                  // 5: google.cloud.baremetalsolution.v2.UpdateInstanceRequest
	(*RenameInstanceRequest)(nil),                  // 6: google.cloud.baremetalsolution.v2.RenameInstanceRequest
	(*ResetInstanceRequest)(nil),                   // 7: google.cloud.baremetalsolution.v2.ResetInstanceRequest
	(*StartInstanceRequest)(nil),                   // 8: google.cloud.baremetalsolution.v2.StartInstanceRequest
	(*StopInstanceRequest)(nil),                    // 9: google.cloud.baremetalsolution.v2.StopInstanceRequest
	(*EnableInteractiveSerialConsoleRequest)(nil),  // 10: google.cloud.baremetalsolution.v2.EnableInteractiveSerialConsoleRequest
	(*DisableInteractiveSerialConsoleRequest)(nil), // 11: google.cloud.baremetalsolution.v2.DisableInteractiveSerialConsoleRequest
	(*DetachLunRequest)(nil),                       // 12: google.cloud.baremetalsolution.v2.DetachLunRequest
	(*ListSSHKeysRequest)(nil),                     // 13: google.cloud.baremetalsolution.v2.ListSSHKeysRequest
	(*CreateSSHKeyRequest)(nil),                    // 14: google.cloud.baremetalsolution.v2.CreateSSHKeyRequest
	(*DeleteSSHKeyRequest)(nil),                    // 15: google.cloud.baremetalsolution.v2.DeleteSSHKeyRequest
	(*ListVolumesRequest)(nil),                     // 16: google.cloud.baremetalsolution.v2.ListVolumesRequest
	(*GetVolumeRequest)(nil),                       // 17: google.cloud.baremetalsolution.v2.GetVolumeRequest
	(*UpdateVolumeRequest)(nil),                    // 18: google.cloud.baremetalsolution.v2.UpdateVolumeRequest
	(*RenameVolumeRequest)(nil),                    // 19: google.cloud.baremetalsolution.v2.RenameVolumeRequest
	(*EvictVolumeRequest)(nil),                     // 20: google.cloud.baremetalsolution.v2.EvictVolumeRequest
	(*ResizeVolumeRequest)(nil),                    // 21: google.cloud.baremetalsolution.v2.ResizeVolumeRequest
	(*ListNetworksRequest)(nil),                    // 22: google.cloud.baremetalsolution.v2.ListNetworksRequest
	(*ListNetworkUsageRequest)(nil),                // 23: google.cloud.baremetalsolution.v2.ListNetworkUsageRequest
	(*GetNetworkRequest)(nil),                      // 24: google.cloud.baremetalsolution.v2.GetNetworkRequest
	(*UpdateNetworkRequest)(nil),                   // 25: google.cloud.baremetalsolution.v2.UpdateNetworkRequest
	(*CreateVolumeSnapshotRequest)(nil),            // 26: google.cloud.baremetalsolution.v2.CreateVolumeSnapshotRequest
	(*RestoreVolumeSnapshotRequest)(nil),           // 27: google.cloud.baremetalsolution.v2.RestoreVolumeSnapshotRequest
	(*DeleteVolumeSnapshotRequest)(nil),            // 28: google.cloud.baremetalsolution.v2.DeleteVolumeSnapshotRequest
	(*GetVolumeSnapshotRequest)(nil),               // 29: google.cloud.baremetalsolution.v2.GetVolumeSnapshotRequest
	(*ListVolumeSnapshotsRequest)(nil),             // 30: google.cloud.baremetalsolution.v2.ListVolumeSnapshotsRequest
	(*GetLunRequest)(nil),                          // 31: google.cloud.baremetalsolution.v2.GetLunRequest
	(*ListLunsRequest)(nil),                        // 32: google.cloud.baremetalsolution.v2.ListLunsRequest
	(*EvictLunRequest)(nil),                        // 33: google.cloud.baremetalsolution.v2.EvictLunRequest
	(*GetNfsShareRequest)(nil),                     // 34: google.cloud.baremetalsolution.v2.GetNfsShareRequest
	(*ListNfsSharesRequest)(nil),                   // 35: google.cloud.baremetalsolution.v2.ListNfsSharesRequest
	(*UpdateNfsShareRequest)(nil),                  // 36: google.cloud.baremetalsolution.v2.UpdateNfsShareRequest
	(*CreateNfsShareRequest)(nil),                  // 37: google.cloud.baremetalsolution.v2.CreateNfsShareRequest
	(*RenameNfsShareRequest)(nil),                  // 38: google.cloud.baremetalsolution.v2.RenameNfsShareRequest
	(*DeleteNfsShareRequest)(nil),                  // 39: google.cloud.baremetalsolution.v2.DeleteNfsShareRequest
	(*ListProvisioningQuotasRequest)(nil),          // 40: google.cloud.baremetalsolution.v2.ListProvisioningQuotasRequest
	(*SubmitProvisioningConfigRequest)(nil),        // 41: google.cloud.baremetalsolution.v2.SubmitProvisioningConfigRequest
	(*GetProvisioningConfigRequest)(nil),           // 42: google.cloud.baremetalsolution.v2.GetProvisioningConfigRequest
	(*CreateProvisioningConfigRequest)(nil),        // 43: google.cloud.baremetalsolution.v2.CreateProvisioningConfigRequest
	(*UpdateProvisioningConfigRequest)(nil),        // 44: google.cloud.baremetalsolution.v2.UpdateProvisioningConfigRequest
	(*RenameNetworkRequest)(nil),                   // 45: google.cloud.baremetalsolution.v2.RenameNetworkRequest
	(*ListOSImagesRequest)(nil),                    // 46: google.cloud.baremetalsolution.v2.ListOSImagesRequest
	(*ListInstancesResponse)(nil),                  // 47: google.cloud.baremetalsolution.v2.ListInstancesResponse
	(*Instance)(nil),                               // 48: google.cloud.baremetalsolution.v2.Instance
	(*longrunningpb.Operation)(nil),                // 49: google.longrunning.Operation
	(*ListSSHKeysResponse)(nil),                    // 50: google.cloud.baremetalsolution.v2.ListSSHKeysResponse
	(*SSHKey)(nil),                                 // 51: google.cloud.baremetalsolution.v2.SSHKey
	(*emptypb.Empty)(nil),                          // 52: google.protobuf.Empty
	(*ListVolumesResponse)(nil),                    // 53: google.cloud.baremetalsolution.v2.ListVolumesResponse
	(*Volume)(nil),                                 // 54: google.cloud.baremetalsolution.v2.Volume
	(*ListNetworksResponse)(nil),                   // 55: google.cloud.baremetalsolution.v2.ListNetworksResponse
	(*ListNetworkUsageResponse)(nil),               // 56: google.cloud.baremetalsolution.v2.ListNetworkUsageResponse
	(*Network)(nil),                                // 57: google.cloud.baremetalsolution.v2.Network
	(*VolumeSnapshot)(nil),                         // 58: google.cloud.baremetalsolution.v2.VolumeSnapshot
	(*ListVolumeSnapshotsResponse)(nil),            // 59: google.cloud.baremetalsolution.v2.ListVolumeSnapshotsResponse
	(*Lun)(nil),                                    // 60: google.cloud.baremetalsolution.v2.Lun
	(*ListLunsResponse)(nil),                       // 61: google.cloud.baremetalsolution.v2.ListLunsResponse
	(*NfsShare)(nil),                               // 62: google.cloud.baremetalsolution.v2.NfsShare
	(*ListNfsSharesResponse)(nil),                  // 63: google.cloud.baremetalsolution.v2.ListNfsSharesResponse
	(*ListProvisioningQuotasResponse)(nil),         // 64: google.cloud.baremetalsolution.v2.ListProvisioningQuotasResponse
	(*SubmitProvisioningConfigResponse)(nil),       // 65: google.cloud.baremetalsolution.v2.SubmitProvisioningConfigResponse
	(*ProvisioningConfig)(nil),                     // 66: google.cloud.baremetalsolution.v2.ProvisioningConfig
	(*ListOSImagesResponse)(nil),                   // 67: google.cloud.baremetalsolution.v2.ListOSImagesResponse
}
var file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_depIdxs = []int32{
	2,  // 0: google.cloud.baremetalsolution.v2.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	2,  // 1: google.cloud.baremetalsolution.v2.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	3,  // 2: google.cloud.baremetalsolution.v2.BareMetalSolution.ListInstances:input_type -> google.cloud.baremetalsolution.v2.ListInstancesRequest
	4,  // 3: google.cloud.baremetalsolution.v2.BareMetalSolution.GetInstance:input_type -> google.cloud.baremetalsolution.v2.GetInstanceRequest
	5,  // 4: google.cloud.baremetalsolution.v2.BareMetalSolution.UpdateInstance:input_type -> google.cloud.baremetalsolution.v2.UpdateInstanceRequest
	6,  // 5: google.cloud.baremetalsolution.v2.BareMetalSolution.RenameInstance:input_type -> google.cloud.baremetalsolution.v2.RenameInstanceRequest
	7,  // 6: google.cloud.baremetalsolution.v2.BareMetalSolution.ResetInstance:input_type -> google.cloud.baremetalsolution.v2.ResetInstanceRequest
	8,  // 7: google.cloud.baremetalsolution.v2.BareMetalSolution.StartInstance:input_type -> google.cloud.baremetalsolution.v2.StartInstanceRequest
	9,  // 8: google.cloud.baremetalsolution.v2.BareMetalSolution.StopInstance:input_type -> google.cloud.baremetalsolution.v2.StopInstanceRequest
	10, // 9: google.cloud.baremetalsolution.v2.BareMetalSolution.EnableInteractiveSerialConsole:input_type -> google.cloud.baremetalsolution.v2.EnableInteractiveSerialConsoleRequest
	11, // 10: google.cloud.baremetalsolution.v2.BareMetalSolution.DisableInteractiveSerialConsole:input_type -> google.cloud.baremetalsolution.v2.DisableInteractiveSerialConsoleRequest
	12, // 11: google.cloud.baremetalsolution.v2.BareMetalSolution.DetachLun:input_type -> google.cloud.baremetalsolution.v2.DetachLunRequest
	13, // 12: google.cloud.baremetalsolution.v2.BareMetalSolution.ListSSHKeys:input_type -> google.cloud.baremetalsolution.v2.ListSSHKeysRequest
	14, // 13: google.cloud.baremetalsolution.v2.BareMetalSolution.CreateSSHKey:input_type -> google.cloud.baremetalsolution.v2.CreateSSHKeyRequest
	15, // 14: google.cloud.baremetalsolution.v2.BareMetalSolution.DeleteSSHKey:input_type -> google.cloud.baremetalsolution.v2.DeleteSSHKeyRequest
	16, // 15: google.cloud.baremetalsolution.v2.BareMetalSolution.ListVolumes:input_type -> google.cloud.baremetalsolution.v2.ListVolumesRequest
	17, // 16: google.cloud.baremetalsolution.v2.BareMetalSolution.GetVolume:input_type -> google.cloud.baremetalsolution.v2.GetVolumeRequest
	18, // 17: google.cloud.baremetalsolution.v2.BareMetalSolution.UpdateVolume:input_type -> google.cloud.baremetalsolution.v2.UpdateVolumeRequest
	19, // 18: google.cloud.baremetalsolution.v2.BareMetalSolution.RenameVolume:input_type -> google.cloud.baremetalsolution.v2.RenameVolumeRequest
	20, // 19: google.cloud.baremetalsolution.v2.BareMetalSolution.EvictVolume:input_type -> google.cloud.baremetalsolution.v2.EvictVolumeRequest
	21, // 20: google.cloud.baremetalsolution.v2.BareMetalSolution.ResizeVolume:input_type -> google.cloud.baremetalsolution.v2.ResizeVolumeRequest
	22, // 21: google.cloud.baremetalsolution.v2.BareMetalSolution.ListNetworks:input_type -> google.cloud.baremetalsolution.v2.ListNetworksRequest
	23, // 22: google.cloud.baremetalsolution.v2.BareMetalSolution.ListNetworkUsage:input_type -> google.cloud.baremetalsolution.v2.ListNetworkUsageRequest
	24, // 23: google.cloud.baremetalsolution.v2.BareMetalSolution.GetNetwork:input_type -> google.cloud.baremetalsolution.v2.GetNetworkRequest
	25, // 24: google.cloud.baremetalsolution.v2.BareMetalSolution.UpdateNetwork:input_type -> google.cloud.baremetalsolution.v2.UpdateNetworkRequest
	26, // 25: google.cloud.baremetalsolution.v2.BareMetalSolution.CreateVolumeSnapshot:input_type -> google.cloud.baremetalsolution.v2.CreateVolumeSnapshotRequest
	27, // 26: google.cloud.baremetalsolution.v2.BareMetalSolution.RestoreVolumeSnapshot:input_type -> google.cloud.baremetalsolution.v2.RestoreVolumeSnapshotRequest
	28, // 27: google.cloud.baremetalsolution.v2.BareMetalSolution.DeleteVolumeSnapshot:input_type -> google.cloud.baremetalsolution.v2.DeleteVolumeSnapshotRequest
	29, // 28: google.cloud.baremetalsolution.v2.BareMetalSolution.GetVolumeSnapshot:input_type -> google.cloud.baremetalsolution.v2.GetVolumeSnapshotRequest
	30, // 29: google.cloud.baremetalsolution.v2.BareMetalSolution.ListVolumeSnapshots:input_type -> google.cloud.baremetalsolution.v2.ListVolumeSnapshotsRequest
	31, // 30: google.cloud.baremetalsolution.v2.BareMetalSolution.GetLun:input_type -> google.cloud.baremetalsolution.v2.GetLunRequest
	32, // 31: google.cloud.baremetalsolution.v2.BareMetalSolution.ListLuns:input_type -> google.cloud.baremetalsolution.v2.ListLunsRequest
	33, // 32: google.cloud.baremetalsolution.v2.BareMetalSolution.EvictLun:input_type -> google.cloud.baremetalsolution.v2.EvictLunRequest
	34, // 33: google.cloud.baremetalsolution.v2.BareMetalSolution.GetNfsShare:input_type -> google.cloud.baremetalsolution.v2.GetNfsShareRequest
	35, // 34: google.cloud.baremetalsolution.v2.BareMetalSolution.ListNfsShares:input_type -> google.cloud.baremetalsolution.v2.ListNfsSharesRequest
	36, // 35: google.cloud.baremetalsolution.v2.BareMetalSolution.UpdateNfsShare:input_type -> google.cloud.baremetalsolution.v2.UpdateNfsShareRequest
	37, // 36: google.cloud.baremetalsolution.v2.BareMetalSolution.CreateNfsShare:input_type -> google.cloud.baremetalsolution.v2.CreateNfsShareRequest
	38, // 37: google.cloud.baremetalsolution.v2.BareMetalSolution.RenameNfsShare:input_type -> google.cloud.baremetalsolution.v2.RenameNfsShareRequest
	39, // 38: google.cloud.baremetalsolution.v2.BareMetalSolution.DeleteNfsShare:input_type -> google.cloud.baremetalsolution.v2.DeleteNfsShareRequest
	40, // 39: google.cloud.baremetalsolution.v2.BareMetalSolution.ListProvisioningQuotas:input_type -> google.cloud.baremetalsolution.v2.ListProvisioningQuotasRequest
	41, // 40: google.cloud.baremetalsolution.v2.BareMetalSolution.SubmitProvisioningConfig:input_type -> google.cloud.baremetalsolution.v2.SubmitProvisioningConfigRequest
	42, // 41: google.cloud.baremetalsolution.v2.BareMetalSolution.GetProvisioningConfig:input_type -> google.cloud.baremetalsolution.v2.GetProvisioningConfigRequest
	43, // 42: google.cloud.baremetalsolution.v2.BareMetalSolution.CreateProvisioningConfig:input_type -> google.cloud.baremetalsolution.v2.CreateProvisioningConfigRequest
	44, // 43: google.cloud.baremetalsolution.v2.BareMetalSolution.UpdateProvisioningConfig:input_type -> google.cloud.baremetalsolution.v2.UpdateProvisioningConfigRequest
	45, // 44: google.cloud.baremetalsolution.v2.BareMetalSolution.RenameNetwork:input_type -> google.cloud.baremetalsolution.v2.RenameNetworkRequest
	46, // 45: google.cloud.baremetalsolution.v2.BareMetalSolution.ListOSImages:input_type -> google.cloud.baremetalsolution.v2.ListOSImagesRequest
	47, // 46: google.cloud.baremetalsolution.v2.BareMetalSolution.ListInstances:output_type -> google.cloud.baremetalsolution.v2.ListInstancesResponse
	48, // 47: google.cloud.baremetalsolution.v2.BareMetalSolution.GetInstance:output_type -> google.cloud.baremetalsolution.v2.Instance
	49, // 48: google.cloud.baremetalsolution.v2.BareMetalSolution.UpdateInstance:output_type -> google.longrunning.Operation
	48, // 49: google.cloud.baremetalsolution.v2.BareMetalSolution.RenameInstance:output_type -> google.cloud.baremetalsolution.v2.Instance
	49, // 50: google.cloud.baremetalsolution.v2.BareMetalSolution.ResetInstance:output_type -> google.longrunning.Operation
	49, // 51: google.cloud.baremetalsolution.v2.BareMetalSolution.StartInstance:output_type -> google.longrunning.Operation
	49, // 52: google.cloud.baremetalsolution.v2.BareMetalSolution.StopInstance:output_type -> google.longrunning.Operation
	49, // 53: google.cloud.baremetalsolution.v2.BareMetalSolution.EnableInteractiveSerialConsole:output_type -> google.longrunning.Operation
	49, // 54: google.cloud.baremetalsolution.v2.BareMetalSolution.DisableInteractiveSerialConsole:output_type -> google.longrunning.Operation
	49, // 55: google.cloud.baremetalsolution.v2.BareMetalSolution.DetachLun:output_type -> google.longrunning.Operation
	50, // 56: google.cloud.baremetalsolution.v2.BareMetalSolution.ListSSHKeys:output_type -> google.cloud.baremetalsolution.v2.ListSSHKeysResponse
	51, // 57: google.cloud.baremetalsolution.v2.BareMetalSolution.CreateSSHKey:output_type -> google.cloud.baremetalsolution.v2.SSHKey
	52, // 58: google.cloud.baremetalsolution.v2.BareMetalSolution.DeleteSSHKey:output_type -> google.protobuf.Empty
	53, // 59: google.cloud.baremetalsolution.v2.BareMetalSolution.ListVolumes:output_type -> google.cloud.baremetalsolution.v2.ListVolumesResponse
	54, // 60: google.cloud.baremetalsolution.v2.BareMetalSolution.GetVolume:output_type -> google.cloud.baremetalsolution.v2.Volume
	49, // 61: google.cloud.baremetalsolution.v2.BareMetalSolution.UpdateVolume:output_type -> google.longrunning.Operation
	54, // 62: google.cloud.baremetalsolution.v2.BareMetalSolution.RenameVolume:output_type -> google.cloud.baremetalsolution.v2.Volume
	49, // 63: google.cloud.baremetalsolution.v2.BareMetalSolution.EvictVolume:output_type -> google.longrunning.Operation
	49, // 64: google.cloud.baremetalsolution.v2.BareMetalSolution.ResizeVolume:output_type -> google.longrunning.Operation
	55, // 65: google.cloud.baremetalsolution.v2.BareMetalSolution.ListNetworks:output_type -> google.cloud.baremetalsolution.v2.ListNetworksResponse
	56, // 66: google.cloud.baremetalsolution.v2.BareMetalSolution.ListNetworkUsage:output_type -> google.cloud.baremetalsolution.v2.ListNetworkUsageResponse
	57, // 67: google.cloud.baremetalsolution.v2.BareMetalSolution.GetNetwork:output_type -> google.cloud.baremetalsolution.v2.Network
	49, // 68: google.cloud.baremetalsolution.v2.BareMetalSolution.UpdateNetwork:output_type -> google.longrunning.Operation
	58, // 69: google.cloud.baremetalsolution.v2.BareMetalSolution.CreateVolumeSnapshot:output_type -> google.cloud.baremetalsolution.v2.VolumeSnapshot
	49, // 70: google.cloud.baremetalsolution.v2.BareMetalSolution.RestoreVolumeSnapshot:output_type -> google.longrunning.Operation
	52, // 71: google.cloud.baremetalsolution.v2.BareMetalSolution.DeleteVolumeSnapshot:output_type -> google.protobuf.Empty
	58, // 72: google.cloud.baremetalsolution.v2.BareMetalSolution.GetVolumeSnapshot:output_type -> google.cloud.baremetalsolution.v2.VolumeSnapshot
	59, // 73: google.cloud.baremetalsolution.v2.BareMetalSolution.ListVolumeSnapshots:output_type -> google.cloud.baremetalsolution.v2.ListVolumeSnapshotsResponse
	60, // 74: google.cloud.baremetalsolution.v2.BareMetalSolution.GetLun:output_type -> google.cloud.baremetalsolution.v2.Lun
	61, // 75: google.cloud.baremetalsolution.v2.BareMetalSolution.ListLuns:output_type -> google.cloud.baremetalsolution.v2.ListLunsResponse
	49, // 76: google.cloud.baremetalsolution.v2.BareMetalSolution.EvictLun:output_type -> google.longrunning.Operation
	62, // 77: google.cloud.baremetalsolution.v2.BareMetalSolution.GetNfsShare:output_type -> google.cloud.baremetalsolution.v2.NfsShare
	63, // 78: google.cloud.baremetalsolution.v2.BareMetalSolution.ListNfsShares:output_type -> google.cloud.baremetalsolution.v2.ListNfsSharesResponse
	49, // 79: google.cloud.baremetalsolution.v2.BareMetalSolution.UpdateNfsShare:output_type -> google.longrunning.Operation
	49, // 80: google.cloud.baremetalsolution.v2.BareMetalSolution.CreateNfsShare:output_type -> google.longrunning.Operation
	62, // 81: google.cloud.baremetalsolution.v2.BareMetalSolution.RenameNfsShare:output_type -> google.cloud.baremetalsolution.v2.NfsShare
	49, // 82: google.cloud.baremetalsolution.v2.BareMetalSolution.DeleteNfsShare:output_type -> google.longrunning.Operation
	64, // 83: google.cloud.baremetalsolution.v2.BareMetalSolution.ListProvisioningQuotas:output_type -> google.cloud.baremetalsolution.v2.ListProvisioningQuotasResponse
	65, // 84: google.cloud.baremetalsolution.v2.BareMetalSolution.SubmitProvisioningConfig:output_type -> google.cloud.baremetalsolution.v2.SubmitProvisioningConfigResponse
	66, // 85: google.cloud.baremetalsolution.v2.BareMetalSolution.GetProvisioningConfig:output_type -> google.cloud.baremetalsolution.v2.ProvisioningConfig
	66, // 86: google.cloud.baremetalsolution.v2.BareMetalSolution.CreateProvisioningConfig:output_type -> google.cloud.baremetalsolution.v2.ProvisioningConfig
	66, // 87: google.cloud.baremetalsolution.v2.BareMetalSolution.UpdateProvisioningConfig:output_type -> google.cloud.baremetalsolution.v2.ProvisioningConfig
	57, // 88: google.cloud.baremetalsolution.v2.BareMetalSolution.RenameNetwork:output_type -> google.cloud.baremetalsolution.v2.Network
	67, // 89: google.cloud.baremetalsolution.v2.BareMetalSolution.ListOSImages:output_type -> google.cloud.baremetalsolution.v2.ListOSImagesResponse
	46, // [46:90] is the sub-list for method output_type
	2,  // [2:46] is the sub-list for method input_type
	2,  // [2:2] is the sub-list for extension type_name
	2,  // [2:2] is the sub-list for extension extendee
	0,  // [0:2] is the sub-list for field type_name
}

func init() { file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_init() }
func file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_init() {
	if File_google_cloud_baremetalsolution_v2_baremetalsolution_proto != nil {
		return
	}
	file_google_cloud_baremetalsolution_v2_instance_proto_init()
	file_google_cloud_baremetalsolution_v2_lun_proto_init()
	file_google_cloud_baremetalsolution_v2_network_proto_init()
	file_google_cloud_baremetalsolution_v2_nfs_share_proto_init()
	file_google_cloud_baremetalsolution_v2_osimage_proto_init()
	file_google_cloud_baremetalsolution_v2_provisioning_proto_init()
	file_google_cloud_baremetalsolution_v2_ssh_key_proto_init()
	file_google_cloud_baremetalsolution_v2_volume_proto_init()
	file_google_cloud_baremetalsolution_v2_volume_snapshot_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResetInstanceResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_goTypes,
		DependencyIndexes: file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_depIdxs,
		MessageInfos:      file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_msgTypes,
	}.Build()
	File_google_cloud_baremetalsolution_v2_baremetalsolution_proto = out.File
	file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_rawDesc = nil
	file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_goTypes = nil
	file_google_cloud_baremetalsolution_v2_baremetalsolution_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BareMetalSolutionClient is the client API for BareMetalSolution service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BareMetalSolutionClient interface {
	// List servers in a given project and location.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Get details about a single server.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Update details of a single server.
	UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// RenameInstance sets a new name for an instance.
	// Use with caution, previous names become immediately invalidated.
	RenameInstance(ctx context.Context, in *RenameInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Perform an ungraceful, hard reset on a server. Equivalent to shutting the
	// power off and then turning it back on.
	ResetInstance(ctx context.Context, in *ResetInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts a server that was shutdown.
	StartInstance(ctx context.Context, in *StartInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Stop a running server.
	StopInstance(ctx context.Context, in *StopInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Enable the interactive serial console feature on an instance.
	EnableInteractiveSerialConsole(ctx context.Context, in *EnableInteractiveSerialConsoleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Disable the interactive serial console feature on an instance.
	DisableInteractiveSerialConsole(ctx context.Context, in *DisableInteractiveSerialConsoleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Detach LUN from Instance.
	DetachLun(ctx context.Context, in *DetachLunRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the public SSH keys registered for the specified project.
	// These SSH keys are used only for the interactive serial console feature.
	ListSSHKeys(ctx context.Context, in *ListSSHKeysRequest, opts ...grpc.CallOption) (*ListSSHKeysResponse, error)
	// Register a public SSH key in the specified project for use with the
	// interactive serial console feature.
	CreateSSHKey(ctx context.Context, in *CreateSSHKeyRequest, opts ...grpc.CallOption) (*SSHKey, error)
	// Deletes a public SSH key registered in the specified project.
	DeleteSSHKey(ctx context.Context, in *DeleteSSHKeyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List storage volumes in a given project and location.
	ListVolumes(ctx context.Context, in *ListVolumesRequest, opts ...grpc.CallOption) (*ListVolumesResponse, error)
	// Get details of a single storage volume.
	GetVolume(ctx context.Context, in *GetVolumeRequest, opts ...grpc.CallOption) (*Volume, error)
	// Update details of a single storage volume.
	UpdateVolume(ctx context.Context, in *UpdateVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// RenameVolume sets a new name for a volume.
	// Use with caution, previous names become immediately invalidated.
	RenameVolume(ctx context.Context, in *RenameVolumeRequest, opts ...grpc.CallOption) (*Volume, error)
	// Skips volume's cooloff and deletes it now.
	// Volume must be in cooloff state.
	EvictVolume(ctx context.Context, in *EvictVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Emergency Volume resize.
	ResizeVolume(ctx context.Context, in *ResizeVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// List network in a given project and location.
	ListNetworks(ctx context.Context, in *ListNetworksRequest, opts ...grpc.CallOption) (*ListNetworksResponse, error)
	// List all Networks (and used IPs for each Network) in the vendor account
	// associated with the specified project.
	ListNetworkUsage(ctx context.Context, in *ListNetworkUsageRequest, opts ...grpc.CallOption) (*ListNetworkUsageResponse, error)
	// Get details of a single network.
	GetNetwork(ctx context.Context, in *GetNetworkRequest, opts ...grpc.CallOption) (*Network, error)
	// Update details of a single network.
	UpdateNetwork(ctx context.Context, in *UpdateNetworkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Takes a snapshot of a boot volume.
	// Returns INVALID_ARGUMENT if called for a non-boot volume.
	CreateVolumeSnapshot(ctx context.Context, in *CreateVolumeSnapshotRequest, opts ...grpc.CallOption) (*VolumeSnapshot, error)
	// Uses the specified snapshot to restore its parent volume.
	// Returns INVALID_ARGUMENT if called for a non-boot volume.
	RestoreVolumeSnapshot(ctx context.Context, in *RestoreVolumeSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a volume snapshot.
	// Returns INVALID_ARGUMENT if called for a non-boot volume.
	DeleteVolumeSnapshot(ctx context.Context, in *DeleteVolumeSnapshotRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns the specified snapshot resource.
	// Returns INVALID_ARGUMENT if called for a non-boot volume.
	GetVolumeSnapshot(ctx context.Context, in *GetVolumeSnapshotRequest, opts ...grpc.CallOption) (*VolumeSnapshot, error)
	// Retrieves the list of snapshots for the specified volume.
	// Returns a response with an empty list of snapshots if called
	// for a non-boot volume.
	ListVolumeSnapshots(ctx context.Context, in *ListVolumeSnapshotsRequest, opts ...grpc.CallOption) (*ListVolumeSnapshotsResponse, error)
	// Get details of a single storage logical unit number(LUN).
	GetLun(ctx context.Context, in *GetLunRequest, opts ...grpc.CallOption) (*Lun, error)
	// List storage volume luns for given storage volume.
	ListLuns(ctx context.Context, in *ListLunsRequest, opts ...grpc.CallOption) (*ListLunsResponse, error)
	// Skips lun's cooloff and deletes it now.
	// Lun must be in cooloff state.
	EvictLun(ctx context.Context, in *EvictLunRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Get details of a single NFS share.
	GetNfsShare(ctx context.Context, in *GetNfsShareRequest, opts ...grpc.CallOption) (*NfsShare, error)
	// List NFS shares.
	ListNfsShares(ctx context.Context, in *ListNfsSharesRequest, opts ...grpc.CallOption) (*ListNfsSharesResponse, error)
	// Update details of a single NFS share.
	UpdateNfsShare(ctx context.Context, in *UpdateNfsShareRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Create an NFS share.
	CreateNfsShare(ctx context.Context, in *CreateNfsShareRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// RenameNfsShare sets a new name for an nfsshare.
	// Use with caution, previous names become immediately invalidated.
	RenameNfsShare(ctx context.Context, in *RenameNfsShareRequest, opts ...grpc.CallOption) (*NfsShare, error)
	// Delete an NFS share. The underlying volume is automatically deleted.
	DeleteNfsShare(ctx context.Context, in *DeleteNfsShareRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// List the budget details to provision resources on a given project.
	ListProvisioningQuotas(ctx context.Context, in *ListProvisioningQuotasRequest, opts ...grpc.CallOption) (*ListProvisioningQuotasResponse, error)
	// Submit a provisiong configuration for a given project.
	SubmitProvisioningConfig(ctx context.Context, in *SubmitProvisioningConfigRequest, opts ...grpc.CallOption) (*SubmitProvisioningConfigResponse, error)
	// Get ProvisioningConfig by name.
	GetProvisioningConfig(ctx context.Context, in *GetProvisioningConfigRequest, opts ...grpc.CallOption) (*ProvisioningConfig, error)
	// Create new ProvisioningConfig.
	CreateProvisioningConfig(ctx context.Context, in *CreateProvisioningConfigRequest, opts ...grpc.CallOption) (*ProvisioningConfig, error)
	// Update existing ProvisioningConfig.
	UpdateProvisioningConfig(ctx context.Context, in *UpdateProvisioningConfigRequest, opts ...grpc.CallOption) (*ProvisioningConfig, error)
	// RenameNetwork sets a new name for a network.
	// Use with caution, previous names become immediately invalidated.
	RenameNetwork(ctx context.Context, in *RenameNetworkRequest, opts ...grpc.CallOption) (*Network, error)
	// Retrieves the list of OS images which are currently approved.
	ListOSImages(ctx context.Context, in *ListOSImagesRequest, opts ...grpc.CallOption) (*ListOSImagesResponse, error)
}

type bareMetalSolutionClient struct {
	cc grpc.ClientConnInterface
}

func NewBareMetalSolutionClient(cc grpc.ClientConnInterface) BareMetalSolutionClient {
	return &bareMetalSolutionClient{cc}
}

func (c *bareMetalSolutionClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) RenameInstance(ctx context.Context, in *RenameInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/RenameInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ResetInstance(ctx context.Context, in *ResetInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/ResetInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) StartInstance(ctx context.Context, in *StartInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/StartInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) StopInstance(ctx context.Context, in *StopInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/StopInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) EnableInteractiveSerialConsole(ctx context.Context, in *EnableInteractiveSerialConsoleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/EnableInteractiveSerialConsole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) DisableInteractiveSerialConsole(ctx context.Context, in *DisableInteractiveSerialConsoleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/DisableInteractiveSerialConsole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) DetachLun(ctx context.Context, in *DetachLunRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/DetachLun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ListSSHKeys(ctx context.Context, in *ListSSHKeysRequest, opts ...grpc.CallOption) (*ListSSHKeysResponse, error) {
	out := new(ListSSHKeysResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListSSHKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) CreateSSHKey(ctx context.Context, in *CreateSSHKeyRequest, opts ...grpc.CallOption) (*SSHKey, error) {
	out := new(SSHKey)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/CreateSSHKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) DeleteSSHKey(ctx context.Context, in *DeleteSSHKeyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/DeleteSSHKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ListVolumes(ctx context.Context, in *ListVolumesRequest, opts ...grpc.CallOption) (*ListVolumesResponse, error) {
	out := new(ListVolumesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListVolumes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) GetVolume(ctx context.Context, in *GetVolumeRequest, opts ...grpc.CallOption) (*Volume, error) {
	out := new(Volume)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) UpdateVolume(ctx context.Context, in *UpdateVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) RenameVolume(ctx context.Context, in *RenameVolumeRequest, opts ...grpc.CallOption) (*Volume, error) {
	out := new(Volume)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/RenameVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) EvictVolume(ctx context.Context, in *EvictVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/EvictVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ResizeVolume(ctx context.Context, in *ResizeVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/ResizeVolume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ListNetworks(ctx context.Context, in *ListNetworksRequest, opts ...grpc.CallOption) (*ListNetworksResponse, error) {
	out := new(ListNetworksResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListNetworks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ListNetworkUsage(ctx context.Context, in *ListNetworkUsageRequest, opts ...grpc.CallOption) (*ListNetworkUsageResponse, error) {
	out := new(ListNetworkUsageResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListNetworkUsage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) GetNetwork(ctx context.Context, in *GetNetworkRequest, opts ...grpc.CallOption) (*Network, error) {
	out := new(Network)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetNetwork", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) UpdateNetwork(ctx context.Context, in *UpdateNetworkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateNetwork", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) CreateVolumeSnapshot(ctx context.Context, in *CreateVolumeSnapshotRequest, opts ...grpc.CallOption) (*VolumeSnapshot, error) {
	out := new(VolumeSnapshot)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/CreateVolumeSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) RestoreVolumeSnapshot(ctx context.Context, in *RestoreVolumeSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/RestoreVolumeSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) DeleteVolumeSnapshot(ctx context.Context, in *DeleteVolumeSnapshotRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/DeleteVolumeSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) GetVolumeSnapshot(ctx context.Context, in *GetVolumeSnapshotRequest, opts ...grpc.CallOption) (*VolumeSnapshot, error) {
	out := new(VolumeSnapshot)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetVolumeSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ListVolumeSnapshots(ctx context.Context, in *ListVolumeSnapshotsRequest, opts ...grpc.CallOption) (*ListVolumeSnapshotsResponse, error) {
	out := new(ListVolumeSnapshotsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListVolumeSnapshots", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) GetLun(ctx context.Context, in *GetLunRequest, opts ...grpc.CallOption) (*Lun, error) {
	out := new(Lun)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetLun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ListLuns(ctx context.Context, in *ListLunsRequest, opts ...grpc.CallOption) (*ListLunsResponse, error) {
	out := new(ListLunsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListLuns", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) EvictLun(ctx context.Context, in *EvictLunRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/EvictLun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) GetNfsShare(ctx context.Context, in *GetNfsShareRequest, opts ...grpc.CallOption) (*NfsShare, error) {
	out := new(NfsShare)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetNfsShare", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ListNfsShares(ctx context.Context, in *ListNfsSharesRequest, opts ...grpc.CallOption) (*ListNfsSharesResponse, error) {
	out := new(ListNfsSharesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListNfsShares", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) UpdateNfsShare(ctx context.Context, in *UpdateNfsShareRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateNfsShare", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) CreateNfsShare(ctx context.Context, in *CreateNfsShareRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/CreateNfsShare", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) RenameNfsShare(ctx context.Context, in *RenameNfsShareRequest, opts ...grpc.CallOption) (*NfsShare, error) {
	out := new(NfsShare)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/RenameNfsShare", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) DeleteNfsShare(ctx context.Context, in *DeleteNfsShareRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/DeleteNfsShare", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ListProvisioningQuotas(ctx context.Context, in *ListProvisioningQuotasRequest, opts ...grpc.CallOption) (*ListProvisioningQuotasResponse, error) {
	out := new(ListProvisioningQuotasResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListProvisioningQuotas", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) SubmitProvisioningConfig(ctx context.Context, in *SubmitProvisioningConfigRequest, opts ...grpc.CallOption) (*SubmitProvisioningConfigResponse, error) {
	out := new(SubmitProvisioningConfigResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/SubmitProvisioningConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) GetProvisioningConfig(ctx context.Context, in *GetProvisioningConfigRequest, opts ...grpc.CallOption) (*ProvisioningConfig, error) {
	out := new(ProvisioningConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetProvisioningConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) CreateProvisioningConfig(ctx context.Context, in *CreateProvisioningConfigRequest, opts ...grpc.CallOption) (*ProvisioningConfig, error) {
	out := new(ProvisioningConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/CreateProvisioningConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) UpdateProvisioningConfig(ctx context.Context, in *UpdateProvisioningConfigRequest, opts ...grpc.CallOption) (*ProvisioningConfig, error) {
	out := new(ProvisioningConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateProvisioningConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) RenameNetwork(ctx context.Context, in *RenameNetworkRequest, opts ...grpc.CallOption) (*Network, error) {
	out := new(Network)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/RenameNetwork", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ListOSImages(ctx context.Context, in *ListOSImagesRequest, opts ...grpc.CallOption) (*ListOSImagesResponse, error) {
	out := new(ListOSImagesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListOSImages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BareMetalSolutionServer is the server API for BareMetalSolution service.
type BareMetalSolutionServer interface {
	// List servers in a given project and location.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Get details about a single server.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Update details of a single server.
	UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunningpb.Operation, error)
	// RenameInstance sets a new name for an instance.
	// Use with caution, previous names become immediately invalidated.
	RenameInstance(context.Context, *RenameInstanceRequest) (*Instance, error)
	// Perform an ungraceful, hard reset on a server. Equivalent to shutting the
	// power off and then turning it back on.
	ResetInstance(context.Context, *ResetInstanceRequest) (*longrunningpb.Operation, error)
	// Starts a server that was shutdown.
	StartInstance(context.Context, *StartInstanceRequest) (*longrunningpb.Operation, error)
	// Stop a running server.
	StopInstance(context.Context, *StopInstanceRequest) (*longrunningpb.Operation, error)
	// Enable the interactive serial console feature on an instance.
	EnableInteractiveSerialConsole(context.Context, *EnableInteractiveSerialConsoleRequest) (*longrunningpb.Operation, error)
	// Disable the interactive serial console feature on an instance.
	DisableInteractiveSerialConsole(context.Context, *DisableInteractiveSerialConsoleRequest) (*longrunningpb.Operation, error)
	// Detach LUN from Instance.
	DetachLun(context.Context, *DetachLunRequest) (*longrunningpb.Operation, error)
	// Lists the public SSH keys registered for the specified project.
	// These SSH keys are used only for the interactive serial console feature.
	ListSSHKeys(context.Context, *ListSSHKeysRequest) (*ListSSHKeysResponse, error)
	// Register a public SSH key in the specified project for use with the
	// interactive serial console feature.
	CreateSSHKey(context.Context, *CreateSSHKeyRequest) (*SSHKey, error)
	// Deletes a public SSH key registered in the specified project.
	DeleteSSHKey(context.Context, *DeleteSSHKeyRequest) (*emptypb.Empty, error)
	// List storage volumes in a given project and location.
	ListVolumes(context.Context, *ListVolumesRequest) (*ListVolumesResponse, error)
	// Get details of a single storage volume.
	GetVolume(context.Context, *GetVolumeRequest) (*Volume, error)
	// Update details of a single storage volume.
	UpdateVolume(context.Context, *UpdateVolumeRequest) (*longrunningpb.Operation, error)
	// RenameVolume sets a new name for a volume.
	// Use with caution, previous names become immediately invalidated.
	RenameVolume(context.Context, *RenameVolumeRequest) (*Volume, error)
	// Skips volume's cooloff and deletes it now.
	// Volume must be in cooloff state.
	EvictVolume(context.Context, *EvictVolumeRequest) (*longrunningpb.Operation, error)
	// Emergency Volume resize.
	ResizeVolume(context.Context, *ResizeVolumeRequest) (*longrunningpb.Operation, error)
	// List network in a given project and location.
	ListNetworks(context.Context, *ListNetworksRequest) (*ListNetworksResponse, error)
	// List all Networks (and used IPs for each Network) in the vendor account
	// associated with the specified project.
	ListNetworkUsage(context.Context, *ListNetworkUsageRequest) (*ListNetworkUsageResponse, error)
	// Get details of a single network.
	GetNetwork(context.Context, *GetNetworkRequest) (*Network, error)
	// Update details of a single network.
	UpdateNetwork(context.Context, *UpdateNetworkRequest) (*longrunningpb.Operation, error)
	// Takes a snapshot of a boot volume.
	// Returns INVALID_ARGUMENT if called for a non-boot volume.
	CreateVolumeSnapshot(context.Context, *CreateVolumeSnapshotRequest) (*VolumeSnapshot, error)
	// Uses the specified snapshot to restore its parent volume.
	// Returns INVALID_ARGUMENT if called for a non-boot volume.
	RestoreVolumeSnapshot(context.Context, *RestoreVolumeSnapshotRequest) (*longrunningpb.Operation, error)
	// Deletes a volume snapshot.
	// Returns INVALID_ARGUMENT if called for a non-boot volume.
	DeleteVolumeSnapshot(context.Context, *DeleteVolumeSnapshotRequest) (*emptypb.Empty, error)
	// Returns the specified snapshot resource.
	// Returns INVALID_ARGUMENT if called for a non-boot volume.
	GetVolumeSnapshot(context.Context, *GetVolumeSnapshotRequest) (*VolumeSnapshot, error)
	// Retrieves the list of snapshots for the specified volume.
	// Returns a response with an empty list of snapshots if called
	// for a non-boot volume.
	ListVolumeSnapshots(context.Context, *ListVolumeSnapshotsRequest) (*ListVolumeSnapshotsResponse, error)
	// Get details of a single storage logical unit number(LUN).
	GetLun(context.Context, *GetLunRequest) (*Lun, error)
	// List storage volume luns for given storage volume.
	ListLuns(context.Context, *ListLunsRequest) (*ListLunsResponse, error)
	// Skips lun's cooloff and deletes it now.
	// Lun must be in cooloff state.
	EvictLun(context.Context, *EvictLunRequest) (*longrunningpb.Operation, error)
	// Get details of a single NFS share.
	GetNfsShare(context.Context, *GetNfsShareRequest) (*NfsShare, error)
	// List NFS shares.
	ListNfsShares(context.Context, *ListNfsSharesRequest) (*ListNfsSharesResponse, error)
	// Update details of a single NFS share.
	UpdateNfsShare(context.Context, *UpdateNfsShareRequest) (*longrunningpb.Operation, error)
	// Create an NFS share.
	CreateNfsShare(context.Context, *CreateNfsShareRequest) (*longrunningpb.Operation, error)
	// RenameNfsShare sets a new name for an nfsshare.
	// Use with caution, previous names become immediately invalidated.
	RenameNfsShare(context.Context, *RenameNfsShareRequest) (*NfsShare, error)
	// Delete an NFS share. The underlying volume is automatically deleted.
	DeleteNfsShare(context.Context, *DeleteNfsShareRequest) (*longrunningpb.Operation, error)
	// List the budget details to provision resources on a given project.
	ListProvisioningQuotas(context.Context, *ListProvisioningQuotasRequest) (*ListProvisioningQuotasResponse, error)
	// Submit a provisiong configuration for a given project.
	SubmitProvisioningConfig(context.Context, *SubmitProvisioningConfigRequest) (*SubmitProvisioningConfigResponse, error)
	// Get ProvisioningConfig by name.
	GetProvisioningConfig(context.Context, *GetProvisioningConfigRequest) (*ProvisioningConfig, error)
	// Create new ProvisioningConfig.
	CreateProvisioningConfig(context.Context, *CreateProvisioningConfigRequest) (*ProvisioningConfig, error)
	// Update existing ProvisioningConfig.
	UpdateProvisioningConfig(context.Context, *UpdateProvisioningConfigRequest) (*ProvisioningConfig, error)
	// RenameNetwork sets a new name for a network.
	// Use with caution, previous names become immediately invalidated.
	RenameNetwork(context.Context, *RenameNetworkRequest) (*Network, error)
	// Retrieves the list of OS images which are currently approved.
	ListOSImages(context.Context, *ListOSImagesRequest) (*ListOSImagesResponse, error)
}

// UnimplementedBareMetalSolutionServer can be embedded to have forward compatible implementations.
type UnimplementedBareMetalSolutionServer struct {
}

func (*UnimplementedBareMetalSolutionServer) ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (*UnimplementedBareMetalSolutionServer) GetInstance(context.Context, *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstance not implemented")
}
func (*UnimplementedBareMetalSolutionServer) UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstance not implemented")
}
func (*UnimplementedBareMetalSolutionServer) RenameInstance(context.Context, *RenameInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameInstance not implemented")
}
func (*UnimplementedBareMetalSolutionServer) ResetInstance(context.Context, *ResetInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetInstance not implemented")
}
func (*UnimplementedBareMetalSolutionServer) StartInstance(context.Context, *StartInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartInstance not implemented")
}
func (*UnimplementedBareMetalSolutionServer) StopInstance(context.Context, *StopInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopInstance not implemented")
}
func (*UnimplementedBareMetalSolutionServer) EnableInteractiveSerialConsole(context.Context, *EnableInteractiveSerialConsoleRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnableInteractiveSerialConsole not implemented")
}
func (*UnimplementedBareMetalSolutionServer) DisableInteractiveSerialConsole(context.Context, *DisableInteractiveSerialConsoleRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisableInteractiveSerialConsole not implemented")
}
func (*UnimplementedBareMetalSolutionServer) DetachLun(context.Context, *DetachLunRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetachLun not implemented")
}
func (*UnimplementedBareMetalSolutionServer) ListSSHKeys(context.Context, *ListSSHKeysRequest) (*ListSSHKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSSHKeys not implemented")
}
func (*UnimplementedBareMetalSolutionServer) CreateSSHKey(context.Context, *CreateSSHKeyRequest) (*SSHKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSSHKey not implemented")
}
func (*UnimplementedBareMetalSolutionServer) DeleteSSHKey(context.Context, *DeleteSSHKeyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSSHKey not implemented")
}
func (*UnimplementedBareMetalSolutionServer) ListVolumes(context.Context, *ListVolumesRequest) (*ListVolumesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVolumes not implemented")
}
func (*UnimplementedBareMetalSolutionServer) GetVolume(context.Context, *GetVolumeRequest) (*Volume, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVolume not implemented")
}
func (*UnimplementedBareMetalSolutionServer) UpdateVolume(context.Context, *UpdateVolumeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVolume not implemented")
}
func (*UnimplementedBareMetalSolutionServer) RenameVolume(context.Context, *RenameVolumeRequest) (*Volume, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameVolume not implemented")
}
func (*UnimplementedBareMetalSolutionServer) EvictVolume(context.Context, *EvictVolumeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EvictVolume not implemented")
}
func (*UnimplementedBareMetalSolutionServer) ResizeVolume(context.Context, *ResizeVolumeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResizeVolume not implemented")
}
func (*UnimplementedBareMetalSolutionServer) ListNetworks(context.Context, *ListNetworksRequest) (*ListNetworksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNetworks not implemented")
}
func (*UnimplementedBareMetalSolutionServer) ListNetworkUsage(context.Context, *ListNetworkUsageRequest) (*ListNetworkUsageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNetworkUsage not implemented")
}
func (*UnimplementedBareMetalSolutionServer) GetNetwork(context.Context, *GetNetworkRequest) (*Network, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNetwork not implemented")
}
func (*UnimplementedBareMetalSolutionServer) UpdateNetwork(context.Context, *UpdateNetworkRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNetwork not implemented")
}
func (*UnimplementedBareMetalSolutionServer) CreateVolumeSnapshot(context.Context, *CreateVolumeSnapshotRequest) (*VolumeSnapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVolumeSnapshot not implemented")
}
func (*UnimplementedBareMetalSolutionServer) RestoreVolumeSnapshot(context.Context, *RestoreVolumeSnapshotRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreVolumeSnapshot not implemented")
}
func (*UnimplementedBareMetalSolutionServer) DeleteVolumeSnapshot(context.Context, *DeleteVolumeSnapshotRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVolumeSnapshot not implemented")
}
func (*UnimplementedBareMetalSolutionServer) GetVolumeSnapshot(context.Context, *GetVolumeSnapshotRequest) (*VolumeSnapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVolumeSnapshot not implemented")
}
func (*UnimplementedBareMetalSolutionServer) ListVolumeSnapshots(context.Context, *ListVolumeSnapshotsRequest) (*ListVolumeSnapshotsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVolumeSnapshots not implemented")
}
func (*UnimplementedBareMetalSolutionServer) GetLun(context.Context, *GetLunRequest) (*Lun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLun not implemented")
}
func (*UnimplementedBareMetalSolutionServer) ListLuns(context.Context, *ListLunsRequest) (*ListLunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLuns not implemented")
}
func (*UnimplementedBareMetalSolutionServer) EvictLun(context.Context, *EvictLunRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EvictLun not implemented")
}
func (*UnimplementedBareMetalSolutionServer) GetNfsShare(context.Context, *GetNfsShareRequest) (*NfsShare, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNfsShare not implemented")
}
func (*UnimplementedBareMetalSolutionServer) ListNfsShares(context.Context, *ListNfsSharesRequest) (*ListNfsSharesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNfsShares not implemented")
}
func (*UnimplementedBareMetalSolutionServer) UpdateNfsShare(context.Context, *UpdateNfsShareRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNfsShare not implemented")
}
func (*UnimplementedBareMetalSolutionServer) CreateNfsShare(context.Context, *CreateNfsShareRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNfsShare not implemented")
}
func (*UnimplementedBareMetalSolutionServer) RenameNfsShare(context.Context, *RenameNfsShareRequest) (*NfsShare, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameNfsShare not implemented")
}
func (*UnimplementedBareMetalSolutionServer) DeleteNfsShare(context.Context, *DeleteNfsShareRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNfsShare not implemented")
}
func (*UnimplementedBareMetalSolutionServer) ListProvisioningQuotas(context.Context, *ListProvisioningQuotasRequest) (*ListProvisioningQuotasResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProvisioningQuotas not implemented")
}
func (*UnimplementedBareMetalSolutionServer) SubmitProvisioningConfig(context.Context, *SubmitProvisioningConfigRequest) (*SubmitProvisioningConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SubmitProvisioningConfig not implemented")
}
func (*UnimplementedBareMetalSolutionServer) GetProvisioningConfig(context.Context, *GetProvisioningConfigRequest) (*ProvisioningConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProvisioningConfig not implemented")
}
func (*UnimplementedBareMetalSolutionServer) CreateProvisioningConfig(context.Context, *CreateProvisioningConfigRequest) (*ProvisioningConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProvisioningConfig not implemented")
}
func (*UnimplementedBareMetalSolutionServer) UpdateProvisioningConfig(context.Context, *UpdateProvisioningConfigRequest) (*ProvisioningConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProvisioningConfig not implemented")
}
func (*UnimplementedBareMetalSolutionServer) RenameNetwork(context.Context, *RenameNetworkRequest) (*Network, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameNetwork not implemented")
}
func (*UnimplementedBareMetalSolutionServer) ListOSImages(context.Context, *ListOSImagesRequest) (*ListOSImagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOSImages not implemented")
}

func RegisterBareMetalSolutionServer(s *grpc.Server, srv BareMetalSolutionServer) {
	s.RegisterService(&_BareMetalSolution_serviceDesc, srv)
}

func _BareMetalSolution_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).UpdateInstance(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_RenameInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).RenameInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/RenameInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).RenameInstance(ctx, req.(*RenameInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ResetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ResetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/ResetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ResetInstance(ctx, req.(*ResetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_StartInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).StartInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/StartInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).StartInstance(ctx, req.(*StartInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_StopInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).StopInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/StopInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).StopInstance(ctx, req.(*StopInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_EnableInteractiveSerialConsole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableInteractiveSerialConsoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).EnableInteractiveSerialConsole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/EnableInteractiveSerialConsole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).EnableInteractiveSerialConsole(ctx, req.(*EnableInteractiveSerialConsoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_DisableInteractiveSerialConsole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableInteractiveSerialConsoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).DisableInteractiveSerialConsole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/DisableInteractiveSerialConsole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).DisableInteractiveSerialConsole(ctx, req.(*DisableInteractiveSerialConsoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_DetachLun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetachLunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).DetachLun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/DetachLun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).DetachLun(ctx, req.(*DetachLunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ListSSHKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSSHKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListSSHKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListSSHKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListSSHKeys(ctx, req.(*ListSSHKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_CreateSSHKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSSHKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).CreateSSHKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/CreateSSHKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).CreateSSHKey(ctx, req.(*CreateSSHKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_DeleteSSHKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSSHKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).DeleteSSHKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/DeleteSSHKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).DeleteSSHKey(ctx, req.(*DeleteSSHKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ListVolumes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVolumesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListVolumes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListVolumes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListVolumes(ctx, req.(*ListVolumesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_GetVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).GetVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).GetVolume(ctx, req.(*GetVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_UpdateVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).UpdateVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).UpdateVolume(ctx, req.(*UpdateVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_RenameVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).RenameVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/RenameVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).RenameVolume(ctx, req.(*RenameVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_EvictVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EvictVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).EvictVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/EvictVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).EvictVolume(ctx, req.(*EvictVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ResizeVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResizeVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ResizeVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/ResizeVolume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ResizeVolume(ctx, req.(*ResizeVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ListNetworks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListNetworks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListNetworks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListNetworks(ctx, req.(*ListNetworksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ListNetworkUsage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworkUsageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListNetworkUsage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListNetworkUsage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListNetworkUsage(ctx, req.(*ListNetworkUsageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_GetNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).GetNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetNetwork",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).GetNetwork(ctx, req.(*GetNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_UpdateNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).UpdateNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateNetwork",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).UpdateNetwork(ctx, req.(*UpdateNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_CreateVolumeSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVolumeSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).CreateVolumeSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/CreateVolumeSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).CreateVolumeSnapshot(ctx, req.(*CreateVolumeSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_RestoreVolumeSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreVolumeSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).RestoreVolumeSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/RestoreVolumeSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).RestoreVolumeSnapshot(ctx, req.(*RestoreVolumeSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_DeleteVolumeSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVolumeSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).DeleteVolumeSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/DeleteVolumeSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).DeleteVolumeSnapshot(ctx, req.(*DeleteVolumeSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_GetVolumeSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVolumeSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).GetVolumeSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetVolumeSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).GetVolumeSnapshot(ctx, req.(*GetVolumeSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ListVolumeSnapshots_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVolumeSnapshotsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListVolumeSnapshots(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListVolumeSnapshots",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListVolumeSnapshots(ctx, req.(*ListVolumeSnapshotsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_GetLun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).GetLun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetLun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).GetLun(ctx, req.(*GetLunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ListLuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListLuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListLuns",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListLuns(ctx, req.(*ListLunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_EvictLun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EvictLunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).EvictLun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/EvictLun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).EvictLun(ctx, req.(*EvictLunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_GetNfsShare_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNfsShareRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).GetNfsShare(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetNfsShare",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).GetNfsShare(ctx, req.(*GetNfsShareRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ListNfsShares_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNfsSharesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListNfsShares(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListNfsShares",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListNfsShares(ctx, req.(*ListNfsSharesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_UpdateNfsShare_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNfsShareRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).UpdateNfsShare(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateNfsShare",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).UpdateNfsShare(ctx, req.(*UpdateNfsShareRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_CreateNfsShare_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNfsShareRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).CreateNfsShare(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/CreateNfsShare",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).CreateNfsShare(ctx, req.(*CreateNfsShareRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_RenameNfsShare_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameNfsShareRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).RenameNfsShare(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/RenameNfsShare",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).RenameNfsShare(ctx, req.(*RenameNfsShareRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_DeleteNfsShare_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNfsShareRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).DeleteNfsShare(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/DeleteNfsShare",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).DeleteNfsShare(ctx, req.(*DeleteNfsShareRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ListProvisioningQuotas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProvisioningQuotasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListProvisioningQuotas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListProvisioningQuotas",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListProvisioningQuotas(ctx, req.(*ListProvisioningQuotasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_SubmitProvisioningConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubmitProvisioningConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).SubmitProvisioningConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/SubmitProvisioningConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).SubmitProvisioningConfig(ctx, req.(*SubmitProvisioningConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_GetProvisioningConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProvisioningConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).GetProvisioningConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetProvisioningConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).GetProvisioningConfig(ctx, req.(*GetProvisioningConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_CreateProvisioningConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProvisioningConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).CreateProvisioningConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/CreateProvisioningConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).CreateProvisioningConfig(ctx, req.(*CreateProvisioningConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_UpdateProvisioningConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProvisioningConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).UpdateProvisioningConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateProvisioningConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).UpdateProvisioningConfig(ctx, req.(*UpdateProvisioningConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_RenameNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).RenameNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/RenameNetwork",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).RenameNetwork(ctx, req.(*RenameNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ListOSImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOSImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListOSImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListOSImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListOSImages(ctx, req.(*ListOSImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BareMetalSolution_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.baremetalsolution.v2.BareMetalSolution",
	HandlerType: (*BareMetalSolutionServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstances",
			Handler:    _BareMetalSolution_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _BareMetalSolution_GetInstance_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _BareMetalSolution_UpdateInstance_Handler,
		},
		{
			MethodName: "RenameInstance",
			Handler:    _BareMetalSolution_RenameInstance_Handler,
		},
		{
			MethodName: "ResetInstance",
			Handler:    _BareMetalSolution_ResetInstance_Handler,
		},
		{
			MethodName: "StartInstance",
			Handler:    _BareMetalSolution_StartInstance_Handler,
		},
		{
			MethodName: "StopInstance",
			Handler:    _BareMetalSolution_StopInstance_Handler,
		},
		{
			MethodName: "EnableInteractiveSerialConsole",
			Handler:    _BareMetalSolution_EnableInteractiveSerialConsole_Handler,
		},
		{
			MethodName: "DisableInteractiveSerialConsole",
			Handler:    _BareMetalSolution_DisableInteractiveSerialConsole_Handler,
		},
		{
			MethodName: "DetachLun",
			Handler:    _BareMetalSolution_DetachLun_Handler,
		},
		{
			MethodName: "ListSSHKeys",
			Handler:    _BareMetalSolution_ListSSHKeys_Handler,
		},
		{
			MethodName: "CreateSSHKey",
			Handler:    _BareMetalSolution_CreateSSHKey_Handler,
		},
		{
			MethodName: "DeleteSSHKey",
			Handler:    _BareMetalSolution_DeleteSSHKey_Handler,
		},
		{
			MethodName: "ListVolumes",
			Handler:    _BareMetalSolution_ListVolumes_Handler,
		},
		{
			MethodName: "GetVolume",
			Handler:    _BareMetalSolution_GetVolume_Handler,
		},
		{
			MethodName: "UpdateVolume",
			Handler:    _BareMetalSolution_UpdateVolume_Handler,
		},
		{
			MethodName: "RenameVolume",
			Handler:    _BareMetalSolution_RenameVolume_Handler,
		},
		{
			MethodName: "EvictVolume",
			Handler:    _BareMetalSolution_EvictVolume_Handler,
		},
		{
			MethodName: "ResizeVolume",
			Handler:    _BareMetalSolution_ResizeVolume_Handler,
		},
		{
			MethodName: "ListNetworks",
			Handler:    _BareMetalSolution_ListNetworks_Handler,
		},
		{
			MethodName: "ListNetworkUsage",
			Handler:    _BareMetalSolution_ListNetworkUsage_Handler,
		},
		{
			MethodName: "GetNetwork",
			Handler:    _BareMetalSolution_GetNetwork_Handler,
		},
		{
			MethodName: "UpdateNetwork",
			Handler:    _BareMetalSolution_UpdateNetwork_Handler,
		},
		{
			MethodName: "CreateVolumeSnapshot",
			Handler:    _BareMetalSolution_CreateVolumeSnapshot_Handler,
		},
		{
			MethodName: "RestoreVolumeSnapshot",
			Handler:    _BareMetalSolution_RestoreVolumeSnapshot_Handler,
		},
		{
			MethodName: "DeleteVolumeSnapshot",
			Handler:    _BareMetalSolution_DeleteVolumeSnapshot_Handler,
		},
		{
			MethodName: "GetVolumeSnapshot",
			Handler:    _BareMetalSolution_GetVolumeSnapshot_Handler,
		},
		{
			MethodName: "ListVolumeSnapshots",
			Handler:    _BareMetalSolution_ListVolumeSnapshots_Handler,
		},
		{
			MethodName: "GetLun",
			Handler:    _BareMetalSolution_GetLun_Handler,
		},
		{
			MethodName: "ListLuns",
			Handler:    _BareMetalSolution_ListLuns_Handler,
		},
		{
			MethodName: "EvictLun",
			Handler:    _BareMetalSolution_EvictLun_Handler,
		},
		{
			MethodName: "GetNfsShare",
			Handler:    _BareMetalSolution_GetNfsShare_Handler,
		},
		{
			MethodName: "ListNfsShares",
			Handler:    _BareMetalSolution_ListNfsShares_Handler,
		},
		{
			MethodName: "UpdateNfsShare",
			Handler:    _BareMetalSolution_UpdateNfsShare_Handler,
		},
		{
			MethodName: "CreateNfsShare",
			Handler:    _BareMetalSolution_CreateNfsShare_Handler,
		},
		{
			MethodName: "RenameNfsShare",
			Handler:    _BareMetalSolution_RenameNfsShare_Handler,
		},
		{
			MethodName: "DeleteNfsShare",
			Handler:    _BareMetalSolution_DeleteNfsShare_Handler,
		},
		{
			MethodName: "ListProvisioningQuotas",
			Handler:    _BareMetalSolution_ListProvisioningQuotas_Handler,
		},
		{
			MethodName: "SubmitProvisioningConfig",
			Handler:    _BareMetalSolution_SubmitProvisioningConfig_Handler,
		},
		{
			MethodName: "GetProvisioningConfig",
			Handler:    _BareMetalSolution_GetProvisioningConfig_Handler,
		},
		{
			MethodName: "CreateProvisioningConfig",
			Handler:    _BareMetalSolution_CreateProvisioningConfig_Handler,
		},
		{
			MethodName: "UpdateProvisioningConfig",
			Handler:    _BareMetalSolution_UpdateProvisioningConfig_Handler,
		},
		{
			MethodName: "RenameNetwork",
			Handler:    _BareMetalSolution_RenameNetwork_Handler,
		},
		{
			MethodName: "ListOSImages",
			Handler:    _BareMetalSolution_ListOSImages_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/baremetalsolution/v2/baremetalsolution.proto",
}
