/* assembly to compute the key powers */

#include "crypto_asm_hidden.h"
// linker define poly1305_maax_g4_keypowers
// linker use mask2
// linker use mask2c

#define mask2  CRYPTO_SHARED_NAMESPACE(mask2)
#define mask2c CRYPTO_SHARED_NAMESPACE(mask2c)

#include "poly1305_keypowers_asm.h"
		
	.p2align 5
	
ASM_HIDDEN _CRYPTO_SHARED_NAMESPACE(poly1305_maax_g4_keypowers)
ASM_HIDDEN CRYPTO_SHARED_NAMESPACE(poly1305_maax_g4_keypowers)
.global _CRYPTO_SHARED_NAMESPACE(poly1305_maax_g4_keypowers)
.global CRYPTO_SHARED_NAMESPACE(poly1305_maax_g4_keypowers)
_CRYPTO_SHARED_NAMESPACE(poly1305_maax_g4_keypowers):
CRYPTO_SHARED_NAMESPACE(poly1305_maax_g4_keypowers):
	
	movq 	%rsp,%r11
	andq    $-32,%rsp
	subq 	$64,%rsp

	movq 	%r11,0(%rsp)
	movq 	%r12,8(%rsp)
	movq 	%r13,16(%rsp)
	movq 	%r14,24(%rsp)
	movq 	%r15,32(%rsp)
	movq 	%rbx,40(%rsp)
	movq 	%rbp,48(%rsp)

	/* key = tau */
	movq    0(%rdi),%r14
	movq    8(%rdi),%r15
	
	/* tau^2 */	
	fe1305_tau_square()
	
	cmp	$3,%rsi
	je	.L2
	
	cmp	$4,%rsi
	je	.L1

	/* tau^4 */	
	fe1305_tau_squaren(3)
	
.L1:	
	/* tau^3 */
	fe1305_mul_tau_taun(1,2)

.L2:
	movq 	0(%rsp),%r11
	movq 	8(%rsp),%r12
	movq 	16(%rsp),%r13
	movq 	24(%rsp),%r14
	movq 	32(%rsp),%r15
	movq 	40(%rsp),%rbx
	movq 	48(%rsp),%rbp

	movq 	%r11,%rsp

	ret
