#line 1 "lex.c"
/* This file is part of Mailfromd.
   Copyright (C) 2005-2025 Sergey Poznyakoff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#line 22 "lex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

/* %not-for-header */
/* %if-c-only */
/* %if-not-reentrant */

/* %endif */
/* %endif */
/* %ok-for-header */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* %if-c++-only */
/* %endif */

/* %if-c-only */

/* %endif */

/* %if-c-only */

/* %endif */

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
/* %if-c-only */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
/* %endif */

/* %if-tables-serialization */
/* %endif */
/* end standard C headers. */

/* %if-c-or-c++ */
/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* %endif */

/* begin standard C++ headers. */
/* %if-c++-only */
/* %endif */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* %not-for-header */
/* Returned upon end-of-file. */
#define YY_NULL 0
/* %ok-for-header */

/* %not-for-header */
/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))
/* %ok-for-header */

/* %if-reentrant */
/* %endif */

/* %if-not-reentrant */

/* %endif */

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

/* %if-not-reentrant */
extern int yyleng;
/* %endif */

/* %if-c-only */
/* %if-not-reentrant */
extern FILE *yyin, *yyout;
/* %endif */
/* %endif */

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
/* %if-c-only */
	FILE *yy_input_file;
/* %endif */

/* %if-c++-only */
/* %endif */

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */
/* %if-not-reentrant */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */
/* %endif */
/* %ok-for-header */

/* %endif */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* %if-c-only Standard (non-C++) definition */

/* %if-not-reentrant */
/* %not-for-header */
/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;
/* %ok-for-header */

/* %endif */

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

/* %endif */

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* %% [1.0] yytext/yyin/yyout/yy_state_type/yylineno etc. def's & init go here */
/* Begin user sect3 */

#define FLEX_DEBUG
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

/* %% [1.5] DFA */

/* %if-c-only Standard (non-C++) definition */

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* %endif */

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
/* %% [2.0] code to fiddle yytext and yyleng for yymore() goes here \ */\
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
/* %% [3.0] code to copy yytext_ptr to yytext[] goes here, if %array \ */\
	(yy_c_buf_p) = yy_cp;
/* %% [4.0] data tables for the DFA and the user's section 1 definitions go here */
#define YY_NUM_RULES 153
#define YY_END_OF_BUFFER 154
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[1004] =
    {   0,
        0,    0,    2,    2,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  154,  152,
      136,  137,  152,  152,   17,  152,  152,  144,  152,  152,
      152,  104,  104,  140,  138,  142,  106,  152,  146,  106,
      106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
      106,  106,  106,  106,  106,  106,  106,  145,  147,  136,
       17,    2,    4,    3,    2,    2,  153,  153,  118,  132,
      132,  153,  151,  134,  132,  132,  151,  153,  135,  153,
      151,  128,   21,   19,   20,   21,   18,  153,    8,  153,
      106,  106,  106,  136,   17,  136,  139,    0,  108,  110,

      110,   17,   16,   90,   92,   91,   93,   96,    0,    0,
        0,    0,  107,    0,    1,  103,    0,  104,  148,  141,
      138,  143,  149,  106,  100,  106,  106,  106,  106,  106,
      106,  106,  106,  106,  106,  106,  106,   35,  106,  106,
       31,  106,  106,  106,  106,   30,  106,  106,  106,  106,
      106,  106,  106,  106,   34,   42,  106,  106,  106,  106,
      106,  106,  106,  106,  106,  106,  106,  106,  106,  136,
        0,   17,   17,   17,   17,   17,   17,   17,   17,    2,
        3,    3,    5,    2,    2,    2,    2,    0,  118,  119,
      119,   94,  131,   95,   98,    0,   88,   88,    0,  125,

      117,  125,  101,  125,    0,  134,  129,  133,    0,  135,
      130,    0,  128,   19,   18,    0,    8,    0,   83,  106,
      106,  136,    0,   17,  110,  116,  109,  116,  116,   91,
       96,    0,    0,    0,  150,  103,  102,    0,    0,    0,
        0,  100,  106,  106,  106,  106,  106,  106,  106,  106,
      106,   27,  106,   43,  106,   78,  106,  106,  106,  106,
      106,  106,  106,  106,  106,  106,  106,  106,   66,  106,
      106,  106,  106,  106,  106,    0,  106,   44,  106,  106,
      106,  106,  106,  106,  106,  106,  106,  105,   47,  106,
      106,  106,  106,  106,   49,  106,  106,  106,  106,    0,

        0,    0,    0,    0,    0,    0,   17,   17,   17,   17,
       17,   17,   17,   17,   17,    2,  117,   95,   98,    0,
       88,   88,    0,    0,  124,  123,  101,    0,    0,    7,
      106,  106,    0,  109,  115,  114,    0,    0,   97,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  102,    0,
        0,    0,    0,  126,    0,  106,  106,  106,  106,  106,
      106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
       55,  106,  106,  106,  106,  106,  106,  106,   36,   50,
       33,   32,  106,   74,   53,  106,   64,  106,  106,    0,
        0,    0,   45,  106,   68,  106,   46,  106,  106,  106,

      106,  106,  106,  106,  106,  106,  106,  106,   59,   41,
      106,    0,    0,    0,    0,    0,    0,    0,   17,    6,
       17,   17,   17,   17,   17,   17,    2,    0,   99,   88,
       88,   88,   88,   88,   88,   88,   88,    0,   89,    0,
      122,  123,  121,   82,   81,  113,  114,  112,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
      106,  106,  106,  106,   69,   67,   48,   62,  106,   79,
      106,  106,  106,  106,  106,  106,  106,    0,    0,  106,

      106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
       63,   70,   65,    0,    0,    0,    0,    0,    0,   17,
       17,   17,   17,   17,   17,   17,    2,   88,   88,   88,
       88,   88,   88,   88,   88,   88,   88,   88,   88,    0,
        0,    0,    0,    0,    0,    0,    0,  123,  120,  114,
      111,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  127,  106,
      106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
      106,  106,   22,  106,  106,   29,  106,  106,   73,  106,

       77,    0,    0,   61,  106,   76,   23,  106,  106,   51,
       75,   60,   54,  106,    0,    0,    0,    0,    0,    0,
        0,   17,    9,   17,   17,   17,   17,   17,   17,    2,
       88,   88,   88,   88,   88,   88,   88,   88,   88,   88,
       88,   88,   88,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  106,  106,   80,  106,  106,  106,  106,  106,  106,
      106,  106,  106,  106,   56,   26,  106,   37,    0,    0,

        0,   58,  106,   28,   72,   52,    0,   57,  106,    0,
        9,    0,    0,    0,    0,    0,    0,   17,   17,   17,
       10,   17,   17,    2,   10,    0,   88,   88,   88,   88,
       88,   88,   88,   88,   88,   88,   88,   88,   88,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   84,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   80,  106,  106,
      106,  106,  106,  106,  106,  106,  106,   25,  106,    0,
        0,   71,   24,    0,    0,    0,    0,   17,   12,   17,

       17,   17,   88,   88,   86,   88,   88,   88,   88,   88,
       88,   88,   88,   88,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   84,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  106,
      106,  106,  106,  106,  106,   38,    0,    0,    0,   12,
        0,    0,    0,   17,   17,   17,   11,   17,   86,   88,
       88,   88,   88,   88,   88,   88,   88,   88,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   85,    0,

        0,    0,    0,    0,    0,    0,    0,  106,  106,  106,
      106,  106,    0,   39,    0,    0,    0,   11,    0,   17,
       15,   17,   17,   13,   88,   88,   88,   88,   88,   88,
        0,    0,   87,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  106,  106,    0,    0,   15,    0,    0,   13,
       17,   88,   88,   88,   88,   88,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   40,
        0,   17,   88,   88,    0,    0,    0,    0,    0,    0,
        0,    0,   17,    0,    0,    0,   17,    0,   17,   14,

        0,   14,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    5,    6,    7,    8,    9,   10,   11,   12,
        1,   13,    1,    1,   14,   15,   16,   17,   18,   18,
       18,   18,   18,   18,   18,   19,   19,    1,    1,   20,
       21,   22,    1,   23,   24,   24,   24,   24,   24,   24,
       25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
       25,   25,   25,   25,   25,   25,   25,   26,   25,   25,
        1,   27,    1,   28,   29,    1,   30,   31,   32,   33,

       34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
       44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
       54,   25,   55,   56,   57,   58,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR yy_meta[59] =
    {   0,
        1,    1,    2,    1,    1,    1,    3,    4,    5,    1,
        6,    7,    8,    9,    1,    1,   10,   11,   11,    1,
        1,    1,    7,   12,   13,   13,   14,    1,   13,   12,
       12,   12,   12,   12,   12,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   15,    1,   16,    1
    } ;

static const flex_int16_t yy_base[1065] =
    {   0,
        0,   57,   57,   64,   66,   70,   77,   79,   81,   91,
     2262, 2261,  118,    0, 2260,   60,   65,  175, 2262, 2266,
       94, 2266, 2240,  172, 2257,  177,   54, 2266, 2248, 2243,
     2244,  168,   94,   71, 2235,   93,    0,   98, 2266, 2226,
      160,  136,  158,  172,  166,  175,  173, 2210,  184,  183,
       58,  179, 2219,  189,  197,  167, 2215, 2266, 2266,  238,
      244,    0, 2266,  223,  248,  249,  248, 2266, 2266,  251,
      252,  269,  257, 2242,  284,  264,  280,  268, 2266,  291,
     2247, 2266, 2266,  309, 2266, 2236,    0, 2245, 2266,  100,
      282, 2203,  274,  324,  343,  325, 2266,  326, 2266, 2266,

      333, 2243, 2266, 2266, 2266,  323, 2266,    0,    0, 2216,
     2215, 2232, 2266, 2227, 2266,  250,    0,  337,  338, 2266,
     2266, 2266, 2266,    0,  340,  331, 2209, 2207, 2201, 2205,
     2203, 2202,  231, 2192, 2193,  189, 2185, 2189, 2194,  226,
        0, 2188, 2182, 2184, 2184,    0, 2181, 2181, 2175, 2190,
      366, 2169, 2172, 2178,    0,    0, 2171,  340, 2187,  344,
      267,  290, 2179, 2174, 2168, 2160, 2168, 2174,  267,  390,
      396,  447,  400,  403,  291,  240,  340,  366,  357,    0,
      383,  395, 2266,  421,  415,  422, 2173,  427, 2266, 2266,
     2207, 2266, 2266,  421,    0,    0,    0, 2180, 2179,  434,

      437,  450,  452,  464,  471, 2198, 2266, 2266,  475, 2266,
     2266, 2203, 2266,  408,    0, 2202, 2266,  491,    0, 2156,
     2162,  425,  485,  536, 2199,  488,  497,  499,  501,  494,
        0, 2144,  500, 2171, 2266,  384,    0,    0,  539,  588,
      433,  503, 2165,  313, 2160, 2159,  514,  471, 2147, 2161,
     2160,    0, 2163,    0, 2162,    0, 2157, 2158,  404, 2155,
     2158, 2153, 2154, 2151, 2140, 2148, 2148, 2151,    0, 2138,
     2147, 2134, 2132, 2144, 2125,  525, 2125,    0, 2142, 2124,
     2139, 2134, 2128, 2134, 2126, 2116, 2115,    0,    0, 2115,
     2125, 2113, 2116, 2116,    0, 2110, 2125, 2114, 2115,    0,

      545, 2108, 2111, 2115, 2105, 2121,  415, 2147,  569,  645,
      487,  377,  522,  452,  529, 2106, 2266,  560,    0, 2091,
        0,  624, 2090,  457, 2266,  659,  565,    0,  583, 2266,
     2097, 2104,  669, 2266, 2266,  672,    0, 2087, 2266, 2109,
      518, 2104, 2103,  640,  644, 2091, 2105,  660,    0, 2127,
      671, 2134,  648, 2266,    0, 2101, 2094, 2091, 2084, 2089,
     2092, 2087, 2096,  651, 2094, 2097, 2079, 2080, 2076, 2083,
        0, 2085, 2072, 2082, 2066, 2068, 2068, 2086,    0,    0,
        0,    0, 2066,    0,    0, 2067,    0, 2076, 2071,  690,
     2068, 2080,    0, 2075,    0, 2070,    0, 2069, 2074, 2075,

     2066, 2056, 2064, 2058, 2068, 2064, 2046, 2050,    0,    0,
     2062,  555,  711, 2048, 2062, 2050, 2062, 2044, 2087, 2266,
      650,  676,  459,  701,  703,  694, 2055, 2031, 2266, 2053,
      672, 2048, 2047,  679,  686, 2035, 2049, 2025, 2266,  707,
     2266,  736,  738,    0,    0, 2266,  742,  748, 2046, 2039,
     2036, 2029, 2034, 2037, 2032, 2041,  687, 2039, 2042, 2024,
     2036,  674, 2031, 2030,  732,  731, 2018, 2032,  764, 2054,
      610, 2030, 2031, 2033, 2027, 2016, 2015, 2008, 2017, 2024,
     2010, 2005, 2005, 2003,    0,    0,    0,    0, 2008,    0,
     2009, 2015, 2001, 2015, 1997, 2011, 2010, 2001, 1993, 1994,

     1996, 2007, 1989, 2005, 1989, 1992, 2002, 1997, 1995, 2001,
        0,    0,    0, 2024, 1985, 1987, 1993, 1990, 1982,  728,
      735,  724,  723,  777,  769,  771,  780, 1989, 1982, 1979,
     1972, 1977, 1980, 1975, 1984,  745, 1982, 1985, 1967,  512,
      745,  419,  747,  759,  758,  741,  753,  791, 2266,  798,
     2266,  748, 1979, 1980, 1982, 1976, 1965, 1964, 1957, 1966,
     1973, 1959, 1954, 1954, 1966, 1959, 1956, 1949, 1954, 1957,
     1952, 1961,  759, 1959, 1962, 1944, 1987,  810, 2266, 1942,
     1959, 1938, 1957, 1956, 1937, 1936, 1941, 1951, 1943, 1932,
     1944, 1939,    0, 1926, 1926,    0, 1941, 1936,    0, 1924,

        0, 1941, 1938,  815, 1919,    0,    0, 1934, 1933, 1918,
        0,  818,    0, 1927, 1958,  818, 1916, 1912,  824, 1919,
     1922,  826, 2266,  828,  833,  820, 1956,  830,  798,  372,
      794, 1924, 1925, 1927, 1921, 1910, 1909, 1902, 1911, 1918,
     1904, 1899, 1899,  805,  797,  800,  795,  802,  807,  804,
      815,  817,  816,  821,  808, 1899, 1916, 1895, 1914, 1913,
     1894, 1893, 1898, 1908, 1900, 1889, 1901, 1896,  822, 1899,
     1900, 1902, 1896, 1885, 1884, 1877, 1886, 1893, 1879, 1874,
     1874, 1892, 1882,    0, 1890, 1889, 1888, 1882, 1879, 1885,
     1869, 1879, 1867, 1876,    0,    0, 1875,    0, 1859, 1870,

      867, 2266, 1858,    0,    0,    0,  873, 2266, 1864,  877,
     2266,  878,  854, 1871, 1900, 1872, 1858, 1897,  860, 1896,
     2266,  884,  865,  879, 2266, 1895, 1850, 1867, 1846, 1865,
     1864, 1845, 1844, 1849, 1859, 1851, 1840, 1852, 1847,  845,
      842,  857,  862,  861,  852,  853,  604,  858,  868,  859,
      854,  860, 1855, 1845, 2266, 1853, 1852, 1851, 1845, 1842,
     1848, 1832, 1842, 1830, 1826, 1843, 1822, 1841, 1840, 1821,
     1820, 1825, 1835, 1827, 1816, 1828, 1823,    0, 1816, 1830,
     1829, 1828, 1822, 1826, 1822, 1815, 1809,    0, 1803, 1818,
     1815,    0,    0, 1845, 1813,  903, 1810, 1842, 2266,  918,

     1841,  924, 1814, 1804,    0, 1812, 1811, 1810, 1804, 1801,
     1807, 1791, 1801, 1789,  866,  877,  875,  883,  900,  884,
      886,  889,  905,  334,  891,  902,  899, 2266, 1788, 1802,
     1801, 1800, 1794, 1798, 1794, 1787, 1527, 1487, 1477, 1457,
     1476, 1475, 1469, 1463, 1436, 1442, 1421, 1428, 1416, 1416,
     1429, 1425, 1421, 1402, 1419,    0, 1410, 1385, 1429, 2266,
      940, 1427,  947, 1426,  936, 1412, 2266, 1316,    0, 1272,
     1286, 1285, 1284, 1278, 1282, 1276, 1266, 1260,  916,  914,
     1245,  921,  924,  925,  926,  919,  929,  917,  930,  920,
     1258, 1271, 1270, 1253, 1219, 1227, 1193, 1186, 2266, 1198,

     1194, 1193, 1187, 1190, 1186, 1179, 1142, 1057, 1056, 1055,
     1054, 1053, 1040, 2266,   59,  143,  232, 2266,  309,  314,
     2266,  962,  472, 2266,  488,  551,  689,  757,  745,  937,
      910,  928, 2266,  939,  941,  946,  945,  955,  956,  951,
      947,  962,  963,  964,  965,  966,  954,  970,  971,  972,
      959,  978,  980,  981,  963, 1011, 2266,  972, 1013, 2266,
     1014,  989,  990,  991,  992,  993,  980,  995,  996,  997,
      981,  998, 1000, 1001, 1002, 1003, 1004, 1005, 1006, 2266,
     1004, 1036, 1011, 1012, 1014, 1015, 1016, 1018, 1019, 1013,
     1020, 1016, 1054, 1022, 1030, 1058, 1058, 1060, 1061, 2266,

     1062, 2266, 2266, 1087, 1103, 1119, 1135, 1151, 1167, 1183,
     1199, 1213, 1228, 1235, 1248, 1264, 1280, 1294, 1305, 1320,
     1336, 1352, 1368, 1375, 1388, 1404, 1411, 1054, 1415, 1422,
     1427, 1056, 1431, 1065, 1441, 1452, 1457, 1464, 1068, 1476,
     1483, 1490, 1497, 1500, 1507, 1520, 1536, 1552, 1568, 1584,
     1600, 1616, 1632, 1648, 1664, 1680, 1696, 1712, 1728, 1744,
     1760, 1776, 1792, 1808
    } ;

static const flex_int16_t yy_def[1065] =
    {   0,
     1003,    1, 1004, 1004, 1005, 1005, 1006, 1006, 1007, 1007,
     1008, 1008, 1003,   13, 1009, 1009,    1,    1, 1003, 1003,
     1003, 1003, 1003, 1010, 1011, 1012, 1003, 1003, 1013, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1014, 1003, 1003, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1003, 1003, 1003,
     1011, 1015, 1003, 1016, 1015, 1015, 1017, 1003, 1003, 1018,
     1019, 1020, 1021, 1003, 1018, 1019, 1020, 1022, 1003, 1020,
     1023, 1003, 1003, 1003, 1003, 1003, 1024, 1025, 1003, 1025,
     1014, 1014, 1014, 1003, 1011, 1003, 1003, 1010, 1003, 1003,

     1026, 1011, 1003, 1003, 1003, 1003, 1003, 1027, 1028, 1003,
     1003, 1013, 1003, 1003, 1003, 1003, 1029, 1003, 1030, 1003,
     1003, 1003, 1003, 1014, 1003, 1014, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1003,
     1003, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1015,
     1016, 1016, 1003, 1015, 1015, 1015, 1015, 1017, 1003, 1003,
     1003, 1003, 1003, 1003, 1031, 1032, 1033, 1033, 1034, 1003,

     1003, 1003, 1003, 1035, 1021, 1003, 1003, 1003, 1022, 1003,
     1003, 1023, 1003, 1003, 1024, 1025, 1003, 1025, 1014, 1014,
     1014, 1003, 1003, 1011, 1003, 1003, 1003, 1003, 1036, 1003,
     1027, 1037, 1003, 1003, 1003, 1003, 1038, 1039, 1030, 1003,
     1030, 1003, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1014, 1003, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,  171,

     1003, 1003, 1003, 1003, 1003, 1003, 1011, 1040, 1011, 1011,
     1011, 1011, 1011, 1011, 1011, 1015, 1003, 1003, 1031, 1041,
     1033, 1033, 1042, 1042, 1003, 1003, 1003, 1043, 1025, 1003,
     1014, 1014, 1003, 1003, 1003, 1003, 1044, 1037, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1038, 1045,
     1030, 1046, 1046, 1003,  240, 1014, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1003,
     1003, 1003, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,

     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
     1014, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1040, 1003,
     1047, 1011, 1011, 1011, 1011, 1011, 1015, 1041, 1003, 1033,
     1033, 1033, 1033, 1033, 1033, 1033, 1033, 1042, 1003, 1042,
     1003, 1003, 1003, 1014, 1014, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1048, 1045,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1003, 1003, 1014,

     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1049, 1003, 1003, 1003, 1003, 1003, 1047,
     1050, 1011, 1011, 1011, 1011, 1011, 1015, 1033, 1033, 1033,
     1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 1042,
     1042, 1042, 1042, 1042, 1042, 1042, 1042, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1048, 1048, 1003, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,

     1014, 1003, 1003, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1049, 1051, 1003, 1003, 1003, 1003,
     1003, 1050, 1003, 1050, 1011, 1011, 1052, 1011, 1011, 1053,
     1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033,
     1033, 1033, 1033, 1042, 1042, 1042, 1042, 1042, 1042, 1042,
     1042, 1042, 1042, 1042, 1042, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1003, 1003,

     1003, 1003, 1014, 1014, 1014, 1014, 1003, 1003, 1014, 1051,
     1003, 1051, 1003, 1003, 1054, 1003, 1003, 1055, 1011, 1052,
     1003, 1011, 1011, 1053, 1003, 1054, 1033, 1033, 1033, 1033,
     1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 1042,
     1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042,
     1042, 1042, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1014, 1014, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 1003,
     1003, 1014, 1014, 1056, 1003, 1003, 1003, 1055, 1003, 1011,

     1057, 1011, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033,
     1033, 1033, 1033, 1033, 1042, 1042, 1042, 1042, 1042, 1042,
     1042, 1042, 1042, 1042, 1042, 1042, 1042, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1014,
     1014, 1014, 1014, 1014, 1014, 1014, 1003, 1003, 1056, 1003,
     1003, 1058, 1003, 1059, 1011, 1057, 1003, 1060, 1033, 1033,
     1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 1042, 1042,
     1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042, 1042,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,

     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1014, 1014, 1014,
     1014, 1014, 1003, 1003, 1061, 1003, 1058, 1003, 1062, 1059,
     1003, 1011, 1060, 1003, 1033, 1033, 1033, 1033, 1033, 1033,
     1042, 1042, 1003, 1042, 1042, 1042, 1042, 1042, 1042, 1042,
     1042, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1014, 1014, 1003, 1061, 1003, 1003, 1062, 1003,
     1011, 1033, 1033, 1033, 1033, 1033, 1042, 1042, 1042, 1042,
     1042, 1042, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1011, 1033, 1033, 1042, 1042, 1042, 1042, 1042, 1003,
     1003, 1003, 1011, 1042, 1042, 1003, 1063, 1064, 1063, 1003,

     1064, 1003,    0, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003
    } ;

static const flex_int16_t yy_nxt[2325] =
    {   0,
       20,   21,   22,   21,   23,   24,   25,   26,   27,   28,
       29,   20,   20,   20,   30,   31,   32,   33,   33,   34,
       35,   36,   20,   37,   37,   37,   38,   39,   40,   41,
       42,   43,   44,   45,   46,   37,   37,   47,   37,   37,
       48,   49,   50,   51,   52,   37,   53,   54,   55,   37,
       56,   57,   37,   37,   20,   58,   20,   59,   60,   63,
       60,  957,   89,   61,   90,   65,   63,   65,   68,   64,
       66,   69,   68,   70,   71,   69,   64,   70,   71,   74,
       20,   74,  110,   79,   75,   76,   75,   76,   70,   71,
      119,  120,   72,   79,   91,   96,   72,   96,   70,   71,

      155,   92,  217,   77,  156,   77,  218,   80,  111,   93,
      118,  118,  118,  122,  123,  125,  125,   80,   83,   84,
       85,   84,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   86,   83,   83,   83,   83,   83,   83,
       83,   87,   87,   87,   83,   83,   87,   87,   87,   87,
       87,   87,   87,   87,   87,   87,   87,   87,   87,   87,
       87,   87,   87,   87,   87,   87,   87,   87,   87,   87,
       87,   87,   83,   83,   83,   83,   94,   99,   94,  100,
      100,   95,  131,  104,  116,  116,  958,  133,  105,  132,
       20,  127,  128,  117,  106,  106,  167,  139,  101,  107,

      129,  134,  130,  135,   91,  136,  140,  146,  157,  137,
      168,   92,  141,  149,  147,  138,  152,  142,  143,   93,
      117,  144,  161,  261,  145,  158,  153,  150,  159,  262,
      164,  109,  154,  165,  918,  182,  151,  162,  183,  170,
      163,  170,  103,  166,  171,  172,  103,  172,  173,  184,
      186,  184,  186,  189,  185,  190,  190,  192,  193,  206,
      193,  174,  174,  266,  207,  207,  236,  236,  194,  194,
      210,  201, 1003,  267,  191,  211,  211,  175,  257,  258,
      198,  176,  312,  207,  177,  202,  203,  203,  178,  187,
      192, 1003,  198,  103,  211,  179,  202,  203,  203,  288,

      298,  194,  194,  157,  299,  196,  199,  202,  203,  203,
      214,  960,  214,  127,  128,  289,  921,  221,  199,  290,
      158,  204,  129,  159,  130,  222,   96,  222,   96,  219,
      223,   99,  204,  100,  100,  227,  291,  311,  196,  230,
      230,  230,  103,  204,  224,  103,  224,  173,  238,  228,
      357,  239,  225,  118,  118,  118,  242,  242,  242,  103,
      174,  174,  358,  243,  241,  244,  245,  276,  103,  276,
      887,  246,  247,  281,  725,  248,  175,  313,  249,  103,
      176,  250,  284,  282,  726,  229,  315,  178,  285,  286,
      439,  170,  287,  170,  179, 1003,  171,  300, 1003,  300,

      236,  236,  103,  307,  309,  103,  309,  182,  423,  214,
      183,  214,  314,  301,  301,  308,  186,  103,  186,  310,
      310,  310,  184,  186,  184,  186,  222,  185,  222,  302,
      308,  223,  189,  303,  190,  190,  304,  318,  318,  318,
      305,  325,  325, 1003,  325,  325, 1003,  306,  172,  103,
      172,  373,  374,  191,  103,  187,  647,  325,  325, 1003,
      325,  103,  187,  325,  174,  174,  326,  326,  327,  327,
      327,  325,  325,  206,  924,  439,  325,  210,  207,  207,
      175,  425,  211,  211,  176,  440,  333,  177,  333,  103,
      325,  178,  329,  330,  329,  335,  335,  207,  179,  523,

      364,  211,  301,  301,  335,  335,  335,  335,  335,  335,
      230,  230,  230,  439,  335,  336,  336,  365,  302,  242,
      242,  242,  303,  335,  103,  335,  390,  335,  390,  305,
      962,  103,  340,  422,  341,  342,  306,  224,  103,  224,
      343,  344,  351,  361,  345,  644,  412,  346,  412,  238,
      347,  362, 1003,  174,  174,  450,  412,  363,  412,  391,
      514,  413,  413,  413,  424,  241,  392,  451,  439,  175,
      309,  103,  309,  176,  421,  426,  318,  318,  318,  869,
      178,  327,  327,  327,  329,  330,  329,  179,  352,  353,
      354,  353,  352,  352,  352,  352,  352,  352,  352,  352,

      352,  352,  352,  352,  355,  355,  355,  352,  352,  352,
      352,  355,  355,  355,  352,  352,  355,  355,  355,  355,
      355,  355,  355,  355,  355,  355,  355,  355,  355,  355,
      355,  355,  355,  355,  355,  355,  355,  355,  355,  355,
      355,  355,  352,  352,  352,  352,  309,  103,  309,  353,
      354,  353,  103,  822,  580,  521,  430,  249,  431,  432,
      439,  310,  310,  310,  433,  434,  441,  441,  435,  454,
      333,  436,  333,  457,  437,  442,  442,  455,  103,  446,
      446,  238,  479,  456, 1003,  441,  301,  301,  447,  447,
      458,  390,  461,  390,  462,  463,  103,  241,  446,  480,

      464,  465,  302,  103,  466,  103,  303,  467,  533,  529,
      468,  566,  412,  305,  412,  536,  534,  963,  560,  522,
      306,  530,  535,  567,  391,  103,  103,  413,  413,  413,
      103,  392,  537,  521,  524,  561,  526,  623,  525,  540,
      624,  541,  542,  441,  441,  549,  549,  543,  544,  446,
      446,  545,  548,  548,  546,  551,  551,  547,  550,  550,
      573,  570,  441,  439,  549,  578,  579,  578,  446,  571,
      625,  103,  626,  103,  551,  572,  639,  574,  627,  103,
      627,  630,  645,  630,  648,  964,  655,  652,  649,  654,
      677,  965,  656,  640,  646,  346,  650,  439,  441,  441,

      103,  439,  651,  439,  653,  446,  446,  678,  629,  439,
      628,  578,  579,  578,  439,  439,  701,  441,  701,  707,
      711,  707,  103,  712,  446,  715,  702,  715,  623,  708,
      623,  624,  103,  624,  718,  103,  718,  741,  727,  740,
      723,  436,  742,  743,  744,  745,  746,  747,  748,  750,
      751,  439,  719,  439,  752,  794,  439,  794,  439,  722,
      439,  439,  103,  439,  439,  749,  765,  103,  701,  467,
      701,  439,  439,  439,  707,  816,  707,  439,  702,  711,
      711,  725,  712,  712,  708,  801,  103,  801,  817,  815,
      818,  726,  546,  800,  819,  820,  821,  823,  439,  824,

      802,  439,  826,  825,  862,  879,  862,  827,  439,  439,
      439,  881,  653,  439,  439,  439,  439,  439,  439,  864,
      103,  864,  439,  880,  439,  868,  103,  868,  882,  885,
      883,  439,  884,  439,  886,  889,  890,  888,  103,  439,
      439,  915,  439,  915,  931,  439,  865,  439,  919,  931,
      919,  932,  934,  935,  937,  439,  439,  938,  439,  936,
      939,  439,  940,  941,  103,  966,  933,  881,  916,  881,
      439,  967,  439,  439,  968,  439,  439,  439,  969,  922,
      439,  439,  439,  881,  439,  439,  439,  970,  971,  972,
      973,  755,  828,  974,  755,  439,  975,  439,  897,  976,

      977,  439,  439,  439,  961,  978,  979,  439,  778,  778,
      980,  439,  439,  957,  981,  960,  103,  983,  805,  869,
      984,  805,  985,  931,  986,  987,  989,  988,  828,  828,
      990,  840,  897,  991,  840,  992,  439,  439,  103,  869,
      869,  897,  994,  881,  931,  982,  995,  881,  897,  996,
      931,  439,  439,  439,  439,  997,  103,  997,  931,  998,
     1000,  998, 1002, 1000, 1002,  232,  232,  320,  320,  993,
      439,  439,  439,  955,  439,  439,  323,  323,  439,  350,
      350,  684,  954,  778,  684,  953,  439,   62,   62,   62,
       62,   62,   62,   62,   62,   62,   62,   62,   62,   62,

       62,   62,   62,   67,   67,   67,   67,   67,   67,   67,
       67,   67,   67,   67,   67,   67,   67,   67,   67,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73,   73,   78,   78,   78,   78,   78,
       78,   78,   78,   78,   78,   78,   78,   78,   78,   78,
       78,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   88,   88,   88,
       88,   88,   88,   88,   88,   88,   88,   88,   88,   88,
       88,   88,   88,   98,  952,   98,   98,   98,   98,   98,
       98,   98,   98,   98,   98,   98,   98,   98,   98,  102,

      102,  102,  102,  102,  102,  102,  102,  102,  102,  102,
      102,  102,  102,  102,  102,  108,  951,  950,  840,  108,
      949,  948,  840,  108,  108,  108,  840,  108,  112,  947,
      112,  112,  112,  112,  112,  112,  112,  112,  112,  112,
      112,  112,  112,  112,  124,  124,  124,  124,  180,  899,
      180,  180,  180,  180,  180,  946,  180,  180,  180,  180,
      180,  180,  180,  180,  181,  945,  181,  181,  181,  181,
      181,  181,  181,  181,  181,  181,  181,  181,  181,  181,
      188,  944,  188,  188,  188,  188,  188,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  195,  195,  943,  828,

      942,  933,  930,  929,  195,  195,  195,  928,  195,  197,
      805,  927,  926,  805,  805,  925,  197,  197,  924,  197,
      200,  200,  200,  200,  200,  200,  200,  200,  200,  200,
      200,  200,  200,  200,  200,  200,  205,  205,  205,  205,
      205,  205,  205,  205,  205,  205,  205,  205,  205,  205,
      205,  205,  209,  209,  209,  209,  209,  209,  209,  209,
      209,  209,  209,  209,  209,  209,  209,  209,  212,  212,
      212,  212,  212,  212,  212,  212,  212,  212,  212,  212,
      212,  212,  212,  212,  215,  215,  215,  215,  216,  216,
      216,  216,  216,  216,  216,  216,  216,  216,  216,  216,

      216,  216,  216,  216,  226,  226,  226,  226,  226,  226,
      226,  226,  226,  226,  867,  226,  226,  226,  226,  226,
      231,  231,  231,  231,  237,  237,  237,  240,  921,  918,
      240,  860,  914,  240,  240,  240,  319,  319,  319,  319,
      321,  321,  321,  321,  328,  328,  913,  912,  911,  910,
      328,  328,  328,  909,  328,  337,  337,  778,  908,  907,
      906,  337,  337,  337,  905,  337,  338,  338,  338,  338,
      904,  903,  338,  349,  349,  349,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  428,  428,  428,  428,  902,  901,  428,  438,

      438,  438,  438,  900,  897,  438,  443,  443,  443,  448,
      448,  448,  470,  899,  898,  897,  470,  470,  470,  470,
      352,  352,  352,  352,  352,  352,  352,  352,  352,  352,
      352,  352,  352,  352,  352,  352,  520,  520,  520,  520,
      520,  520,  520,  520,  520,  520,  520,  520,  520,  520,
      520,  520,  577,  577,  577,  577,  577,  577,  577,  577,
      577,  577,  577,  577,  577,  577,  577,  577,  615,  896,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  622,  622,  622,  622,  622,  622,
      622,  622,  622,  622,  622,  622,  622,  622,  622,  622,

      710,  710,  710,  710,  710,  710,  710,  710,  710,  710,
      710,  710,  710,  710,  710,  710,  720,  720,  720,  720,
      720,  720,  720,  720,  720,  720,  720,  720,  720,  720,
      720,  720,  724,  724,  724,  724,  724,  724,  724,  724,
      724,  724,  724,  724,  724,  724,  724,  724,  726,  726,
      726,  726,  726,  726,  726,  726,  726,  726,  726,  726,
      726,  726,  726,  726,  798,  798,  798,  798,  798,  798,
      798,  798,  798,  798,  798,  798,  798,  798,  798,  798,
      859,  859,  859,  859,  859,  859,  859,  859,  859,  859,
      859,  859,  859,  859,  859,  859,  866,  866,  866,  866,

      866,  866,  866,  866,  866,  866,  866,  866,  866,  866,
      866,  866,  917,  917,  917,  917,  917,  917,  917,  917,
      917,  917,  917,  917,  917,  917,  917,  917,  920,  920,
      920,  920,  920,  920,  920,  920,  920,  920,  920,  920,
      920,  920,  920,  920,  923,  923,  923,  923,  923,  923,
      923,  923,  923,  923,  923,  923,  923,  923,  923,  923,
      956,  956,  956,  956,  956,  956,  956,  956,  956,  956,
      956,  956,  956,  956,  956,  956,  959,  959,  959,  959,
      959,  959,  959,  959,  959,  959,  959,  959,  959,  959,
      959,  959,  999,  999,  999,  999,  999,  999,  999,  999,

      999,  999,  999,  999,  999,  999,  999,  999, 1001, 1001,
     1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001,
     1001, 1001, 1001, 1001,  895,  894,  755,  893,  892,  755,
      755,  891,  878,  877,  876,  875,  874,  873,  872,  871,
      869,  870,  869,  867,  799,  863,  861,  860,  858,  857,
      856,  855,  854,  853,  684,  852,  851,  684,  684,  850,
      849,  848,  847,  846,  845,  844,  843,  842,  841,  840,
      839,  838,  574,  837,  836,  835,  834,  833,  832,  831,
      830,  828,  829,  828,  814,  813,  812,  811,  810,  809,
      808,  807,  806,  805,  804,  803,  537,  725,  721,  799,

      797,  796,  725,  795,  793,  792,  791,  790,  789,  788,
      787,  786,  785,  784,  783,  782,  781,  780,  778,  779,
      778,  777,  776,  775,  774,  773,  772,  771,  770,  769,
      768,  767,  766,  764,  763,  762,  761,  760,  759,  758,
      757,  756,  755,  754,  753,  458,  739,  738,  737,  736,
      735,  734,  733,  732,  731,  730,  729,  728,  721,  717,
      716,  714,  713,  616,  709,  706,  705,  704,  703,  700,
      699,  698,  697,  696,  695,  694,  693,  692,  691,  690,
      689,  688,  687,  686,  685,  684,  683,  682,  365,  579,
      681,  680,  679,  676,  675,  674,  673,  672,  671,  670,

      669,  668,  667,  666,  665,  664,  663,  662,  661,  660,
      659,  658,  657,  643,  642,  641,  638,  637,  636,  635,
      634,  633,  632,  631,  621,  620,  619,  618,  617,  616,
      614,  613,  612,  611,  610,  609,  608,  607,  606,  605,
      604,  603,  602,  601,  600,  599,  598,  597,  596,  595,
      594,  593,  592,  591,  590,  589,  588,  587,  586,  585,
      584,  583,  582,  581,  469,  576,  575,  569,  568,  565,
      564,  563,  562,  559,  558,  557,  556,  555,  554,  553,
      552,  439,  539,  538,  532,  531,  528,  429,  527,  420,
      519,  518,  517,  516,  515,  513,  512,  511,  510,  509,

      508,  507,  506,  505,  504,  503,  502,  501,  500,  499,
      498,  497,  496,  495,  494,  493,  492,  491,  490,  489,
      488,  487,  486,  485,  484,  483,  482,  481,  478,  477,
      476,  475,  474,  473,  472,  471,  354,  469,  460,  459,
      453,  452,  449,  339,  445,  444,  439,  429,  427,  420,
      418,  417,  416,  415,  414,  411,  410,  409,  408,  407,
      406,  405,  404,  403,  402,  401,  400,  399,  398,  397,
      396,  395,  394,  393,  389,  388,  387,  386,  385,  384,
      383,  382,  381,  380,  379,  378,  377,  376,  375,  372,
      371,  370,  369,  368,  367,  366,  360,  359,  356,  348,

      339,  334,  332,  331,  217,  213,  208,  324,  322,  317,
      316,  297,  296,  295,  294,  293,  292,  283,  280,  279,
      278,  277,  275,  274,  273,  272,  271,  270,  269,  268,
      265,  264,  263,  260,  259,  256,  255,  254,  253,  252,
      251,  235,  113,  234,  233,  103,  220,  217,  115,  213,
      208,  169,  160,  148,  126,  121,  115,  114,  113,  103,
       97, 1003,   89,   82,   82,   19, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,

     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003
    } ;

static const flex_int16_t yy_chk[2325] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        2,  915,   16,    2,   16,    4,    4,    4,    5,    3,
        4,    5,    6,    5,    5,    6,    4,    6,    6,    7,
       17,    8,   27,    9,    7,    7,    8,    8,    9,    9,
       34,   34,    5,   10,   17,   21,    6,   21,   10,   10,

       51,   17,   90,    7,   51,    8,   90,    9,   27,   17,
       33,   33,   33,   36,   36,   38,   38,   10,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   18,   24,   18,   24,
       24,   18,   42,   26,   32,   32,  916,   43,   26,   42,
       18,   41,   41,   32,   26,   26,   56,   45,   24,   26,

       41,   43,   41,   44,   18,   44,   45,   47,   52,   44,
       56,   18,   46,   49,   47,   44,   50,   46,   46,   18,
       32,   46,   54,  136,   46,   52,   50,   49,   52,  136,
       55,   26,   50,   55,  917,   64,   49,   54,   64,   60,
       54,   60,  176,   55,   60,   61,   61,   61,   61,   65,
       66,   65,   66,   67,   65,   67,   67,   70,   70,   73,
       71,   61,   61,  140,   73,   73,  116,  116,   70,   70,
       78,   72,   76,  140,   67,   78,   78,   61,  133,  133,
       71,   61,  176,   73,   61,   72,   72,   72,   61,   66,
       75,   75,   76,  175,   78,   61,   77,   77,   77,  161,

      169,   75,   75,   93,  169,   70,   71,   80,   80,   80,
       84,  919,   84,   91,   91,  161,  920,   93,   76,  162,
       93,   72,   91,   93,   91,   94,   96,   94,   96,   91,
       94,   98,   77,   98,   98,  101,  162,  175,   75,  106,
      106,  106,  177,   80,   95,   95,   95,   95,  119,  101,
      244,  119,   98,  118,  118,  118,  125,  125,  125,  179,
       95,   95,  244,  126,  119,  126,  126,  151,  178,  151,
      824,  126,  126,  158,  630,  126,   95,  177,  126,  312,
       95,  126,  160,  158,  630,  101,  179,   95,  160,  160,
      824,  170,  160,  170,   95,  181,  170,  171,  181,  171,

      236,  236,  173,  173,  174,  174,  174,  182,  312,  214,
      182,  214,  178,  171,  171,  173,  185,  307,  185,  174,
      174,  174,  184,  186,  184,  186,  222,  184,  222,  171,
      307,  222,  188,  171,  188,  188,  171,  194,  194,  194,
      171,  200,  200,  241,  201,  201,  241,  171,  172,  172,
      172,  259,  259,  188,  314,  185,  542,  202,  202,  241,
      200,  423,  186,  201,  172,  172,  202,  202,  203,  203,
      203,  204,  204,  205,  923,  542,  202,  209,  205,  205,
      172,  314,  209,  209,  172,  324,  223,  172,  223,  311,
      204,  172,  218,  218,  218,  226,  226,  205,  172,  423,

      248,  209,  223,  223,  227,  227,  228,  228,  229,  229,
      230,  230,  230,  324,  226,  228,  228,  248,  223,  242,
      242,  242,  223,  227,  313,  228,  276,  229,  276,  223,
      925,  315,  233,  311,  233,  233,  223,  224,  224,  224,
      233,  233,  239,  247,  233,  540,  301,  233,  301,  239,
      233,  247,  239,  224,  224,  341,  412,  247,  412,  276,
      412,  301,  301,  301,  313,  239,  276,  341,  540,  224,
      309,  309,  309,  224,  309,  315,  318,  318,  318,  926,
      224,  327,  327,  327,  329,  329,  329,  224,  240,  240,
      240,  240,  240,  240,  240,  240,  240,  240,  240,  240,

      240,  240,  240,  240,  240,  240,  240,  240,  240,  240,
      240,  240,  240,  240,  240,  240,  240,  240,  240,  240,
      240,  240,  240,  240,  240,  240,  240,  240,  240,  240,
      240,  240,  240,  240,  240,  240,  240,  240,  240,  240,
      240,  240,  240,  240,  240,  240,  310,  310,  310,  353,
      353,  353,  421,  747,  471,  421,  322,  471,  322,  322,
      747,  310,  310,  310,  322,  322,  326,  326,  322,  344,
      333,  322,  333,  345,  322,  326,  326,  344,  422,  336,
      336,  351,  364,  344,  351,  326,  333,  333,  336,  336,
      345,  390,  348,  390,  348,  348,  426,  351,  336,  364,

      348,  348,  333,  424,  348,  425,  333,  348,  434,  431,
      348,  462,  413,  333,  413,  435,  434,  927,  457,  422,
      333,  431,  434,  462,  390,  523,  522,  413,  413,  413,
      520,  390,  435,  520,  424,  457,  426,  521,  425,  440,
      521,  440,  440,  442,  442,  443,  443,  440,  440,  447,
      447,  440,  442,  442,  440,  448,  448,  440,  447,  447,
      466,  465,  442,  440,  443,  469,  469,  469,  447,  465,
      522,  525,  523,  526,  448,  465,  536,  466,  524,  524,
      524,  527,  541,  527,  543,  928,  547,  545,  544,  546,
      573,  929,  552,  536,  541,  552,  544,  546,  548,  548,

      629,  541,  544,  543,  545,  550,  550,  573,  526,  547,
      525,  578,  578,  578,  545,  544,  604,  548,  604,  612,
      616,  612,  626,  616,  550,  619,  604,  619,  622,  612,
      624,  622,  628,  624,  625,  625,  625,  645,  631,  644,
      629,  631,  646,  647,  648,  649,  650,  651,  652,  653,
      654,  647,  626,  645,  655,  713,  646,  713,  648,  628,
      650,  644,  719,  649,  655,  652,  669,  723,  701,  669,
      701,  651,  653,  652,  707,  741,  707,  654,  701,  710,
      712,  724,  710,  712,  707,  722,  722,  722,  742,  740,
      743,  724,  740,  719,  744,  745,  746,  748,  741,  749,

      723,  740,  751,  750,  796,  816,  796,  752,  745,  746,
      751,  818,  815,  742,  748,  750,  752,  744,  743,  800,
      800,  800,  815,  817,  749,  802,  802,  802,  819,  822,
      820,  817,  821,  816,  823,  826,  827,  825,  865,  818,
      820,  861,  821,  861,  879,  822,  800,  825,  863,  882,
      863,  880,  883,  884,  886,  827,  819,  887,  826,  885,
      888,  823,  889,  890,  922,  930,  931,  934,  861,  935,
      880,  932,  879,  888,  936,  886,  890,  882,  937,  865,
      883,  884,  885,  938,  932,  887,  889,  939,  940,  941,
      942,  943,  944,  945,  946,  934,  947,  935,  948,  949,

      950,  937,  936,  941,  922,  951,  952,  940,  953,  954,
      955,  938,  939,  956,  958,  959,  961,  962,  963,  964,
      965,  966,  967,  968,  969,  970,  972,  971,  973,  974,
      975,  976,  977,  978,  979,  981,  967,  971,  982,  983,
      984,  990,  985,  986,  987,  961,  988,  989,  991,  992,
      994,  968,  969,  970,  972,  993,  993,  993,  995,  996,
      997,  996,  998,  999, 1001, 1028, 1028, 1032, 1032,  982,
      985,  986,  987,  913,  988,  989, 1034, 1034,  994, 1039,
     1039,  912,  911,  910,  909,  908,  995, 1004, 1004, 1004,
     1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004,

     1004, 1004, 1004, 1005, 1005, 1005, 1005, 1005, 1005, 1005,
     1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 1006,
     1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006,
     1006, 1006, 1006, 1006, 1006, 1007, 1007, 1007, 1007, 1007,
     1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007, 1007,
     1007, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008,
     1008, 1008, 1008, 1008, 1008, 1008, 1008, 1009, 1009, 1009,
     1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009, 1009,
     1009, 1009, 1009, 1010,  907, 1010, 1010, 1010, 1010, 1010,
     1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1011,

     1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011,
     1011, 1011, 1011, 1011, 1011, 1012,  906,  905,  904, 1012,
      903,  902,  901, 1012, 1012, 1012,  900, 1012, 1013,  898,
     1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013,
     1013, 1013, 1013, 1013, 1014, 1014, 1014, 1014, 1015,  897,
     1015, 1015, 1015, 1015, 1015,  896, 1015, 1015, 1015, 1015,
     1015, 1015, 1015, 1015, 1016,  895, 1016, 1016, 1016, 1016,
     1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016, 1016,
     1017,  894, 1017, 1017, 1017, 1017, 1017, 1017, 1017, 1017,
     1017, 1017, 1017, 1017, 1017, 1017, 1018, 1018,  893,  892,

      891,  881,  878,  877, 1018, 1018, 1018,  876, 1018, 1019,
      875,  874,  873,  872,  871,  870, 1019, 1019,  868, 1019,
     1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020, 1020,
     1020, 1020, 1020, 1020, 1020, 1020, 1021, 1021, 1021, 1021,
     1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021,
     1021, 1021, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022,
     1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 1023, 1023,
     1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
     1023, 1023, 1023, 1023, 1024, 1024, 1024, 1024, 1025, 1025,
     1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025,

     1025, 1025, 1025, 1025, 1026, 1026, 1026, 1026, 1026, 1026,
     1026, 1026, 1026, 1026,  866, 1026, 1026, 1026, 1026, 1026,
     1027, 1027, 1027, 1027, 1029, 1029, 1029, 1030,  864,  862,
     1030,  859,  858, 1030, 1030, 1030, 1031, 1031, 1031, 1031,
     1033, 1033, 1033, 1033, 1035, 1035,  857,  855,  854,  853,
     1035, 1035, 1035,  852, 1035, 1036, 1036,  851,  850,  849,
      848, 1036, 1036, 1036,  847, 1036, 1037, 1037, 1037, 1037,
      846,  845, 1037, 1038, 1038, 1038, 1040, 1040, 1040, 1040,
     1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040,
     1040, 1040, 1041, 1041, 1041, 1041,  844,  843, 1041, 1042,

     1042, 1042, 1042,  842,  841, 1042, 1043, 1043, 1043, 1044,
     1044, 1044, 1045,  840,  839,  838, 1045, 1045, 1045, 1045,
     1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046,
     1046, 1046, 1046, 1046, 1046, 1046, 1047, 1047, 1047, 1047,
     1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047,
     1047, 1047, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
     1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1049,  837,
     1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049,
     1049, 1049, 1049, 1049, 1050, 1050, 1050, 1050, 1050, 1050,
     1050, 1050, 1050, 1050, 1050, 1050, 1050, 1050, 1050, 1050,

     1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051, 1051,
     1051, 1051, 1051, 1051, 1051, 1051, 1052, 1052, 1052, 1052,
     1052, 1052, 1052, 1052, 1052, 1052, 1052, 1052, 1052, 1052,
     1052, 1052, 1053, 1053, 1053, 1053, 1053, 1053, 1053, 1053,
     1053, 1053, 1053, 1053, 1053, 1053, 1053, 1053, 1054, 1054,
     1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054, 1054,
     1054, 1054, 1054, 1054, 1055, 1055, 1055, 1055, 1055, 1055,
     1055, 1055, 1055, 1055, 1055, 1055, 1055, 1055, 1055, 1055,
     1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056, 1056,
     1056, 1056, 1056, 1056, 1056, 1056, 1057, 1057, 1057, 1057,

     1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057, 1057,
     1057, 1057, 1058, 1058, 1058, 1058, 1058, 1058, 1058, 1058,
     1058, 1058, 1058, 1058, 1058, 1058, 1058, 1058, 1059, 1059,
     1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059, 1059,
     1059, 1059, 1059, 1059, 1060, 1060, 1060, 1060, 1060, 1060,
     1060, 1060, 1060, 1060, 1060, 1060, 1060, 1060, 1060, 1060,
     1061, 1061, 1061, 1061, 1061, 1061, 1061, 1061, 1061, 1061,
     1061, 1061, 1061, 1061, 1061, 1061, 1062, 1062, 1062, 1062,
     1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062, 1062,
     1062, 1062, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063,

     1063, 1063, 1063, 1063, 1063, 1063, 1063, 1063, 1064, 1064,
     1064, 1064, 1064, 1064, 1064, 1064, 1064, 1064, 1064, 1064,
     1064, 1064, 1064, 1064,  836,  835,  834,  833,  832,  831,
      830,  829,  814,  813,  812,  811,  810,  809,  808,  807,
      806,  804,  803,  801,  798,  797,  795,  794,  791,  790,
      789,  787,  786,  785,  784,  783,  782,  781,  780,  779,
      777,  776,  775,  774,  773,  772,  771,  770,  769,  768,
      767,  766,  765,  764,  763,  762,  761,  760,  759,  758,
      757,  756,  754,  753,  739,  738,  737,  736,  735,  734,
      733,  732,  731,  730,  729,  728,  727,  726,  720,  718,

      717,  716,  715,  714,  709,  703,  700,  699,  697,  694,
      693,  692,  691,  690,  689,  688,  687,  686,  685,  683,
      682,  681,  680,  679,  678,  677,  676,  675,  674,  673,
      672,  671,  670,  668,  667,  666,  665,  664,  663,  662,
      661,  660,  659,  658,  657,  656,  643,  642,  641,  640,
      639,  638,  637,  636,  635,  634,  633,  632,  627,  621,
      620,  618,  617,  615,  614,  610,  609,  608,  605,  603,
      602,  600,  598,  597,  595,  594,  592,  591,  590,  589,
      588,  587,  586,  585,  584,  583,  582,  581,  580,  577,
      576,  575,  574,  572,  571,  570,  569,  568,  567,  566,

      565,  564,  563,  562,  561,  560,  559,  558,  557,  556,
      555,  554,  553,  539,  538,  537,  535,  534,  533,  532,
      531,  530,  529,  528,  519,  518,  517,  516,  515,  514,
      510,  509,  508,  507,  506,  505,  504,  503,  502,  501,
      500,  499,  498,  497,  496,  495,  494,  493,  492,  491,
      489,  484,  483,  482,  481,  480,  479,  478,  477,  476,
      475,  474,  473,  472,  470,  468,  467,  464,  463,  461,
      460,  459,  458,  456,  455,  454,  453,  452,  451,  450,
      449,  438,  437,  436,  433,  432,  430,  428,  427,  419,
      418,  417,  416,  415,  414,  411,  408,  407,  406,  405,

      404,  403,  402,  401,  400,  399,  398,  396,  394,  392,
      391,  389,  388,  386,  383,  378,  377,  376,  375,  374,
      373,  372,  370,  369,  368,  367,  366,  365,  363,  362,
      361,  360,  359,  358,  357,  356,  352,  350,  347,  346,
      343,  342,  340,  338,  332,  331,  323,  320,  316,  308,
      306,  305,  304,  303,  302,  299,  298,  297,  296,  294,
      293,  292,  291,  290,  287,  286,  285,  284,  283,  282,
      281,  280,  279,  277,  275,  274,  273,  272,  271,  270,
      268,  267,  266,  265,  264,  263,  262,  261,  260,  258,
      257,  255,  253,  251,  250,  249,  246,  245,  243,  234,

      232,  225,  221,  220,  216,  212,  206,  199,  198,  191,
      187,  168,  167,  166,  165,  164,  163,  159,  157,  154,
      153,  152,  150,  149,  148,  147,  145,  144,  143,  142,
      139,  138,  137,  135,  134,  132,  131,  130,  129,  128,
      127,  114,  112,  111,  110,  102,   92,   88,   86,   81,
       74,   57,   53,   48,   40,   35,   31,   30,   29,   25,
       23,   19,   15,   12,   11, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,

     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003, 1003,
     1003, 1003, 1003, 1003
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 1;

static const flex_int16_t yy_rule_linenum[153] =
    {   0,
      543,  545,  546,  547,  548,  552,  558,  559,  562,  579,
      584,  589,  600,  611,  614,  618,  619,  622,  627,  628,
      629,  637,  638,  639,  640,  641,  642,  643,  644,  645,
      646,  647,  648,  649,  650,  651,  652,  653,  654,  655,
      656,  657,  658,  659,  660,  661,  662,  663,  664,  665,
      666,  667,  668,  669,  670,  671,  672,  673,  674,  675,
      676,  677,  678,  679,  680,  681,  682,  683,  684,  685,
      686,  687,  688,  689,  694,  695,  696,  738,  739,  741,
      744,  745,  746,  751,  754,  760,  763,  766,  770,  778,
      779,  780,  781,  785,  788,  796,  808,  814,  826,  832,

      833,  837,  838,  839,  841,  842,  879,  883,  887,  891,
      895,  900,  905,  910,  915,  920,  926,  927,  934,  942,
      947,  950,  955,  958,  963,  969,  970, 1010, 1032, 1041,
     1046, 1051, 1055, 1076, 1098, 1114, 1115, 1116, 1117, 1118,
     1119, 1120, 1121, 1122, 1123, 1124, 1125, 1126, 1127, 1128,
     1129, 1131
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "lex.l"

#line 26 "lex.l"
#include <sys/types.h>
#include <sys/stat.h>
#include "mailfromd.h"
#include <mailutils/yyloc.h>
#include "gram.h"
#include "prog.h"
#include "srvcfg.h"

static mu_linetrack_t trk;

static struct mu_locus_point start_locus; /* Location when the last state switch
					    occurred */
static mu_opool_t string_pool;   /* Opool for constructing string values */
static char *multiline_delimiter; /* End of here-document delimiter */
static size_t multiline_delimiter_len; /* Length of multiline_delimiter_len */
static int multiline_unescape;         /* Unescape here-document contents */
static int (*char_to_strip)(char);     /* Strip matching characters of each
					  here-document line */
struct mu_locus_range const *
get_locus(void)
{
	return &yylloc;
}

static int
is_tab(char c)
{
	return c == '\t';
}

static int
is_space(char c)
{
	return c == '\t' || c == ' ';
}

static unsigned char
c_unescape(unsigned char inc)
{
	int outc = mu_wordsplit_c_unquote_char(inc);
	return outc ? outc : inc;
}

static void
switch_origin(struct mu_locus_point *pt)
{
	mu_linetrack_origin(trk, pt);
	mu_locus_point_deinit(pt);
}

#define line_begin string_begin
#define line_add string_add
#define line_add_char string_add_char
static void line_finish(void);
static void string(const char *str, size_t len);
static int isemptystr(char *text);
static int builtin_const(const char *s, size_t len);


/* Input context flags */
#define INCTX_MODULE     0x1  /* current input is a MFL module */
#define INCTX_HADINPUT   0x2  /* some statements has already been processed */
#define INCTX_IGNORE_BYE 0x4  /* ignore eventual `bye' statement, because
				 this is an #included module */

/* Input context stack */
struct inctx {                     /* input context structure */
	struct inctx *parent;      /* parent context */
	struct mu_locus_range locus;/* locus where the context was pushed */
	mu_linetrack_t trk;
	struct input_file_ident id;/* file id structure to prevent recursion */
	FILE *file;                /* saved yyin */
	pid_t pp_pid;              /* preprocessor pid, if used */
	int inctx_flags;           /* input context flags */
	YY_BUFFER_STATE buf;       /* lex buffer state */
};

struct inctx *inctx_tos;           /* stack of input contexts */

/* Current input context: */
static pid_t pp_pid;               /* preprocessor pid */
static struct input_file_ident input_file_id;
static int inctx_flags;            /* input context flags */

/* If not 0, emit_token keeps a token that yylex must return on the
   next call. See YY_USER_ACTION below. */
static int emit_token;

/* Find on stack an input context that matches the given file id.
   Return pointer to the context. */
struct inctx *
inctx_locate(struct input_file_ident *id)
{
	struct inctx *ctx;

	for (ctx = inctx_tos; ctx; ctx = ctx->parent)
		if (ctx->id.device == id->device
		    && ctx->id.i_node == id->i_node)
			break;
	return ctx;
}

/* Push input context */
static void
inctx_push()
{
	struct inctx *ctx = mu_alloc(sizeof(*ctx));

	mu_locus_range_init(&ctx->locus);
	mu_locus_range_copy(&ctx->locus, &yylloc);
	ctx->trk = trk;
	ctx->id = input_file_id;
	ctx->file = yyin;
	ctx->pp_pid = pp_pid;
	ctx->inctx_flags = inctx_flags;
	ctx->buf = YY_CURRENT_BUFFER;
	ctx->parent = inctx_tos;
	inctx_tos = ctx;
}

/* Pop input context from the top of the stack into the current
   input context. Return 1 if there are no more contexts left. */
int
inctx_pop()
{
	struct inctx *ctx = inctx_tos;

	if (!ctx)
		return 1;

	inctx_tos = ctx->parent;

	mu_locus_range_deinit(&ctx->locus);
	trk = ctx->trk;
	yyin = ctx->file;
	input_file_id = ctx->id;
	inctx_flags = ctx->inctx_flags;
	yy_delete_buffer(YY_CURRENT_BUFFER);
	yy_switch_to_buffer(ctx->buf);
	pp_pid = ctx->pp_pid;
	free(ctx);
	return 0;
}

/* Setup the scanner for input from the file NAME. Return 0 on success,
   and an appropriate EX_ code on error. See lex_new_source below. */
static int
lex_new_source_0(const char *name)
{
	if (!yyin)
		mu_locus_range_init (&yylloc);
	if (preprocessor.enabled) {
		yyin = pp_extrn_start(name, &pp_pid);
		if (!yyin) {
			parse_error(_("unable to start external "
				      "preprocessor `%s': %s"),
				    string_preprocessor(),
				    mu_strerror(errno));
			return EX_OSFILE;
		}
	} else {
		yyin = fopen(name, "r");
		if (!yyin) {
			parse_error(_("cannot open %s: %s"), name,
				    mu_strerror(errno));
			return EX_NOINPUT;
		}
	}
	yy_switch_to_buffer(yy_create_buffer(yyin, YY_BUF_SIZE));
	MU_ASSERT(mu_linetrack_create(&trk, name, 2));
	mu_locus_point_set_file(&yylloc.beg, name);
	yylloc.beg.mu_line = 1;
	yylloc.beg.mu_col = 1;
	mu_locus_point_copy(&yylloc.end, &yylloc.beg);
	mu_stream_ioctl(mu_strerr, MU_IOCTL_LOGSTREAM,
			MU_IOCTL_LOGSTREAM_SET_LOCUS_RANGE, &yylloc);
	return EX_OK;
}

/* Save the current input context on stack and set up the scanner for
   input from the file NAME. Return 0 on success,
   and an appropriate EX_ code on error. */
int
lex_new_source(const char *name, int flag)
{
	int rc;
	struct stat st;
	struct input_file_ident id;
	struct inctx *pctx;

	if (stat(name, &st)) {
		parse_error(_("cannot open `%s': %s"),
			    name, mu_strerror(errno));
		return EX_NOINPUT;
	} else if (!S_ISREG(st.st_mode)) {
		parse_error(_("`%s' is not a regular file"), name);
		return EX_NOINPUT;
	}

	id.device = st.st_dev;
	id.i_node = st.st_ino;

	pctx = inctx_locate(&id);
	if (pctx) {
		parse_error(_("recursive inclusion"));
		if (pctx->parent)
			parse_error_locus(&pctx->parent->locus,
					  _("`%s' already included here"),
					  name);
		else
			parse_error(_("`%s' already included at top level"),
				    name);
		return 1;
	}

	if (flag == LEX_ONCE && source_lookup(&id))
		return 0;

	if (yyin)
		inctx_push();
	rc = lex_new_source_0(name);
	if (rc)
		inctx_pop();
	else {
		input_file_id = id;
		if (flag == LEX_MODULE) {
			inctx_flags = INCTX_MODULE;
			emit_token = T_MODBEG;
		} else
			inctx_flags = 0;
	}
	return rc;
}


/* Return constant or variable token corresponding to the current
   value of yylval.literal->text. */
static int
variable_or_const(void)
{
	struct variable *vptr;
	const struct constant *cptr;

	cptr = constant_lookup(yylval.literal->text);
	if (cptr) {
		const struct value *value_ptr = &cptr->value;
		switch (value_ptr->type) {
		case dtype_number:
			yylval.number = value_ptr->v.number;
			return T_NUMBER;

		case dtype_string:
			yylval.literal = value_ptr->v.literal;
			return T_STRING;

		default:
			abort();
		}
	}

	vptr = variable_lookup(yylval.literal->text);
	if (!vptr) {
		parse_error(_("variable %s is not defined"),
			    yylval.literal->text);
		return T_BOGUS;
	}
	variable_check_initialized(vptr, &yylloc);
	add_xref(vptr, &yylloc);
	yylval.var = vptr;
	return T_VARIABLE;
}

/* Saved lexer state before entering COMMENT */
static int save_state;
/* Same as BEGIN, but also saves the current locus. It is then used
   to report unclosed constructs at the end of file. */
#define BEGIN_X(s)							\
	do {								\
		BEGIN(s);						\
		mu_locus_point_copy (&start_locus, &yylloc.beg);	\
	} while(0)

/* If emit_token is not 0, push back current input and return the value
   of emit_token. Clear emit_token before returning. */
#define YY_USER_ACTION							\
	if (emit_token) {						\
		int tok = emit_token;					\
		emit_token = 0;						\
		if (yy_flex_debug)					\
			fprintf(stderr, "--emitting %d (module %s)\n",	\
				tok,top_module->name);			\
		mu_linetrack_retreat(trk, yyleng);			\
		yyless(0);						\
		return tok;						\
	} else {							\
		mu_linetrack_advance(trk, &yylloc, yytext, yyleng);	\
		mu_stream_ioctl(mu_strerr, MU_IOCTL_LOGSTREAM,		\
				MU_IOCTL_LOGSTREAM_SET_LOCUS_RANGE, &yylloc);\
	}

/* Read next input chunk. */
#define YY_INPUT(buf,result,max_size)					\
	if (yyin == NULL)						\
		result = YY_NULL;					\
	else if (((result = fread(buf, 1, max_size, yyin)) == 0)	\
		 && ferror(yyin))					\
		YY_FATAL_ERROR("input in flex scanner failed");

/* Redeclare main entry point. Actual yylex is defined in the code section
   below. */
#define YY_DECL static int lexscan(void)


/* String composer */
static struct mu_locus_point string_beg;
static NODE *string_head, *string_tail;

static void
compose_add_node(NODE *node)
{
	if (string_tail)
		string_tail->next = node;
	else
		string_head = node;
	string_tail = node;
}

static void
compose_start(int state)
{
	if (string_head) {
		parse_error("INTERNAL ERROR: previous composition has not "
			    "finished when a new one started");
		abort();
	}
	mu_locus_point_copy(&string_beg, &yylloc.beg);
	BEGIN_X(state);
}

static int
compose_finish()
{
	if (string_tail != string_head) {
		while (string_head->next) {
			NODE *cat = alloc_node(node_type_concat,
					       &string_head->locus);
			NODE *next = string_head->next;
			cat->next = next->next;
			cat->v.concat.arg[0] = cast_to(dtype_string,
						       string_head);
			cat->v.concat.arg[1] = cast_to(dtype_string, next);
			string_head->next = next->next = NULL;
			string_head = cat;
		}
	}
	yylval.node = string_head;
	mu_locus_point_copy(&yylloc.beg, &string_beg);
	mu_locus_point_deinit(&string_beg);
	string_head = string_tail = NULL;
	return T_COMPOSE;
}

static void
compose_add_literal(struct literal *lit)
{
	NODE *node = alloc_node(node_type_string, &yylloc);
	node->v.literal = lit;
	compose_add_node(node);
	if (yy_flex_debug)
		fprintf(stderr, "--add literal: '%s'\n", lit->text);
}

static void
compose_add_string(const char *text, size_t length)
{
	compose_add_literal(string_alloc(text, length));
}

static void
compose_add_number(long num)
{
	NODE *node = alloc_node(node_type_number, &yylloc);
	node->v.number = num;
	compose_add_node(node);
}

void
compose_add_builtin_const(const char *s, size_t len)
{
	const char *sval;
	long nval;

	switch (builtin_const_value(s, len, &sval, &nval)) {
	case dtype_number:
		compose_add_number(nval);
		break;

	case dtype_string:
		compose_add_string(sval, strlen(sval));
		break;

	default:
		abort();
	}
}

void
compose_add_variable_or_const(int what)
{
	switch (what) {
	case T_NUMBER:
		compose_add_number(yylval.number);
		break;

	case T_STRING:
		compose_add_literal(yylval.literal);
		break;

	case T_VARIABLE:
		compose_add_node(create_node_variable(yylval.var, &yylloc));
	}
}

static int
getnum(int type, int off, int base)
{
	errno = 0;
	yylval.number = strtol(yytext + off, NULL, base);
	if (errno) {
		struct mu_locus_range loc = yylloc;
		loc.beg.mu_col += off;
		parse_error_locus(&loc, "%s", _("numeric value out of range"));
		return T_BOGUS;
	}
	return type;
}

static int
skip_pcom(char const *str)
{
	char *p;
	for (p = strchr(str, '#') + 1; is_space(*p); p++)
	       ;
	for (p++; !is_space(*p); p++)
	       ;
	for (p++; is_space(*p); p++)
	       ;
	return p - str;
}

/*
 * Dequote a string STR, LEN bytes long.
 * On input, STR points to a quoted string.
 * On output, the quotes are removed, any occurences of \\ are replaced
 * by \ and any occurrences of \" are replaced by ".
 */
static char *
dequote_string(char const *str, size_t len)
{
	char *s, *p;

	str++;
	len -= 2;
	s = mu_alloc(len + 1);
	for (p = s; len; len--, str++) {
	        if (*str == '\\') {
			if (len > 1 && (str[1] == '\\' || str[1] == '"')) {
			        len--;
				str++;
			}
		}
		*p++ = *str;
	}
	*p = 0;
	return s;
}

#line 1896 "lex.c"
/* Exclusive states:

   SHELLMAGIC     Initial shell-magic boilerplate (#!... !#)
   COMMENT        Within a C-style comment;
   XIDENT         Expected identifier;
   STR            Processing a complex string;
   ML             Within a multi-line aggregator.  The line being built
		  requires stripping leading whitespace (if requested).
   CML            Continuation within a multi-line aggregator.  The line
		  being built does not require stripping leading whitespace.
   QML            Quoted multi-line aggregator.  No variable substitution and
		  unquoting is needed.

   Inclusive states:

   ONBLOCK	  Lexical tie-in after an `on' keyword.  In ONBLOCK state
		  the strigns `as', `host', `from', and `poll' are
		  recognized as keywords.  The string `for' also acquires
		  special meaning.
*/

#line 1918 "lex.c"

#define INITIAL 0
#define COMMENT 1
#define STR 2
#define ML 3
#define CML 4
#define QML 5
#define XIDENT 6
#define SHELLMAGIC 7
#define ONBLOCK 8

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
/* %if-c-only */
#include <unistd.h>
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* %if-c-only Reentrant structure and macros (non-C++). */
/* %if-reentrant */
/* %if-c-only */

static int yy_init_globals ( void );

/* %endif */
/* %if-reentrant */
/* %endif */
/* %endif End reentrant structures and macros. */

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

/* %if-bison-bridge */
/* %endif */

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

/* %not-for-header */
#ifndef YY_NO_UNPUT
    
#endif
/* %ok-for-header */

/* %endif */

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
/* %if-c-only Standard (non-C++) definition */
/* %not-for-header */
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif
/* %ok-for-header */

/* %endif */
#endif

/* %if-c-only */

/* %endif */

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* %if-c-only Standard (non-C++) definition */
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
/* %% [5.0] fread()/read() definition of YY_INPUT goes here unless we're doing C++ \ */\
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\
/* %if-c++-only C++ definition \ */\
/* %endif */

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
/* %if-c-only */
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
/* %endif */
/* %if-c++-only */
/* %endif */
#endif

/* %if-tables-serialization structures and prototypes */
/* %not-for-header */
/* %ok-for-header */

/* %not-for-header */
/* %tables-yydmap generated elements */
/* %endif */
/* end tables serialization structures and prototypes */

/* %ok-for-header */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1
/* %if-c-only Standard (non-C++) definition */

extern int yylex (void);

#define YY_DECL int yylex (void)
/* %endif */
/* %if-c++-only C++ definition */
/* %endif */
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

/* %% [6.0] YY_RULE_SETUP definition goes here */
#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/* %not-for-header */
/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
/* %if-c-only */
			yyin = stdin;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! yyout )
/* %if-c-only */
			yyout = stdout;
/* %endif */
/* %if-c++-only */
/* %endif */

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
/* %% [7.0] user's declarations go here */
#line 540 "lex.l"

#line 542 "lex.l"
	 /* C-style comments */
#line 2211 "lex.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
/* %% [8.0] yymore()-related code goes here */
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

/* %% [9.0] code to set up and find next match goes here */
		yy_current_state = (yy_start);
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 1004 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 2266 );

yy_find_action:
/* %% [10.0] code to find the action number goes here */
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

/* %% [11.0] code for yylineno update goes here */

do_action:	/* This label is used only to access EOF actions. */

/* %% [12.0] debug code goes here */
		if ( yy_flex_debug )
			{
			if ( yy_act == 0 )
				fprintf( stderr, "--scanner backing up\n" );
			else if ( yy_act < 153 )
				fprintf( stderr, "--accepting rule at line %ld (\"%s\")\n",
				         (long)yy_rule_linenum[yy_act], yytext );
			else if ( yy_act == 153 )
				fprintf( stderr, "--accepting default rule (\"%s\")\n",
				         yytext );
			else if ( yy_act == 154 )
				fprintf( stderr, "--(end of buffer or a NUL)\n" );
			else
				fprintf( stderr, "--EOF (start condition %d)\n", YY_START );
			}

		switch ( yy_act )
	{ /* beginning of action switch */
/* %% [13.0] actions go here */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 543 "lex.l"
{ save_state = YYSTATE;  BEGIN_X(COMMENT); }
	YY_BREAK

case 2:
YY_RULE_SETUP
#line 545 "lex.l"
/* eat anything that's not a '*' */
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 546 "lex.l"
/* eat up '*'s not followed by '/'s */
	YY_BREAK
case 4:
/* rule 4 can match eol */
YY_RULE_SETUP
#line 547 "lex.l"
;
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 548 "lex.l"
BEGIN(save_state);
	YY_BREAK

/* Shell magic sequence */
case 6:
/* rule 6 can match eol */
YY_RULE_SETUP
#line 552 "lex.l"
{
	if (yylloc.beg.mu_line == 1) {
		BEGIN_X(SHELLMAGIC);
	}
 }
	YY_BREAK

case 7:
/* rule 7 can match eol */
YY_RULE_SETUP
#line 558 "lex.l"
{ BEGIN(INITIAL); }
	YY_BREAK
case 8:
/* rule 8 can match eol */
YY_RULE_SETUP
#line 559 "lex.l"
;
	YY_BREAK

/* Configuration directives */
case 9:
/* rule 9 can match eol */
YY_RULE_SETUP
#line 562 "lex.l"
{
	struct mu_locus_point pt;
	if (parse_line_cpp(yytext, &pt) == 0)
		switch_origin(&pt);
}
	YY_BREAK
/* Normally, everything within a comment should be ignored, so
	   the exclusive condition for the rule below is an error.
	   Unfortunately, GNU m4 in versions up to 1.4.9 outputs line
	   synchronisation directives in comments, which makes any decent
	   compiler lose trace of which input line it is on.  To avoid
	   this, mfd handles #line directives even within a C-comment
	   block.

	   This bug was fixed in m4 version 1.4.10.  I prefer to keep
	   this kludge until I am pretty sure there are no 1.4.9 around.
	*/
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 579 "lex.l"
{
	struct mu_locus_point pt;
	if (parse_line(yytext, &pt) == 0)
		switch_origin(&pt);
}
	YY_BREAK
case 11:
/* rule 11 can match eol */
YY_RULE_SETUP
#line 584 "lex.l"
{
	mu_linetrack_retreat(trk, 1);
	yyless(yyleng-1);
	parse_pragma(yytext);
}
	YY_BREAK
case 12:
/* rule 12 can match eol */
YY_RULE_SETUP
#line 589 "lex.l"
{
	int n =	skip_pcom(yytext);
	int len = yyleng - n - 1;
	char *p = yytext + n;

	if (p[0] == '"' && p[len - 1] == '"') {
		char *msg = dequote_string(p, len);
		parse_error("%s", msg);
		free(msg);
	}
}
	YY_BREAK
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
#line 600 "lex.l"
{
	int n =	skip_pcom(yytext);
	int len = yyleng - n - 1;
	char *p = yytext + n;

	if (p[0] == '"' && p[len - 1] == '"') {
		char *msg = dequote_string(p, len);
		parse_warning("%s", msg);
		free(msg);
	}
}
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 611 "lex.l"
{
	parse_include(yytext, 1);
}
	YY_BREAK
case 15:
/* rule 15 can match eol */
YY_RULE_SETUP
#line 614 "lex.l"
{
	parse_include(yytext, 0);
}
	YY_BREAK
/* End-of-line comments */
case 16:
/* rule 16 can match eol */
YY_RULE_SETUP
#line 618 "lex.l"
;
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 619 "lex.l"
/* end-of-file comment */;
	YY_BREAK
/* expected identifier (after 'require', 'prog' and initial 'from') */

case 18:
YY_RULE_SETUP
#line 622 "lex.l"
{
		BEGIN(INITIAL);
		string(yytext, yyleng);
		return T_IDENTIFIER;
	}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 627 "lex.l"
;
	YY_BREAK
case 20:
/* rule 20 can match eol */
YY_RULE_SETUP
#line 628 "lex.l"
;
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 629 "lex.l"
{
		BEGIN(INITIAL);
		mu_linetrack_retreat(trk, yyleng);
		yyless(0);
	}
	YY_BREAK

/* Reserved words */
case 22:
YY_RULE_SETUP
#line 637 "lex.l"
return T_ACCEPT;
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 638 "lex.l"
return T_REJECT;
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 639 "lex.l"
return T_TEMPFAIL;
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 640 "lex.l"
return T_CONTINUE;
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 641 "lex.l"
return T_DISCARD;
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 642 "lex.l"
return T_ADD;
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 643 "lex.l"
return T_REPLACE;
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 644 "lex.l"
return T_DELETE;
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 645 "lex.l"
return T_IF;
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 646 "lex.l"
return T_FI;
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 647 "lex.l"
return T_ELSE;
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 648 "lex.l"
return T_ELIF;
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 649 "lex.l"
return T_ON;
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 650 "lex.l"
return T_DO;
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 651 "lex.l"
return T_DONE;
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 652 "lex.l"
return T_MATCHES;
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 653 "lex.l"
return T_FNMATCHES;
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 654 "lex.l"
return T_MXMATCHES;
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 655 "lex.l"
return T_MXFNMATCHES;
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 656 "lex.l"
return T_WHEN;
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 657 "lex.l"
return T_OR;
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 658 "lex.l"
return T_AND;
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 659 "lex.l"
return T_NOT;
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 660 "lex.l"
return T_NEXT;
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 661 "lex.l"
{ BEGIN(XIDENT); return T_PROG; }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 662 "lex.l"
return T_SET;
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 663 "lex.l"
return T_CATCH;
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 664 "lex.l"
return T_TRY;
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 665 "lex.l"
return T_ECHO;
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 666 "lex.l"
return T_RETURN;
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 667 "lex.l"
return T_RETURNS;
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 668 "lex.l"
return T_FUNC;
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 669 "lex.l"
return T_SWITCH;
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 670 "lex.l"
return T_CASE;
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 671 "lex.l"
return T_DEFAULT;
	YY_BREAK
case 57:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 6;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 672 "lex.l"
{ yylval.type = dtype_string; return T_TYPECAST; }
	YY_BREAK
case 58:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 6;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 673 "lex.l"
{ yylval.type = dtype_number; return T_TYPECAST; }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 674 "lex.l"
return T_VOID;
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 675 "lex.l"
{ yylval.type = dtype_string; return T_TYPE; }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 676 "lex.l"
{ yylval.type = dtype_number; return T_TYPE; }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 677 "lex.l"
return T_CONST;
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 678 "lex.l"
return T_THROW;
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 679 "lex.l"
return T_LOOP;
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 680 "lex.l"
return T_WHILE;
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 681 "lex.l"
return T_FOR;
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 682 "lex.l"
return T_BREAK;
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 683 "lex.l"
return T_PASS;
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 684 "lex.l"
return T_ALIAS;
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 685 "lex.l"
return T_VAPTR;
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 686 "lex.l"
return T_PRECIOUS;
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 687 "lex.l"
{ BEGIN(XIDENT); return T_REQUIRE; }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 688 "lex.l"
return T_IMPORT;
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 689 "lex.l"
{
	if (YYSTATE != ONBLOCK)
		BEGIN(XIDENT);
	return T_FROM;
 }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 694 "lex.l"
return T_STATIC;
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 695 "lex.l"
return T_PUBLIC;
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 696 "lex.l"
{
	if (inctx_tos && inctx_flags == 0) {
		int c;
		int flen;
		const char *fname = strrchr(yylloc.beg.mu_file, '/');

		if (fname)
			fname++;
		else
			fname = yylloc.beg.mu_file;
		flen = strlen(fname);

		if (flen > 3 && strcmp(fname + flen - 3, ".mf") == 0)
			flen -= 3;
		parse_warning_locus(&inctx_tos->locus,
				    _("including a module file is unreliable and may cause subtle errors"));
		/* TRANSLATORS: Do not translate `require %*.*s' */
		parse_warning_locus(&inctx_tos->locus,
				    _("use `require %*.*s' instead"),
				    flen, flen, fname);
		inctx_flags |= INCTX_IGNORE_BYE;
		mu_locus_point_copy(&start_locus, &yylloc.beg);
		while ((c = input()) != '.') {
		    /*
		     * On end of file, input() returns EOF in flex versions
		     * before 2.6.1, and 0 in flex 2.6.1 and later.
		     * See https://github.com/westes/flex/issues/448
		     */
		    if (c == EOF || c == 0) {
			mu_diag_at_locus_point(MU_DIAG_ERROR, &start_locus,
					       "%s",
					       _("unexpected end of file"));
			return 0;
		    } else {
			char ch = c;
			mu_linetrack_advance(trk, &yylloc, &ch, 1);
		    }
		}
	     } else if (inctx_flags & INCTX_HADINPUT)
		     parse_error(_("misplaced `module'"));
	    return T_MODULE;
 }
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 738 "lex.l"
return T_BYE;
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 739 "lex.l"
return T_DCLEX;
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 741 "lex.l"
{ return builtin_const(yytext, yyleng); }
	YY_BREAK

case 81:
YY_RULE_SETUP
#line 744 "lex.l"
return T_POLL;
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 745 "lex.l"
return T_HOST;
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 746 "lex.l"
return T_AS;
	YY_BREAK

/* Variables */

case 84:
YY_RULE_SETUP
#line 751 "lex.l"
{
		return builtin_const(yytext + 1, yyleng - 1);
	}
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 754 "lex.l"
{
		return builtin_const(yytext + 2, yyleng - 3);
	}
	YY_BREAK


case 86:
YY_RULE_SETUP
#line 760 "lex.l"
{
		compose_add_builtin_const(yytext + 1, yyleng - 1);
	}
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 763 "lex.l"
{
		compose_add_builtin_const(yytext + 2, yyleng - 3);
	}
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 766 "lex.l"
{
		string(yytext + 1, yyleng - 1);
		compose_add_variable_or_const(variable_or_const());
	}
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 770 "lex.l"
{
		string(yytext + 2, yyleng - 3);
		compose_add_variable_or_const(variable_or_const());
	}
	YY_BREAK

/* Positional arguments */

case 90:
YY_RULE_SETUP
#line 778 "lex.l"
return T_ARGCOUNT;
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 779 "lex.l"
return getnum(T_ARG, 1, 0);
	YY_BREAK
case 92:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 780 "lex.l"
return T_ARGX;
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 781 "lex.l"
return T_ARGV;
	YY_BREAK


case 94:
YY_RULE_SETUP
#line 785 "lex.l"
{
		compose_add_node(create_node_argcount(&yylloc));
	}
	YY_BREAK
case 95:
YY_RULE_SETUP
#line 788 "lex.l"
{
		compose_add_node(create_node_arg(strtol(yytext + 1, NULL, 0),
						 &yylloc));
	}
	YY_BREAK

/* Sendmail variables */

case 96:
YY_RULE_SETUP
#line 796 "lex.l"
{
		if (yyleng == 2)
			string(yytext + 1, 1);
		else {
			line_begin();
			line_add("{", 1);
			line_add(yytext + 1, yyleng - 1);
			line_add("}", 1);
			line_finish();
		}
		return T_SYMBOL;
	}
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 808 "lex.l"
{
		string(yytext+1, yyleng - 1); return T_SYMBOL;
	}
	YY_BREAK


case 98:
YY_RULE_SETUP
#line 814 "lex.l"
{
		if (yyleng == 2)
			string(yytext + 1, 1);
		else {
			line_begin();
			line_add("{", 1);
			line_add(yytext + 1, yyleng - 1);
			line_add("}", 1);
			line_finish();
		}
		compose_add_node(create_node_symbol(yylval.literal, &yylloc));
	}
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 826 "lex.l"
{
		string(yytext+1, yyleng - 1);
		compose_add_node(create_node_symbol(yylval.literal, &yylloc));
	}
	YY_BREAK

/* Back-references */
case 100:
YY_RULE_SETUP
#line 832 "lex.l"
{ return getnum(T_BACKREF, 1, 0); }
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 833 "lex.l"
{
	compose_add_node(create_node_backref(strtoul(yytext+1, NULL, 10),
					     &yylloc)); }
	YY_BREAK
/* Numeric strings */
case 102:
YY_RULE_SETUP
#line 837 "lex.l"
{ return getnum(T_NUMBER, 0, 16); }
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 838 "lex.l"
{ return getnum(T_NUMBER, 0, 8); }
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 839 "lex.l"
{ return getnum(T_NUMBER, 0, 10); }
	YY_BREAK
/* Identifiers */
case 105:
YY_RULE_SETUP
#line 841 "lex.l"
return T_SED;
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 842 "lex.l"
{
	const struct constant *cptr;

	cptr = constant_lookup(yytext);
	if (cptr) {
		const struct value *value_ptr = &cptr->value;
		switch (value_ptr->type) {
		case dtype_number:
			yylval.number = value_ptr->v.number;
			return T_NUMBER;

		case dtype_string:
			yylval.literal = value_ptr->v.literal;
			return T_STRING;

		default:
			abort();
		}
	}

	if (yylval.builtin = builtin_lookup(yytext))
		return T_BUILTIN;
	else if (yylval.function = function_lookup(yytext))
		return T_FUNCTION;
	else {
		struct variable *vptr;
		string(yytext, yyleng);
		vptr = variable_lookup(yylval.literal->text);
		if (!vptr) {
			return T_IDENTIFIER;
		}
		add_xref(vptr, &yylloc);
		yylval.var = vptr;
		return T_VARIABLE;
	}
}
	YY_BREAK
/* Strings */
case 107:
YY_RULE_SETUP
#line 879 "lex.l"
{
	string(yytext+1, yyleng-2);
	return T_STRING;
 }
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 883 "lex.l"
{
	string(yytext+1, yyleng-2);
	return T_STRING;
 }
	YY_BREAK
case 109:
/* rule 109 can match eol */
YY_RULE_SETUP
#line 887 "lex.l"
{
	compose_start(STR);
	compose_add_string(yytext + 1, yyleng - 3);
 }
	YY_BREAK
case 110:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 891 "lex.l"
{
	compose_start(STR);
	compose_add_string(yytext+1, yyleng-1);
 }
	YY_BREAK
case 111:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 5;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 895 "lex.l"
{
	compose_start(STR);
	line_add_char(strtoul(yytext + 3, NULL, 16));
	compose_add_literal(string_finish());
 }
	YY_BREAK
case 112:
YY_RULE_SETUP
#line 900 "lex.l"
{
	compose_start(STR);
	line_add_char(strtoul(yytext + 3, NULL, 16));
 }
	YY_BREAK
case 113:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 905 "lex.l"
{
	compose_start(STR);
	line_add_char(strtoul(yytext + 3, NULL, 8));
	compose_add_literal(string_finish());
 }
	YY_BREAK
case 114:
YY_RULE_SETUP
#line 910 "lex.l"
{
	compose_start(STR);
	line_add_char(strtoul(yytext + 3, NULL, 8));
 }
	YY_BREAK
case 115:
/* rule 115 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_bp + 3);
(yy_c_buf_p) = yy_cp = yy_bp + 3;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 915 "lex.l"
{
	compose_start(STR);
	line_add_char(c_unescape(yytext[2]));
	compose_add_literal(string_finish());
 }
	YY_BREAK
case 116:
/* rule 116 can match eol */
YY_RULE_SETUP
#line 920 "lex.l"
{
	compose_start(STR);
	line_add_char(c_unescape(yytext[2]));
 }
	YY_BREAK

case 117:
/* rule 117 can match eol */
YY_RULE_SETUP
#line 926 "lex.l"
{ line_add(yytext, yyleng - 2); }
	YY_BREAK
case 118:
YY_RULE_SETUP
#line 927 "lex.l"
{
		BEGIN(INITIAL);
		if (yyleng > 1)
			line_add(yytext, yyleng - 1);
		compose_add_literal(string_finish());
		return compose_finish();
	}
	YY_BREAK
case 119:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 934 "lex.l"
{
		line_add(yytext, yyleng);
		compose_add_literal(string_finish());
		line_begin();
	}
	YY_BREAK


case 120:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp = yy_bp + 4;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 942 "lex.l"
{
		line_add_char(strtoul(yytext + 2, NULL, 16));
		compose_add_literal(string_finish());
		line_begin();
	}
	YY_BREAK
case 121:
YY_RULE_SETUP
#line 947 "lex.l"
{
		line_add_char(strtoul(yytext + 2, NULL, 16));
	}
	YY_BREAK
case 122:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 950 "lex.l"
{
		line_add_char(strtoul(yytext + 2, NULL, 8));
		compose_add_literal(string_finish());
		line_begin();
	}
	YY_BREAK
case 123:
YY_RULE_SETUP
#line 955 "lex.l"
{
		line_add_char(strtoul(yytext + 2, NULL, 8));
	}
	YY_BREAK
case 124:
/* rule 124 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_bp + 2);
(yy_c_buf_p) = yy_cp = yy_bp + 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 958 "lex.l"
{
		line_add_char(c_unescape(yytext[1]));
		compose_add_literal(string_finish());
		line_begin();
	}
	YY_BREAK
case 125:
/* rule 125 can match eol */
YY_RULE_SETUP
#line 963 "lex.l"
{
		line_add_char(c_unescape(yytext[1]));
	}
	YY_BREAK

/* Multi-line strings */
case 126:
/* rule 126 can match eol */
#line 970 "lex.l"
case 127:
/* rule 127 can match eol */
YY_RULE_SETUP
#line 970 "lex.l"
{
	char *p;

	char_to_strip = NULL;
	multiline_unescape = 1;

	line_begin();
	p = yytext + 2;
	if (*p == '-') {
		++p;
		if (*p == ' ') {
			++p;
			char_to_strip = is_space;
		} else
			char_to_strip = is_tab;
	}

	if (*p == '\\') {
		p++;
		multiline_unescape = 0;
	}
	if (*p == '\'') {
		char *q;

		p++;
		multiline_unescape = 0;
		q = strchr(p, '\'');
		multiline_delimiter_len = q - p;
	} else
		multiline_delimiter_len = strcspn(p, " \t");

	multiline_delimiter = mu_alloc(multiline_delimiter_len + 1);
	memcpy(multiline_delimiter, p, multiline_delimiter_len);
	multiline_delimiter[multiline_delimiter_len] = 0;
	if (multiline_unescape)
		compose_start(ML);
	else
		compose_start(QML);
}
	YY_BREAK
/* Quoted multilines */
case 128:
/* rule 128 can match eol */
YY_RULE_SETUP
#line 1010 "lex.l"
{
	char *p;

	p = yytext;
	if (char_to_strip)
	       for (; char_to_strip (*p); p++)
		      ;

	if (strlen(p) >= multiline_delimiter_len
	    && memcmp(p, multiline_delimiter, multiline_delimiter_len) == 0
	    && isemptystr(p + multiline_delimiter_len)) {
		free (multiline_delimiter);
		multiline_delimiter = NULL;
		multiline_delimiter_len = 0;
		BEGIN(INITIAL);
		compose_add_literal(string_finish());
		return compose_finish();
	}
	line_add(p, strlen(p));
}
	YY_BREAK
/* Unquoted multilines */
case 129:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 1032 "lex.l"
{
	char *p = yytext;
	if (char_to_strip)
	       for (; char_to_strip (*p); p++)
		      ;
	line_add(p, strlen(p));
	compose_add_literal(string_finish());
	BEGIN_X(CML);
}
	YY_BREAK
case 130:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 1041 "lex.l"
{
	line_add(yytext, yyleng);
	compose_add_literal(string_finish());
	line_begin();
}
	YY_BREAK
case 131:
YY_RULE_SETUP
#line 1046 "lex.l"
{
	line_add(yytext, 1);
	compose_add_literal(string_finish());
	line_begin();
}
	YY_BREAK
case 132:
YY_RULE_SETUP
#line 1051 "lex.l"
{
	line_add(yytext, yyleng);
}
	YY_BREAK

case 133:
/* rule 133 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
YY_LINENO_REWIND_TO(yy_cp - 1);
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 1055 "lex.l"
{
		char *p;

		p = yytext;
		if (char_to_strip)
			for (; char_to_strip (*p); p++)
				;

		if (strlen(p) >= multiline_delimiter_len
		    && memcmp(p, multiline_delimiter, multiline_delimiter_len) == 0
		    && isemptystr(p + multiline_delimiter_len)) {
			free(multiline_delimiter);
			multiline_delimiter = NULL;
			multiline_delimiter_len = 0;
			BEGIN(INITIAL);
			compose_add_literal(string_finish());
			return compose_finish();
		}
		line_add(p, strlen(p));
		compose_add_literal(string_finish());
	}
	YY_BREAK
case 134:
/* rule 134 can match eol */
YY_RULE_SETUP
#line 1076 "lex.l"
{
		char *p;

		p = yytext;
		if (char_to_strip)
			for (; char_to_strip (*p); p++)
				;

		if (strlen(p) >= multiline_delimiter_len
		    && memcmp(p, multiline_delimiter, multiline_delimiter_len) == 0
		    && isemptystr(p + multiline_delimiter_len)) {
			free(multiline_delimiter);
			multiline_delimiter = NULL;
			multiline_delimiter_len = 0;
			BEGIN(INITIAL);
			compose_add_literal(string_finish());
			return compose_finish();
		}
		line_add(p, strlen(p));
	}
	YY_BREAK

case 135:
/* rule 135 can match eol */
YY_RULE_SETUP
#line 1098 "lex.l"
{
	if (yyleng >= multiline_delimiter_len
	    && memcmp(yytext, multiline_delimiter,
		      multiline_delimiter_len) == 0
	    && isemptystr(yytext + multiline_delimiter_len)) {
	       free (multiline_delimiter);
	       multiline_delimiter = NULL;
	       multiline_delimiter_len = 0;
	       BEGIN(INITIAL);
	       compose_add_literal(string_finish());
	       return compose_finish();
	}
	line_add(yytext, yyleng);
	BEGIN_X(ML);
}
	YY_BREAK
/* Other tokens */
case 136:
YY_RULE_SETUP
#line 1114 "lex.l"
;
	YY_BREAK
case 137:
/* rule 137 can match eol */
YY_RULE_SETUP
#line 1115 "lex.l"
;
	YY_BREAK
case 138:
YY_RULE_SETUP
#line 1116 "lex.l"
return T_EQ;
	YY_BREAK
case 139:
YY_RULE_SETUP
#line 1117 "lex.l"
return T_NE;
	YY_BREAK
case 140:
YY_RULE_SETUP
#line 1118 "lex.l"
return T_LT;
	YY_BREAK
case 141:
YY_RULE_SETUP
#line 1119 "lex.l"
return T_LE;
	YY_BREAK
case 142:
YY_RULE_SETUP
#line 1120 "lex.l"
return T_GT;
	YY_BREAK
case 143:
YY_RULE_SETUP
#line 1121 "lex.l"
return T_GE;
	YY_BREAK
case 144:
YY_RULE_SETUP
#line 1122 "lex.l"
return T_LOGAND;
	YY_BREAK
case 145:
YY_RULE_SETUP
#line 1123 "lex.l"
return T_LOGOR;
	YY_BREAK
case 146:
YY_RULE_SETUP
#line 1124 "lex.l"
return T_LOGXOR;
	YY_BREAK
case 147:
YY_RULE_SETUP
#line 1125 "lex.l"
return T_LOGNOT;
	YY_BREAK
case 148:
YY_RULE_SETUP
#line 1126 "lex.l"
return T_SHL;
	YY_BREAK
case 149:
YY_RULE_SETUP
#line 1127 "lex.l"
return T_SHR;
	YY_BREAK
case 150:
YY_RULE_SETUP
#line 1128 "lex.l"
return T_DOTS;
	YY_BREAK
case 151:
YY_RULE_SETUP
#line 1129 "lex.l"
/* If a here-document is not closed and its next line does not
	       end with a \n, prevent it from being displayed by ECHO */;
	YY_BREAK
case 152:
YY_RULE_SETUP
#line 1131 "lex.l"
return yytext[0];
	YY_BREAK
case 153:
YY_RULE_SETUP
#line 1132 "lex.l"
ECHO;
	YY_BREAK
#line 3544 "lex.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(COMMENT):
case YY_STATE_EOF(STR):
case YY_STATE_EOF(ML):
case YY_STATE_EOF(CML):
case YY_STATE_EOF(QML):
case YY_STATE_EOF(XIDENT):
case YY_STATE_EOF(SHELLMAGIC):
case YY_STATE_EOF(ONBLOCK):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
/* %if-c-only */
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
/* %endif */
/* %if-c++-only */
/* %endif */
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
/* %% [14.0] code to do back-up for compressed tables and set up yy_cp goes here */
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */
/* %ok-for-header */

/* %if-c++-only */
/* %not-for-header */
/* %ok-for-header */

/* %endif */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
/* %if-c-only */
static int yy_get_next_buffer (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

/* %if-c-only */
/* %not-for-header */
    static yy_state_type yy_get_previous_state (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
/* %% [15.0] code to get the start state into yy_current_state goes here */
	yy_current_state = (yy_start);
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
/* %% [16.0] code to find the next state goes here */
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 1004 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
/* %if-c-only */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
/* %endif */
/* %if-c++-only */
/* %endif */
{
	int yy_is_jam;
    /* %% [17.0] code to find the next state, and perhaps do backing up, goes here */
	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 1004 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 1003);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT
/* %if-c-only */

/* %endif */
#endif

/* %if-c-only */
#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

/* %endif */
/* %if-c++-only */
/* %endif */
{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

/* %% [19.0] update BOL and yylineno */
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
/* %if-c-only */
#endif	/* ifndef YY_NO_INPUT */
/* %endif */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
/* %if-c-only */
    void yyrestart  (FILE * input_file )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/* %if-c++-only */
/* %endif */

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
/* %if-c-only */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

/* %if-c-only */
static void yy_load_buffer_state  (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
/* %if-c-only */
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
/* %endif */
/* %if-c++-only */
/* %endif */
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
/* %if-c-only */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
/* %endif */
/* %if-c++-only */
/* %endif */
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/* %if-c++-only */
/* %endif */

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
/* %if-c-only */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
/* %if-c-only */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )
/* %endif */
/* %if-c++-only */
/* %endif */

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

/* %if-c-only */
	b->yy_input_file = file;
/* %endif */
/* %if-c++-only */
/* %endif */
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

/* %if-c-only */

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
/* %endif */
/* %if-c++-only */
/* %endif */
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
/* %if-c-only */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/* %if-c-or-c++ */
/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
/* %if-c-only */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}
/* %endif */

/* %if-c-or-c++ */
/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
/* %if-c-only */
void yypop_buffer_state (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}
/* %endif */

/* %if-c-or-c++ */
/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
/* %if-c-only */
static void yyensure_buffer_stack (void)
/* %endif */
/* %if-c++-only */
/* %endif */
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}
/* %endif */

/* %if-c-only */
/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}
/* %endif */

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

/* %if-c-only */
static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}
/* %endif */
/* %if-c++-only */
/* %endif */

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/* %if-c-only */
/* %if-reentrant */
/* %endif */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/* %if-reentrant */
/* %endif */

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

/* %endif */

/* %if-reentrant */
/* %if-bison-bridge */
/* %endif */
/* %endif if-c-only */

/* %if-c-only */
static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}
/* %endif */

/* %if-c-only SNIP! this currently causes conflicts with the c++ scanner */
/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

/* %if-reentrant */
/* %endif */
    return 0;
}
/* %endif */

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

/* %if-tables-serialization definitions */
/* %define-yytables   The name for this specific scanner's tables. */
#define YYTABLES_NAME "yytables"
/* %endif */

/* %ok-for-header */

#line 1132 "lex.l"


int
yylex()
{
	int rc = lexscan();
	if (rc != T_MODBEG && rc != T_MODEND)
		inctx_flags |= INCTX_HADINPUT;
	return rc;
}

void
init_string_space()
{
	mu_opool_create(&string_pool, MU_OPOOL_ENOMEMABRT);
}

void
free_string_space()
{
	mu_opool_destroy(&string_pool);
}

char *
mf_strdup(const char *str)
{
	string_add(str, strlen(str) + 1);
	return mu_opool_finish(string_pool, NULL);
}

struct literal *
string_alloc(const char *str, size_t len)
{
	string_begin();
	string_add(str, len);
	return string_finish();
}

static void
string(const char *str, size_t len)
{
	yylval.literal = string_alloc(str, len);
}

void
string_begin()
{
	/* nothing */
}

struct literal *
string_finish()
{
	char *ptr;
	struct literal *lit;
	mu_opool_append_char(string_pool, 0);
	ptr = mu_opool_finish(string_pool, NULL);
	lit = literal_lookup(ptr);
	if (lit->text != ptr)
		mu_opool_free(string_pool, ptr);
	return lit;
}

static void
line_finish()
{
	yylval.literal = string_finish();
	if (yy_flex_debug)
		fprintf(stderr, "constructed line: %s\n",
			yylval.literal->text);
}

void
string_add(const char *str, size_t len)
{
	mu_opool_append(string_pool, str, len);
}

void
string_add_char(unsigned char c)
{
	mu_opool_append_char(string_pool, c);
}

void
parse_warning(const char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	mu_diag_voutput (MU_DIAG_WARNING, fmt, ap);
	va_end(ap);
}

void
parse_warning_locus(struct mu_locus_range const *loc, const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	mu_vdiag_at_locus_range(MU_DIAG_WARNING, loc, fmt, ap);
	va_end(ap);
}

void
parse_error(const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	mu_diag_voutput(MU_DIAG_ERROR, fmt, ap);
	va_end(ap);
	error_count++;
}

void
parse_error_locus(struct mu_locus_range const *loc, const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	mu_vdiag_at_locus_range(MU_DIAG_ERROR, loc, fmt, ap);
	va_end(ap);
	error_count++;
}



static int
lex_close_source()
{
	if (!yyin)
		return 1;
	if (preprocessor.enabled)
		pp_extrn_shutdown(yyin, pp_pid);
	else
		fclose(yyin);
	yyin = NULL;
	mu_linetrack_destroy(&trk);

	switch (YYSTATE) {
	case INITIAL:
		/* ok */
		break;

	case COMMENT:
		mu_diag_at_locus_point (MU_DIAG_ERROR, &start_locus,
					"%s", _("end of file in comment"));
		break;

	case STR:
	case ML:
	case CML:
	case QML:
		mu_diag_at_locus_point (MU_DIAG_ERROR, &start_locus,
					"%s", _("end of file in string"));
		break;

	case SHELLMAGIC:
		mu_diag_at_locus_point (MU_DIAG_ERROR, &start_locus,
					"%s", _("end of file in shell block"));
		break;
	}
	return inctx_pop();
}

void
lex_drain_input()
{
	int c;
	while ((c = input()) != 0 && c != EOF)
		;
}

void
lex_bye()
{
	lex_drain_input();
	lex_close_source();
}

int
yywrap()
{
	if (yy_flex_debug && top_module)
		fprintf(stderr, "--eof in module %s\n", top_module->name);
	if (inctx_flags & INCTX_MODULE)
		emit_token = T_MODEND;
	return lex_close_source();
}

static int
isemptystr(char *text)
{
	for (; *text && mu_isspace (*text); text++)
		;
	return *text == 0;
}

void
tie_in_onblock(int enable)
{
	if (enable)
		BEGIN(ONBLOCK);
	else
		BEGIN(INITIAL);
}

data_type_t
builtin_const_value(const char *s, size_t len, const char **sval, long *nval)
{
	if (strncmp(s, "__file__", len) == 0) {
		struct literal *lit = literal_lookup(yylloc.beg.mu_file);
		*sval = lit->text;
		return dtype_string;
	} else if (strncmp(s, "__line__", len) == 0) {
		*nval = yylloc.beg.mu_line;
		return dtype_number;
	} else if (strncmp(s, "__function__", len) == 0) {
		*sval = function_name();
		return dtype_string;
	} else if (strncmp(s, "__package__", len) == 0) {
		*sval = PACKAGE_TARNAME;
		return dtype_string;
	} else if (strncmp(s, "__version__", len) == 0) {
		*sval = PACKAGE_VERSION;
		return dtype_string;
	} else if (strncmp(s, "__major__", len) == 0) {
		*nval = MAILFROMD_VERSION_MAJOR;
		return dtype_number;
	} else if (strncmp(s, "__minor__", len) == 0) {
		*nval = MAILFROMD_VERSION_MINOR;
		return dtype_number;
	} else if (strncmp(s, "__patch__", len) == 0) {
		*nval = MAILFROMD_VERSION_PATCH;
		return dtype_number;
	} else if (strncmp(s, "__git__", len) == 0) {
#ifdef GIT_DESCRIBE
		*sval = GIT_DESCRIBE;
#else
		*sval = "";
#endif
		return dtype_string;
	} else if (strncmp(s, "__statedir__", len) == 0) {
		*sval = mailfromd_state_dir;
		return dtype_string;
	} else if (strncmp(s, "__defstatedir__", len) == 0) {
		*sval = DEFAULT_STATE_DIR;
		return dtype_string;
	} else if (strncmp(s, "__preproc__", len) == 0) {
		*sval = (preprocessor.enabled && preprocessor.command)
			   ? preprocessor.command : "";
		return dtype_string;
	} else if (strncmp(s, "__defpreproc__", len) == 0) {
		*sval = DEF_EXT_PP ? DEF_EXT_PP : "";
		return dtype_string;
	} else if (strncmp(s, "__module__", len) == 0) {
		*sval = top_module->dclname ? top_module->dclname : top_module->name;
		return dtype_string;
	}
	return dtype_unspecified;
}

int
builtin_const(const char *s, size_t len)
{
	const char *sval;
	long nval;

	switch (builtin_const_value(s, len, &sval, &nval)) {
	case dtype_number:
		yylval.number = nval;
		return T_NUMBER;

	case dtype_string:
		string(sval, strlen(sval));
		return T_STRING;

	default:
		abort();
	}
	return T_BOGUS;
}

const char *
symbit_to_qualifier(unsigned f)
{
	switch (f) {
	case SYM_PRECIOUS:
		return "precious";
	case SYM_STATIC:
		return "static";
	case SYM_PUBLIC:
		return "public";
	}
	return NULL;
}

/* End of lex.l */

