# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class CompositeDataDisplayAttributesLegacy(Object):
    r"""
    CompositeDataDisplayAttributesLegacy - rendering attributes for a
    multi-block dataset.
    
    Superclass: Object
    
    The CompositeDataDisplayAttributesLegacy class stores display
    attributes for individual blocks in a multi-block dataset. Attributes
    are mapped to blocks through their flat-index; This is the mechanism
    used in legacy open_gl classes.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCompositeDataDisplayAttributesLegacy, obj, update, **traits)
    
    def get_block_color(self, *args):
        """
        get_block_color(self, flat_index:int, color:[float, float, float])
            -> None
        C++: void get_block_color(unsigned int flat_index, double color[3])
        get_block_color(self, flat_index:int) -> Color3d
        C++: Color3d get_block_color(unsigned int flat_index)"""
        ret = self._wrap_call(self._vtk_obj.GetBlockColor, *args)
        return wrap_vtk(ret)

    def set_block_color(self, *args):
        """
        set_block_color(self, flat_index:int, color:(float, float, float))
            -> None
        C++: void set_block_color(unsigned int flat_index,
            const double color[3])
        Set/get the color for the block with flat_index.
        """
        ret = self._wrap_call(self._vtk_obj.SetBlockColor, *args)
        return ret

    def get_block_opacity(self, *args):
        """
        get_block_opacity(self, flat_index:int) -> float
        C++: double get_block_opacity(unsigned int flat_index)"""
        ret = self._wrap_call(self._vtk_obj.GetBlockOpacity, *args)
        return ret

    def set_block_opacity(self, *args):
        """
        set_block_opacity(self, flat_index:int, opacity:float) -> None
        C++: void set_block_opacity(unsigned int flat_index, double opacity)
        Set/get the opacity for the block with flat_index.
        """
        ret = self._wrap_call(self._vtk_obj.SetBlockOpacity, *args)
        return ret

    def get_block_pickability(self, *args):
        """
        get_block_pickability(self, flat_index:int) -> bool
        C++: bool get_block_pickability(unsigned int flat_index)"""
        ret = self._wrap_call(self._vtk_obj.GetBlockPickability, *args)
        return ret

    def set_block_pickability(self, *args):
        """
        set_block_pickability(self, flat_index:int, visible:bool) -> None
        C++: void set_block_pickability(unsigned int flat_index,
            bool visible)
        Set/get the visibility for the block with flat_index.
        """
        ret = self._wrap_call(self._vtk_obj.SetBlockPickability, *args)
        return ret

    def get_block_visibility(self, *args):
        """
        get_block_visibility(self, flat_index:int) -> bool
        C++: bool get_block_visibility(unsigned int flat_index)"""
        ret = self._wrap_call(self._vtk_obj.GetBlockVisibility, *args)
        return ret

    def set_block_visibility(self, *args):
        """
        set_block_visibility(self, flat_index:int, visible:bool) -> None
        C++: void set_block_visibility(unsigned int flat_index,
            bool visible)
        Set/get the visibility for the block with flat_index.
        """
        ret = self._wrap_call(self._vtk_obj.SetBlockVisibility, *args)
        return ret

    def compute_visible_bounds(self, *args):
        """
        compute_visible_bounds(cda:CompositeDataDisplayAttributesLegacy,
            dobj:DataObject, bounds:[float, float, float, float, float,
             float]) -> None
        C++: static void compute_visible_bounds(
            CompositeDataDisplayAttributesLegacy *cda,
            DataObject *dobj, double bounds[6])"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ComputeVisibleBounds, *my_args)
        return ret

    def has_block_color(self, *args):
        """
        has_block_color(self, flat_index:int) -> bool
        C++: bool has_block_color(unsigned int flat_index)
        Returns true if the block with the given flat_index has a color.
        """
        ret = self._wrap_call(self._vtk_obj.HasBlockColor, *args)
        return ret

    def has_block_colors(self):
        """
        has_block_colors(self) -> bool
        C++: bool has_block_colors()
        Returns true if any block has any block color is set.
        """
        ret = self._vtk_obj.HasBlockColors()
        return ret
        

    def has_block_opacities(self):
        """
        has_block_opacities(self) -> bool
        C++: bool has_block_opacities()
        Returns true if any block has an opacity set.
        """
        ret = self._vtk_obj.HasBlockOpacities()
        return ret
        

    def has_block_opacity(self, *args):
        """
        has_block_opacity(self, flat_index:int) -> bool
        C++: bool has_block_opacity(unsigned int flat_index)
        Returns true if the block with flat_index has an opacity set.
        """
        ret = self._wrap_call(self._vtk_obj.HasBlockOpacity, *args)
        return ret

    def has_block_pickabilities(self):
        """
        has_block_pickabilities(self) -> bool
        C++: bool has_block_pickabilities()
        Returns true if any block has any block visibility is set.
        """
        ret = self._vtk_obj.HasBlockPickabilities()
        return ret
        

    def has_block_pickability(self, *args):
        """
        has_block_pickability(self, flat_index:int) -> bool
        C++: bool has_block_pickability(unsigned int flat_index)
        Returns true if the block with the given flat_index has a
        visibility set.
        """
        ret = self._wrap_call(self._vtk_obj.HasBlockPickability, *args)
        return ret

    def has_block_visibilities(self):
        """
        has_block_visibilities(self) -> bool
        C++: bool has_block_visibilities()
        Returns true if any block has any block visibility is set.
        """
        ret = self._vtk_obj.HasBlockVisibilities()
        return ret
        

    def has_block_visibility(self, *args):
        """
        has_block_visibility(self, flat_index:int) -> bool
        C++: bool has_block_visibility(unsigned int flat_index)
        Returns true if the block with the given flat_index has a
        visibility set.
        """
        ret = self._wrap_call(self._vtk_obj.HasBlockVisibility, *args)
        return ret

    def remove_block_color(self, *args):
        """
        remove_block_color(self, flat_index:int) -> None
        C++: void remove_block_color(unsigned int flat_index)
        Removes the block color for the block with flat_index.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveBlockColor, *args)
        return ret

    def remove_block_colors(self):
        """
        remove_block_colors(self) -> None
        C++: void remove_block_colors()
        Removes all block colors.
        """
        ret = self._vtk_obj.RemoveBlockColors()
        return ret
        

    def remove_block_opacities(self):
        """
        remove_block_opacities(self) -> None
        C++: void remove_block_opacities()
        Removes all block opacities.
        """
        ret = self._vtk_obj.RemoveBlockOpacities()
        return ret
        

    def remove_block_opacity(self, *args):
        """
        remove_block_opacity(self, flat_index:int) -> None
        C++: void remove_block_opacity(unsigned int flat_index)
        Removes the set opacity for the block with flat_index.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveBlockOpacity, *args)
        return ret

    def remove_block_pickabilities(self):
        """
        remove_block_pickabilities(self) -> None
        C++: void remove_block_pickabilities()
        Removes all block visibility flags. The effectively sets the
        visibility for all blocks to true.
        """
        ret = self._vtk_obj.RemoveBlockPickabilities()
        return ret
        

    def remove_block_pickability(self, *args):
        """
        remove_block_pickability(self, flat_index:int) -> None
        C++: void remove_block_pickability(unsigned int flat_index)
        Removes the block visibility flag for the block with flat_index.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveBlockPickability, *args)
        return ret

    def remove_block_visibilities(self):
        """
        remove_block_visibilities(self) -> None
        C++: void remove_block_visibilities()
        Removes all block visibility flags. The effectively sets the
        visibility for all blocks to true.
        """
        ret = self._vtk_obj.RemoveBlockVisibilities()
        return ret
        

    def remove_block_visibility(self, *args):
        """
        remove_block_visibility(self, flat_index:int) -> None
        C++: void remove_block_visibility(unsigned int flat_index)
        Removes the block visibility flag for the block with flat_index.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveBlockVisibility, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CompositeDataDisplayAttributesLegacy, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CompositeDataDisplayAttributesLegacy properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit CompositeDataDisplayAttributesLegacy properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CompositeDataDisplayAttributesLegacy properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

