# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.cell3d import Cell3D


class HexagonalPrism(Cell3D):
    r"""
    HexagonalPrism - a 3D cell that represents a prism with hexagonal
    base
    
    Superclass: Cell3D
    
    HexagonalPrism is a concrete implementation of Cell to
    represent a linear 3D prism with hexagonal base. Such prism is
    defined by the twelve points (0-12) where (0,1,2,3,4,5) is the base
    of the prism which, using the right hand rule, forms a hexagon whose
    normal points is in the direction of the opposite face
    (6,7,8,9,10,11).
    
    @par Thanks: Thanks to Philippe Guerville who developed this class.
    Thanks to Charles Pignerol (CEA-DAM, France) who ported this class
    under VTK 4. Thanks to Jean Favre (CSCS, Switzerland) who contributed
    to integrate this class in VTK. Please address all comments to Jean
    Favre (jfavre at cscs.ch).
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHexagonalPrism, obj, update, **traits)
    
    def get_edge_array(self, *args):
        """
        get_edge_array(edgeId:int) -> Pointer
        C++: static const IdType *get_edge_array(IdType edgeId)
        Return the ids of the vertices defining edge/face
        (`edgeId`/`faceId'). Ids are related to the cell, not to the
        dataset.
        
        ote The return type changed. It used to be int*, it is now const
        IdType*. This is so ids are unified between Cell and
        Points, and so Cell ids can be used as inputs in algorithms
        such as Polygon::ComputeNormal.
        """
        ret = self._wrap_call(self._vtk_obj.GetEdgeArray, *args)
        return ret

    def get_edge_to_adjacent_faces_array(self, *args):
        """
        get_edge_to_adjacent_faces_array(edgeId:int) -> (int, int)
        C++: static const IdType *get_edge_to_adjacent_faces_array(
            IdType edgeId)
        Static method version of get_edge_to_adjacent_faces.
        """
        ret = self._wrap_call(self._vtk_obj.GetEdgeToAdjacentFacesArray, *args)
        return ret

    def get_face_array(self, *args):
        """
        get_face_array(faceId:int) -> Pointer
        C++: static const IdType *get_face_array(IdType faceId)"""
        ret = self._wrap_call(self._vtk_obj.GetFaceArray, *args)
        return ret

    def get_face_to_adjacent_faces_array(self, *args):
        """
        get_face_to_adjacent_faces_array(faceId:int) -> (int, int, int, int,
            int, int)
        C++: static const IdType *get_face_to_adjacent_faces_array(
            IdType faceId)
        Static method version of get_face_to_adjacent_faces.
        """
        ret = self._wrap_call(self._vtk_obj.GetFaceToAdjacentFacesArray, *args)
        return ret

    def get_point_to_incident_edges_array(self, *args):
        """
        get_point_to_incident_edges_array(pointId:int) -> (int, int, int)
        C++: static const IdType *get_point_to_incident_edges_array(
            IdType pointId)
        Static method version of get_point_to_incident_edges_array.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointToIncidentEdgesArray, *args)
        return ret

    def get_point_to_incident_faces_array(self, *args):
        """
        get_point_to_incident_faces_array(pointId:int) -> (int, int, int)
        C++: static const IdType *get_point_to_incident_faces_array(
            IdType pointId)
        Static method version of get_point_to_incident_faces_array.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointToIncidentFacesArray, *args)
        return ret

    def get_point_to_one_ring_points_array(self, *args):
        """
        get_point_to_one_ring_points_array(pointId:int) -> (int, int, int)
        C++: static const IdType *get_point_to_one_ring_points_array(
            IdType pointId)
        Static method version of get_point_to_one_ring_points.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointToOneRingPointsArray, *args)
        return ret

    def compute_centroid(self, *args):
        """
        compute_centroid(points:Points, pointIds:(int, ...),
            centroid:[float, float, float]) -> bool
        C++: static bool compute_centroid(Points *points,
            const IdType *pointIds, double centroid[3])
        Static method version of get_centroid.
        """
        my_args = deref_array(args, [('vtkPoints', ('int', Ellipsis), ['float', 'float', 'float'])])
        ret = self._wrap_call(self._vtk_obj.ComputeCentroid, *my_args)
        return ret

    def interpolation_derivs(self, *args):
        """
        interpolation_derivs(pcoords:(float, float, float), derivs:[float,
            float, float, float, float, float, float, float, float, float,
             float, float, float, float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float, float, float, float, float, float, float, float,
            float]) -> None
        C++: static void interpolation_derivs(const double pcoords[3],
            double derivs[36])"""
        ret = self._wrap_call(self._vtk_obj.InterpolationDerivs, *args)
        return ret

    def interpolation_functions(self, *args):
        """
        interpolation_functions(pcoords:(float, float, float),
            weights:[float, float, float, float, float, float, float,
            float, float, float, float, float]) -> None
        C++: static void interpolation_functions(const double pcoords[3],
            double weights[12])"""
        ret = self._wrap_call(self._vtk_obj.InterpolationFunctions, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('merge_tolerance', 'GetMergeTolerance'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'merge_tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HexagonalPrism, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HexagonalPrism properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['merge_tolerance']),
            title='Edit HexagonalPrism properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HexagonalPrism properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

