% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-all-equal.R
\name{chk_all_equal}
\alias{chk_all_equal}
\alias{vld_all_equal}
\title{Check All Equal}
\usage{
chk_all_equal(x, tolerance = sqrt(.Machine$double.eps), x_name = NULL)

vld_all_equal(x, tolerance = sqrt(.Machine$double.eps))
}
\arguments{
\item{x}{The object to check.}

\item{tolerance}{A non-negative numeric scalar.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks all elements in x equal using

\code{length(x) < 2L || all(vapply(x, vld_equal, TRUE, y = x[[1]], tolerance = tolerance))}
}
\section{Functions}{
\itemize{
\item \code{vld_all_equal()}: Validate All Equal

}}
\examples{
# chk_all_equal
chk_all_equal(c(1, 1.00000001))
try(chk_all_equal(c(1, 1.0000001)))
chk_all_equal(list(c(x = 1), c(x = 1)))
try(chk_all_equal(list(c(x = 1), c(y = 1))))
# vld_all_equal
vld_all_equal(c(1, 1L))
}
\seealso{
\code{\link[=length]{length()}}

\code{\link[=vld_equal]{vld_equal()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other equal_checkers: 
\code{\link{chk_all_equivalent}()},
\code{\link{chk_all_identical}()},
\code{\link{chk_equal}()},
\code{\link{chk_equivalent}()},
\code{\link{chk_identical}()}

Other all_checkers: 
\code{\link{chk_all}()},
\code{\link{chk_all_equivalent}()},
\code{\link{chk_all_identical}()}
}
\concept{all_checkers}
\concept{equal_checkers}
