% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-package.R
\name{ExampleData.FittingLM}
\alias{ExampleData.FittingLM}
\alias{values.curve}
\alias{values.curveBG}
\title{Example data for fit_LMCurve() in the package Luminescence}
\format{
Two objects (data.frames) with two columns (time and counts).
}
\source{
\tabular{ll}{
Lab: \tab Luminescence Laboratory Bayreuth\cr
Lab-Code: \tab BT900\cr
Location: \tab Norway\cr
Material: \tab Beach deposit, coarse grain quartz measured on aluminium discs on a Risø TL/OSL DA-15 reader\cr
}
}
\description{
Linearly modulated (LM) measurement data from a quartz sample from Norway
including background measurement. Measurements carried out in the
luminescence laboratory at the University of Bayreuth.
}
\examples{

##show LM data
data(ExampleData.FittingLM, envir = environment())
plot(values.curve,log="x")

}
\references{
Fuchs, M., Kreutzer, S., Fischer, M., Sauer, D., Soerensen, R., 2012. OSL and IRSL
dating of raised beach sand deposits along the south-eastern coast of Norway.
Quaternary Geochronology, 10, 195-200.
}
\keyword{datasets}
\keyword{internal}
