#' Brandsma school data used Snijders and Bosker (2012)
#'
#' Dataset with raw data from Snijders and Bosker (2012) containing
#' data from 4106 pupils attending 216 schools. This dataset
#' includes all pupils and schools with missing data.
#'
#' @name brandsma
#' @docType data
#' @format \code{brandsma} is a data frame with 4106 rows and 14 columns:
#' \describe{
#' \item{\code{sch}}{School number}
#' \item{\code{pup}}{Pupil ID}
#' \item{\code{iqv}}{IQ verbal}
#' \item{\code{iqp}}{IQ performal}
#' \item{\code{sex}}{Sex of pupil}
#' \item{\code{ses}}{SES score of pupil}
#' \item{\code{min}}{Minority member 0/1}
#' \item{\code{rpg}}{Number of repeated groups, 0, 1, 2}
#' \item{\code{lpr}}{language score PRE}
#' \item{\code{lpo}}{language score POST}
#' \item{\code{apr}}{Arithmetic score PRE}
#' \item{\code{apo}}{Arithmetic score POST}
#' \item{\code{den}}{Denomination classification 1-4 - at school level}
#' \item{\code{ssi}}{School SES indicator - at school level}
#' }
#'
#' @note This dataset is constructed from the raw data. There are
#' a few differences with the data set used in Chapter 4 and 5
#' of Snijders and Bosker:
#' \enumerate{
#' \item All schools are included, including the five school with
#' missing values on \code{langpost}.
#' \item Missing \code{denomina} codes are left as missing.
#' \item Aggregates are undefined in the presence of missing data
#' in the underlying values.
#' Variables \code{ses}, \code{iqv} and \code{iqp} are in their
#' original scale, and not globally centered.
#' No aggregate variables at the school level are included.
#' \item There is a wider selection of original variables. Note
#' however that the source data contain an even wider set of
#' variables.
#' }
#'
#' @source Constructed from \code{MLbook_2nded_total_4106-99.sav} from
#' \url{https://www.stats.ox.ac.uk/~snijders/mlbook.htm} by function
#' \code{data-raw/R/brandsma.R}
#'
#' @references
#' Brandsma, HP and Knuver, JWM (1989), Effects of school and
#' classroom characteristics on pupil progress in language and arithmetic.
#' International Journal of Educational Research, 13(7), 777 - 788.
#'
#' Snijders, TAB and Bosker RJ (2012). Multilevel Analysis, 2nd Ed. Sage,
#' Los Angeles, 2012.
#' @keywords datasets
NULL
