% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_count.R
\name{row_count}
\alias{row_count}
\alias{col_count}
\title{Count row or column indices}
\usage{
row_count(x, ..., count, var = "rowcount", append = TRUE)

col_count(x, ..., count, var = "colcount", append = TRUE)
}
\arguments{
\item{x}{A vector or data frame.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or tidyselect's
select-helpers.
See 'Examples' or \href{../doc/design_philosophy.html}{package-vignette}.}

\item{count}{The value for which the row or column sum should be computed. May
be a numeric value, a character string (for factors or character vectors),
\code{NA}, \code{Inf} or \code{NULL} to count missing or infinite values,
or null-values.}

\item{var}{Name of new the variable with the row or column counts.}

\item{append}{Logical, if \code{TRUE} (the default) and \code{x} is a data frame,
\code{x} including the new variables as additional columns is returned;
if \code{FALSE}, only the new variables are returned.}
}
\value{
For \code{row_count()}, a data frame with one variable: the sum of \code{count}
        appearing in each row of \code{x}; for \code{col_count()}, a data frame with
        one row and the same number of variables as in \code{x}: each variable
        holds the sum of \code{count} appearing in each variable of \code{x}.
        If \code{append = TRUE}, \code{x} including this variable will be returned.
}
\description{
\code{row_count()} mimics base R's \code{rowSums()}, with sums
             for a specific value indicated by \code{count}. Hence, it is equivalent
             to \code{rowSums(x == count, na.rm = TRUE)}. However, this function
             is designed to work nicely within a pipe-workflow and allows select-helpers
             for selecting variables and the return value is always a data frame
             (with one variable).
             \cr \cr
             \code{col_count()} does the same for columns. The return value is
             a data frame with one row (the column counts) and the same number
             of columns as \code{x}.
}
\examples{
dat <- data.frame(
  c1 = c(1, 2, 3, 1, 3, NA),
  c2 = c(3, 2, 1, 2, NA, 3),
  c3 = c(1, 1, 2, 1, 3, NA),
  c4 = c(1, 1, 3, 2, 1, 2)
)

row_count(dat, count = 1, append = FALSE)
row_count(dat, count = NA, append = FALSE)
row_count(dat, c1:c3, count = 2, append = TRUE)

col_count(dat, count = 1, append = FALSE)
col_count(dat, count = NA, append = FALSE)
col_count(dat, c1:c3, count = 2, append = TRUE)

}
