#ifndef CAPSTONE_ARM64_H
#define CAPSTONE_ARM64_H

/* Capstone Disassembly Engine */
/* By Nguyen Anh Quynh <aquynh@gmail.com>, 2013-2015 */

#ifdef __cplusplus
extern "C" {
#endif

#include "platform.h"

#ifdef _MSC_VER
#pragma warning(disable:4201)
#endif

/// ARM64 shift type
typedef enum arm64_shifter {
	ARM64_SFT_INVALID = 0,
	ARM64_SFT_LSL = 1,
	ARM64_SFT_MSL = 2,
	ARM64_SFT_LSR = 3,
	ARM64_SFT_ASR = 4,
	ARM64_SFT_ROR = 5,
} arm64_shifter;

/// ARM64 extender type
typedef enum arm64_extender {
	ARM64_EXT_INVALID = 0,
	ARM64_EXT_UXTB = 1,
	ARM64_EXT_UXTH = 2,
	ARM64_EXT_UXTW = 3,
	ARM64_EXT_UXTX = 4,
	ARM64_EXT_SXTB = 5,
	ARM64_EXT_SXTH = 6,
	ARM64_EXT_SXTW = 7,
	ARM64_EXT_SXTX = 8,
} arm64_extender;

/// ARM64 condition code
typedef enum arm64_cc {
	ARM64_CC_INVALID = 0,
	ARM64_CC_EQ = 1,     ///< Equal
	ARM64_CC_NE = 2,     ///< Not equal:                 Not equal, or unordered
	ARM64_CC_HS = 3,     ///< Unsigned higher or same:   >, ==, or unordered
	ARM64_CC_LO = 4,     ///< Unsigned lower or same:    Less than
	ARM64_CC_MI = 5,     ///< Minus, negative:           Less than
	ARM64_CC_PL = 6,     ///< Plus, positive or zero:    >, ==, or unordered
	ARM64_CC_VS = 7,     ///< Overflow:                  Unordered
	ARM64_CC_VC = 8,     ///< No overflow:               Ordered
	ARM64_CC_HI = 9,     ///< Unsigned higher:           Greater than, or unordered
	ARM64_CC_LS = 10,     ///< Unsigned lower or same:    Less than or equal
	ARM64_CC_GE = 11,     ///< Greater than or equal:     Greater than or equal
	ARM64_CC_LT = 12,     ///< Less than:                 Less than, or unordered
	ARM64_CC_GT = 13,     ///< Signed greater than:       Greater than
	ARM64_CC_LE = 14,     ///< Signed less than or equal: <, ==, or unordered
	ARM64_CC_AL = 15,     ///< Always (unconditional):    Always (unconditional)
	ARM64_CC_NV = 16,     ///< Always (unconditional):   Always (unconditional)
	//< Note the NV exists purely to disassemble 0b1111. Execution is "always".
} arm64_cc;

/// System registers
typedef enum arm64_sysreg {
	// System registers for MRS
	ARM64_SYSREG_INVALID           = 0,

	ARM64_SYSREG_MDCCSR_EL0 = 0x9808,
	ARM64_SYSREG_DBGDTRRX_EL0 = 0x9828,
	ARM64_SYSREG_MDRAR_EL1 = 0x8080,
	ARM64_SYSREG_OSLSR_EL1 = 0x808C,
	ARM64_SYSREG_DBGAUTHSTATUS_EL1 = 0x83F6,
	ARM64_SYSREG_PMCEID0_EL0 = 0xDCE6,
	ARM64_SYSREG_PMCEID1_EL0 = 0xDCE7,
	ARM64_SYSREG_MIDR_EL1 = 0xC000,
	ARM64_SYSREG_CCSIDR_EL1 = 0xC800,
	ARM64_SYSREG_CCSIDR2_EL1 = 0xC802,
	ARM64_SYSREG_CLIDR_EL1 = 0xC801,
	ARM64_SYSREG_CTR_EL0 = 0xD801,
	ARM64_SYSREG_MPIDR_EL1 = 0xC005,
	ARM64_SYSREG_REVIDR_EL1 = 0xC006,
	ARM64_SYSREG_AIDR_EL1 = 0xC807,
	ARM64_SYSREG_DCZID_EL0 = 0xD807,
	ARM64_SYSREG_ID_PFR0_EL1 = 0xC008,
	ARM64_SYSREG_ID_PFR1_EL1 = 0xC009,
	ARM64_SYSREG_ID_DFR0_EL1 = 0xC00A,
	ARM64_SYSREG_ID_AFR0_EL1 = 0xC00B,
	ARM64_SYSREG_ID_MMFR0_EL1 = 0xC00C,
	ARM64_SYSREG_ID_MMFR1_EL1 = 0xC00D,
	ARM64_SYSREG_ID_MMFR2_EL1 = 0xC00E,
	ARM64_SYSREG_ID_MMFR3_EL1 = 0xC00F,
	ARM64_SYSREG_ID_ISAR0_EL1 = 0xC010,
	ARM64_SYSREG_ID_ISAR1_EL1 = 0xC011,
	ARM64_SYSREG_ID_ISAR2_EL1 = 0xC012,
	ARM64_SYSREG_ID_ISAR3_EL1 = 0xC013,
	ARM64_SYSREG_ID_ISAR4_EL1 = 0xC014,
	ARM64_SYSREG_ID_ISAR5_EL1 = 0xC015,
	ARM64_SYSREG_ID_ISAR6_EL1 = 0xC017,
	ARM64_SYSREG_ID_AA64PFR0_EL1 = 0xC020,
	ARM64_SYSREG_ID_AA64PFR1_EL1 = 0xC021,
	ARM64_SYSREG_ID_AA64DFR0_EL1 = 0xC028,
	ARM64_SYSREG_ID_AA64DFR1_EL1 = 0xC029,
	ARM64_SYSREG_ID_AA64AFR0_EL1 = 0xC02C,
	ARM64_SYSREG_ID_AA64AFR1_EL1 = 0xC02D,
	ARM64_SYSREG_ID_AA64ISAR0_EL1 = 0xC030,
	ARM64_SYSREG_ID_AA64ISAR1_EL1 = 0xC031,
	ARM64_SYSREG_ID_AA64MMFR0_EL1 = 0xC038,
	ARM64_SYSREG_ID_AA64MMFR1_EL1 = 0xC039,
	ARM64_SYSREG_ID_AA64MMFR2_EL1 = 0xC03A,
	ARM64_SYSREG_MVFR0_EL1 = 0xC018,
	ARM64_SYSREG_MVFR1_EL1 = 0xC019,
	ARM64_SYSREG_MVFR2_EL1 = 0xC01A,
	ARM64_SYSREG_RVBAR_EL1 = 0xC601,
	ARM64_SYSREG_RVBAR_EL2 = 0xE601,
	ARM64_SYSREG_RVBAR_EL3 = 0xF601,
	ARM64_SYSREG_ISR_EL1 = 0xC608,
	ARM64_SYSREG_CNTPCT_EL0 = 0xDF01,
	ARM64_SYSREG_CNTVCT_EL0 = 0xDF02,
	ARM64_SYSREG_ID_MMFR4_EL1 = 0xC016,
	ARM64_SYSREG_TRCSTATR = 0x8818,
	ARM64_SYSREG_TRCIDR8 = 0x8806,
	ARM64_SYSREG_TRCIDR9 = 0x880E,
	ARM64_SYSREG_TRCIDR10 = 0x8816,
	ARM64_SYSREG_TRCIDR11 = 0x881E,
	ARM64_SYSREG_TRCIDR12 = 0x8826,
	ARM64_SYSREG_TRCIDR13 = 0x882E,
	ARM64_SYSREG_TRCIDR0 = 0x8847,
	ARM64_SYSREG_TRCIDR1 = 0x884F,
	ARM64_SYSREG_TRCIDR2 = 0x8857,
	ARM64_SYSREG_TRCIDR3 = 0x885F,
	ARM64_SYSREG_TRCIDR4 = 0x8867,
	ARM64_SYSREG_TRCIDR5 = 0x886F,
	ARM64_SYSREG_TRCIDR6 = 0x8877,
	ARM64_SYSREG_TRCIDR7 = 0x887F,
	ARM64_SYSREG_TRCOSLSR = 0x888C,
	ARM64_SYSREG_TRCPDSR = 0x88AC,
	ARM64_SYSREG_TRCDEVAFF0 = 0x8BD6,
	ARM64_SYSREG_TRCDEVAFF1 = 0x8BDE,
	ARM64_SYSREG_TRCLSR = 0x8BEE,
	ARM64_SYSREG_TRCAUTHSTATUS = 0x8BF6,
	ARM64_SYSREG_TRCDEVARCH = 0x8BFE,
	ARM64_SYSREG_TRCDEVID = 0x8B97,
	ARM64_SYSREG_TRCDEVTYPE = 0x8B9F,
	ARM64_SYSREG_TRCPIDR4 = 0x8BA7,
	ARM64_SYSREG_TRCPIDR5 = 0x8BAF,
	ARM64_SYSREG_TRCPIDR6 = 0x8BB7,
	ARM64_SYSREG_TRCPIDR7 = 0x8BBF,
	ARM64_SYSREG_TRCPIDR0 = 0x8BC7,
	ARM64_SYSREG_TRCPIDR1 = 0x8BCF,
	ARM64_SYSREG_TRCPIDR2 = 0x8BD7,
	ARM64_SYSREG_TRCPIDR3 = 0x8BDF,
	ARM64_SYSREG_TRCCIDR0 = 0x8BE7,
	ARM64_SYSREG_TRCCIDR1 = 0x8BEF,
	ARM64_SYSREG_TRCCIDR2 = 0x8BF7,
	ARM64_SYSREG_TRCCIDR3 = 0x8BFF,
	ARM64_SYSREG_ICC_IAR1_EL1 = 0xC660,
	ARM64_SYSREG_ICC_IAR0_EL1 = 0xC640,
	ARM64_SYSREG_ICC_HPPIR1_EL1 = 0xC662,
	ARM64_SYSREG_ICC_HPPIR0_EL1 = 0xC642,
	ARM64_SYSREG_ICC_RPR_EL1 = 0xC65B,
	ARM64_SYSREG_ICH_VTR_EL2 = 0xE659,
	ARM64_SYSREG_ICH_EISR_EL2 = 0xE65B,
	ARM64_SYSREG_ICH_ELRSR_EL2 = 0xE65D,
	ARM64_SYSREG_ID_AA64ZFR0_EL1 = 0xC024,
	ARM64_SYSREG_LORID_EL1 = 0xC527,
	ARM64_SYSREG_ERRIDR_EL1 = 0xC298,
	ARM64_SYSREG_ERXFR_EL1 = 0xC2A0,
	ARM64_SYSREG_DBGDTRTX_EL0 = 0x9828,
	ARM64_SYSREG_OSLAR_EL1 = 0x8084,
	ARM64_SYSREG_PMSWINC_EL0 = 0xDCE4,
	ARM64_SYSREG_TRCOSLAR = 0x8884,
	ARM64_SYSREG_TRCLAR = 0x8BE6,
	ARM64_SYSREG_ICC_EOIR1_EL1 = 0xC661,
	ARM64_SYSREG_ICC_EOIR0_EL1 = 0xC641,
	ARM64_SYSREG_ICC_DIR_EL1 = 0xC659,
	ARM64_SYSREG_ICC_SGI1R_EL1 = 0xC65D,
	ARM64_SYSREG_ICC_ASGI1R_EL1 = 0xC65E,
	ARM64_SYSREG_ICC_SGI0R_EL1 = 0xC65F,
	ARM64_SYSREG_OSDTRRX_EL1 = 0x8002,
	ARM64_SYSREG_OSDTRTX_EL1 = 0x801A,
	ARM64_SYSREG_TEECR32_EL1 = 0x9000,
	ARM64_SYSREG_MDCCINT_EL1 = 0x8010,
	ARM64_SYSREG_MDSCR_EL1 = 0x8012,
	ARM64_SYSREG_DBGDTR_EL0 = 0x9820,
	ARM64_SYSREG_OSECCR_EL1 = 0x8032,
	ARM64_SYSREG_DBGVCR32_EL2 = 0xA038,
	ARM64_SYSREG_DBGBVR0_EL1 = 0x8004,
	ARM64_SYSREG_DBGBVR1_EL1 = 0x800C,
	ARM64_SYSREG_DBGBVR2_EL1 = 0x8014,
	ARM64_SYSREG_DBGBVR3_EL1 = 0x801C,
	ARM64_SYSREG_DBGBVR4_EL1 = 0x8024,
	ARM64_SYSREG_DBGBVR5_EL1 = 0x802C,
	ARM64_SYSREG_DBGBVR6_EL1 = 0x8034,
	ARM64_SYSREG_DBGBVR7_EL1 = 0x803C,
	ARM64_SYSREG_DBGBVR8_EL1 = 0x8044,
	ARM64_SYSREG_DBGBVR9_EL1 = 0x804C,
	ARM64_SYSREG_DBGBVR10_EL1 = 0x8054,
	ARM64_SYSREG_DBGBVR11_EL1 = 0x805C,
	ARM64_SYSREG_DBGBVR12_EL1 = 0x8064,
	ARM64_SYSREG_DBGBVR13_EL1 = 0x806C,
	ARM64_SYSREG_DBGBVR14_EL1 = 0x8074,
	ARM64_SYSREG_DBGBVR15_EL1 = 0x807C,
	ARM64_SYSREG_DBGBCR0_EL1 = 0x8005,
	ARM64_SYSREG_DBGBCR1_EL1 = 0x800D,
	ARM64_SYSREG_DBGBCR2_EL1 = 0x8015,
	ARM64_SYSREG_DBGBCR3_EL1 = 0x801D,
	ARM64_SYSREG_DBGBCR4_EL1 = 0x8025,
	ARM64_SYSREG_DBGBCR5_EL1 = 0x802D,
	ARM64_SYSREG_DBGBCR6_EL1 = 0x8035,
	ARM64_SYSREG_DBGBCR7_EL1 = 0x803D,
	ARM64_SYSREG_DBGBCR8_EL1 = 0x8045,
	ARM64_SYSREG_DBGBCR9_EL1 = 0x804D,
	ARM64_SYSREG_DBGBCR10_EL1 = 0x8055,
	ARM64_SYSREG_DBGBCR11_EL1 = 0x805D,
	ARM64_SYSREG_DBGBCR12_EL1 = 0x8065,
	ARM64_SYSREG_DBGBCR13_EL1 = 0x806D,
	ARM64_SYSREG_DBGBCR14_EL1 = 0x8075,
	ARM64_SYSREG_DBGBCR15_EL1 = 0x807D,
	ARM64_SYSREG_DBGWVR0_EL1 = 0x8006,
	ARM64_SYSREG_DBGWVR1_EL1 = 0x800E,
	ARM64_SYSREG_DBGWVR2_EL1 = 0x8016,
	ARM64_SYSREG_DBGWVR3_EL1 = 0x801E,
	ARM64_SYSREG_DBGWVR4_EL1 = 0x8026,
	ARM64_SYSREG_DBGWVR5_EL1 = 0x802E,
	ARM64_SYSREG_DBGWVR6_EL1 = 0x8036,
	ARM64_SYSREG_DBGWVR7_EL1 = 0x803E,
	ARM64_SYSREG_DBGWVR8_EL1 = 0x8046,
	ARM64_SYSREG_DBGWVR9_EL1 = 0x804E,
	ARM64_SYSREG_DBGWVR10_EL1 = 0x8056,
	ARM64_SYSREG_DBGWVR11_EL1 = 0x805E,
	ARM64_SYSREG_DBGWVR12_EL1 = 0x8066,
	ARM64_SYSREG_DBGWVR13_EL1 = 0x806E,
	ARM64_SYSREG_DBGWVR14_EL1 = 0x8076,
	ARM64_SYSREG_DBGWVR15_EL1 = 0x807E,
	ARM64_SYSREG_DBGWCR0_EL1 = 0x8007,
	ARM64_SYSREG_DBGWCR1_EL1 = 0x800F,
	ARM64_SYSREG_DBGWCR2_EL1 = 0x8017,
	ARM64_SYSREG_DBGWCR3_EL1 = 0x801F,
	ARM64_SYSREG_DBGWCR4_EL1 = 0x8027,
	ARM64_SYSREG_DBGWCR5_EL1 = 0x802F,
	ARM64_SYSREG_DBGWCR6_EL1 = 0x8037,
	ARM64_SYSREG_DBGWCR7_EL1 = 0x803F,
	ARM64_SYSREG_DBGWCR8_EL1 = 0x8047,
	ARM64_SYSREG_DBGWCR9_EL1 = 0x804F,
	ARM64_SYSREG_DBGWCR10_EL1 = 0x8057,
	ARM64_SYSREG_DBGWCR11_EL1 = 0x805F,
	ARM64_SYSREG_DBGWCR12_EL1 = 0x8067,
	ARM64_SYSREG_DBGWCR13_EL1 = 0x806F,
	ARM64_SYSREG_DBGWCR14_EL1 = 0x8077,
	ARM64_SYSREG_DBGWCR15_EL1 = 0x807F,
	ARM64_SYSREG_TEEHBR32_EL1 = 0x9080,
	ARM64_SYSREG_OSDLR_EL1 = 0x809C,
	ARM64_SYSREG_DBGPRCR_EL1 = 0x80A4,
	ARM64_SYSREG_DBGCLAIMSET_EL1 = 0x83C6,
	ARM64_SYSREG_DBGCLAIMCLR_EL1 = 0x83CE,
	ARM64_SYSREG_CSSELR_EL1 = 0xD000,
	ARM64_SYSREG_VPIDR_EL2 = 0xE000,
	ARM64_SYSREG_VMPIDR_EL2 = 0xE005,
	ARM64_SYSREG_CPACR_EL1 = 0xC082,
	ARM64_SYSREG_SCTLR_EL1 = 0xC080,
	ARM64_SYSREG_SCTLR_EL2 = 0xE080,
	ARM64_SYSREG_SCTLR_EL3 = 0xF080,
	ARM64_SYSREG_ACTLR_EL1 = 0xC081,
	ARM64_SYSREG_ACTLR_EL2 = 0xE081,
	ARM64_SYSREG_ACTLR_EL3 = 0xF081,
	ARM64_SYSREG_HCR_EL2 = 0xE088,
	ARM64_SYSREG_SCR_EL3 = 0xF088,
	ARM64_SYSREG_MDCR_EL2 = 0xE089,
	ARM64_SYSREG_SDER32_EL3 = 0xF089,
	ARM64_SYSREG_CPTR_EL2 = 0xE08A,
	ARM64_SYSREG_CPTR_EL3 = 0xF08A,
	ARM64_SYSREG_HSTR_EL2 = 0xE08B,
	ARM64_SYSREG_HACR_EL2 = 0xE08F,
	ARM64_SYSREG_MDCR_EL3 = 0xF099,
	ARM64_SYSREG_TTBR0_EL1 = 0xC100,
	ARM64_SYSREG_TTBR0_EL2 = 0xE100,
	ARM64_SYSREG_TTBR0_EL3 = 0xF100,
	ARM64_SYSREG_TTBR1_EL1 = 0xC101,
	ARM64_SYSREG_TCR_EL1 = 0xC102,
	ARM64_SYSREG_TCR_EL2 = 0xE102,
	ARM64_SYSREG_TCR_EL3 = 0xF102,
	ARM64_SYSREG_VTTBR_EL2 = 0xE108,
	ARM64_SYSREG_VTCR_EL2 = 0xE10A,
	ARM64_SYSREG_DACR32_EL2 = 0xE180,
	ARM64_SYSREG_SPSR_EL1 = 0xC200,
	ARM64_SYSREG_SPSR_EL2 = 0xE200,
	ARM64_SYSREG_SPSR_EL3 = 0xF200,
	ARM64_SYSREG_ELR_EL1 = 0xC201,
	ARM64_SYSREG_ELR_EL2 = 0xE201,
	ARM64_SYSREG_ELR_EL3 = 0xF201,
	ARM64_SYSREG_SP_EL0 = 0xC208,
	ARM64_SYSREG_SP_EL1 = 0xE208,
	ARM64_SYSREG_SP_EL2 = 0xF208,
	ARM64_SYSREG_SPSEL = 0xC210,
	ARM64_SYSREG_NZCV = 0xDA10,
	ARM64_SYSREG_DAIF = 0xDA11,
	ARM64_SYSREG_CURRENTEL = 0xC212,
	ARM64_SYSREG_SPSR_IRQ = 0xE218,
	ARM64_SYSREG_SPSR_ABT = 0xE219,
	ARM64_SYSREG_SPSR_UND = 0xE21A,
	ARM64_SYSREG_SPSR_FIQ = 0xE21B,
	ARM64_SYSREG_FPCR = 0xDA20,
	ARM64_SYSREG_FPSR = 0xDA21,
	ARM64_SYSREG_DSPSR_EL0 = 0xDA28,
	ARM64_SYSREG_DLR_EL0 = 0xDA29,
	ARM64_SYSREG_IFSR32_EL2 = 0xE281,
	ARM64_SYSREG_AFSR0_EL1 = 0xC288,
	ARM64_SYSREG_AFSR0_EL2 = 0xE288,
	ARM64_SYSREG_AFSR0_EL3 = 0xF288,
	ARM64_SYSREG_AFSR1_EL1 = 0xC289,
	ARM64_SYSREG_AFSR1_EL2 = 0xE289,
	ARM64_SYSREG_AFSR1_EL3 = 0xF289,
	ARM64_SYSREG_ESR_EL1 = 0xC290,
	ARM64_SYSREG_ESR_EL2 = 0xE290,
	ARM64_SYSREG_ESR_EL3 = 0xF290,
	ARM64_SYSREG_FPEXC32_EL2 = 0xE298,
	ARM64_SYSREG_FAR_EL1 = 0xC300,
	ARM64_SYSREG_FAR_EL2 = 0xE300,
	ARM64_SYSREG_FAR_EL3 = 0xF300,
	ARM64_SYSREG_HPFAR_EL2 = 0xE304,
	ARM64_SYSREG_PAR_EL1 = 0xC3A0,
	ARM64_SYSREG_PMCR_EL0 = 0xDCE0,
	ARM64_SYSREG_PMCNTENSET_EL0 = 0xDCE1,
	ARM64_SYSREG_PMCNTENCLR_EL0 = 0xDCE2,
	ARM64_SYSREG_PMOVSCLR_EL0 = 0xDCE3,
	ARM64_SYSREG_PMSELR_EL0 = 0xDCE5,
	ARM64_SYSREG_PMCCNTR_EL0 = 0xDCE8,
	ARM64_SYSREG_PMXEVTYPER_EL0 = 0xDCE9,
	ARM64_SYSREG_PMXEVCNTR_EL0 = 0xDCEA,
	ARM64_SYSREG_PMUSERENR_EL0 = 0xDCF0,
	ARM64_SYSREG_PMINTENSET_EL1 = 0xC4F1,
	ARM64_SYSREG_PMINTENCLR_EL1 = 0xC4F2,
	ARM64_SYSREG_PMOVSSET_EL0 = 0xDCF3,
	ARM64_SYSREG_MAIR_EL1 = 0xC510,
	ARM64_SYSREG_MAIR_EL2 = 0xE510,
	ARM64_SYSREG_MAIR_EL3 = 0xF510,
	ARM64_SYSREG_AMAIR_EL1 = 0xC518,
	ARM64_SYSREG_AMAIR_EL2 = 0xE518,
	ARM64_SYSREG_AMAIR_EL3 = 0xF518,
	ARM64_SYSREG_VBAR_EL1 = 0xC600,
	ARM64_SYSREG_VBAR_EL2 = 0xE600,
	ARM64_SYSREG_VBAR_EL3 = 0xF600,
	ARM64_SYSREG_RMR_EL1 = 0xC602,
	ARM64_SYSREG_RMR_EL2 = 0xE602,
	ARM64_SYSREG_RMR_EL3 = 0xF602,
	ARM64_SYSREG_CONTEXTIDR_EL1 = 0xC681,
	ARM64_SYSREG_TPIDR_EL0 = 0xDE82,
	ARM64_SYSREG_TPIDR_EL2 = 0xE682,
	ARM64_SYSREG_TPIDR_EL3 = 0xF682,
	ARM64_SYSREG_TPIDRRO_EL0 = 0xDE83,
	ARM64_SYSREG_TPIDR_EL1 = 0xC684,
	ARM64_SYSREG_CNTFRQ_EL0 = 0xDF00,
	ARM64_SYSREG_CNTVOFF_EL2 = 0xE703,
	ARM64_SYSREG_CNTKCTL_EL1 = 0xC708,
	ARM64_SYSREG_CNTHCTL_EL2 = 0xE708,
	ARM64_SYSREG_CNTP_TVAL_EL0 = 0xDF10,
	ARM64_SYSREG_CNTHP_TVAL_EL2 = 0xE710,
	ARM64_SYSREG_CNTPS_TVAL_EL1 = 0xFF10,
	ARM64_SYSREG_CNTP_CTL_EL0 = 0xDF11,
	ARM64_SYSREG_CNTHP_CTL_EL2 = 0xE711,
	ARM64_SYSREG_CNTPS_CTL_EL1 = 0xFF11,
	ARM64_SYSREG_CNTP_CVAL_EL0 = 0xDF12,
	ARM64_SYSREG_CNTHP_CVAL_EL2 = 0xE712,
	ARM64_SYSREG_CNTPS_CVAL_EL1 = 0xFF12,
	ARM64_SYSREG_CNTV_TVAL_EL0 = 0xDF18,
	ARM64_SYSREG_CNTV_CTL_EL0 = 0xDF19,
	ARM64_SYSREG_CNTV_CVAL_EL0 = 0xDF1A,
	ARM64_SYSREG_PMEVCNTR0_EL0 = 0xDF40,
	ARM64_SYSREG_PMEVCNTR1_EL0 = 0xDF41,
	ARM64_SYSREG_PMEVCNTR2_EL0 = 0xDF42,
	ARM64_SYSREG_PMEVCNTR3_EL0 = 0xDF43,
	ARM64_SYSREG_PMEVCNTR4_EL0 = 0xDF44,
	ARM64_SYSREG_PMEVCNTR5_EL0 = 0xDF45,
	ARM64_SYSREG_PMEVCNTR6_EL0 = 0xDF46,
	ARM64_SYSREG_PMEVCNTR7_EL0 = 0xDF47,
	ARM64_SYSREG_PMEVCNTR8_EL0 = 0xDF48,
	ARM64_SYSREG_PMEVCNTR9_EL0 = 0xDF49,
	ARM64_SYSREG_PMEVCNTR10_EL0 = 0xDF4A,
	ARM64_SYSREG_PMEVCNTR11_EL0 = 0xDF4B,
	ARM64_SYSREG_PMEVCNTR12_EL0 = 0xDF4C,
	ARM64_SYSREG_PMEVCNTR13_EL0 = 0xDF4D,
	ARM64_SYSREG_PMEVCNTR14_EL0 = 0xDF4E,
	ARM64_SYSREG_PMEVCNTR15_EL0 = 0xDF4F,
	ARM64_SYSREG_PMEVCNTR16_EL0 = 0xDF50,
	ARM64_SYSREG_PMEVCNTR17_EL0 = 0xDF51,
	ARM64_SYSREG_PMEVCNTR18_EL0 = 0xDF52,
	ARM64_SYSREG_PMEVCNTR19_EL0 = 0xDF53,
	ARM64_SYSREG_PMEVCNTR20_EL0 = 0xDF54,
	ARM64_SYSREG_PMEVCNTR21_EL0 = 0xDF55,
	ARM64_SYSREG_PMEVCNTR22_EL0 = 0xDF56,
	ARM64_SYSREG_PMEVCNTR23_EL0 = 0xDF57,
	ARM64_SYSREG_PMEVCNTR24_EL0 = 0xDF58,
	ARM64_SYSREG_PMEVCNTR25_EL0 = 0xDF59,
	ARM64_SYSREG_PMEVCNTR26_EL0 = 0xDF5A,
	ARM64_SYSREG_PMEVCNTR27_EL0 = 0xDF5B,
	ARM64_SYSREG_PMEVCNTR28_EL0 = 0xDF5C,
	ARM64_SYSREG_PMEVCNTR29_EL0 = 0xDF5D,
	ARM64_SYSREG_PMEVCNTR30_EL0 = 0xDF5E,
	ARM64_SYSREG_PMCCFILTR_EL0 = 0xDF7F,
	ARM64_SYSREG_PMEVTYPER0_EL0 = 0xDF60,
	ARM64_SYSREG_PMEVTYPER1_EL0 = 0xDF61,
	ARM64_SYSREG_PMEVTYPER2_EL0 = 0xDF62,
	ARM64_SYSREG_PMEVTYPER3_EL0 = 0xDF63,
	ARM64_SYSREG_PMEVTYPER4_EL0 = 0xDF64,
	ARM64_SYSREG_PMEVTYPER5_EL0 = 0xDF65,
	ARM64_SYSREG_PMEVTYPER6_EL0 = 0xDF66,
	ARM64_SYSREG_PMEVTYPER7_EL0 = 0xDF67,
	ARM64_SYSREG_PMEVTYPER8_EL0 = 0xDF68,
	ARM64_SYSREG_PMEVTYPER9_EL0 = 0xDF69,
	ARM64_SYSREG_PMEVTYPER10_EL0 = 0xDF6A,
	ARM64_SYSREG_PMEVTYPER11_EL0 = 0xDF6B,
	ARM64_SYSREG_PMEVTYPER12_EL0 = 0xDF6C,
	ARM64_SYSREG_PMEVTYPER13_EL0 = 0xDF6D,
	ARM64_SYSREG_PMEVTYPER14_EL0 = 0xDF6E,
	ARM64_SYSREG_PMEVTYPER15_EL0 = 0xDF6F,
	ARM64_SYSREG_PMEVTYPER16_EL0 = 0xDF70,
	ARM64_SYSREG_PMEVTYPER17_EL0 = 0xDF71,
	ARM64_SYSREG_PMEVTYPER18_EL0 = 0xDF72,
	ARM64_SYSREG_PMEVTYPER19_EL0 = 0xDF73,
	ARM64_SYSREG_PMEVTYPER20_EL0 = 0xDF74,
	ARM64_SYSREG_PMEVTYPER21_EL0 = 0xDF75,
	ARM64_SYSREG_PMEVTYPER22_EL0 = 0xDF76,
	ARM64_SYSREG_PMEVTYPER23_EL0 = 0xDF77,
	ARM64_SYSREG_PMEVTYPER24_EL0 = 0xDF78,
	ARM64_SYSREG_PMEVTYPER25_EL0 = 0xDF79,
	ARM64_SYSREG_PMEVTYPER26_EL0 = 0xDF7A,
	ARM64_SYSREG_PMEVTYPER27_EL0 = 0xDF7B,
	ARM64_SYSREG_PMEVTYPER28_EL0 = 0xDF7C,
	ARM64_SYSREG_PMEVTYPER29_EL0 = 0xDF7D,
	ARM64_SYSREG_PMEVTYPER30_EL0 = 0xDF7E,
	ARM64_SYSREG_TRCPRGCTLR = 0x8808,
	ARM64_SYSREG_TRCPROCSELR = 0x8810,
	ARM64_SYSREG_TRCCONFIGR = 0x8820,
	ARM64_SYSREG_TRCAUXCTLR = 0x8830,
	ARM64_SYSREG_TRCEVENTCTL0R = 0x8840,
	ARM64_SYSREG_TRCEVENTCTL1R = 0x8848,
	ARM64_SYSREG_TRCSTALLCTLR = 0x8858,
	ARM64_SYSREG_TRCTSCTLR = 0x8860,
	ARM64_SYSREG_TRCSYNCPR = 0x8868,
	ARM64_SYSREG_TRCCCCTLR = 0x8870,
	ARM64_SYSREG_TRCBBCTLR = 0x8878,
	ARM64_SYSREG_TRCTRACEIDR = 0x8801,
	ARM64_SYSREG_TRCQCTLR = 0x8809,
	ARM64_SYSREG_TRCVICTLR = 0x8802,
	ARM64_SYSREG_TRCVIIECTLR = 0x880A,
	ARM64_SYSREG_TRCVISSCTLR = 0x8812,
	ARM64_SYSREG_TRCVIPCSSCTLR = 0x881A,
	ARM64_SYSREG_TRCVDCTLR = 0x8842,
	ARM64_SYSREG_TRCVDSACCTLR = 0x884A,
	ARM64_SYSREG_TRCVDARCCTLR = 0x8852,
	ARM64_SYSREG_TRCSEQEVR0 = 0x8804,
	ARM64_SYSREG_TRCSEQEVR1 = 0x880C,
	ARM64_SYSREG_TRCSEQEVR2 = 0x8814,
	ARM64_SYSREG_TRCSEQRSTEVR = 0x8834,
	ARM64_SYSREG_TRCSEQSTR = 0x883C,
	ARM64_SYSREG_TRCEXTINSELR = 0x8844,
	ARM64_SYSREG_TRCCNTRLDVR0 = 0x8805,
	ARM64_SYSREG_TRCCNTRLDVR1 = 0x880D,
	ARM64_SYSREG_TRCCNTRLDVR2 = 0x8815,
	ARM64_SYSREG_TRCCNTRLDVR3 = 0x881D,
	ARM64_SYSREG_TRCCNTCTLR0 = 0x8825,
	ARM64_SYSREG_TRCCNTCTLR1 = 0x882D,
	ARM64_SYSREG_TRCCNTCTLR2 = 0x8835,
	ARM64_SYSREG_TRCCNTCTLR3 = 0x883D,
	ARM64_SYSREG_TRCCNTVR0 = 0x8845,
	ARM64_SYSREG_TRCCNTVR1 = 0x884D,
	ARM64_SYSREG_TRCCNTVR2 = 0x8855,
	ARM64_SYSREG_TRCCNTVR3 = 0x885D,
	ARM64_SYSREG_TRCIMSPEC0 = 0x8807,
	ARM64_SYSREG_TRCIMSPEC1 = 0x880F,
	ARM64_SYSREG_TRCIMSPEC2 = 0x8817,
	ARM64_SYSREG_TRCIMSPEC3 = 0x881F,
	ARM64_SYSREG_TRCIMSPEC4 = 0x8827,
	ARM64_SYSREG_TRCIMSPEC5 = 0x882F,
	ARM64_SYSREG_TRCIMSPEC6 = 0x8837,
	ARM64_SYSREG_TRCIMSPEC7 = 0x883F,
	ARM64_SYSREG_TRCRSCTLR2 = 0x8890,
	ARM64_SYSREG_TRCRSCTLR3 = 0x8898,
	ARM64_SYSREG_TRCRSCTLR4 = 0x88A0,
	ARM64_SYSREG_TRCRSCTLR5 = 0x88A8,
	ARM64_SYSREG_TRCRSCTLR6 = 0x88B0,
	ARM64_SYSREG_TRCRSCTLR7 = 0x88B8,
	ARM64_SYSREG_TRCRSCTLR8 = 0x88C0,
	ARM64_SYSREG_TRCRSCTLR9 = 0x88C8,
	ARM64_SYSREG_TRCRSCTLR10 = 0x88D0,
	ARM64_SYSREG_TRCRSCTLR11 = 0x88D8,
	ARM64_SYSREG_TRCRSCTLR12 = 0x88E0,
	ARM64_SYSREG_TRCRSCTLR13 = 0x88E8,
	ARM64_SYSREG_TRCRSCTLR14 = 0x88F0,
	ARM64_SYSREG_TRCRSCTLR15 = 0x88F8,
	ARM64_SYSREG_TRCRSCTLR16 = 0x8881,
	ARM64_SYSREG_TRCRSCTLR17 = 0x8889,
	ARM64_SYSREG_TRCRSCTLR18 = 0x8891,
	ARM64_SYSREG_TRCRSCTLR19 = 0x8899,
	ARM64_SYSREG_TRCRSCTLR20 = 0x88A1,
	ARM64_SYSREG_TRCRSCTLR21 = 0x88A9,
	ARM64_SYSREG_TRCRSCTLR22 = 0x88B1,
	ARM64_SYSREG_TRCRSCTLR23 = 0x88B9,
	ARM64_SYSREG_TRCRSCTLR24 = 0x88C1,
	ARM64_SYSREG_TRCRSCTLR25 = 0x88C9,
	ARM64_SYSREG_TRCRSCTLR26 = 0x88D1,
	ARM64_SYSREG_TRCRSCTLR27 = 0x88D9,
	ARM64_SYSREG_TRCRSCTLR28 = 0x88E1,
	ARM64_SYSREG_TRCRSCTLR29 = 0x88E9,
	ARM64_SYSREG_TRCRSCTLR30 = 0x88F1,
	ARM64_SYSREG_TRCRSCTLR31 = 0x88F9,
	ARM64_SYSREG_TRCSSCCR0 = 0x8882,
	ARM64_SYSREG_TRCSSCCR1 = 0x888A,
	ARM64_SYSREG_TRCSSCCR2 = 0x8892,
	ARM64_SYSREG_TRCSSCCR3 = 0x889A,
	ARM64_SYSREG_TRCSSCCR4 = 0x88A2,
	ARM64_SYSREG_TRCSSCCR5 = 0x88AA,
	ARM64_SYSREG_TRCSSCCR6 = 0x88B2,
	ARM64_SYSREG_TRCSSCCR7 = 0x88BA,
	ARM64_SYSREG_TRCSSCSR0 = 0x88C2,
	ARM64_SYSREG_TRCSSCSR1 = 0x88CA,
	ARM64_SYSREG_TRCSSCSR2 = 0x88D2,
	ARM64_SYSREG_TRCSSCSR3 = 0x88DA,
	ARM64_SYSREG_TRCSSCSR4 = 0x88E2,
	ARM64_SYSREG_TRCSSCSR5 = 0x88EA,
	ARM64_SYSREG_TRCSSCSR6 = 0x88F2,
	ARM64_SYSREG_TRCSSCSR7 = 0x88FA,
	ARM64_SYSREG_TRCSSPCICR0 = 0x8883,
	ARM64_SYSREG_TRCSSPCICR1 = 0x888B,
	ARM64_SYSREG_TRCSSPCICR2 = 0x8893,
	ARM64_SYSREG_TRCSSPCICR3 = 0x889B,
	ARM64_SYSREG_TRCSSPCICR4 = 0x88A3,
	ARM64_SYSREG_TRCSSPCICR5 = 0x88AB,
	ARM64_SYSREG_TRCSSPCICR6 = 0x88B3,
	ARM64_SYSREG_TRCSSPCICR7 = 0x88BB,
	ARM64_SYSREG_TRCPDCR = 0x88A4,
	ARM64_SYSREG_TRCACVR0 = 0x8900,
	ARM64_SYSREG_TRCACVR1 = 0x8910,
	ARM64_SYSREG_TRCACVR2 = 0x8920,
	ARM64_SYSREG_TRCACVR3 = 0x8930,
	ARM64_SYSREG_TRCACVR4 = 0x8940,
	ARM64_SYSREG_TRCACVR5 = 0x8950,
	ARM64_SYSREG_TRCACVR6 = 0x8960,
	ARM64_SYSREG_TRCACVR7 = 0x8970,
	ARM64_SYSREG_TRCACVR8 = 0x8901,
	ARM64_SYSREG_TRCACVR9 = 0x8911,
	ARM64_SYSREG_TRCACVR10 = 0x8921,
	ARM64_SYSREG_TRCACVR11 = 0x8931,
	ARM64_SYSREG_TRCACVR12 = 0x8941,
	ARM64_SYSREG_TRCACVR13 = 0x8951,
	ARM64_SYSREG_TRCACVR14 = 0x8961,
	ARM64_SYSREG_TRCACVR15 = 0x8971,
	ARM64_SYSREG_TRCACATR0 = 0x8902,
	ARM64_SYSREG_TRCACATR1 = 0x8912,
	ARM64_SYSREG_TRCACATR2 = 0x8922,
	ARM64_SYSREG_TRCACATR3 = 0x8932,
	ARM64_SYSREG_TRCACATR4 = 0x8942,
	ARM64_SYSREG_TRCACATR5 = 0x8952,
	ARM64_SYSREG_TRCACATR6 = 0x8962,
	ARM64_SYSREG_TRCACATR7 = 0x8972,
	ARM64_SYSREG_TRCACATR8 = 0x8903,
	ARM64_SYSREG_TRCACATR9 = 0x8913,
	ARM64_SYSREG_TRCACATR10 = 0x8923,
	ARM64_SYSREG_TRCACATR11 = 0x8933,
	ARM64_SYSREG_TRCACATR12 = 0x8943,
	ARM64_SYSREG_TRCACATR13 = 0x8953,
	ARM64_SYSREG_TRCACATR14 = 0x8963,
	ARM64_SYSREG_TRCACATR15 = 0x8973,
	ARM64_SYSREG_TRCDVCVR0 = 0x8904,
	ARM64_SYSREG_TRCDVCVR1 = 0x8924,
	ARM64_SYSREG_TRCDVCVR2 = 0x8944,
	ARM64_SYSREG_TRCDVCVR3 = 0x8964,
	ARM64_SYSREG_TRCDVCVR4 = 0x8905,
	ARM64_SYSREG_TRCDVCVR5 = 0x8925,
	ARM64_SYSREG_TRCDVCVR6 = 0x8945,
	ARM64_SYSREG_TRCDVCVR7 = 0x8965,
	ARM64_SYSREG_TRCDVCMR0 = 0x8906,
	ARM64_SYSREG_TRCDVCMR1 = 0x8926,
	ARM64_SYSREG_TRCDVCMR2 = 0x8946,
	ARM64_SYSREG_TRCDVCMR3 = 0x8966,
	ARM64_SYSREG_TRCDVCMR4 = 0x8907,
	ARM64_SYSREG_TRCDVCMR5 = 0x8927,
	ARM64_SYSREG_TRCDVCMR6 = 0x8947,
	ARM64_SYSREG_TRCDVCMR7 = 0x8967,
	ARM64_SYSREG_TRCCIDCVR0 = 0x8980,
	ARM64_SYSREG_TRCCIDCVR1 = 0x8990,
	ARM64_SYSREG_TRCCIDCVR2 = 0x89A0,
	ARM64_SYSREG_TRCCIDCVR3 = 0x89B0,
	ARM64_SYSREG_TRCCIDCVR4 = 0x89C0,
	ARM64_SYSREG_TRCCIDCVR5 = 0x89D0,
	ARM64_SYSREG_TRCCIDCVR6 = 0x89E0,
	ARM64_SYSREG_TRCCIDCVR7 = 0x89F0,
	ARM64_SYSREG_TRCVMIDCVR0 = 0x8981,
	ARM64_SYSREG_TRCVMIDCVR1 = 0x8991,
	ARM64_SYSREG_TRCVMIDCVR2 = 0x89A1,
	ARM64_SYSREG_TRCVMIDCVR3 = 0x89B1,
	ARM64_SYSREG_TRCVMIDCVR4 = 0x89C1,
	ARM64_SYSREG_TRCVMIDCVR5 = 0x89D1,
	ARM64_SYSREG_TRCVMIDCVR6 = 0x89E1,
	ARM64_SYSREG_TRCVMIDCVR7 = 0x89F1,
	ARM64_SYSREG_TRCCIDCCTLR0 = 0x8982,
	ARM64_SYSREG_TRCCIDCCTLR1 = 0x898A,
	ARM64_SYSREG_TRCVMIDCCTLR0 = 0x8992,
	ARM64_SYSREG_TRCVMIDCCTLR1 = 0x899A,
	ARM64_SYSREG_TRCITCTRL = 0x8B84,
	ARM64_SYSREG_TRCCLAIMSET = 0x8BC6,
	ARM64_SYSREG_TRCCLAIMCLR = 0x8BCE,
	ARM64_SYSREG_ICC_BPR1_EL1 = 0xC663,
	ARM64_SYSREG_ICC_BPR0_EL1 = 0xC643,
	ARM64_SYSREG_ICC_PMR_EL1 = 0xC230,
	ARM64_SYSREG_ICC_CTLR_EL1 = 0xC664,
	ARM64_SYSREG_ICC_CTLR_EL3 = 0xF664,
	ARM64_SYSREG_ICC_SRE_EL1 = 0xC665,
	ARM64_SYSREG_ICC_SRE_EL2 = 0xE64D,
	ARM64_SYSREG_ICC_SRE_EL3 = 0xF665,
	ARM64_SYSREG_ICC_IGRPEN0_EL1 = 0xC666,
	ARM64_SYSREG_ICC_IGRPEN1_EL1 = 0xC667,
	ARM64_SYSREG_ICC_IGRPEN1_EL3 = 0xF667,
	ARM64_SYSREG_ICC_SEIEN_EL1 = 0xC668,
	ARM64_SYSREG_ICC_AP0R0_EL1 = 0xC644,
	ARM64_SYSREG_ICC_AP0R1_EL1 = 0xC645,
	ARM64_SYSREG_ICC_AP0R2_EL1 = 0xC646,
	ARM64_SYSREG_ICC_AP0R3_EL1 = 0xC647,
	ARM64_SYSREG_ICC_AP1R0_EL1 = 0xC648,
	ARM64_SYSREG_ICC_AP1R1_EL1 = 0xC649,
	ARM64_SYSREG_ICC_AP1R2_EL1 = 0xC64A,
	ARM64_SYSREG_ICC_AP1R3_EL1 = 0xC64B,
	ARM64_SYSREG_ICH_AP0R0_EL2 = 0xE640,
	ARM64_SYSREG_ICH_AP0R1_EL2 = 0xE641,
	ARM64_SYSREG_ICH_AP0R2_EL2 = 0xE642,
	ARM64_SYSREG_ICH_AP0R3_EL2 = 0xE643,
	ARM64_SYSREG_ICH_AP1R0_EL2 = 0xE648,
	ARM64_SYSREG_ICH_AP1R1_EL2 = 0xE649,
	ARM64_SYSREG_ICH_AP1R2_EL2 = 0xE64A,
	ARM64_SYSREG_ICH_AP1R3_EL2 = 0xE64B,
	ARM64_SYSREG_ICH_HCR_EL2 = 0xE658,
	ARM64_SYSREG_ICH_MISR_EL2 = 0xE65A,
	ARM64_SYSREG_ICH_VMCR_EL2 = 0xE65F,
	ARM64_SYSREG_ICH_VSEIR_EL2 = 0xE64C,
	ARM64_SYSREG_ICH_LR0_EL2 = 0xE660,
	ARM64_SYSREG_ICH_LR1_EL2 = 0xE661,
	ARM64_SYSREG_ICH_LR2_EL2 = 0xE662,
	ARM64_SYSREG_ICH_LR3_EL2 = 0xE663,
	ARM64_SYSREG_ICH_LR4_EL2 = 0xE664,
	ARM64_SYSREG_ICH_LR5_EL2 = 0xE665,
	ARM64_SYSREG_ICH_LR6_EL2 = 0xE666,
	ARM64_SYSREG_ICH_LR7_EL2 = 0xE667,
	ARM64_SYSREG_ICH_LR8_EL2 = 0xE668,
	ARM64_SYSREG_ICH_LR9_EL2 = 0xE669,
	ARM64_SYSREG_ICH_LR10_EL2 = 0xE66A,
	ARM64_SYSREG_ICH_LR11_EL2 = 0xE66B,
	ARM64_SYSREG_ICH_LR12_EL2 = 0xE66C,
	ARM64_SYSREG_ICH_LR13_EL2 = 0xE66D,
	ARM64_SYSREG_ICH_LR14_EL2 = 0xE66E,
	ARM64_SYSREG_ICH_LR15_EL2 = 0xE66F,
	ARM64_SYSREG_PAN = 0xC213,
	ARM64_SYSREG_LORSA_EL1 = 0xC520,
	ARM64_SYSREG_LOREA_EL1 = 0xC521,
	ARM64_SYSREG_LORN_EL1 = 0xC522,
	ARM64_SYSREG_LORC_EL1 = 0xC523,
	ARM64_SYSREG_TTBR1_EL2 = 0xE101,
	ARM64_SYSREG_CONTEXTIDR_EL2 = 0xE681,
	ARM64_SYSREG_CNTHV_TVAL_EL2 = 0xE718,
	ARM64_SYSREG_CNTHV_CVAL_EL2 = 0xE71A,
	ARM64_SYSREG_CNTHV_CTL_EL2 = 0xE719,
	ARM64_SYSREG_SCTLR_EL12 = 0xE880,
	ARM64_SYSREG_CPACR_EL12 = 0xE882,
	ARM64_SYSREG_TTBR0_EL12 = 0xE900,
	ARM64_SYSREG_TTBR1_EL12 = 0xE901,
	ARM64_SYSREG_TCR_EL12 = 0xE902,
	ARM64_SYSREG_AFSR0_EL12 = 0xEA88,
	ARM64_SYSREG_AFSR1_EL12 = 0xEA89,
	ARM64_SYSREG_ESR_EL12 = 0xEA90,
	ARM64_SYSREG_FAR_EL12 = 0xEB00,
	ARM64_SYSREG_MAIR_EL12 = 0xED10,
	ARM64_SYSREG_AMAIR_EL12 = 0xED18,
	ARM64_SYSREG_VBAR_EL12 = 0xEE00,
	ARM64_SYSREG_CONTEXTIDR_EL12 = 0xEE81,
	ARM64_SYSREG_CNTKCTL_EL12 = 0xEF08,
	ARM64_SYSREG_CNTP_TVAL_EL02 = 0xEF10,
	ARM64_SYSREG_CNTP_CTL_EL02 = 0xEF11,
	ARM64_SYSREG_CNTP_CVAL_EL02 = 0xEF12,
	ARM64_SYSREG_CNTV_TVAL_EL02 = 0xEF18,
	ARM64_SYSREG_CNTV_CTL_EL02 = 0xEF19,
	ARM64_SYSREG_CNTV_CVAL_EL02 = 0xEF1A,
	ARM64_SYSREG_SPSR_EL12 = 0xEA00,
	ARM64_SYSREG_ELR_EL12 = 0xEA01,
	ARM64_SYSREG_UAO = 0xC214,
	ARM64_SYSREG_PMBLIMITR_EL1 = 0xC4D0,
	ARM64_SYSREG_PMBPTR_EL1 = 0xC4D1,
	ARM64_SYSREG_PMBSR_EL1 = 0xC4D3,
	ARM64_SYSREG_PMBIDR_EL1 = 0xC4D7,
	ARM64_SYSREG_PMSCR_EL2 = 0xE4C8,
	ARM64_SYSREG_PMSCR_EL12 = 0xECC8,
	ARM64_SYSREG_PMSCR_EL1 = 0xC4C8,
	ARM64_SYSREG_PMSICR_EL1 = 0xC4CA,
	ARM64_SYSREG_PMSIRR_EL1 = 0xC4CB,
	ARM64_SYSREG_PMSFCR_EL1 = 0xC4CC,
	ARM64_SYSREG_PMSEVFR_EL1 = 0xC4CD,
	ARM64_SYSREG_PMSLATFR_EL1 = 0xC4CE,
	ARM64_SYSREG_PMSIDR_EL1 = 0xC4CF,
	ARM64_SYSREG_ERRSELR_EL1 = 0xC299,
	ARM64_SYSREG_ERXCTLR_EL1 = 0xC2A1,
	ARM64_SYSREG_ERXSTATUS_EL1 = 0xC2A2,
	ARM64_SYSREG_ERXADDR_EL1 = 0xC2A3,
	ARM64_SYSREG_ERXMISC0_EL1 = 0xC2A8,
	ARM64_SYSREG_ERXMISC1_EL1 = 0xC2A9,
	ARM64_SYSREG_DISR_EL1 = 0xC609,
	ARM64_SYSREG_VDISR_EL2 = 0xE609,
	ARM64_SYSREG_VSESR_EL2 = 0xE293,
	ARM64_SYSREG_APIAKEYLO_EL1 = 0xC108,
	ARM64_SYSREG_APIAKEYHI_EL1 = 0xC109,
	ARM64_SYSREG_APIBKEYLO_EL1 = 0xC10A,
	ARM64_SYSREG_APIBKEYHI_EL1 = 0xC10B,
	ARM64_SYSREG_APDAKEYLO_EL1 = 0xC110,
	ARM64_SYSREG_APDAKEYHI_EL1 = 0xC111,
	ARM64_SYSREG_APDBKEYLO_EL1 = 0xC112,
	ARM64_SYSREG_APDBKEYHI_EL1 = 0xC113,
	ARM64_SYSREG_APGAKEYLO_EL1 = 0xC118,
	ARM64_SYSREG_APGAKEYHI_EL1 = 0xC119,
	ARM64_SYSREG_VSTCR_EL2 = 0xE132,
	ARM64_SYSREG_VSTTBR_EL2 = 0xE130,
	ARM64_SYSREG_CNTHVS_TVAL_EL2 = 0xE720,
	ARM64_SYSREG_CNTHVS_CVAL_EL2 = 0xE722,
	ARM64_SYSREG_CNTHVS_CTL_EL2 = 0xE721,
	ARM64_SYSREG_CNTHPS_TVAL_EL2 = 0xE728,
	ARM64_SYSREG_CNTHPS_CVAL_EL2 = 0xE72A,
	ARM64_SYSREG_CNTHPS_CTL_EL2 = 0xE729,
	ARM64_SYSREG_SDER32_EL2 = 0xE099,
	ARM64_SYSREG_ERXPFGCTL_EL1 = 0xC2A5,
	ARM64_SYSREG_ERXPFGCDN_EL1 = 0xC2A6,
	ARM64_SYSREG_ERXTS_EL1 = 0xC2AF,
	ARM64_SYSREG_ERXMISC2_EL1 = 0xC2AA,
	ARM64_SYSREG_ERXMISC3_EL1 = 0xC2AB,
	ARM64_SYSREG_ERXPFGF_EL1 = 0xC2A4,
	ARM64_SYSREG_MPAM0_EL1 = 0xC529,
	ARM64_SYSREG_MPAM1_EL1 = 0xC528,
	ARM64_SYSREG_MPAM2_EL2 = 0xE528,
	ARM64_SYSREG_MPAM3_EL3 = 0xF528,
	ARM64_SYSREG_MPAM1_EL12 = 0xED28,
	ARM64_SYSREG_MPAMHCR_EL2 = 0xE520,
	ARM64_SYSREG_MPAMVPMV_EL2 = 0xE521,
	ARM64_SYSREG_MPAMVPM0_EL2 = 0xE530,
	ARM64_SYSREG_MPAMVPM1_EL2 = 0xE531,
	ARM64_SYSREG_MPAMVPM2_EL2 = 0xE532,
	ARM64_SYSREG_MPAMVPM3_EL2 = 0xE533,
	ARM64_SYSREG_MPAMVPM4_EL2 = 0xE534,
	ARM64_SYSREG_MPAMVPM5_EL2 = 0xE535,
	ARM64_SYSREG_MPAMVPM6_EL2 = 0xE536,
	ARM64_SYSREG_MPAMVPM7_EL2 = 0xE537,
	ARM64_SYSREG_MPAMIDR_EL1 = 0xC524,
	ARM64_SYSREG_AMCR_EL0 = 0xDE90,
	ARM64_SYSREG_AMCFGR_EL0 = 0xDE91,
	ARM64_SYSREG_AMCGCR_EL0 = 0xDE92,
	ARM64_SYSREG_AMUSERENR_EL0 = 0xDE93,
	ARM64_SYSREG_AMCNTENCLR0_EL0 = 0xDE94,
	ARM64_SYSREG_AMCNTENSET0_EL0 = 0xDE95,
	ARM64_SYSREG_AMEVCNTR00_EL0 = 0xDEA0,
	ARM64_SYSREG_AMEVCNTR01_EL0 = 0xDEA1,
	ARM64_SYSREG_AMEVCNTR02_EL0 = 0xDEA2,
	ARM64_SYSREG_AMEVCNTR03_EL0 = 0xDEA3,
	ARM64_SYSREG_AMEVTYPER00_EL0 = 0xDEB0,
	ARM64_SYSREG_AMEVTYPER01_EL0 = 0xDEB1,
	ARM64_SYSREG_AMEVTYPER02_EL0 = 0xDEB2,
	ARM64_SYSREG_AMEVTYPER03_EL0 = 0xDEB3,
	ARM64_SYSREG_AMCNTENCLR1_EL0 = 0xDE98,
	ARM64_SYSREG_AMCNTENSET1_EL0 = 0xDE99,
	ARM64_SYSREG_AMEVCNTR10_EL0 = 0xDEE0,
	ARM64_SYSREG_AMEVCNTR11_EL0 = 0xDEE1,
	ARM64_SYSREG_AMEVCNTR12_EL0 = 0xDEE2,
	ARM64_SYSREG_AMEVCNTR13_EL0 = 0xDEE3,
	ARM64_SYSREG_AMEVCNTR14_EL0 = 0xDEE4,
	ARM64_SYSREG_AMEVCNTR15_EL0 = 0xDEE5,
	ARM64_SYSREG_AMEVCNTR16_EL0 = 0xDEE6,
	ARM64_SYSREG_AMEVCNTR17_EL0 = 0xDEE7,
	ARM64_SYSREG_AMEVCNTR18_EL0 = 0xDEE8,
	ARM64_SYSREG_AMEVCNTR19_EL0 = 0xDEE9,
	ARM64_SYSREG_AMEVCNTR110_EL0 = 0xDEEA,
	ARM64_SYSREG_AMEVCNTR111_EL0 = 0xDEEB,
	ARM64_SYSREG_AMEVCNTR112_EL0 = 0xDEEC,
	ARM64_SYSREG_AMEVCNTR113_EL0 = 0xDEED,
	ARM64_SYSREG_AMEVCNTR114_EL0 = 0xDEEE,
	ARM64_SYSREG_AMEVCNTR115_EL0 = 0xDEEF,
	ARM64_SYSREG_AMEVTYPER10_EL0 = 0xDEF0,
	ARM64_SYSREG_AMEVTYPER11_EL0 = 0xDEF1,
	ARM64_SYSREG_AMEVTYPER12_EL0 = 0xDEF2,
	ARM64_SYSREG_AMEVTYPER13_EL0 = 0xDEF3,
	ARM64_SYSREG_AMEVTYPER14_EL0 = 0xDEF4,
	ARM64_SYSREG_AMEVTYPER15_EL0 = 0xDEF5,
	ARM64_SYSREG_AMEVTYPER16_EL0 = 0xDEF6,
	ARM64_SYSREG_AMEVTYPER17_EL0 = 0xDEF7,
	ARM64_SYSREG_AMEVTYPER18_EL0 = 0xDEF8,
	ARM64_SYSREG_AMEVTYPER19_EL0 = 0xDEF9,
	ARM64_SYSREG_AMEVTYPER110_EL0 = 0xDEFA,
	ARM64_SYSREG_AMEVTYPER111_EL0 = 0xDEFB,
	ARM64_SYSREG_AMEVTYPER112_EL0 = 0xDEFC,
	ARM64_SYSREG_AMEVTYPER113_EL0 = 0xDEFD,
	ARM64_SYSREG_AMEVTYPER114_EL0 = 0xDEFE,
	ARM64_SYSREG_AMEVTYPER115_EL0 = 0xDEFF,
	ARM64_SYSREG_TRFCR_EL1 = 0xC091,
	ARM64_SYSREG_TRFCR_EL2 = 0xE091,
	ARM64_SYSREG_TRFCR_EL12 = 0xE891,
	ARM64_SYSREG_DIT = 0xDA15,
	ARM64_SYSREG_VNCR_EL2 = 0xE110,
	ARM64_SYSREG_ZCR_EL1 = 0xC090,
	ARM64_SYSREG_ZCR_EL2 = 0xE090,
	ARM64_SYSREG_ZCR_EL3 = 0xF090,
	ARM64_SYSREG_ZCR_EL12 = 0xE890,
	ARM64_SYSREG_CPM_IOACC_CTL_EL3 = 0xFF90,
} arm64_sysreg;

/// System PState Field (MSR instruction)
typedef enum arm64_pstate {
	ARM64_PSTATE_INVALID = 0,
	ARM64_PSTATE_SPSEL = 0x05,
	ARM64_PSTATE_DAIFSET = 0x1e,
	ARM64_PSTATE_DAIFCLR = 0x1f,
	ARM64_PSTATE_PAN = 0x4,
	ARM64_PSTATE_UAO = 0x3,
	ARM64_PSTATE_DIT = 0x1a,
} arm64_pstate;

/// Vector arrangement specifier (for FloatingPoint/Advanced SIMD insn)
typedef enum arm64_vas {
	ARM64_VAS_INVALID = 0,
	ARM64_VAS_16B,
	ARM64_VAS_8B,
	ARM64_VAS_4B,
	ARM64_VAS_1B,
	ARM64_VAS_8H,
	ARM64_VAS_4H,
	ARM64_VAS_2H,
	ARM64_VAS_1H,
	ARM64_VAS_4S,
	ARM64_VAS_2S,
	ARM64_VAS_1S,
	ARM64_VAS_2D,
	ARM64_VAS_1D,
	ARM64_VAS_1Q,
} arm64_vas;

/// Memory barrier operands
typedef enum arm64_barrier_op {
	ARM64_BARRIER_INVALID = 0,
	ARM64_BARRIER_OSHLD = 0x1,
	ARM64_BARRIER_OSHST = 0x2,
	ARM64_BARRIER_OSH =   0x3,
	ARM64_BARRIER_NSHLD = 0x5,
	ARM64_BARRIER_NSHST = 0x6,
	ARM64_BARRIER_NSH =   0x7,
	ARM64_BARRIER_ISHLD = 0x9,
	ARM64_BARRIER_ISHST = 0xa,
	ARM64_BARRIER_ISH =   0xb,
	ARM64_BARRIER_LD =    0xd,
	ARM64_BARRIER_ST =    0xe,
	ARM64_BARRIER_SY =    0xf
} arm64_barrier_op;

/// Operand type for instruction's operands
typedef enum arm64_op_type {
	ARM64_OP_INVALID = 0, ///< = CS_OP_INVALID (Uninitialized).
	ARM64_OP_REG, ///< = CS_OP_REG (Register operand).
	ARM64_OP_IMM, ///< = CS_OP_IMM (Immediate operand).
	ARM64_OP_MEM, ///< = CS_OP_MEM (Memory operand).
	ARM64_OP_FP,  ///< = CS_OP_FP (Floating-Point operand).
	ARM64_OP_CIMM = 64, ///< C-Immediate
	ARM64_OP_REG_MRS, ///< MRS register operand.
	ARM64_OP_REG_MSR, ///< MSR register operand.
	ARM64_OP_PSTATE, ///< PState operand.
	ARM64_OP_SYS, ///< SYS operand for IC/DC/AT/TLBI instructions.
	ARM64_OP_PREFETCH, ///< Prefetch operand (PRFM).
	ARM64_OP_BARRIER, ///< Memory barrier operand (ISB/DMB/DSB instructions).
} arm64_op_type;

/// SYS operands (IC/DC/AC/TLBI)
typedef enum arm64_sys_op {
	ARM64_SYS_INVALID = 0,

	/// TLBI operations
	ARM64_TLBI_IPAS2E1IS,
	ARM64_TLBI_IPAS2LE1IS,
	ARM64_TLBI_VMALLE1IS,
	ARM64_TLBI_ALLE2IS,
	ARM64_TLBI_ALLE3IS,
	ARM64_TLBI_VAE1IS,
	ARM64_TLBI_VAE2IS,
	ARM64_TLBI_VAE3IS,
	ARM64_TLBI_ASIDE1IS,
	ARM64_TLBI_VAAE1IS,
	ARM64_TLBI_ALLE1IS,
	ARM64_TLBI_VALE1IS,
	ARM64_TLBI_VALE2IS,
	ARM64_TLBI_VALE3IS,
	ARM64_TLBI_VMALLS12E1IS,
	ARM64_TLBI_VAALE1IS,
	ARM64_TLBI_IPAS2E1,
	ARM64_TLBI_IPAS2LE1,
	ARM64_TLBI_VMALLE1,
	ARM64_TLBI_ALLE2,
	ARM64_TLBI_ALLE3,
	ARM64_TLBI_VAE1,
	ARM64_TLBI_VAE2,
	ARM64_TLBI_VAE3,
	ARM64_TLBI_ASIDE1,
	ARM64_TLBI_VAAE1,
	ARM64_TLBI_ALLE1,
	ARM64_TLBI_VALE1,
	ARM64_TLBI_VALE2,
	ARM64_TLBI_VALE3,
	ARM64_TLBI_VMALLS12E1,
	ARM64_TLBI_VAALE1,
	ARM64_TLBI_VMALLE1OS,
	ARM64_TLBI_VAE1OS,
	ARM64_TLBI_ASIDE1OS,
	ARM64_TLBI_VAAE1OS,
	ARM64_TLBI_VALE1OS,
	ARM64_TLBI_VAALE1OS,
	ARM64_TLBI_IPAS2E1OS,
	ARM64_TLBI_IPAS2LE1OS,
	ARM64_TLBI_VAE2OS,
	ARM64_TLBI_VALE2OS,
	ARM64_TLBI_VMALLS12E1OS,
	ARM64_TLBI_VAE3OS,
	ARM64_TLBI_VALE3OS,
	ARM64_TLBI_ALLE2OS,
	ARM64_TLBI_ALLE1OS,
	ARM64_TLBI_ALLE3OS,
	ARM64_TLBI_RVAE1,
	ARM64_TLBI_RVAAE1,
	ARM64_TLBI_RVALE1,
	ARM64_TLBI_RVAALE1,
	ARM64_TLBI_RVAE1IS,
	ARM64_TLBI_RVAAE1IS,
	ARM64_TLBI_RVALE1IS,
	ARM64_TLBI_RVAALE1IS,
	ARM64_TLBI_RVAE1OS,
	ARM64_TLBI_RVAAE1OS,
	ARM64_TLBI_RVALE1OS,
	ARM64_TLBI_RVAALE1OS,
	ARM64_TLBI_RIPAS2E1IS,
	ARM64_TLBI_RIPAS2LE1IS,
	ARM64_TLBI_RIPAS2E1,
	ARM64_TLBI_RIPAS2LE1,
	ARM64_TLBI_RIPAS2E1OS,
	ARM64_TLBI_RIPAS2LE1OS,
	ARM64_TLBI_RVAE2,
	ARM64_TLBI_RVALE2,
	ARM64_TLBI_RVAE2IS,
	ARM64_TLBI_RVALE2IS,
	ARM64_TLBI_RVAE2OS,
	ARM64_TLBI_RVALE2OS,
	ARM64_TLBI_RVAE3,
	ARM64_TLBI_RVALE3,
	ARM64_TLBI_RVAE3IS,
	ARM64_TLBI_RVALE3IS,
	ARM64_TLBI_RVAE3OS,
	ARM64_TLBI_RVALE3OS,

	/// AT operations
	ARM64_AT_S1E1R,
	ARM64_AT_S1E2R,
	ARM64_AT_S1E3R,
	ARM64_AT_S1E1W,
	ARM64_AT_S1E2W,
	ARM64_AT_S1E3W,
	ARM64_AT_S1E0R,
	ARM64_AT_S1E0W,
	ARM64_AT_S12E1R,
	ARM64_AT_S12E1W,
	ARM64_AT_S12E0R,
	ARM64_AT_S12E0W,
	ARM64_AT_S1E1RP,
	ARM64_AT_S1E1WP,

	/// DC operations
	ARM64_DC_ZVA,
	ARM64_DC_IVAC,
	ARM64_DC_ISW,
	ARM64_DC_CVAC,
	ARM64_DC_CSW,
	ARM64_DC_CVAU,
	ARM64_DC_CIVAC,
	ARM64_DC_CISW,
	ARM64_DC_CVAP,

	/// IC operations
	ARM64_IC_IALLUIS,
	ARM64_IC_IALLU,
	ARM64_IC_IVAU,
} arm64_sys_op;

/// Prefetch operations (PRFM)
typedef enum arm64_prefetch_op {
	ARM64_PRFM_INVALID = 0,
	ARM64_PRFM_PLDL1KEEP = 0x00 + 1,
	ARM64_PRFM_PLDL1STRM = 0x01 + 1,
	ARM64_PRFM_PLDL2KEEP = 0x02 + 1,
	ARM64_PRFM_PLDL2STRM = 0x03 + 1,
	ARM64_PRFM_PLDL3KEEP = 0x04 + 1,
	ARM64_PRFM_PLDL3STRM = 0x05 + 1,
	ARM64_PRFM_PLIL1KEEP = 0x08 + 1,
	ARM64_PRFM_PLIL1STRM = 0x09 + 1,
	ARM64_PRFM_PLIL2KEEP = 0x0a + 1,
	ARM64_PRFM_PLIL2STRM = 0x0b + 1,
	ARM64_PRFM_PLIL3KEEP = 0x0c + 1,
	ARM64_PRFM_PLIL3STRM = 0x0d + 1,
	ARM64_PRFM_PSTL1KEEP = 0x10 + 1,
	ARM64_PRFM_PSTL1STRM = 0x11 + 1,
	ARM64_PRFM_PSTL2KEEP = 0x12 + 1,
	ARM64_PRFM_PSTL2STRM = 0x13 + 1,
	ARM64_PRFM_PSTL3KEEP = 0x14 + 1,
	ARM64_PRFM_PSTL3STRM = 0x15 + 1,
} arm64_prefetch_op;

/// ARM64 registers
typedef enum arm64_reg {
	ARM64_REG_INVALID = 0,

	ARM64_REG_FFR = 1,
	ARM64_REG_FP = 2,
	ARM64_REG_LR = 3,
	ARM64_REG_NZCV = 4,
	ARM64_REG_SP = 5,
	ARM64_REG_WSP = 6,
	ARM64_REG_WZR = 7,
	ARM64_REG_XZR = 8,
	ARM64_REG_B0 = 9,
	ARM64_REG_B1 = 10,
	ARM64_REG_B2 = 11,
	ARM64_REG_B3 = 12,
	ARM64_REG_B4 = 13,
	ARM64_REG_B5 = 14,
	ARM64_REG_B6 = 15,
	ARM64_REG_B7 = 16,
	ARM64_REG_B8 = 17,
	ARM64_REG_B9 = 18,
	ARM64_REG_B10 = 19,
	ARM64_REG_B11 = 20,
	ARM64_REG_B12 = 21,
	ARM64_REG_B13 = 22,
	ARM64_REG_B14 = 23,
	ARM64_REG_B15 = 24,
	ARM64_REG_B16 = 25,
	ARM64_REG_B17 = 26,
	ARM64_REG_B18 = 27,
	ARM64_REG_B19 = 28,
	ARM64_REG_B20 = 29,
	ARM64_REG_B21 = 30,
	ARM64_REG_B22 = 31,
	ARM64_REG_B23 = 32,
	ARM64_REG_B24 = 33,
	ARM64_REG_B25 = 34,
	ARM64_REG_B26 = 35,
	ARM64_REG_B27 = 36,
	ARM64_REG_B28 = 37,
	ARM64_REG_B29 = 38,
	ARM64_REG_B30 = 39,
	ARM64_REG_B31 = 40,
	ARM64_REG_D0 = 41,
	ARM64_REG_D1 = 42,
	ARM64_REG_D2 = 43,
	ARM64_REG_D3 = 44,
	ARM64_REG_D4 = 45,
	ARM64_REG_D5 = 46,
	ARM64_REG_D6 = 47,
	ARM64_REG_D7 = 48,
	ARM64_REG_D8 = 49,
	ARM64_REG_D9 = 50,
	ARM64_REG_D10 = 51,
	ARM64_REG_D11 = 52,
	ARM64_REG_D12 = 53,
	ARM64_REG_D13 = 54,
	ARM64_REG_D14 = 55,
	ARM64_REG_D15 = 56,
	ARM64_REG_D16 = 57,
	ARM64_REG_D17 = 58,
	ARM64_REG_D18 = 59,
	ARM64_REG_D19 = 60,
	ARM64_REG_D20 = 61,
	ARM64_REG_D21 = 62,
	ARM64_REG_D22 = 63,
	ARM64_REG_D23 = 64,
	ARM64_REG_D24 = 65,
	ARM64_REG_D25 = 66,
	ARM64_REG_D26 = 67,
	ARM64_REG_D27 = 68,
	ARM64_REG_D28 = 69,
	ARM64_REG_D29 = 70,
	ARM64_REG_D30 = 71,
	ARM64_REG_D31 = 72,
	ARM64_REG_H0 = 73,
	ARM64_REG_H1 = 74,
	ARM64_REG_H2 = 75,
	ARM64_REG_H3 = 76,
	ARM64_REG_H4 = 77,
	ARM64_REG_H5 = 78,
	ARM64_REG_H6 = 79,
	ARM64_REG_H7 = 80,
	ARM64_REG_H8 = 81,
	ARM64_REG_H9 = 82,
	ARM64_REG_H10 = 83,
	ARM64_REG_H11 = 84,
	ARM64_REG_H12 = 85,
	ARM64_REG_H13 = 86,
	ARM64_REG_H14 = 87,
	ARM64_REG_H15 = 88,
	ARM64_REG_H16 = 89,
	ARM64_REG_H17 = 90,
	ARM64_REG_H18 = 91,
	ARM64_REG_H19 = 92,
	ARM64_REG_H20 = 93,
	ARM64_REG_H21 = 94,
	ARM64_REG_H22 = 95,
	ARM64_REG_H23 = 96,
	ARM64_REG_H24 = 97,
	ARM64_REG_H25 = 98,
	ARM64_REG_H26 = 99,
	ARM64_REG_H27 = 100,
	ARM64_REG_H28 = 101,
	ARM64_REG_H29 = 102,
	ARM64_REG_H30 = 103,
	ARM64_REG_H31 = 104,
	ARM64_REG_P0 = 105,
	ARM64_REG_P1 = 106,
	ARM64_REG_P2 = 107,
	ARM64_REG_P3 = 108,
	ARM64_REG_P4 = 109,
	ARM64_REG_P5 = 110,
	ARM64_REG_P6 = 111,
	ARM64_REG_P7 = 112,
	ARM64_REG_P8 = 113,
	ARM64_REG_P9 = 114,
	ARM64_REG_P10 = 115,
	ARM64_REG_P11 = 116,
	ARM64_REG_P12 = 117,
	ARM64_REG_P13 = 118,
	ARM64_REG_P14 = 119,
	ARM64_REG_P15 = 120,
	ARM64_REG_Q0 = 121,
	ARM64_REG_Q1 = 122,
	ARM64_REG_Q2 = 123,
	ARM64_REG_Q3 = 124,
	ARM64_REG_Q4 = 125,
	ARM64_REG_Q5 = 126,
	ARM64_REG_Q6 = 127,
	ARM64_REG_Q7 = 128,
	ARM64_REG_Q8 = 129,
	ARM64_REG_Q9 = 130,
	ARM64_REG_Q10 = 131,
	ARM64_REG_Q11 = 132,
	ARM64_REG_Q12 = 133,
	ARM64_REG_Q13 = 134,
	ARM64_REG_Q14 = 135,
	ARM64_REG_Q15 = 136,
	ARM64_REG_Q16 = 137,
	ARM64_REG_Q17 = 138,
	ARM64_REG_Q18 = 139,
	ARM64_REG_Q19 = 140,
	ARM64_REG_Q20 = 141,
	ARM64_REG_Q21 = 142,
	ARM64_REG_Q22 = 143,
	ARM64_REG_Q23 = 144,
	ARM64_REG_Q24 = 145,
	ARM64_REG_Q25 = 146,
	ARM64_REG_Q26 = 147,
	ARM64_REG_Q27 = 148,
	ARM64_REG_Q28 = 149,
	ARM64_REG_Q29 = 150,
	ARM64_REG_Q30 = 151,
	ARM64_REG_Q31 = 152,
	ARM64_REG_S0 = 153,
	ARM64_REG_S1 = 154,
	ARM64_REG_S2 = 155,
	ARM64_REG_S3 = 156,
	ARM64_REG_S4 = 157,
	ARM64_REG_S5 = 158,
	ARM64_REG_S6 = 159,
	ARM64_REG_S7 = 160,
	ARM64_REG_S8 = 161,
	ARM64_REG_S9 = 162,
	ARM64_REG_S10 = 163,
	ARM64_REG_S11 = 164,
	ARM64_REG_S12 = 165,
	ARM64_REG_S13 = 166,
	ARM64_REG_S14 = 167,
	ARM64_REG_S15 = 168,
	ARM64_REG_S16 = 169,
	ARM64_REG_S17 = 170,
	ARM64_REG_S18 = 171,
	ARM64_REG_S19 = 172,
	ARM64_REG_S20 = 173,
	ARM64_REG_S21 = 174,
	ARM64_REG_S22 = 175,
	ARM64_REG_S23 = 176,
	ARM64_REG_S24 = 177,
	ARM64_REG_S25 = 178,
	ARM64_REG_S26 = 179,
	ARM64_REG_S27 = 180,
	ARM64_REG_S28 = 181,
	ARM64_REG_S29 = 182,
	ARM64_REG_S30 = 183,
	ARM64_REG_S31 = 184,
	ARM64_REG_W0 = 185,
	ARM64_REG_W1 = 186,
	ARM64_REG_W2 = 187,
	ARM64_REG_W3 = 188,
	ARM64_REG_W4 = 189,
	ARM64_REG_W5 = 190,
	ARM64_REG_W6 = 191,
	ARM64_REG_W7 = 192,
	ARM64_REG_W8 = 193,
	ARM64_REG_W9 = 194,
	ARM64_REG_W10 = 195,
	ARM64_REG_W11 = 196,
	ARM64_REG_W12 = 197,
	ARM64_REG_W13 = 198,
	ARM64_REG_W14 = 199,
	ARM64_REG_W15 = 200,
	ARM64_REG_W16 = 201,
	ARM64_REG_W17 = 202,
	ARM64_REG_W18 = 203,
	ARM64_REG_W19 = 204,
	ARM64_REG_W20 = 205,
	ARM64_REG_W21 = 206,
	ARM64_REG_W22 = 207,
	ARM64_REG_W23 = 208,
	ARM64_REG_W24 = 209,
	ARM64_REG_W25 = 210,
	ARM64_REG_W26 = 211,
	ARM64_REG_W27 = 212,
	ARM64_REG_W28 = 213,
	ARM64_REG_W29 = 214,
	ARM64_REG_W30 = 215,
	ARM64_REG_X0 = 216,
	ARM64_REG_X1 = 217,
	ARM64_REG_X2 = 218,
	ARM64_REG_X3 = 219,
	ARM64_REG_X4 = 220,
	ARM64_REG_X5 = 221,
	ARM64_REG_X6 = 222,
	ARM64_REG_X7 = 223,
	ARM64_REG_X8 = 224,
	ARM64_REG_X9 = 225,
	ARM64_REG_X10 = 226,
	ARM64_REG_X11 = 227,
	ARM64_REG_X12 = 228,
	ARM64_REG_X13 = 229,
	ARM64_REG_X14 = 230,
	ARM64_REG_X15 = 231,
	ARM64_REG_X16 = 232,
	ARM64_REG_X17 = 233,
	ARM64_REG_X18 = 234,
	ARM64_REG_X19 = 235,
	ARM64_REG_X20 = 236,
	ARM64_REG_X21 = 237,
	ARM64_REG_X22 = 238,
	ARM64_REG_X23 = 239,
	ARM64_REG_X24 = 240,
	ARM64_REG_X25 = 241,
	ARM64_REG_X26 = 242,
	ARM64_REG_X27 = 243,
	ARM64_REG_X28 = 244,
	ARM64_REG_Z0 = 245,
	ARM64_REG_Z1 = 246,
	ARM64_REG_Z2 = 247,
	ARM64_REG_Z3 = 248,
	ARM64_REG_Z4 = 249,
	ARM64_REG_Z5 = 250,
	ARM64_REG_Z6 = 251,
	ARM64_REG_Z7 = 252,
	ARM64_REG_Z8 = 253,
	ARM64_REG_Z9 = 254,
	ARM64_REG_Z10 = 255,
	ARM64_REG_Z11 = 256,
	ARM64_REG_Z12 = 257,
	ARM64_REG_Z13 = 258,
	ARM64_REG_Z14 = 259,
	ARM64_REG_Z15 = 260,
	ARM64_REG_Z16 = 261,
	ARM64_REG_Z17 = 262,
	ARM64_REG_Z18 = 263,
	ARM64_REG_Z19 = 264,
	ARM64_REG_Z20 = 265,
	ARM64_REG_Z21 = 266,
	ARM64_REG_Z22 = 267,
	ARM64_REG_Z23 = 268,
	ARM64_REG_Z24 = 269,
	ARM64_REG_Z25 = 270,
	ARM64_REG_Z26 = 271,
	ARM64_REG_Z27 = 272,
	ARM64_REG_Z28 = 273,
	ARM64_REG_Z29 = 274,
	ARM64_REG_Z30 = 275,
	ARM64_REG_Z31 = 276,

	ARM64_REG_V0,
	ARM64_REG_V1,
	ARM64_REG_V2,
	ARM64_REG_V3,
	ARM64_REG_V4,
	ARM64_REG_V5,
	ARM64_REG_V6,
	ARM64_REG_V7,
	ARM64_REG_V8,
	ARM64_REG_V9,
	ARM64_REG_V10,
	ARM64_REG_V11,
	ARM64_REG_V12,
	ARM64_REG_V13,
	ARM64_REG_V14,
	ARM64_REG_V15,
	ARM64_REG_V16,
	ARM64_REG_V17,
	ARM64_REG_V18,
	ARM64_REG_V19,
	ARM64_REG_V20,
	ARM64_REG_V21,
	ARM64_REG_V22,
	ARM64_REG_V23,
	ARM64_REG_V24,
	ARM64_REG_V25,
	ARM64_REG_V26,
	ARM64_REG_V27,
	ARM64_REG_V28,
	ARM64_REG_V29,
	ARM64_REG_V30,
	ARM64_REG_V31,

	ARM64_REG_ENDING,		// <-- mark the end of the list of registers

	// alias registers
	ARM64_REG_IP0 = ARM64_REG_X16,
	ARM64_REG_IP1 = ARM64_REG_X17,
	ARM64_REG_X29 = ARM64_REG_FP,
	ARM64_REG_X30 = ARM64_REG_LR,
} arm64_reg;

/// Instruction's operand referring to memory
/// This is associated with ARM64_OP_MEM operand type above
typedef struct arm64_op_mem {
	arm64_reg base;	///< base register
	arm64_reg index;	///< index register
	int32_t disp;	///< displacement/offset value
} arm64_op_mem;

/// Instruction operand
typedef struct cs_arm64_op {
	int vector_index;	///< Vector Index for some vector operands (or -1 if irrelevant)
	arm64_vas vas;		///< Vector Arrangement Specifier
	struct {
		arm64_shifter type;	///< shifter type of this operand
		unsigned int value;	///< shifter value of this operand
	} shift;
	arm64_extender ext;		///< extender type of this operand
	arm64_op_type type;	///< operand type
	union {
		arm64_reg reg;	///< register value for REG operand
		int64_t imm;		///< immediate value, or index for C-IMM or IMM operand
		double fp;			///< floating point value for FP operand
		arm64_op_mem mem;		///< base/index/scale/disp value for MEM operand
		arm64_pstate pstate;		///< PState field of MSR instruction.
		arm64_sys_op sys;  ///< IC/DC/AT/TLBI operation (see arm64_ic_op, arm64_dc_op, arm64_at_op, arm64_tlbi_op)
		arm64_prefetch_op prefetch;  ///< PRFM operation.
		arm64_barrier_op barrier;  ///< Memory barrier operation (ISB/DMB/DSB instructions).
	};

	/// How is this operand accessed? (READ, WRITE or READ|WRITE)
	/// This field is combined of cs_ac_type.
	/// NOTE: this field is irrelevant if engine is compiled in DIET mode.
	uint8_t access;
} cs_arm64_op;

/// Instruction structure
typedef struct cs_arm64 {
	arm64_cc cc;	///< conditional code for this insn
	bool update_flags;	///< does this insn update flags?
	bool writeback;	///< does this insn request writeback? 'True' means 'yes'

	/// Number of operands of this instruction,
	/// or 0 when instruction has no operand.
	uint8_t op_count;

	cs_arm64_op operands[8]; ///< operands for this instruction.
} cs_arm64;

/// ARM64 instruction
typedef enum arm64_insn {
	ARM64_INS_INVALID = 0,

	ARM64_INS_ABS,
	ARM64_INS_ADC,
	ARM64_INS_ADCS,
	ARM64_INS_ADD,
	ARM64_INS_ADDHN,
	ARM64_INS_ADDHN2,
	ARM64_INS_ADDP,
	ARM64_INS_ADDPL,
	ARM64_INS_ADDS,
	ARM64_INS_ADDV,
	ARM64_INS_ADDVL,
	ARM64_INS_ADR,
	ARM64_INS_ADRP,
	ARM64_INS_AESD,
	ARM64_INS_AESE,
	ARM64_INS_AESIMC,
	ARM64_INS_AESMC,
	ARM64_INS_AND,
	ARM64_INS_ANDS,
	ARM64_INS_ANDV,
	ARM64_INS_ASR,
	ARM64_INS_ASRD,
	ARM64_INS_ASRR,
	ARM64_INS_ASRV,
	ARM64_INS_AUTDA,
	ARM64_INS_AUTDB,
	ARM64_INS_AUTDZA,
	ARM64_INS_AUTDZB,
	ARM64_INS_AUTIA,
	ARM64_INS_AUTIA1716,
	ARM64_INS_AUTIASP,
	ARM64_INS_AUTIAZ,
	ARM64_INS_AUTIB,
	ARM64_INS_AUTIB1716,
	ARM64_INS_AUTIBSP,
	ARM64_INS_AUTIBZ,
	ARM64_INS_AUTIZA,
	ARM64_INS_AUTIZB,
	ARM64_INS_B,
	ARM64_INS_BCAX,
	ARM64_INS_BFM,
	ARM64_INS_BIC,
	ARM64_INS_BICS,
	ARM64_INS_BIF,
	ARM64_INS_BIT,
	ARM64_INS_BL,
	ARM64_INS_BLR,
	ARM64_INS_BLRAA,
	ARM64_INS_BLRAAZ,
	ARM64_INS_BLRAB,
	ARM64_INS_BLRABZ,
	ARM64_INS_BR,
	ARM64_INS_BRAA,
	ARM64_INS_BRAAZ,
	ARM64_INS_BRAB,
	ARM64_INS_BRABZ,
	ARM64_INS_BRK,
	ARM64_INS_BRKA,
	ARM64_INS_BRKAS,
	ARM64_INS_BRKB,
	ARM64_INS_BRKBS,
	ARM64_INS_BRKN,
	ARM64_INS_BRKNS,
	ARM64_INS_BRKPA,
	ARM64_INS_BRKPAS,
	ARM64_INS_BRKPB,
	ARM64_INS_BRKPBS,
	ARM64_INS_BSL,
	ARM64_INS_CAS,
	ARM64_INS_CASA,
	ARM64_INS_CASAB,
	ARM64_INS_CASAH,
	ARM64_INS_CASAL,
	ARM64_INS_CASALB,
	ARM64_INS_CASALH,
	ARM64_INS_CASB,
	ARM64_INS_CASH,
	ARM64_INS_CASL,
	ARM64_INS_CASLB,
	ARM64_INS_CASLH,
	ARM64_INS_CASP,
	ARM64_INS_CASPA,
	ARM64_INS_CASPAL,
	ARM64_INS_CASPL,
	ARM64_INS_CBNZ,
	ARM64_INS_CBZ,
	ARM64_INS_CCMN,
	ARM64_INS_CCMP,
	ARM64_INS_CFINV,
	ARM64_INS_CINC,
	ARM64_INS_CINV,
	ARM64_INS_CLASTA,
	ARM64_INS_CLASTB,
	ARM64_INS_CLREX,
	ARM64_INS_CLS,
	ARM64_INS_CLZ,
	ARM64_INS_CMEQ,
	ARM64_INS_CMGE,
	ARM64_INS_CMGT,
	ARM64_INS_CMHI,
	ARM64_INS_CMHS,
	ARM64_INS_CMLE,
	ARM64_INS_CMLO,
	ARM64_INS_CMLS,
	ARM64_INS_CMLT,
	ARM64_INS_CMN,
	ARM64_INS_CMP,
	ARM64_INS_CMPEQ,
	ARM64_INS_CMPGE,
	ARM64_INS_CMPGT,
	ARM64_INS_CMPHI,
	ARM64_INS_CMPHS,
	ARM64_INS_CMPLE,
	ARM64_INS_CMPLO,
	ARM64_INS_CMPLS,
	ARM64_INS_CMPLT,
	ARM64_INS_CMPNE,
	ARM64_INS_CMTST,
	ARM64_INS_CNEG,
	ARM64_INS_CNOT,
	ARM64_INS_CNT,
	ARM64_INS_CNTB,
	ARM64_INS_CNTD,
	ARM64_INS_CNTH,
	ARM64_INS_CNTP,
	ARM64_INS_CNTW,
	ARM64_INS_COMPACT,
	ARM64_INS_CPY,
	ARM64_INS_CRC32B,
	ARM64_INS_CRC32CB,
	ARM64_INS_CRC32CH,
	ARM64_INS_CRC32CW,
	ARM64_INS_CRC32CX,
	ARM64_INS_CRC32H,
	ARM64_INS_CRC32W,
	ARM64_INS_CRC32X,
	ARM64_INS_CSDB,
	ARM64_INS_CSEL,
	ARM64_INS_CSET,
	ARM64_INS_CSETM,
	ARM64_INS_CSINC,
	ARM64_INS_CSINV,
	ARM64_INS_CSNEG,
	ARM64_INS_CTERMEQ,
	ARM64_INS_CTERMNE,
	ARM64_INS_DCPS1,
	ARM64_INS_DCPS2,
	ARM64_INS_DCPS3,
	ARM64_INS_DECB,
	ARM64_INS_DECD,
	ARM64_INS_DECH,
	ARM64_INS_DECP,
	ARM64_INS_DECW,
	ARM64_INS_DMB,
	ARM64_INS_DRPS,
	ARM64_INS_DSB,
	ARM64_INS_DUP,
	ARM64_INS_DUPM,
	ARM64_INS_EON,
	ARM64_INS_EOR,
	ARM64_INS_EOR3,
	ARM64_INS_EORS,
	ARM64_INS_EORV,
	ARM64_INS_ERET,
	ARM64_INS_ERETAA,
	ARM64_INS_ERETAB,
	ARM64_INS_ESB,
	ARM64_INS_EXT,
	ARM64_INS_EXTR,
	ARM64_INS_FABD,
	ARM64_INS_FABS,
	ARM64_INS_FACGE,
	ARM64_INS_FACGT,
	ARM64_INS_FACLE,
	ARM64_INS_FACLT,
	ARM64_INS_FADD,
	ARM64_INS_FADDA,
	ARM64_INS_FADDP,
	ARM64_INS_FADDV,
	ARM64_INS_FCADD,
	ARM64_INS_FCCMP,
	ARM64_INS_FCCMPE,
	ARM64_INS_FCMEQ,
	ARM64_INS_FCMGE,
	ARM64_INS_FCMGT,
	ARM64_INS_FCMLA,
	ARM64_INS_FCMLE,
	ARM64_INS_FCMLT,
	ARM64_INS_FCMNE,
	ARM64_INS_FCMP,
	ARM64_INS_FCMPE,
	ARM64_INS_FCMUO,
	ARM64_INS_FCPY,
	ARM64_INS_FCSEL,
	ARM64_INS_FCVT,
	ARM64_INS_FCVTAS,
	ARM64_INS_FCVTAU,
	ARM64_INS_FCVTL,
	ARM64_INS_FCVTL2,
	ARM64_INS_FCVTMS,
	ARM64_INS_FCVTMU,
	ARM64_INS_FCVTN,
	ARM64_INS_FCVTN2,
	ARM64_INS_FCVTNS,
	ARM64_INS_FCVTNU,
	ARM64_INS_FCVTPS,
	ARM64_INS_FCVTPU,
	ARM64_INS_FCVTXN,
	ARM64_INS_FCVTXN2,
	ARM64_INS_FCVTZS,
	ARM64_INS_FCVTZU,
	ARM64_INS_FDIV,
	ARM64_INS_FDIVR,
	ARM64_INS_FDUP,
	ARM64_INS_FEXPA,
	ARM64_INS_FJCVTZS,
	ARM64_INS_FMAD,
	ARM64_INS_FMADD,
	ARM64_INS_FMAX,
	ARM64_INS_FMAXNM,
	ARM64_INS_FMAXNMP,
	ARM64_INS_FMAXNMV,
	ARM64_INS_FMAXP,
	ARM64_INS_FMAXV,
	ARM64_INS_FMIN,
	ARM64_INS_FMINNM,
	ARM64_INS_FMINNMP,
	ARM64_INS_FMINNMV,
	ARM64_INS_FMINP,
	ARM64_INS_FMINV,
	ARM64_INS_FMLA,
	ARM64_INS_FMLS,
	ARM64_INS_FMOV,
	ARM64_INS_FMSB,
	ARM64_INS_FMSUB,
	ARM64_INS_FMUL,
	ARM64_INS_FMULX,
	ARM64_INS_FNEG,
	ARM64_INS_FNMAD,
	ARM64_INS_FNMADD,
	ARM64_INS_FNMLA,
	ARM64_INS_FNMLS,
	ARM64_INS_FNMSB,
	ARM64_INS_FNMSUB,
	ARM64_INS_FNMUL,
	ARM64_INS_FRECPE,
	ARM64_INS_FRECPS,
	ARM64_INS_FRECPX,
	ARM64_INS_FRINTA,
	ARM64_INS_FRINTI,
	ARM64_INS_FRINTM,
	ARM64_INS_FRINTN,
	ARM64_INS_FRINTP,
	ARM64_INS_FRINTX,
	ARM64_INS_FRINTZ,
	ARM64_INS_FRSQRTE,
	ARM64_INS_FRSQRTS,
	ARM64_INS_FSCALE,
	ARM64_INS_FSQRT,
	ARM64_INS_FSUB,
	ARM64_INS_FSUBR,
	ARM64_INS_FTMAD,
	ARM64_INS_FTSMUL,
	ARM64_INS_FTSSEL,
	ARM64_INS_HINT,
	ARM64_INS_HLT,
	ARM64_INS_HVC,
	ARM64_INS_INCB,
	ARM64_INS_INCD,
	ARM64_INS_INCH,
	ARM64_INS_INCP,
	ARM64_INS_INCW,
	ARM64_INS_INDEX,
	ARM64_INS_INS,
	ARM64_INS_INSR,
	ARM64_INS_ISB,
	ARM64_INS_LASTA,
	ARM64_INS_LASTB,
	ARM64_INS_LD1,
	ARM64_INS_LD1B,
	ARM64_INS_LD1D,
	ARM64_INS_LD1H,
	ARM64_INS_LD1R,
	ARM64_INS_LD1RB,
	ARM64_INS_LD1RD,
	ARM64_INS_LD1RH,
	ARM64_INS_LD1RQB,
	ARM64_INS_LD1RQD,
	ARM64_INS_LD1RQH,
	ARM64_INS_LD1RQW,
	ARM64_INS_LD1RSB,
	ARM64_INS_LD1RSH,
	ARM64_INS_LD1RSW,
	ARM64_INS_LD1RW,
	ARM64_INS_LD1SB,
	ARM64_INS_LD1SH,
	ARM64_INS_LD1SW,
	ARM64_INS_LD1W,
	ARM64_INS_LD2,
	ARM64_INS_LD2B,
	ARM64_INS_LD2D,
	ARM64_INS_LD2H,
	ARM64_INS_LD2R,
	ARM64_INS_LD2W,
	ARM64_INS_LD3,
	ARM64_INS_LD3B,
	ARM64_INS_LD3D,
	ARM64_INS_LD3H,
	ARM64_INS_LD3R,
	ARM64_INS_LD3W,
	ARM64_INS_LD4,
	ARM64_INS_LD4B,
	ARM64_INS_LD4D,
	ARM64_INS_LD4H,
	ARM64_INS_LD4R,
	ARM64_INS_LD4W,
	ARM64_INS_LDADD,
	ARM64_INS_LDADDA,
	ARM64_INS_LDADDAB,
	ARM64_INS_LDADDAH,
	ARM64_INS_LDADDAL,
	ARM64_INS_LDADDALB,
	ARM64_INS_LDADDALH,
	ARM64_INS_LDADDB,
	ARM64_INS_LDADDH,
	ARM64_INS_LDADDL,
	ARM64_INS_LDADDLB,
	ARM64_INS_LDADDLH,
	ARM64_INS_LDAPR,
	ARM64_INS_LDAPRB,
	ARM64_INS_LDAPRH,
	ARM64_INS_LDAPUR,
	ARM64_INS_LDAPURB,
	ARM64_INS_LDAPURH,
	ARM64_INS_LDAPURSB,
	ARM64_INS_LDAPURSH,
	ARM64_INS_LDAPURSW,
	ARM64_INS_LDAR,
	ARM64_INS_LDARB,
	ARM64_INS_LDARH,
	ARM64_INS_LDAXP,
	ARM64_INS_LDAXR,
	ARM64_INS_LDAXRB,
	ARM64_INS_LDAXRH,
	ARM64_INS_LDCLR,
	ARM64_INS_LDCLRA,
	ARM64_INS_LDCLRAB,
	ARM64_INS_LDCLRAH,
	ARM64_INS_LDCLRAL,
	ARM64_INS_LDCLRALB,
	ARM64_INS_LDCLRALH,
	ARM64_INS_LDCLRB,
	ARM64_INS_LDCLRH,
	ARM64_INS_LDCLRL,
	ARM64_INS_LDCLRLB,
	ARM64_INS_LDCLRLH,
	ARM64_INS_LDEOR,
	ARM64_INS_LDEORA,
	ARM64_INS_LDEORAB,
	ARM64_INS_LDEORAH,
	ARM64_INS_LDEORAL,
	ARM64_INS_LDEORALB,
	ARM64_INS_LDEORALH,
	ARM64_INS_LDEORB,
	ARM64_INS_LDEORH,
	ARM64_INS_LDEORL,
	ARM64_INS_LDEORLB,
	ARM64_INS_LDEORLH,
	ARM64_INS_LDFF1B,
	ARM64_INS_LDFF1D,
	ARM64_INS_LDFF1H,
	ARM64_INS_LDFF1SB,
	ARM64_INS_LDFF1SH,
	ARM64_INS_LDFF1SW,
	ARM64_INS_LDFF1W,
	ARM64_INS_LDLAR,
	ARM64_INS_LDLARB,
	ARM64_INS_LDLARH,
	ARM64_INS_LDNF1B,
	ARM64_INS_LDNF1D,
	ARM64_INS_LDNF1H,
	ARM64_INS_LDNF1SB,
	ARM64_INS_LDNF1SH,
	ARM64_INS_LDNF1SW,
	ARM64_INS_LDNF1W,
	ARM64_INS_LDNP,
	ARM64_INS_LDNT1B,
	ARM64_INS_LDNT1D,
	ARM64_INS_LDNT1H,
	ARM64_INS_LDNT1W,
	ARM64_INS_LDP,
	ARM64_INS_LDPSW,
	ARM64_INS_LDR,
	ARM64_INS_LDRAA,
	ARM64_INS_LDRAB,
	ARM64_INS_LDRB,
	ARM64_INS_LDRH,
	ARM64_INS_LDRSB,
	ARM64_INS_LDRSH,
	ARM64_INS_LDRSW,
	ARM64_INS_LDSET,
	ARM64_INS_LDSETA,
	ARM64_INS_LDSETAB,
	ARM64_INS_LDSETAH,
	ARM64_INS_LDSETAL,
	ARM64_INS_LDSETALB,
	ARM64_INS_LDSETALH,
	ARM64_INS_LDSETB,
	ARM64_INS_LDSETH,
	ARM64_INS_LDSETL,
	ARM64_INS_LDSETLB,
	ARM64_INS_LDSETLH,
	ARM64_INS_LDSMAX,
	ARM64_INS_LDSMAXA,
	ARM64_INS_LDSMAXAB,
	ARM64_INS_LDSMAXAH,
	ARM64_INS_LDSMAXAL,
	ARM64_INS_LDSMAXALB,
	ARM64_INS_LDSMAXALH,
	ARM64_INS_LDSMAXB,
	ARM64_INS_LDSMAXH,
	ARM64_INS_LDSMAXL,
	ARM64_INS_LDSMAXLB,
	ARM64_INS_LDSMAXLH,
	ARM64_INS_LDSMIN,
	ARM64_INS_LDSMINA,
	ARM64_INS_LDSMINAB,
	ARM64_INS_LDSMINAH,
	ARM64_INS_LDSMINAL,
	ARM64_INS_LDSMINALB,
	ARM64_INS_LDSMINALH,
	ARM64_INS_LDSMINB,
	ARM64_INS_LDSMINH,
	ARM64_INS_LDSMINL,
	ARM64_INS_LDSMINLB,
	ARM64_INS_LDSMINLH,
	ARM64_INS_LDTR,
	ARM64_INS_LDTRB,
	ARM64_INS_LDTRH,
	ARM64_INS_LDTRSB,
	ARM64_INS_LDTRSH,
	ARM64_INS_LDTRSW,
	ARM64_INS_LDUMAX,
	ARM64_INS_LDUMAXA,
	ARM64_INS_LDUMAXAB,
	ARM64_INS_LDUMAXAH,
	ARM64_INS_LDUMAXAL,
	ARM64_INS_LDUMAXALB,
	ARM64_INS_LDUMAXALH,
	ARM64_INS_LDUMAXB,
	ARM64_INS_LDUMAXH,
	ARM64_INS_LDUMAXL,
	ARM64_INS_LDUMAXLB,
	ARM64_INS_LDUMAXLH,
	ARM64_INS_LDUMIN,
	ARM64_INS_LDUMINA,
	ARM64_INS_LDUMINAB,
	ARM64_INS_LDUMINAH,
	ARM64_INS_LDUMINAL,
	ARM64_INS_LDUMINALB,
	ARM64_INS_LDUMINALH,
	ARM64_INS_LDUMINB,
	ARM64_INS_LDUMINH,
	ARM64_INS_LDUMINL,
	ARM64_INS_LDUMINLB,
	ARM64_INS_LDUMINLH,
	ARM64_INS_LDUR,
	ARM64_INS_LDURB,
	ARM64_INS_LDURH,
	ARM64_INS_LDURSB,
	ARM64_INS_LDURSH,
	ARM64_INS_LDURSW,
	ARM64_INS_LDXP,
	ARM64_INS_LDXR,
	ARM64_INS_LDXRB,
	ARM64_INS_LDXRH,
	ARM64_INS_LSL,
	ARM64_INS_LSLR,
	ARM64_INS_LSLV,
	ARM64_INS_LSR,
	ARM64_INS_LSRR,
	ARM64_INS_LSRV,
	ARM64_INS_MAD,
	ARM64_INS_MADD,
	ARM64_INS_MLA,
	ARM64_INS_MLS,
	ARM64_INS_MNEG,
	ARM64_INS_MOV,
	ARM64_INS_MOVI,
	ARM64_INS_MOVK,
	ARM64_INS_MOVN,
	ARM64_INS_MOVPRFX,
	ARM64_INS_MOVS,
	ARM64_INS_MOVZ,
	ARM64_INS_MRS,
	ARM64_INS_MSB,
	ARM64_INS_MSR,
	ARM64_INS_MSUB,
	ARM64_INS_MUL,
	ARM64_INS_MVN,
	ARM64_INS_MVNI,
	ARM64_INS_NAND,
	ARM64_INS_NANDS,
	ARM64_INS_NEG,
	ARM64_INS_NEGS,
	ARM64_INS_NGC,
	ARM64_INS_NGCS,
	ARM64_INS_NOP,
	ARM64_INS_NOR,
	ARM64_INS_NORS,
	ARM64_INS_NOT,
	ARM64_INS_NOTS,
	ARM64_INS_ORN,
	ARM64_INS_ORNS,
	ARM64_INS_ORR,
	ARM64_INS_ORRS,
	ARM64_INS_ORV,
	ARM64_INS_PACDA,
	ARM64_INS_PACDB,
	ARM64_INS_PACDZA,
	ARM64_INS_PACDZB,
	ARM64_INS_PACGA,
	ARM64_INS_PACIA,
	ARM64_INS_PACIA1716,
	ARM64_INS_PACIASP,
	ARM64_INS_PACIAZ,
	ARM64_INS_PACIB,
	ARM64_INS_PACIB1716,
	ARM64_INS_PACIBSP,
	ARM64_INS_PACIBZ,
	ARM64_INS_PACIZA,
	ARM64_INS_PACIZB,
	ARM64_INS_PFALSE,
	ARM64_INS_PFIRST,
	ARM64_INS_PMUL,
	ARM64_INS_PMULL,
	ARM64_INS_PMULL2,
	ARM64_INS_PNEXT,
	ARM64_INS_PRFB,
	ARM64_INS_PRFD,
	ARM64_INS_PRFH,
	ARM64_INS_PRFM,
	ARM64_INS_PRFUM,
	ARM64_INS_PRFW,
	ARM64_INS_PSB,
	ARM64_INS_PTEST,
	ARM64_INS_PTRUE,
	ARM64_INS_PTRUES,
	ARM64_INS_PUNPKHI,
	ARM64_INS_PUNPKLO,
	ARM64_INS_RADDHN,
	ARM64_INS_RADDHN2,
	ARM64_INS_RAX1,
	ARM64_INS_RBIT,
	ARM64_INS_RDFFR,
	ARM64_INS_RDFFRS,
	ARM64_INS_RDVL,
	ARM64_INS_RET,
	ARM64_INS_RETAA,
	ARM64_INS_RETAB,
	ARM64_INS_REV,
	ARM64_INS_REV16,
	ARM64_INS_REV32,
	ARM64_INS_REV64,
	ARM64_INS_REVB,
	ARM64_INS_REVH,
	ARM64_INS_REVW,
	ARM64_INS_RMIF,
	ARM64_INS_ROR,
	ARM64_INS_RORV,
	ARM64_INS_RSHRN,
	ARM64_INS_RSHRN2,
	ARM64_INS_RSUBHN,
	ARM64_INS_RSUBHN2,
	ARM64_INS_SABA,
	ARM64_INS_SABAL,
	ARM64_INS_SABAL2,
	ARM64_INS_SABD,
	ARM64_INS_SABDL,
	ARM64_INS_SABDL2,
	ARM64_INS_SADALP,
	ARM64_INS_SADDL,
	ARM64_INS_SADDL2,
	ARM64_INS_SADDLP,
	ARM64_INS_SADDLV,
	ARM64_INS_SADDV,
	ARM64_INS_SADDW,
	ARM64_INS_SADDW2,
	ARM64_INS_SBC,
	ARM64_INS_SBCS,
	ARM64_INS_SBFM,
	ARM64_INS_SCVTF,
	ARM64_INS_SDIV,
	ARM64_INS_SDIVR,
	ARM64_INS_SDOT,
	ARM64_INS_SEL,
	ARM64_INS_SETF16,
	ARM64_INS_SETF8,
	ARM64_INS_SETFFR,
	ARM64_INS_SEV,
	ARM64_INS_SEVL,
	ARM64_INS_SHA1C,
	ARM64_INS_SHA1H,
	ARM64_INS_SHA1M,
	ARM64_INS_SHA1P,
	ARM64_INS_SHA1SU0,
	ARM64_INS_SHA1SU1,
	ARM64_INS_SHA256H,
	ARM64_INS_SHA256H2,
	ARM64_INS_SHA256SU0,
	ARM64_INS_SHA256SU1,
	ARM64_INS_SHA512H,
	ARM64_INS_SHA512H2,
	ARM64_INS_SHA512SU0,
	ARM64_INS_SHA512SU1,
	ARM64_INS_SHADD,
	ARM64_INS_SHL,
	ARM64_INS_SHLL,
	ARM64_INS_SHLL2,
	ARM64_INS_SHRN,
	ARM64_INS_SHRN2,
	ARM64_INS_SHSUB,
	ARM64_INS_SLI,
	ARM64_INS_SM3PARTW1,
	ARM64_INS_SM3PARTW2,
	ARM64_INS_SM3SS1,
	ARM64_INS_SM3TT1A,
	ARM64_INS_SM3TT1B,
	ARM64_INS_SM3TT2A,
	ARM64_INS_SM3TT2B,
	ARM64_INS_SM4E,
	ARM64_INS_SM4EKEY,
	ARM64_INS_SMADDL,
	ARM64_INS_SMAX,
	ARM64_INS_SMAXP,
	ARM64_INS_SMAXV,
	ARM64_INS_SMC,
	ARM64_INS_SMIN,
	ARM64_INS_SMINP,
	ARM64_INS_SMINV,
	ARM64_INS_SMLAL,
	ARM64_INS_SMLAL2,
	ARM64_INS_SMLSL,
	ARM64_INS_SMLSL2,
	ARM64_INS_SMNEGL,
	ARM64_INS_SMOV,
	ARM64_INS_SMSUBL,
	ARM64_INS_SMULH,
	ARM64_INS_SMULL,
	ARM64_INS_SMULL2,
	ARM64_INS_SPLICE,
	ARM64_INS_SQABS,
	ARM64_INS_SQADD,
	ARM64_INS_SQDECB,
	ARM64_INS_SQDECD,
	ARM64_INS_SQDECH,
	ARM64_INS_SQDECP,
	ARM64_INS_SQDECW,
	ARM64_INS_SQDMLAL,
	ARM64_INS_SQDMLAL2,
	ARM64_INS_SQDMLSL,
	ARM64_INS_SQDMLSL2,
	ARM64_INS_SQDMULH,
	ARM64_INS_SQDMULL,
	ARM64_INS_SQDMULL2,
	ARM64_INS_SQINCB,
	ARM64_INS_SQINCD,
	ARM64_INS_SQINCH,
	ARM64_INS_SQINCP,
	ARM64_INS_SQINCW,
	ARM64_INS_SQNEG,
	ARM64_INS_SQRDMLAH,
	ARM64_INS_SQRDMLSH,
	ARM64_INS_SQRDMULH,
	ARM64_INS_SQRSHL,
	ARM64_INS_SQRSHRN,
	ARM64_INS_SQRSHRN2,
	ARM64_INS_SQRSHRUN,
	ARM64_INS_SQRSHRUN2,
	ARM64_INS_SQSHL,
	ARM64_INS_SQSHLU,
	ARM64_INS_SQSHRN,
	ARM64_INS_SQSHRN2,
	ARM64_INS_SQSHRUN,
	ARM64_INS_SQSHRUN2,
	ARM64_INS_SQSUB,
	ARM64_INS_SQXTN,
	ARM64_INS_SQXTN2,
	ARM64_INS_SQXTUN,
	ARM64_INS_SQXTUN2,
	ARM64_INS_SRHADD,
	ARM64_INS_SRI,
	ARM64_INS_SRSHL,
	ARM64_INS_SRSHR,
	ARM64_INS_SRSRA,
	ARM64_INS_SSHL,
	ARM64_INS_SSHLL,
	ARM64_INS_SSHLL2,
	ARM64_INS_SSHR,
	ARM64_INS_SSRA,
	ARM64_INS_SSUBL,
	ARM64_INS_SSUBL2,
	ARM64_INS_SSUBW,
	ARM64_INS_SSUBW2,
	ARM64_INS_ST1,
	ARM64_INS_ST1B,
	ARM64_INS_ST1D,
	ARM64_INS_ST1H,
	ARM64_INS_ST1W,
	ARM64_INS_ST2,
	ARM64_INS_ST2B,
	ARM64_INS_ST2D,
	ARM64_INS_ST2H,
	ARM64_INS_ST2W,
	ARM64_INS_ST3,
	ARM64_INS_ST3B,
	ARM64_INS_ST3D,
	ARM64_INS_ST3H,
	ARM64_INS_ST3W,
	ARM64_INS_ST4,
	ARM64_INS_ST4B,
	ARM64_INS_ST4D,
	ARM64_INS_ST4H,
	ARM64_INS_ST4W,
	ARM64_INS_STADD,
	ARM64_INS_STADDB,
	ARM64_INS_STADDH,
	ARM64_INS_STADDL,
	ARM64_INS_STADDLB,
	ARM64_INS_STADDLH,
	ARM64_INS_STCLR,
	ARM64_INS_STCLRB,
	ARM64_INS_STCLRH,
	ARM64_INS_STCLRL,
	ARM64_INS_STCLRLB,
	ARM64_INS_STCLRLH,
	ARM64_INS_STEOR,
	ARM64_INS_STEORB,
	ARM64_INS_STEORH,
	ARM64_INS_STEORL,
	ARM64_INS_STEORLB,
	ARM64_INS_STEORLH,
	ARM64_INS_STLLR,
	ARM64_INS_STLLRB,
	ARM64_INS_STLLRH,
	ARM64_INS_STLR,
	ARM64_INS_STLRB,
	ARM64_INS_STLRH,
	ARM64_INS_STLUR,
	ARM64_INS_STLURB,
	ARM64_INS_STLURH,
	ARM64_INS_STLXP,
	ARM64_INS_STLXR,
	ARM64_INS_STLXRB,
	ARM64_INS_STLXRH,
	ARM64_INS_STNP,
	ARM64_INS_STNT1B,
	ARM64_INS_STNT1D,
	ARM64_INS_STNT1H,
	ARM64_INS_STNT1W,
	ARM64_INS_STP,
	ARM64_INS_STR,
	ARM64_INS_STRB,
	ARM64_INS_STRH,
	ARM64_INS_STSET,
	ARM64_INS_STSETB,
	ARM64_INS_STSETH,
	ARM64_INS_STSETL,
	ARM64_INS_STSETLB,
	ARM64_INS_STSETLH,
	ARM64_INS_STSMAX,
	ARM64_INS_STSMAXB,
	ARM64_INS_STSMAXH,
	ARM64_INS_STSMAXL,
	ARM64_INS_STSMAXLB,
	ARM64_INS_STSMAXLH,
	ARM64_INS_STSMIN,
	ARM64_INS_STSMINB,
	ARM64_INS_STSMINH,
	ARM64_INS_STSMINL,
	ARM64_INS_STSMINLB,
	ARM64_INS_STSMINLH,
	ARM64_INS_STTR,
	ARM64_INS_STTRB,
	ARM64_INS_STTRH,
	ARM64_INS_STUMAX,
	ARM64_INS_STUMAXB,
	ARM64_INS_STUMAXH,
	ARM64_INS_STUMAXL,
	ARM64_INS_STUMAXLB,
	ARM64_INS_STUMAXLH,
	ARM64_INS_STUMIN,
	ARM64_INS_STUMINB,
	ARM64_INS_STUMINH,
	ARM64_INS_STUMINL,
	ARM64_INS_STUMINLB,
	ARM64_INS_STUMINLH,
	ARM64_INS_STUR,
	ARM64_INS_STURB,
	ARM64_INS_STURH,
	ARM64_INS_STXP,
	ARM64_INS_STXR,
	ARM64_INS_STXRB,
	ARM64_INS_STXRH,
	ARM64_INS_SUB,
	ARM64_INS_SUBHN,
	ARM64_INS_SUBHN2,
	ARM64_INS_SUBR,
	ARM64_INS_SUBS,
	ARM64_INS_SUNPKHI,
	ARM64_INS_SUNPKLO,
	ARM64_INS_SUQADD,
	ARM64_INS_SVC,
	ARM64_INS_SWP,
	ARM64_INS_SWPA,
	ARM64_INS_SWPAB,
	ARM64_INS_SWPAH,
	ARM64_INS_SWPAL,
	ARM64_INS_SWPALB,
	ARM64_INS_SWPALH,
	ARM64_INS_SWPB,
	ARM64_INS_SWPH,
	ARM64_INS_SWPL,
	ARM64_INS_SWPLB,
	ARM64_INS_SWPLH,
	ARM64_INS_SXTB,
	ARM64_INS_SXTH,
	ARM64_INS_SXTL,
	ARM64_INS_SXTL2,
	ARM64_INS_SXTW,
	ARM64_INS_SYS,
	ARM64_INS_SYSL,
	ARM64_INS_TBL,
	ARM64_INS_TBNZ,
	ARM64_INS_TBX,
	ARM64_INS_TBZ,
	ARM64_INS_TRN1,
	ARM64_INS_TRN2,
	ARM64_INS_TSB,
	ARM64_INS_TST,
	ARM64_INS_UABA,
	ARM64_INS_UABAL,
	ARM64_INS_UABAL2,
	ARM64_INS_UABD,
	ARM64_INS_UABDL,
	ARM64_INS_UABDL2,
	ARM64_INS_UADALP,
	ARM64_INS_UADDL,
	ARM64_INS_UADDL2,
	ARM64_INS_UADDLP,
	ARM64_INS_UADDLV,
	ARM64_INS_UADDV,
	ARM64_INS_UADDW,
	ARM64_INS_UADDW2,
	ARM64_INS_UBFM,
	ARM64_INS_UCVTF,
	ARM64_INS_UDIV,
	ARM64_INS_UDIVR,
	ARM64_INS_UDOT,
	ARM64_INS_UHADD,
	ARM64_INS_UHSUB,
	ARM64_INS_UMADDL,
	ARM64_INS_UMAX,
	ARM64_INS_UMAXP,
	ARM64_INS_UMAXV,
	ARM64_INS_UMIN,
	ARM64_INS_UMINP,
	ARM64_INS_UMINV,
	ARM64_INS_UMLAL,
	ARM64_INS_UMLAL2,
	ARM64_INS_UMLSL,
	ARM64_INS_UMLSL2,
	ARM64_INS_UMNEGL,
	ARM64_INS_UMOV,
	ARM64_INS_UMSUBL,
	ARM64_INS_UMULH,
	ARM64_INS_UMULL,
	ARM64_INS_UMULL2,
	ARM64_INS_UQADD,
	ARM64_INS_UQDECB,
	ARM64_INS_UQDECD,
	ARM64_INS_UQDECH,
	ARM64_INS_UQDECP,
	ARM64_INS_UQDECW,
	ARM64_INS_UQINCB,
	ARM64_INS_UQINCD,
	ARM64_INS_UQINCH,
	ARM64_INS_UQINCP,
	ARM64_INS_UQINCW,
	ARM64_INS_UQRSHL,
	ARM64_INS_UQRSHRN,
	ARM64_INS_UQRSHRN2,
	ARM64_INS_UQSHL,
	ARM64_INS_UQSHRN,
	ARM64_INS_UQSHRN2,
	ARM64_INS_UQSUB,
	ARM64_INS_UQXTN,
	ARM64_INS_UQXTN2,
	ARM64_INS_URECPE,
	ARM64_INS_URHADD,
	ARM64_INS_URSHL,
	ARM64_INS_URSHR,
	ARM64_INS_URSQRTE,
	ARM64_INS_URSRA,
	ARM64_INS_USHL,
	ARM64_INS_USHLL,
	ARM64_INS_USHLL2,
	ARM64_INS_USHR,
	ARM64_INS_USQADD,
	ARM64_INS_USRA,
	ARM64_INS_USUBL,
	ARM64_INS_USUBL2,
	ARM64_INS_USUBW,
	ARM64_INS_USUBW2,
	ARM64_INS_UUNPKHI,
	ARM64_INS_UUNPKLO,
	ARM64_INS_UXTB,
	ARM64_INS_UXTH,
	ARM64_INS_UXTL,
	ARM64_INS_UXTL2,
	ARM64_INS_UXTW,
	ARM64_INS_UZP1,
	ARM64_INS_UZP2,
	ARM64_INS_WFE,
	ARM64_INS_WFI,
	ARM64_INS_WHILELE,
	ARM64_INS_WHILELO,
	ARM64_INS_WHILELS,
	ARM64_INS_WHILELT,
	ARM64_INS_WRFFR,
	ARM64_INS_XAR,
	ARM64_INS_XPACD,
	ARM64_INS_XPACI,
	ARM64_INS_XPACLRI,
	ARM64_INS_XTN,
	ARM64_INS_XTN2,
	ARM64_INS_YIELD,
	ARM64_INS_ZIP1,
	ARM64_INS_ZIP2,

	// alias insn
	ARM64_INS_SBFIZ,
	ARM64_INS_UBFIZ,
	ARM64_INS_SBFX,
	ARM64_INS_UBFX,
	ARM64_INS_BFI,
	ARM64_INS_BFXIL,
	ARM64_INS_IC,
	ARM64_INS_DC,
	ARM64_INS_AT,
	ARM64_INS_TLBI,

	ARM64_INS_ENDING,  // <-- mark the end of the list of insn
} arm64_insn;

/// Group of ARM64 instructions
typedef enum arm64_insn_group {
	ARM64_GRP_INVALID = 0, ///< = CS_GRP_INVALID

	// Generic groups
	// all jump instructions (conditional+direct+indirect jumps)
	ARM64_GRP_JUMP,	///< = CS_GRP_JUMP
	ARM64_GRP_CALL,
	ARM64_GRP_RET,
	ARM64_GRP_INT,
	ARM64_GRP_PRIVILEGE = 6, ///< = CS_GRP_PRIVILEGE
	ARM64_GRP_BRANCH_RELATIVE, ///< = CS_GRP_BRANCH_RELATIVE
	ARM64_GRP_PAC,

	// Architecture-specific groups
	ARM64_GRP_CRYPTO = 128,
	ARM64_GRP_FPARMV8,
	ARM64_GRP_NEON,
	ARM64_GRP_CRC,
	ARM64_GRP_AES,
	ARM64_GRP_DOTPROD,
	ARM64_GRP_FULLFP16,
	ARM64_GRP_LSE,
	ARM64_GRP_RCPC,
	ARM64_GRP_RDM,
	ARM64_GRP_SHA2,
	ARM64_GRP_SHA3,
	ARM64_GRP_SM4,
	ARM64_GRP_SVE,
	ARM64_GRP_V8_1A,
	ARM64_GRP_V8_3A,
	ARM64_GRP_V8_4A,

	ARM64_GRP_ENDING,  // <-- mark the end of the list of groups
} arm64_insn_group;

#ifdef __cplusplus
}
#endif

#endif
