## Changelog

### v0.4.10

- Update dependencies. This removes `nix` from the dependency tree, which was
  causing build failures on `s390x`. This also removes a few other
  now-redundant dependencies.

### v0.4.9

- Replace `libc` crate with `tz-rs`. The former has broken definitions—it works
  by coincidence on 64bit platforms and doesn't build on 32bit platforms.

### v0.4.8

**Yanked**: this release won't build properly on 32bit architectures and has
been yanked.

- Bump `libc` crate. Fixes builds on s390x and loongarch64.

### v0.4.7

- Fix reliance on layer-shell quirk that was only present in sway <= 1.9.
- Fix builds with upstream changes in Rust 1.8.0.

### v0.4.6

- Work around backwards-incompatible change in recent wlroots. See:
  https://gitlab.freedesktop.org/wayland/wayland/-/merge_requests/363

### v0.4.5

- Fix Makefile ignoring the PREFIX environment variable.

### v0.4.4

- Implement `--image-editor`. The `IMAGE_EDITOR` environment variable is still
  used as a fallback.
- Fix blank screenshots in some multi-display configurations.
- Various documentation fixes.
- Add a Makefile to simplify downstream packaging or installing from source.

### v0.4.3

- Errata: the v0.4.2 changelog shows an entry that was dropped before release.

### v0.4.2

- Introduced `IMAGE_EDITOR` environment variable (see README for further
  details).
- Thumbnails are now slightly larger.
- Fix build issue handling `SHOTMAN_VERSION`.
- Add support for `XRGB2101010` and `XBGR2101010` pixel formats.
- The `--verbose` flag now takes a named log level (e.g.: `info`, `trace`, etc).
- The `single-pixel-buffer-v1` protocol is now used to render single-pixel
  buffers. Only compositors with compatible with this protocol are supported.
- The thumbnail window border colour now changes when focused.
- ~~Copying now also copies the file path into the clipboard as `text/uri-list`.
  File managers and other applications will paste by copying the file directly.
  This works on `dolphin`, and [does not work on `nemo`][nemo-bug]. [Cutting
  file is not possible on Wayland][cutting-files], so this new behaviour does
  not apply when cutting.~~

[nemo-bug]: https://github.com/linuxmint/nemo/issues/3213
[cutting-files]: https://gitlab.freedesktop.org/wayland/wayland/-/issues/372

### v0.4.1

- Fixed output of `--version`.
- Added documentation for shell completions.

### v0.4.0

- Added helper to generate shell completions.

### Prior versions

There's no changelog for prior versions; this was too experimental.
