// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UMLAL2_8H_TRACE_AARCH64_H_
#define VIXL_SIM_UMLAL2_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_umlal2_8H[] = {
  0x4309, 0x70e5, 0xa292, 0xf050, 0xfa86, 0xfc82, 0xfe80, 0x3333,
  0x56fe, 0x8779, 0xc5a2, 0xf528, 0xfb83, 0xfd80, 0x007f, 0x3333,
  0x6864, 0xa4b1, 0xc99e, 0xf620, 0xfc80, 0x007e, 0x017e, 0x3333,
  0x7ee8, 0xa803, 0xca6a, 0xf718, 0x007d, 0x017c, 0x027d, 0x3333,
  0x8177, 0xa8ad, 0xcb36, 0x0010, 0x017a, 0x027a, 0x0877, 0x3333,
  0x81fa, 0xa957, 0x0002, 0x0108, 0x0277, 0x086e, 0x334c, 0x3333,
  0x827d, 0x0001, 0x00ce, 0x0200, 0x0865, 0x3318, 0x552a, 0x3333,
  0x0000, 0x00ab, 0x019a, 0x07d0, 0x32e4, 0x54d4, 0x7d02, 0x3333,
  0x0083, 0x0155, 0x0662, 0x3178, 0x547e, 0x7c84, 0x7e01, 0x3333,
  0x0106, 0x0551, 0x28a6, 0x5268, 0x7c06, 0x7d82, 0x7f00, 0x3333,
  0x0418, 0x21df, 0x43be, 0x7928, 0x7d03, 0x7e80, 0x7fff, 0x3333,
  0x1a19, 0x3873, 0x639e, 0x7a20, 0x7e00, 0x7f7e, 0x80fe, 0x3333,
  0x2b7f, 0x5303, 0x646a, 0x7b18, 0x7efd, 0x807c, 0x81fd, 0x3333,
  0x3ff7, 0x53ad, 0x6536, 0x7c10, 0x7ffa, 0x817a, 0x82fc, 0x3333,
  0x407a, 0x5457, 0x6602, 0x7d08, 0x80f7, 0x8278, 0xa9d5, 0x3333,
  0x40fd, 0x5501, 0x66ce, 0x7e00, 0x81f4, 0xa92a, 0xcbb3, 0x3333,
  0x4180, 0x55ab, 0x679a, 0x7ef8, 0xa87f, 0xcae6, 0xf787, 0x3333,
  0x4203, 0x5655, 0x6866, 0xa4c0, 0xca19, 0xf68e, 0xfc82, 0x3333,
  0x4286, 0x56ff, 0x877a, 0xc5b0, 0xf595, 0xfb84, 0xfd81, 0x3333,
  0x56fe, 0x8779, 0xc5a2, 0xf528, 0xfb83, 0xfd80, 0x007f, 0x3333,
  0x70e4, 0xa291, 0xf042, 0xfa19, 0xfc81, 0xfe7f, 0x007f, 0x3334,
  0x8778, 0xc5a1, 0xf51a, 0xfb16, 0xfd7f, 0x007e, 0x007f, 0x3335,
  0xa4b0, 0xc99d, 0xf612, 0xfc13, 0x007d, 0x017d, 0x007f, 0x333b,
  0xa802, 0xca69, 0xf70a, 0x0010, 0x017b, 0x027c, 0x007f, 0x3366,
  0xa8ac, 0xcb35, 0x0002, 0x010d, 0x0279, 0x0876, 0x007f, 0x3388,
  0xa956, 0x0001, 0x00fa, 0x020a, 0x086d, 0x334b, 0x007f, 0x33b0,
  0x0000, 0x00cd, 0x01f2, 0x07f8, 0x3317, 0x5529, 0x007f, 0x33b1,
  0x00aa, 0x0199, 0x07c2, 0x3277, 0x54d3, 0x7d01, 0x007f, 0x33b2,
  0x0154, 0x0661, 0x316a, 0x5411, 0x7c83, 0x7e00, 0x007f, 0x33b3,
  0x0550, 0x28a5, 0x525a, 0x7b99, 0x7d81, 0x7eff, 0x007f, 0x33b4,
  0x21de, 0x43bd, 0x791a, 0x7c96, 0x7e7f, 0x7ffe, 0x007f, 0x33b5,
  0x3872, 0x639d, 0x7a12, 0x7d93, 0x7f7d, 0x80fd, 0x007f, 0x33b6,
  0x5302, 0x6469, 0x7b0a, 0x7e90, 0x807b, 0x81fc, 0x007f, 0x33dd,
  0x53ac, 0x6535, 0x7c02, 0x7f8d, 0x8179, 0x82fb, 0x007f, 0x33ff,
  0x5456, 0x6601, 0x7cfa, 0x808a, 0x8277, 0xa9d4, 0x007f, 0x342b,
  0x5500, 0x66cd, 0x7df2, 0x8187, 0xa929, 0xcbb2, 0x007f, 0x3430,
  0x55aa, 0x6799, 0x7eea, 0xa812, 0xcae5, 0xf786, 0x007f, 0x3431,
  0x5654, 0x6865, 0xa4b2, 0xc9ac, 0xf68d, 0xfc81, 0x007f, 0x3432,
  0x6864, 0xa4b1, 0xc99e, 0xf620, 0xfc80, 0x007e, 0x017e, 0x3333,
  0x8778, 0xc5a1, 0xf51a, 0xfb16, 0xfd7f, 0x007e, 0x007f, 0x3335,
  0xa290, 0xf041, 0xfa0b, 0xfc14, 0xfe7e, 0x007e, 0x0080, 0x3337,
  0xc5a0, 0xf519, 0xfb08, 0xfd12, 0x007d, 0x007e, 0x0081, 0x3343,
  0xc99c, 0xf611, 0xfc05, 0x0010, 0x017c, 0x007e, 0x0087, 0x3399,
  0xca68, 0xf709, 0x0002, 0x010e, 0x027b, 0x007e, 0x00b2, 0x33dd,
  0xcb34, 0x0001, 0x00ff, 0x020c, 0x0875, 0x007e, 0x00d4, 0x342d,
  0x0000, 0x00f9, 0x01fc, 0x0800, 0x334a, 0x007e, 0x00fc, 0x342f,
  0x00cc, 0x01f1, 0x07ea, 0x32aa, 0x5528, 0x007e, 0x00fd, 0x3431,
  0x0198, 0x07c1, 0x3269, 0x5466, 0x7d00, 0x007e, 0x00fe, 0x3433,
  0x0660, 0x3169, 0x5403, 0x7c16, 0x7dff, 0x007e, 0x00ff, 0x3435,
  0x28a4, 0x5259, 0x7b8b, 0x7d14, 0x7efe, 0x007e, 0x0100, 0x3437,
  0x43bc, 0x7919, 0x7c88, 0x7e12, 0x7ffd, 0x007e, 0x0101, 0x3439,
  0x639c, 0x7a11, 0x7d85, 0x7f10, 0x80fc, 0x007e, 0x0102, 0x3487,
  0x6468, 0x7b09, 0x7e82, 0x800e, 0x81fb, 0x007e, 0x0129, 0x34cb,
  0x6534, 0x7c01, 0x7f7f, 0x810c, 0x82fa, 0x007e, 0x014b, 0x3523,
  0x6600, 0x7cf9, 0x807c, 0x820a, 0xa9d3, 0x007e, 0x0177, 0x352d,
  0x66cc, 0x7df1, 0x8179, 0xa8bc, 0xcbb1, 0x007e, 0x017c, 0x352f,
  0x6798, 0x7ee9, 0xa804, 0xca78, 0xf785, 0x007e, 0x017d, 0x3531,
  0x7ee8, 0xa803, 0xca6a, 0xf718, 0x007d, 0x017c, 0x027d, 0x3333,
  0xa4b0, 0xc99d, 0xf612, 0xfc13, 0x007d, 0x017d, 0x007f, 0x333b,
  0xc5a0, 0xf519, 0xfb08, 0xfd12, 0x007d, 0x007e, 0x0081, 0x3343,
  0xf040, 0xfa0a, 0xfc06, 0xfe11, 0x007d, 0x007f, 0x0083, 0x3373,
  0xf518, 0xfb07, 0xfd04, 0x0010, 0x007d, 0x0080, 0x008f, 0x34cb,
  0xf610, 0xfc04, 0x0002, 0x010f, 0x007d, 0x0086, 0x00e5, 0x35db,
  0xf708, 0x0001, 0x0100, 0x020e, 0x007d, 0x00b1, 0x0129, 0x371b,
  0x0000, 0x00fe, 0x01fe, 0x0808, 0x007d, 0x00d3, 0x0179, 0x3723,
  0x00f8, 0x01fb, 0x07f2, 0x32dd, 0x007d, 0x00fb, 0x017b, 0x372b,
  0x01f0, 0x07e9, 0x329c, 0x54bb, 0x007d, 0x00fc, 0x017d, 0x3733,
  0x07c0, 0x3268, 0x5458, 0x7c93, 0x007d, 0x00fd, 0x017f, 0x373b,
  0x3168, 0x5402, 0x7c08, 0x7d92, 0x007d, 0x00fe, 0x0181, 0x3743,
  0x5258, 0x7b8a, 0x7d06, 0x7e91, 0x007d, 0x00ff, 0x0183, 0x374b,
  0x7918, 0x7c87, 0x7e04, 0x7f90, 0x007d, 0x0100, 0x0185, 0x3883,
  0x7a10, 0x7d84, 0x7f02, 0x808f, 0x007d, 0x0101, 0x01d3, 0x3993,
  0x7b08, 0x7e81, 0x8000, 0x818e, 0x007d, 0x0128, 0x0217, 0x3af3,
  0x7c00, 0x7f7e, 0x80fe, 0x828d, 0x007d, 0x014a, 0x026f, 0x3b1b,
  0x7cf8, 0x807b, 0x81fc, 0xa966, 0x007d, 0x0176, 0x0279, 0x3b23,
  0x7df0, 0x8178, 0xa8ae, 0xcb44, 0x007d, 0x017b, 0x027b, 0x3b2b,
  0x8177, 0xa8ad, 0xcb36, 0x0010, 0x017a, 0x027a, 0x0877, 0x3333,
  0xa802, 0xca69, 0xf70a, 0x0010, 0x017b, 0x027c, 0x007f, 0x3366,
  0xc99c, 0xf611, 0xfc05, 0x0010, 0x017c, 0x007e, 0x0087, 0x3399,
  0xf518, 0xfb07, 0xfd04, 0x0010, 0x007d, 0x0080, 0x008f, 0x34cb,
  0xfa09, 0xfc05, 0xfe03, 0x0010, 0x007e, 0x0082, 0x00bf, 0x3d5c,
  0xfb06, 0xfd03, 0x0002, 0x0010, 0x007f, 0x008e, 0x0217, 0x4422,
  0xfc03, 0x0001, 0x0101, 0x0010, 0x0085, 0x00e4, 0x0327, 0x4c1a,
  0x0000, 0x00ff, 0x0200, 0x0010, 0x00b0, 0x0128, 0x0467, 0x4c4d,
  0x00fd, 0x01fd, 0x07fa, 0x0010, 0x00d2, 0x0178, 0x046f, 0x4c80,
  0x01fa, 0x07f1, 0x32cf, 0x0010, 0x00fa, 0x017a, 0x0477, 0x4cb3,
  0x07e8, 0x329b, 0x54ad, 0x0010, 0x00fb, 0x017c, 0x047f, 0x4ce6,
  0x3267, 0x5457, 0x7c85, 0x0010, 0x00fc, 0x017e, 0x0487, 0x4d19,
  0x5401, 0x7c07, 0x7d84, 0x0010, 0x00fd, 0x0180, 0x048f, 0x4d4c,
  0x7b89, 0x7d05, 0x7e83, 0x0010, 0x00fe, 0x0182, 0x0497, 0x5511,
  0x7c86, 0x7e03, 0x7f82, 0x0010, 0x00ff, 0x0184, 0x05cf, 0x5bd7,
  0x7d83, 0x7f01, 0x8081, 0x0010, 0x0100, 0x01d2, 0x06df, 0x649b,
  0x7e80, 0x7fff, 0x8180, 0x0010, 0x0127, 0x0216, 0x083f, 0x659a,
  0x7f7d, 0x80fd, 0x827f, 0x0010, 0x0149, 0x026e, 0x0867, 0x65cd,
  0x807a, 0x81fb, 0xa958, 0x0010, 0x0175, 0x0278, 0x086f, 0x6600,
  0x81fa, 0xa957, 0x0002, 0x0108, 0x0277, 0x086e, 0x334c, 0x3333,
  0xa8ac, 0xcb35, 0x0002, 0x010d, 0x0279, 0x0876, 0x007f, 0x3388,
  0xca68, 0xf709, 0x0002, 0x010e, 0x027b, 0x007e, 0x00b2, 0x33dd,
  0xf610, 0xfc04, 0x0002, 0x010f, 0x007d, 0x0086, 0x00e5, 0x35db,
  0xfb06, 0xfd03, 0x0002, 0x0010, 0x007f, 0x008e, 0x0217, 0x4422,
  0xfc04, 0xfe02, 0x0002, 0x0011, 0x0081, 0x00be, 0x0aa8, 0x4f6c,
  0xfd02, 0x0001, 0x0002, 0x0012, 0x008d, 0x0216, 0x116e, 0x5cb4,
  0x0000, 0x0100, 0x0002, 0x0018, 0x00e3, 0x0326, 0x1966, 0x5d09,
  0x00fe, 0x01ff, 0x0002, 0x0043, 0x0127, 0x0466, 0x1999, 0x5d5e,
  0x01fc, 0x07f9, 0x0002, 0x0065, 0x0177, 0x046e, 0x19cc, 0x5db3,
  0x07f0, 0x32ce, 0x0002, 0x008d, 0x0179, 0x0476, 0x19ff, 0x5e08,
  0x329a, 0x54ac, 0x0002, 0x008e, 0x017b, 0x047e, 0x1a32, 0x5e5d,
  0x5456, 0x7c84, 0x0002, 0x008f, 0x017d, 0x0486, 0x1a65, 0x5eb2,
  0x7c06, 0x7d83, 0x0002, 0x0090, 0x017f, 0x048e, 0x1a98, 0x6ba5,
  0x7d04, 0x7e82, 0x0002, 0x0091, 0x0181, 0x0496, 0x225d, 0x76ef,
  0x7e02, 0x7f81, 0x0002, 0x0092, 0x0183, 0x05ce, 0x2923, 0x858b,
  0x7f00, 0x8080, 0x0002, 0x0093, 0x01d1, 0x06de, 0x31e7, 0x8734,
  0x7ffe, 0x817f, 0x0002, 0x00ba, 0x0215, 0x083e, 0x32e6, 0x8789,
  0x80fc, 0x827e, 0x0002, 0x00dc, 0x026d, 0x0866, 0x3319, 0x87de,
  0x827d, 0x0001, 0x00ce, 0x0200, 0x0865, 0x3318, 0x552a, 0x3333,
  0xa956, 0x0001, 0x00fa, 0x020a, 0x086d, 0x334b, 0x007f, 0x33b0,
  0xcb34, 0x0001, 0x00ff, 0x020c, 0x0875, 0x007e, 0x00d4, 0x342d,
  0xf708, 0x0001, 0x0100, 0x020e, 0x007d, 0x00b1, 0x0129, 0x371b,
  0xfc03, 0x0001, 0x0101, 0x0010, 0x0085, 0x00e4, 0x0327, 0x4c1a,
  0xfd02, 0x0001, 0x0002, 0x0012, 0x008d, 0x0216, 0x116e, 0x5cb4,
  0xfe01, 0x0001, 0x0003, 0x0014, 0x00bd, 0x0aa7, 0x1cb8, 0x703c,
  0x0000, 0x0001, 0x0004, 0x0020, 0x0215, 0x116d, 0x2a00, 0x70b9,
  0x00ff, 0x0001, 0x000a, 0x0076, 0x0325, 0x1965, 0x2a55, 0x7136,
  0x01fe, 0x0001, 0x0035, 0x00ba, 0x0465, 0x1998, 0x2aaa, 0x71b3,
  0x07f8, 0x0001, 0x0057, 0x010a, 0x046d, 0x19cb, 0x2aff, 0x7230,
  0x32cd, 0x0001, 0x007f, 0x010c, 0x0475, 0x19fe, 0x2b54, 0x72ad,
  0x54ab, 0x0001, 0x0080, 0x010e, 0x047d, 0x1a31, 0x2ba9, 0x732a,
  0x7c83, 0x0001, 0x0081, 0x0110, 0x0485, 0x1a64, 0x2bfe, 0x8635,
  0x7d82, 0x0001, 0x0082, 0x0112, 0x048d, 0x1a97, 0x38f1, 0x96cf,
  0x7e81, 0x0001, 0x0083, 0x0114, 0x0495, 0x225c, 0x443b, 0xac4b,
  0x7f80, 0x0001, 0x0084, 0x0116, 0x05cd, 0x2922, 0x52d7, 0xaebc,
  0x807f, 0x0001, 0x0085, 0x0164, 0x06dd, 0x31e6, 0x5480, 0xaf39,
  0x817e, 0x0001, 0x00ac, 0x01a8, 0x083d, 0x32e5, 0x54d5, 0xafb6,
  0x0000, 0x00ab, 0x019a, 0x07d0, 0x32e4, 0x54d4, 0x7d02, 0x3333,
  0x0000, 0x00cd, 0x01f2, 0x07f8, 0x3317, 0x5529, 0x007f, 0x33b1,
  0x0000, 0x00f9, 0x01fc, 0x0800, 0x334a, 0x007e, 0x00fc, 0x342f,
  0x0000, 0x00fe, 0x01fe, 0x0808, 0x007d, 0x00d3, 0x0179, 0x3723,
  0x0000, 0x00ff, 0x0200, 0x0010, 0x00b0, 0x0128, 0x0467, 0x4c4d,
  0x0000, 0x0100, 0x0002, 0x0018, 0x00e3, 0x0326, 0x1966, 0x5d09,
  0x0000, 0x0001, 0x0004, 0x0020, 0x0215, 0x116d, 0x2a00, 0x70b9,
  0x0000, 0x0002, 0x0006, 0x0050, 0x0aa6, 0x1cb7, 0x3d88, 0x7137,
  0x0000, 0x0003, 0x0012, 0x01a8, 0x116c, 0x29ff, 0x3e05, 0x71b5,
  0x0000, 0x0009, 0x0068, 0x02b8, 0x1964, 0x2a54, 0x3e82, 0x7233,
  0x0000, 0x0034, 0x00ac, 0x03f8, 0x1997, 0x2aa9, 0x3eff, 0x72b1,
  0x0000, 0x0056, 0x00fc, 0x0400, 0x19ca, 0x2afe, 0x3f7c, 0x732f,
  0x0000, 0x007e, 0x00fe, 0x0408, 0x19fd, 0x2b53, 0x3ff9, 0x73ad,
  0x0000, 0x007f, 0x0100, 0x0410, 0x1a30, 0x2ba8, 0x4076, 0x86df,
  0x0000, 0x0080, 0x0102, 0x0418, 0x1a63, 0x2bfd, 0x5381, 0x979b,
  0x0000, 0x0081, 0x0104, 0x0420, 0x1a96, 0x38f0, 0x641b, 0xad43,
  0x0000, 0x0082, 0x0106, 0x0428, 0x225b, 0x443a, 0x7997, 0xafb9,
  0x0000, 0x0083, 0x0108, 0x0560, 0x2921, 0x52d6, 0x7c08, 0xb037,
  0x0000, 0x0084, 0x0156, 0x0670, 0x31e5, 0x547f, 0x7c85, 0xb0b5,
  0x0083, 0x0155, 0x0662, 0x3178, 0x547e, 0x7c84, 0x7e01, 0x3333,
  0x00aa, 0x0199, 0x07c2, 0x3277, 0x54d3, 0x7d01, 0x007f, 0x33b2,
  0x00cc, 0x01f1, 0x07ea, 0x32aa, 0x5528, 0x007e, 0x00fd, 0x3431,
  0x00f8, 0x01fb, 0x07f2, 0x32dd, 0x007d, 0x00fb, 0x017b, 0x372b,
  0x00fd, 0x01fd, 0x07fa, 0x0010, 0x00d2, 0x0178, 0x046f, 0x4c80,
  0x00fe, 0x01ff, 0x0002, 0x0043, 0x0127, 0x0466, 0x1999, 0x5d5e,
  0x00ff, 0x0001, 0x000a, 0x0076, 0x0325, 0x1965, 0x2a55, 0x7136,
  0x0000, 0x0003, 0x0012, 0x01a8, 0x116c, 0x29ff, 0x3e05, 0x71b5,
  0x0001, 0x0005, 0x0042, 0x0a39, 0x1cb6, 0x3d87, 0x3e83, 0x7234,
  0x0002, 0x0011, 0x019a, 0x10ff, 0x29fe, 0x3e04, 0x3f01, 0x72b3,
  0x0008, 0x0067, 0x02aa, 0x18f7, 0x2a53, 0x3e81, 0x3f7f, 0x7332,
  0x0033, 0x00ab, 0x03ea, 0x192a, 0x2aa8, 0x3efe, 0x3ffd, 0x73b1,
  0x0055, 0x00fb, 0x03f2, 0x195d, 0x2afd, 0x3f7b, 0x407b, 0x7430,
  0x007d, 0x00fd, 0x03fa, 0x1990, 0x2b52, 0x3ff8, 0x40f9, 0x8789,
  0x007e, 0x00ff, 0x0402, 0x19c3, 0x2ba7, 0x4075, 0x542b, 0x9867,
  0x007f, 0x0101, 0x040a, 0x19f6, 0x2bfc, 0x5380, 0x64e7, 0xae3b,
  0x0080, 0x0103, 0x0412, 0x1a29, 0x38ef, 0x641a, 0x7a8f, 0xb0b6,
  0x0081, 0x0105, 0x041a, 0x21ee, 0x4439, 0x7996, 0x7d05, 0xb135,
  0x0082, 0x0107, 0x0552, 0x28b4, 0x52d5, 0x7c07, 0x7d83, 0xb1b4,
  0x0106, 0x0551, 0x28a6, 0x5268, 0x7c06, 0x7d82, 0x7f00, 0x3333,
  0x0154, 0x0661, 0x316a, 0x5411, 0x7c83, 0x7e00, 0x007f, 0x33b3,
  0x0198, 0x07c1, 0x3269, 0x5466, 0x7d00, 0x007e, 0x00fe, 0x3433,
  0x01f0, 0x07e9, 0x329c, 0x54bb, 0x007d, 0x00fc, 0x017d, 0x3733,
  0x01fa, 0x07f1, 0x32cf, 0x0010, 0x00fa, 0x017a, 0x0477, 0x4cb3,
  0x01fc, 0x07f9, 0x0002, 0x0065, 0x0177, 0x046e, 0x19cc, 0x5db3,
  0x01fe, 0x0001, 0x0035, 0x00ba, 0x0465, 0x1998, 0x2aaa, 0x71b3,
  0x0000, 0x0009, 0x0068, 0x02b8, 0x1964, 0x2a54, 0x3e82, 0x7233,
  0x0002, 0x0011, 0x019a, 0x10ff, 0x29fe, 0x3e04, 0x3f01, 0x72b3,
  0x0004, 0x0041, 0x0a2b, 0x1c49, 0x3d86, 0x3e82, 0x3f80, 0x7333,
  0x0010, 0x0199, 0x10f1, 0x2991, 0x3e03, 0x3f00, 0x3fff, 0x73b3,
  0x0066, 0x02a9, 0x18e9, 0x29e6, 0x3e80, 0x3f7e, 0x407e, 0x7433,
  0x00aa, 0x03e9, 0x191c, 0x2a3b, 0x3efd, 0x3ffc, 0x40fd, 0x74b3,
  0x00fa, 0x03f1, 0x194f, 0x2a90, 0x3f7a, 0x407a, 0x417c, 0x8833,
  0x00fc, 0x03f9, 0x1982, 0x2ae5, 0x3ff7, 0x40f8, 0x54d5, 0x9933,
  0x00fe, 0x0401, 0x19b5, 0x2b3a, 0x4074, 0x542a, 0x65b3, 0xaf33,
  0x0100, 0x0409, 0x19e8, 0x2b8f, 0x537f, 0x64e6, 0x7b87, 0xb1b3,
  0x0102, 0x0411, 0x1a1b, 0x3882, 0x6419, 0x7a8e, 0x7e02, 0xb233,
  0x0104, 0x0419, 0x21e0, 0x43cc, 0x7995, 0x7d04, 0x7e81, 0xb2b3,
  0x0418, 0x21df, 0x43be, 0x7928, 0x7d03, 0x7e80, 0x7fff, 0x3333,
  0x0550, 0x28a5, 0x525a, 0x7b99, 0x7d81, 0x7eff, 0x007f, 0x33b4,
  0x0660, 0x3169, 0x5403, 0x7c16, 0x7dff, 0x007e, 0x00ff, 0x3435,
  0x07c0, 0x3268, 0x5458, 0x7c93, 0x007d, 0x00fd, 0x017f, 0x373b,
  0x07e8, 0x329b, 0x54ad, 0x0010, 0x00fb, 0x017c, 0x047f, 0x4ce6,
  0x07f0, 0x32ce, 0x0002, 0x008d, 0x0179, 0x0476, 0x19ff, 0x5e08,
  0x07f8, 0x0001, 0x0057, 0x010a, 0x046d, 0x19cb, 0x2aff, 0x7230,
  0x0000, 0x0034, 0x00ac, 0x03f8, 0x1997, 0x2aa9, 0x3eff, 0x72b1,
  0x0008, 0x0067, 0x02aa, 0x18f7, 0x2a53, 0x3e81, 0x3f7f, 0x7332,
  0x0010, 0x0199, 0x10f1, 0x2991, 0x3e03, 0x3f00, 0x3fff, 0x73b3,
  0x0040, 0x0a2a, 0x1c3b, 0x3d19, 0x3e81, 0x3f7f, 0x407f, 0x7434,
  0x0198, 0x10f0, 0x2983, 0x3d96, 0x3eff, 0x3ffe, 0x40ff, 0x74b5,
  0x02a8, 0x18e8, 0x29d8, 0x3e13, 0x3f7d, 0x407d, 0x417f, 0x7536,
  0x03e8, 0x191b, 0x2a2d, 0x3e90, 0x3ffb, 0x40fc, 0x41ff, 0x88dd,
  0x03f0, 0x194e, 0x2a82, 0x3f0d, 0x4079, 0x417b, 0x557f, 0x99ff,
  0x03f8, 0x1981, 0x2ad7, 0x3f8a, 0x40f7, 0x54d4, 0x667f, 0xb02b,
  0x0400, 0x19b4, 0x2b2c, 0x4007, 0x5429, 0x65b2, 0x7c7f, 0xb2b0,
  0x0408, 0x19e7, 0x2b81, 0x5312, 0x64e5, 0x7b86, 0x7eff, 0xb331,
  0x0410, 0x1a1a, 0x3874, 0x63ac, 0x7a8d, 0x7e01, 0x7f7f, 0xb3b2,
  0x1a19, 0x3873, 0x639e, 0x7a20, 0x7e00, 0x7f7e, 0x80fe, 0x3333,
  0x21de, 0x43bd, 0x791a, 0x7c96, 0x7e7f, 0x7ffe, 0x007f, 0x33b5,
  0x28a4, 0x5259, 0x7b8b, 0x7d14, 0x7efe, 0x007e, 0x0100, 0x3437,
  0x3168, 0x5402, 0x7c08, 0x7d92, 0x007d, 0x00fe, 0x0181, 0x3743,
  0x3267, 0x5457, 0x7c85, 0x0010, 0x00fc, 0x017e, 0x0487, 0x4d19,
  0x329a, 0x54ac, 0x0002, 0x008e, 0x017b, 0x047e, 0x1a32, 0x5e5d,
  0x32cd, 0x0001, 0x007f, 0x010c, 0x0475, 0x19fe, 0x2b54, 0x72ad,
  0x0000, 0x0056, 0x00fc, 0x0400, 0x19ca, 0x2afe, 0x3f7c, 0x732f,
  0x0033, 0x00ab, 0x03ea, 0x192a, 0x2aa8, 0x3efe, 0x3ffd, 0x73b1,
  0x0066, 0x02a9, 0x18e9, 0x29e6, 0x3e80, 0x3f7e, 0x407e, 0x7433,
  0x0198, 0x10f0, 0x2983, 0x3d96, 0x3eff, 0x3ffe, 0x40ff, 0x74b5,
  0x0a29, 0x1c3a, 0x3d0b, 0x3e14, 0x3f7e, 0x407e, 0x4180, 0x7537,
  0x10ef, 0x2982, 0x3d88, 0x3e92, 0x3ffd, 0x40fe, 0x4201, 0x75b9,
  0x18e7, 0x29d7, 0x3e05, 0x3f10, 0x407c, 0x417e, 0x4282, 0x8987,
  0x191a, 0x2a2c, 0x3e82, 0x3f8e, 0x40fb, 0x41fe, 0x5629, 0x9acb,
  0x194d, 0x2a81, 0x3eff, 0x400c, 0x417a, 0x557e, 0x674b, 0xb123,
  0x1980, 0x2ad6, 0x3f7c, 0x408a, 0x54d3, 0x667e, 0x7d77, 0xb3ad,
  0x19b3, 0x2b2b, 0x3ff9, 0x53bc, 0x65b1, 0x7c7e, 0x7ffc, 0xb42f,
  0x19e6, 0x2b80, 0x5304, 0x6478, 0x7b85, 0x7efe, 0x807d, 0xb4b1,
  0x2b7f, 0x5303, 0x646a, 0x7b18, 0x7efd, 0x807c, 0x81fd, 0x3333,
  0x3872, 0x639d, 0x7a12, 0x7d93, 0x7f7d, 0x80fd, 0x007f, 0x33b6,
  0x43bc, 0x7919, 0x7c88, 0x7e12, 0x7ffd, 0x007e, 0x0101, 0x3439,
  0x5258, 0x7b8a, 0x7d06, 0x7e91, 0x007d, 0x00ff, 0x0183, 0x374b,
  0x5401, 0x7c07, 0x7d84, 0x0010, 0x00fd, 0x0180, 0x048f, 0x4d4c,
  0x5456, 0x7c84, 0x0002, 0x008f, 0x017d, 0x0486, 0x1a65, 0x5eb2,
  0x54ab, 0x0001, 0x0080, 0x010e, 0x047d, 0x1a31, 0x2ba9, 0x732a,
  0x0000, 0x007e, 0x00fe, 0x0408, 0x19fd, 0x2b53, 0x3ff9, 0x73ad,
  0x0055, 0x00fb, 0x03f2, 0x195d, 0x2afd, 0x3f7b, 0x407b, 0x7430,
  0x00aa, 0x03e9, 0x191c, 0x2a3b, 0x3efd, 0x3ffc, 0x40fd, 0x74b3,
  0x02a8, 0x18e8, 0x29d8, 0x3e13, 0x3f7d, 0x407d, 0x417f, 0x7536,
  0x10ef, 0x2982, 0x3d88, 0x3e92, 0x3ffd, 0x40fe, 0x4201, 0x75b9,
  0x1c39, 0x3d0a, 0x3e06, 0x3f11, 0x407d, 0x417f, 0x4283, 0x763c,
  0x2981, 0x3d87, 0x3e84, 0x3f90, 0x40fd, 0x4200, 0x4305, 0x8a31,
  0x29d6, 0x3e04, 0x3f02, 0x400f, 0x417d, 0x4281, 0x56d3, 0x9b97,
  0x2a2b, 0x3e81, 0x3f80, 0x408e, 0x41fd, 0x5628, 0x6817, 0xb21b,
  0x2a80, 0x3efe, 0x3ffe, 0x410d, 0x557d, 0x674a, 0x7e6f, 0xb4aa,
  0x2ad5, 0x3f7b, 0x407c, 0x5466, 0x667d, 0x7d76, 0x80f9, 0xb52d,
  0x2b2a, 0x3ff8, 0x53ae, 0x6544, 0x7c7d, 0x7ffb, 0x817b, 0xb5b0,
  0x3ff7, 0x53ad, 0x6536, 0x7c10, 0x7ffa, 0x817a, 0x82fc, 0x3333,
  0x5302, 0x6469, 0x7b0a, 0x7e90, 0x807b, 0x81fc, 0x007f, 0x33dd,
  0x639c, 0x7a11, 0x7d85, 0x7f10, 0x80fc, 0x007e, 0x0102, 0x3487,
  0x7918, 0x7c87, 0x7e04, 0x7f90, 0x007d, 0x0100, 0x0185, 0x3883,
  0x7b89, 0x7d05, 0x7e83, 0x0010, 0x00fe, 0x0182, 0x0497, 0x5511,
  0x7c06, 0x7d83, 0x0002, 0x0090, 0x017f, 0x048e, 0x1a98, 0x6ba5,
  0x7c83, 0x0001, 0x0081, 0x0110, 0x0485, 0x1a64, 0x2bfe, 0x8635,
  0x0000, 0x007f, 0x0100, 0x0410, 0x1a30, 0x2ba8, 0x4076, 0x86df,
  0x007d, 0x00fd, 0x03fa, 0x1990, 0x2b52, 0x3ff8, 0x40f9, 0x8789,
  0x00fa, 0x03f1, 0x194f, 0x2a90, 0x3f7a, 0x407a, 0x417c, 0x8833,
  0x03e8, 0x191b, 0x2a2d, 0x3e90, 0x3ffb, 0x40fc, 0x41ff, 0x88dd,
  0x18e7, 0x29d7, 0x3e05, 0x3f10, 0x407c, 0x417e, 0x4282, 0x8987,
  0x2981, 0x3d87, 0x3e84, 0x3f90, 0x40fd, 0x4200, 0x4305, 0x8a31,
  0x3d09, 0x3e05, 0x3f03, 0x4010, 0x417e, 0x4282, 0x4388, 0xa417,
  0x3d86, 0x3e83, 0x3f82, 0x4090, 0x41ff, 0x4304, 0x577d, 0xbaab,
  0x3e03, 0x3f01, 0x4001, 0x4110, 0x4280, 0x56d2, 0x68e3, 0xd7e3,
  0x3e80, 0x3f7f, 0x4080, 0x4190, 0x5627, 0x6816, 0x7f67, 0xdb35,
  0x3efd, 0x3ffd, 0x40ff, 0x5510, 0x6749, 0x7e6e, 0x81f6, 0xdbdf,
  0x3f7a, 0x407b, 0x5458, 0x6610, 0x7d75, 0x80f8, 0x8279, 0xdc89,
  0x407a, 0x5457, 0x6602, 0x7d08, 0x80f7, 0x8278, 0xa9d5, 0x3333,
  0x53ac, 0x6535, 0x7c02, 0x7f8d, 0x8179, 0x82fb, 0x007f, 0x33ff,
  0x6468, 0x7b09, 0x7e82, 0x800e, 0x81fb, 0x007e, 0x0129, 0x34cb,
  0x7a10, 0x7d84, 0x7f02, 0x808f, 0x007d, 0x0101, 0x01d3, 0x3993,
  0x7c86, 0x7e03, 0x7f82, 0x0010, 0x00ff, 0x0184, 0x05cf, 0x5bd7,
  0x7d04, 0x7e82, 0x0002, 0x0091, 0x0181, 0x0496, 0x225d, 0x76ef,
  0x7d82, 0x0001, 0x0082, 0x0112, 0x048d, 0x1a97, 0x38f1, 0x96cf,
  0x0000, 0x0080, 0x0102, 0x0418, 0x1a63, 0x2bfd, 0x5381, 0x979b,
  0x007e, 0x00ff, 0x0402, 0x19c3, 0x2ba7, 0x4075, 0x542b, 0x9867,
  0x00fc, 0x03f9, 0x1982, 0x2ae5, 0x3ff7, 0x40f8, 0x54d5, 0x9933,
  0x03f0, 0x194e, 0x2a82, 0x3f0d, 0x4079, 0x417b, 0x557f, 0x99ff,
  0x191a, 0x2a2c, 0x3e82, 0x3f8e, 0x40fb, 0x41fe, 0x5629, 0x9acb,
  0x29d6, 0x3e04, 0x3f02, 0x400f, 0x417d, 0x4281, 0x56d3, 0x9b97,
  0x3d86, 0x3e83, 0x3f82, 0x4090, 0x41ff, 0x4304, 0x577d, 0xbaab,
  0x3e04, 0x3f02, 0x4002, 0x4111, 0x4281, 0x4387, 0x7163, 0xd5c3,
  0x3e82, 0x3f81, 0x4082, 0x4192, 0x4303, 0x577c, 0x87f7, 0xf8d3,
  0x3f00, 0x4000, 0x4102, 0x4213, 0x56d1, 0x68e2, 0xa52f, 0xfccf,
  0x3f7e, 0x407f, 0x4182, 0x55ba, 0x6815, 0x7f66, 0xa881, 0xfd9b,
  0x3ffc, 0x40fe, 0x5502, 0x66dc, 0x7e6d, 0x81f5, 0xa92b, 0xfe67,
  0x40fd, 0x5501, 0x66ce, 0x7e00, 0x81f4, 0xa92a, 0xcbb3, 0x3333,
  0x5456, 0x6601, 0x7cfa, 0x808a, 0x8277, 0xa9d4, 0x007f, 0x342b,
  0x6534, 0x7c01, 0x7f7f, 0x810c, 0x82fa, 0x007e, 0x014b, 0x3523,
  0x7b08, 0x7e81, 0x8000, 0x818e, 0x007d, 0x0128, 0x0217, 0x3af3,
  0x7d83, 0x7f01, 0x8081, 0x0010, 0x0100, 0x01d2, 0x06df, 0x649b,
  0x7e02, 0x7f81, 0x0002, 0x0092, 0x0183, 0x05ce, 0x2923, 0x858b,
  0x7e81, 0x0001, 0x0083, 0x0114, 0x0495, 0x225c, 0x443b, 0xac4b,
  0x0000, 0x0081, 0x0104, 0x0420, 0x1a96, 0x38f0, 0x641b, 0xad43,
  0x007f, 0x0101, 0x040a, 0x19f6, 0x2bfc, 0x5380, 0x64e7, 0xae3b,
  0x00fe, 0x0401, 0x19b5, 0x2b3a, 0x4074, 0x542a, 0x65b3, 0xaf33,
  0x03f8, 0x1981, 0x2ad7, 0x3f8a, 0x40f7, 0x54d4, 0x667f, 0xb02b,
  0x194d, 0x2a81, 0x3eff, 0x400c, 0x417a, 0x557e, 0x674b, 0xb123,
  0x2a2b, 0x3e81, 0x3f80, 0x408e, 0x41fd, 0x5628, 0x6817, 0xb21b,
  0x3e03, 0x3f01, 0x4001, 0x4110, 0x4280, 0x56d2, 0x68e3, 0xd7e3,
  0x3e82, 0x3f81, 0x4082, 0x4192, 0x4303, 0x577c, 0x87f7, 0xf8d3,
  0x3f01, 0x4001, 0x4103, 0x4214, 0x4386, 0x7162, 0xa30f, 0x2373,
  0x3f80, 0x4081, 0x4184, 0x4296, 0x577b, 0x87f6, 0xc61f, 0x284b,
  0x3fff, 0x4101, 0x4205, 0x5664, 0x68e1, 0xa52e, 0xca1b, 0x2943,
  0x407e, 0x4181, 0x55ac, 0x67a8, 0x7f65, 0xa880, 0xcae7, 0x2a3b,
  0x4180, 0x55ab, 0x679a, 0x7ef8, 0xa87f, 0xcae6, 0xf787, 0x3333,
  0x5500, 0x66cd, 0x7df2, 0x8187, 0xa929, 0xcbb2, 0x007f, 0x3430,
  0x6600, 0x7cf9, 0x807c, 0x820a, 0xa9d3, 0x007e, 0x0177, 0x352d,
  0x7c00, 0x7f7e, 0x80fe, 0x828d, 0x007d, 0x014a, 0x026f, 0x3b1b,
  0x7e80, 0x7fff, 0x8180, 0x0010, 0x0127, 0x0216, 0x083f, 0x659a,
  0x7f00, 0x8080, 0x0002, 0x0093, 0x01d1, 0x06de, 0x31e7, 0x8734,
  0x7f80, 0x0001, 0x0084, 0x0116, 0x05cd, 0x2922, 0x52d7, 0xaebc,
  0x0000, 0x0082, 0x0106, 0x0428, 0x225b, 0x443a, 0x7997, 0xafb9,
  0x0080, 0x0103, 0x0412, 0x1a29, 0x38ef, 0x641a, 0x7a8f, 0xb0b6,
  0x0100, 0x0409, 0x19e8, 0x2b8f, 0x537f, 0x64e6, 0x7b87, 0xb1b3,
  0x0400, 0x19b4, 0x2b2c, 0x4007, 0x5429, 0x65b2, 0x7c7f, 0xb2b0,
  0x1980, 0x2ad6, 0x3f7c, 0x408a, 0x54d3, 0x667e, 0x7d77, 0xb3ad,
  0x2a80, 0x3efe, 0x3ffe, 0x410d, 0x557d, 0x674a, 0x7e6f, 0xb4aa,
  0x3e80, 0x3f7f, 0x4080, 0x4190, 0x5627, 0x6816, 0x7f67, 0xdb35,
  0x3f00, 0x4000, 0x4102, 0x4213, 0x56d1, 0x68e2, 0xa52f, 0xfccf,
  0x3f80, 0x4081, 0x4184, 0x4296, 0x577b, 0x87f6, 0xc61f, 0x284b,
  0x4000, 0x4102, 0x4206, 0x4319, 0x7161, 0xa30e, 0xf0bf, 0x2d3c,
  0x4080, 0x4183, 0x4288, 0x570e, 0x87f5, 0xc61e, 0xf597, 0x2e39,
  0x4100, 0x4204, 0x5656, 0x6874, 0xa52d, 0xca1a, 0xf68f, 0x2f36,
  0x4203, 0x5655, 0x6866, 0xa4c0, 0xca19, 0xf68e, 0xfc82, 0x3333,
  0x55aa, 0x6799, 0x7eea, 0xa812, 0xcae5, 0xf786, 0x007f, 0x3431,
  0x66cc, 0x7df1, 0x8179, 0xa8bc, 0xcbb1, 0x007e, 0x017c, 0x352f,
  0x7cf8, 0x807b, 0x81fc, 0xa966, 0x007d, 0x0176, 0x0279, 0x3b23,
  0x7f7d, 0x80fd, 0x827f, 0x0010, 0x0149, 0x026e, 0x0867, 0x65cd,
  0x7ffe, 0x817f, 0x0002, 0x00ba, 0x0215, 0x083e, 0x32e6, 0x8789,
  0x807f, 0x0001, 0x0085, 0x0164, 0x06dd, 0x31e6, 0x5480, 0xaf39,
  0x0000, 0x0083, 0x0108, 0x0560, 0x2921, 0x52d6, 0x7c08, 0xb037,
  0x0081, 0x0105, 0x041a, 0x21ee, 0x4439, 0x7996, 0x7d05, 0xb135,
  0x0102, 0x0411, 0x1a1b, 0x3882, 0x6419, 0x7a8e, 0x7e02, 0xb233,
  0x0408, 0x19e7, 0x2b81, 0x5312, 0x64e5, 0x7b86, 0x7eff, 0xb331,
  0x19b3, 0x2b2b, 0x3ff9, 0x53bc, 0x65b1, 0x7c7e, 0x7ffc, 0xb42f,
  0x2ad5, 0x3f7b, 0x407c, 0x5466, 0x667d, 0x7d76, 0x80f9, 0xb52d,
  0x3efd, 0x3ffd, 0x40ff, 0x5510, 0x6749, 0x7e6e, 0x81f6, 0xdbdf,
  0x3f7e, 0x407f, 0x4182, 0x55ba, 0x6815, 0x7f66, 0xa881, 0xfd9b,
  0x3fff, 0x4101, 0x4205, 0x5664, 0x68e1, 0xa52e, 0xca1b, 0x2943,
  0x4080, 0x4183, 0x4288, 0x570e, 0x87f5, 0xc61e, 0xf597, 0x2e39,
  0x4101, 0x4205, 0x430b, 0x70f4, 0xa30d, 0xf0be, 0xfa88, 0x2f37,
  0x4182, 0x4287, 0x5700, 0x8788, 0xc61d, 0xf596, 0xfb85, 0x3035,
  0x4286, 0x56ff, 0x877a, 0xc5b0, 0xf595, 0xfb84, 0xfd81, 0x3333,
  0x5654, 0x6865, 0xa4b2, 0xc9ac, 0xf68d, 0xfc81, 0x007f, 0x3432,
  0x6798, 0x7ee9, 0xa804, 0xca78, 0xf785, 0x007e, 0x017d, 0x3531,
  0x7df0, 0x8178, 0xa8ae, 0xcb44, 0x007d, 0x017b, 0x027b, 0x3b2b,
  0x807a, 0x81fb, 0xa958, 0x0010, 0x0175, 0x0278, 0x086f, 0x6600,
  0x80fc, 0x827e, 0x0002, 0x00dc, 0x026d, 0x0866, 0x3319, 0x87de,
  0x817e, 0x0001, 0x00ac, 0x01a8, 0x083d, 0x32e5, 0x54d5, 0xafb6,
  0x0000, 0x0084, 0x0156, 0x0670, 0x31e5, 0x547f, 0x7c85, 0xb0b5,
  0x0082, 0x0107, 0x0552, 0x28b4, 0x52d5, 0x7c07, 0x7d83, 0xb1b4,
  0x0104, 0x0419, 0x21e0, 0x43cc, 0x7995, 0x7d04, 0x7e81, 0xb2b3,
  0x0410, 0x1a1a, 0x3874, 0x63ac, 0x7a8d, 0x7e01, 0x7f7f, 0xb3b2,
  0x19e6, 0x2b80, 0x5304, 0x6478, 0x7b85, 0x7efe, 0x807d, 0xb4b1,
  0x2b2a, 0x3ff8, 0x53ae, 0x6544, 0x7c7d, 0x7ffb, 0x817b, 0xb5b0,
  0x3f7a, 0x407b, 0x5458, 0x6610, 0x7d75, 0x80f8, 0x8279, 0xdc89,
  0x3ffc, 0x40fe, 0x5502, 0x66dc, 0x7e6d, 0x81f5, 0xa92b, 0xfe67,
  0x407e, 0x4181, 0x55ac, 0x67a8, 0x7f65, 0xa880, 0xcae7, 0x2a3b,
  0x4100, 0x4204, 0x5656, 0x6874, 0xa52d, 0xca1a, 0xf68f, 0x2f36,
  0x4182, 0x4287, 0x5700, 0x8788, 0xc61d, 0xf596, 0xfb85, 0x3035,
  0x4204, 0x430a, 0x70e6, 0xa2a0, 0xf0bd, 0xfa87, 0xfc83, 0x3134,
};
const unsigned kExpectedCount_NEON_umlal2_8H = 361;

#endif  // VIXL_SIM_UMLAL2_8H_TRACE_AARCH64_H_
