/*
 * Copyright (C) 2025 Samuel Weinig <sam@webkit.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <WebCore/StyleValueTypes.h>
#include <WebCore/TextSpacing.h>

namespace WebCore {
namespace Style {

// <'text-spacing-trim'> = space-all | normal | space-first | trim-start | trim-both | trim-all | auto
// FIXME: Only `space-all`, `trim-all` and `auto` are currently supported.
// https://drafts.csswg.org/css-text-4/#propdef-text-spacing-trim
struct TextSpacingTrim {
    constexpr TextSpacingTrim(CSS::Keyword::SpaceAll) : value { WebCore::TextSpacingTrim::TrimType::SpaceAll } { }
    constexpr TextSpacingTrim(CSS::Keyword::TrimAll) : value { WebCore::TextSpacingTrim::TrimType::TrimAll } { }
    constexpr TextSpacingTrim(CSS::Keyword::Auto) : value { WebCore::TextSpacingTrim::TrimType::Auto } { }

    constexpr TextSpacingTrim(WebCore::TextSpacingTrim platform) : value { platform.type() } { }
    constexpr TextSpacingTrim(WebCore::TextSpacingTrim::TrimType platformType) : value { platformType } { }

    constexpr WebCore::TextSpacingTrim::TrimType platform() const { return value; }

    constexpr bool operator==(const TextSpacingTrim&) const = default;

    WebCore::TextSpacingTrim::TrimType value;
};
DEFINE_TYPE_WRAPPER_GET(TextSpacingTrim, value);

} // namespace Style
} // namespace WebCore

DEFINE_TUPLE_LIKE_CONFORMANCE_FOR_TYPE_WRAPPER(WebCore::Style::TextSpacingTrim);
